/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.expiry;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class CacheLoader
implements AlarmListener {
    private static TraceComponent tc = SibTr.register((Class)CacheLoader.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final String XML_LOADER = "CacheLoader";
    public static final String XML_STORED_EXCEPTION = "storedException";
    private static final int MAX_DIAG_LOG = 10;
    private Alarm loaderAlarm = null;
    private long interval = 0L;
    private boolean enabled = false;
    private boolean shutdown = false;
    private MessageStoreImpl messageStore = null;
    private Object lockObject = new Object();
    private JsMessagingEngine messagingEngine = null;
    private PersistentMessageStore pm = null;
    private Set results = null;
    private Iterator iter = null;
    private long loaderStartTime = 0L;
    private long loaderStopTime = 0L;
    private Throwable lastException = null;
    private long lastExceptionTime = 0L;
    private int maxStreamsPerCycle = 0;
    private long totalStreams = 0L;
    private int diagIndex = 0;
    private long[] cycleTime = new long[10];
    private long[] logStreamsLoaded = new long[10];
    private long[] logDuration = new long[10];

    public CacheLoader(MessageStoreImpl messageStoreImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)messageStoreImpl);
        }
        this.messageStore = messageStoreImpl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public final void start(long l, JsMessagingEngine jsMessagingEngine) {
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)new Long(l));
        }
        this.messagingEngine = jsMessagingEngine;
        if (l >= 0L) {
            this.interval = l * 1000L;
        } else {
            string = this.messageStore.getProperty("cacheLoaderInterval", "60");
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"start", (Object)("Interval from system prop=<" + string + ">"));
            }
            try {
                this.interval = Long.parseLong(string.trim()) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                this.lastException = numberFormatException;
                this.lastExceptionTime = CacheLoader.timeNow();
                SibTr.debug((TraceComponent)tc, (String)"start", (Object)("Unable to parse cacheLoaderInterval property: " + numberFormatException));
                this.interval = 60000L;
            }
        }
        string = this.messageStore.getProperty("maxStreamsPerCycle", "10");
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"start", (Object)("maxStreamsPerCycle from system prop=<" + string + ">"));
        }
        try {
            this.maxStreamsPerCycle = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.lastException = numberFormatException;
            this.lastExceptionTime = CacheLoader.timeNow();
            SibTr.debug((TraceComponent)tc, (String)"start", (Object)("Unable to parse maxStreamsPerCycle property: " + numberFormatException));
            this.maxStreamsPerCycle = 10;
        }
        PersistentMessageStore persistentMessageStore = this.messageStore.getPersistentMessageStore();
        try {
            this.results = persistentMessageStore.identifyStreamsWithExpirableItems();
            this.totalStreams = this.results.size();
            this.iter = this.results.iterator();
            if (this.interval < 1L) {
                this.enabled = false;
            } else if (this.loaderAlarm == null) {
                this.enabled = true;
                this.shutdown = false;
                this.loaderStartTime = CacheLoader.timeNow();
                this.loaderAlarm = this.scheduleAlarm(this.interval);
            }
        }
        catch (PersistenceException persistenceException) {
            FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.expiry.CacheLoader.run", (String)"191", (Object)this);
            this.lastException = persistenceException;
            this.lastExceptionTime = CacheLoader.timeNow();
            this.enabled = false;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"run", (Object)("CacheLoader stopping - interrupted: " + (Object)((Object)persistenceException)));
            }
            throw new MessageStoreRuntimeException("CACHE_LOADER_TERMINATED_SIMS2003", new Object[]{persistenceException}, (Throwable)((Object)persistenceException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start", (Object)("enabled=" + this.enabled + " interval=" + this.interval));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.enabled) {
                this.loaderStopTime = CacheLoader.timeNow();
                this.enabled = false;
                this.shutdown = true;
            }
            if (this.loaderAlarm != null) {
                this.loaderAlarm.cancel();
                this.loaderAlarm = null;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void alarm(Object object) {
        if (this.messagingEngine != null) {
            SibTr.push((Object)this.messagingEngine);
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm");
        }
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        String string = "";
        Object object2 = this.lockObject;
        synchronized (object2) {
            block20: {
                try {
                    if (this.enabled) {
                        long l3;
                        l2 = CacheLoader.timeNow();
                        n = this.saveStartTime(l2);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"CacheLoader cycle starting");
                        }
                        l = 0L;
                        while (this.enabled && this.iter.hasNext() && l < (long)this.maxStreamsPerCycle) {
                            AbstractItemLink abstractItemLink;
                            l3 = (Long)this.iter.next();
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Reloading stream ID=" + l3));
                            }
                            if ((abstractItemLink = this.messageStore.getLink(l3)) != null) {
                                boolean bl = ((LinkOwner)abstractItemLink).loadOwnedLinks();
                                if (!bl) continue;
                                ++l;
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            SibTr.debug((TraceComponent)tc, (String)"ID returned from persistence gave null link?");
                        }
                        this.logDuration[n] = l3 = CacheLoader.timeNow() - l2;
                        this.logStreamsLoaded[n] = l;
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("End of CacheLoader cycle. " + l + " stream(s) loaded in " + l3 + "ms"));
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.expiry.CacheLoader.run", (String)"301", (Object)this);
                    this.lastException = exception;
                    this.lastExceptionTime = CacheLoader.timeNow();
                    this.enabled = false;
                    if (this.shutdown && exception instanceof InterruptedException) break block20;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"run", (Object)("CacheLoader stopping - interrupted: " + exception));
                    }
                    throw new MessageStoreRuntimeException("CACHE_LOADER_TERMINATED_SIMS2003", new Object[]{exception}, exception);
                }
            }
            if (this.enabled) {
                if (this.iter.hasNext()) {
                    this.loaderAlarm = this.scheduleAlarm(this.interval);
                    string = "More";
                } else {
                    this.loaderAlarm = null;
                    this.loaderStopTime = CacheLoader.timeNow();
                    string = "Finished";
                }
            } else {
                this.loaderAlarm = null;
                this.loaderStopTime = CacheLoader.timeNow();
                string = "Ended";
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)string);
        }
        if (this.messagingEngine != null) {
            SibTr.pop();
        }
    }

    private int saveStartTime(long l) {
        int n = this.diagIndex;
        this.cycleTime[this.diagIndex++] = l;
        if (this.diagIndex >= 10) {
            this.diagIndex = 0;
        }
        return n;
    }

    private Alarm scheduleAlarm(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)("scheduleAlarm timeOut=" + l));
        }
        Alarm alarm = AlarmManager.createNonDeferrable((long)l, (AlarmListener)this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"scheduleAlarm");
        }
        return alarm;
    }

    public static long timeNow() {
        return System.currentTimeMillis();
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd @ HH:mm:ss.SSS");
        String string = simpleDateFormat.format(new Date());
        formattedWriter.newLine();
        formattedWriter.startTag(XML_LOADER);
        formattedWriter.indent();
        formattedWriter.newLine();
        formattedWriter.taggedValue("timeNow", (Object)string);
        formattedWriter.newLine();
        formattedWriter.taggedValue("interval", this.interval);
        formattedWriter.newLine();
        formattedWriter.taggedValue("enabled", (Object)new Boolean(this.enabled));
        formattedWriter.newLine();
        formattedWriter.taggedValue("maxStreamsPerCycle", (long)this.maxStreamsPerCycle);
        formattedWriter.newLine();
        formattedWriter.taggedValue("loaderStartTime", (Object)simpleDateFormat.format(new Date(this.loaderStartTime)));
        formattedWriter.newLine();
        formattedWriter.taggedValue("loaderStopTime", (Object)simpleDateFormat.format(new Date(this.loaderStopTime)));
        formattedWriter.newLine();
        formattedWriter.taggedValue("totalStreams", this.totalStreams);
        formattedWriter.newLine();
        for (int i = 0; i < 10; ++i) {
            String string2 = "Cycle=" + i + (this.diagIndex == i ? ":*" : ": ") + simpleDateFormat.format(new Date(this.cycleTime[i])) + " streamsLoaded=" + this.logStreamsLoaded[i] + " duration=" + this.logDuration[i];
            formattedWriter.taggedValue("info", (Object)string2);
            formattedWriter.newLine();
        }
        formattedWriter.startTag(XML_STORED_EXCEPTION);
        if (this.lastException == null) {
            formattedWriter.write("No exceptions recorded");
        } else {
            formattedWriter.indent();
            formattedWriter.newLine();
            formattedWriter.taggedValue("time", (Object)new Date(this.lastExceptionTime));
            formattedWriter.outdent();
            formattedWriter.write(this.lastException);
            formattedWriter.newLine();
        }
        formattedWriter.endTag(XML_STORED_EXCEPTION);
        formattedWriter.outdent();
        formattedWriter.newLine();
        formattedWriter.endTag(XML_LOADER);
    }
}

