/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.example.index;

import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.example.index.IndexableItem;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import java.util.HashMap;

public final class IndexedItemStream
extends ItemStream {
    private final HashMap _map = new HashMap();

    public final void addItem(Item item, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException {
        super.addItem(item, transaction);
        if (item instanceof IndexableItem) {
            this.addToIndex((IndexableItem)item);
        }
    }

    private final void addToIndex(IndexableItem indexableItem) {
        Object object = indexableItem.getKey();
        Long l = new Long(indexableItem.getID());
        System.out.println("adding: " + object + " ===> " + l);
        indexableItem.setStream(this);
        this._map.put(object, l);
    }

    public void eventRestored() {
        super.eventRestored();
        try {
            System.out.println("Start Restoring");
            NonLockingCursor nonLockingCursor = this.newNonLockingItemCursor(null);
            AbstractItem abstractItem = nonLockingCursor.next();
            while (null != abstractItem) {
                if (abstractItem instanceof IndexableItem) {
                    this.addToIndex((IndexableItem)abstractItem);
                }
                abstractItem = nonLockingCursor.next();
            }
            System.out.println("Stop Restoring");
        }
        catch (MessageStoreException messageStoreException) {
            messageStoreException.printStackTrace();
        }
    }

    public final IndexableItem findByKey(Object object) throws MessageStoreException {
        IndexableItem indexableItem = null;
        Long l = (Long)this._map.get(object);
        if (null != l) {
            System.out.println("finding: " + object + " ===> " + l);
            indexableItem = (IndexableItem)this.findById(l);
        } else {
            System.out.println("finding: " + object + " ===> null");
        }
        return indexableItem;
    }

    public final IndexableItem getByKey(Object object, Transaction transaction) throws MessageStoreException {
        IndexableItem indexableItem = this.findByKey(object);
        if (null != indexableItem) {
            indexableItem.remove(transaction, -1L);
        }
        return indexableItem;
    }

    public final int getStorageStrategy() {
        return 4;
    }

    final void removeFromIndex(IndexableItem indexableItem) {
        Object object = indexableItem.getKey();
        System.out.println("removing: " + object);
        this._map.remove(object);
        indexableItem.setStream(null);
    }
}

