/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.example.index;

import com.ibm.ws.sib.msgstore.Configuration;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.example.index.IndexableItem;
import com.ibm.ws.sib.msgstore.example.index.IndexedItemStream;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;

public final class IndexTest {
    private MessageStore _messageStore;
    private IndexedItemStream _itemStream;

    public static final void main(String[] stringArray) {
        try {
            new IndexTest().doit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    IndexTest() {
    }

    public final void doit() throws Exception {
        Object object;
        IndexableItem indexableItem;
        Object object2;
        int n;
        this._createAndStartMessageStore();
        this._createItemStream();
        int n2 = 10;
        IndexableItem[] indexableItemArray = new IndexableItem[n2];
        ExternalAutoCommitTransaction externalAutoCommitTransaction = this._messageStore.getTransactionFactory().createAutoCommitTransaction();
        for (n = 0; n < n2; ++n) {
            indexableItemArray[n] = new IndexableItem();
            this._itemStream.addItem(indexableItemArray[n], externalAutoCommitTransaction);
        }
        for (n = 0; n < 10; n += 2) {
            object2 = indexableItemArray[n].getKey();
            indexableItem = this._itemStream.getByKey(object2, externalAutoCommitTransaction);
            if (null == indexableItem) {
                throw new Exception("Item not found");
            }
            object = indexableItem.getKey();
            if (object.equals(object2)) continue;
            throw new Exception("Items do not match");
        }
        this._closeMessageStore();
        System.out.println("starting msgstore");
        this._restartMessageStore();
        System.out.println("reloading stream");
        this._reloadItemStream();
        System.out.println("reading items");
        for (n = 1; n < 10; n += 2) {
            object2 = indexableItemArray[n].getKey();
            indexableItem = this._itemStream.getByKey(object2, externalAutoCommitTransaction);
            if (null == indexableItem) {
                throw new Exception("Item not found");
            }
            object = indexableItem.getKey();
            if (object.equals(object2)) continue;
            throw new Exception("Items do not match");
        }
        this._closeMessageStore();
    }

    private final void _closeMessageStore() {
        this._messageStore.stop(0);
    }

    private final void _createItemStream() throws Exception {
        this._itemStream = new IndexedItemStream();
        ExternalAutoCommitTransaction externalAutoCommitTransaction = this._messageStore.getTransactionFactory().createAutoCommitTransaction();
        this._messageStore.add(this._itemStream, externalAutoCommitTransaction);
    }

    private final void _createAndStartMessageStore() throws Exception {
        this._messageStore = MessageStore.createInstance();
        Configuration configuration = Configuration.createBasicConfiguration();
        configuration.setCleanPersistenceOnStart(true);
        this._messageStore.initialize(configuration);
        this._messageStore.start();
    }

    private final void _restartMessageStore() throws Exception {
        this._messageStore = MessageStore.createInstance();
        Configuration configuration = Configuration.createBasicConfiguration();
        configuration.setCleanPersistenceOnStart(false);
        this._messageStore.initialize(configuration);
        this._messageStore.start();
    }

    private final void _reloadItemStream() throws Exception {
        this._itemStream = (IndexedItemStream)this._messageStore.findFirstMatching(null);
    }
}

