/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.example;

import com.ibm.ws.sib.msgstore.Configuration;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.example.EmptyableItemStream;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;

public class TestEmptyableItemStream {
    public static final void main(String[] stringArray) {
        try {
            new TestEmptyableItemStream().doit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final void doit() throws Exception {
        long l = 0L;
        long l2 = 0L;
        System.out.println("create and start message store");
        MessageStore messageStore = MessageStore.createInstance();
        Configuration configuration = Configuration.createBasicConfiguration();
        configuration.setCleanPersistenceOnStart(true);
        messageStore.initialize(configuration);
        messageStore.start();
        System.out.println("create Emptyable Item stream");
        EmptyableItemStream emptyableItemStream = new EmptyableItemStream();
        ExternalAutoCommitTransaction externalAutoCommitTransaction = messageStore.getTransactionFactory().createAutoCommitTransaction();
        messageStore.add(emptyableItemStream, externalAutoCommitTransaction);
        System.out.println("add a contained item stream");
        ItemStream itemStream = new ItemStream();
        emptyableItemStream.addItemStream(itemStream, externalAutoCommitTransaction);
        System.out.println("add a contained reference stream");
        ReferenceStream referenceStream = new ReferenceStream();
        emptyableItemStream.addReferenceStream(referenceStream, externalAutoCommitTransaction);
        System.out.println("add ten committed items");
        for (int i = 0; i < 10; ++i) {
            emptyableItemStream.addItem(new Item(), externalAutoCommitTransaction);
        }
        System.out.println("put an item but leave it uncommitted");
        ExternalLocalTransaction externalLocalTransaction = messageStore.getTransactionFactory().createLocalTransaction();
        emptyableItemStream.addItem(new Item(), externalLocalTransaction);
        l = emptyableItemStream.getStatistics().getAvailableItemCount();
        l2 = emptyableItemStream.getStatistics().getUnavailableItemCount();
        System.out.println("available = " + l + ", unavailable = " + l2);
        System.out.println("put an item, then get it but do not commit the get");
        Item item = new Item();
        emptyableItemStream.addItem(item, externalAutoCommitTransaction);
        ExternalLocalTransaction externalLocalTransaction2 = messageStore.getTransactionFactory().createLocalTransaction();
        item.remove(externalLocalTransaction2, 0L);
        l = emptyableItemStream.getStatistics().getAvailableItemCount();
        l2 = emptyableItemStream.getStatistics().getUnavailableItemCount();
        System.out.println("available = " + l + ", unavailable = " + l2);
        System.out.println("Empty the item stream");
        emptyableItemStream.empty();
        l = emptyableItemStream.getStatistics().getAvailableItemCount();
        l2 = emptyableItemStream.getStatistics().getUnavailableItemCount();
        System.out.println("available = " + l + ", unavailable = " + l2);
        System.out.println("Commit the put then Empty the item stream");
        externalLocalTransaction.commit();
        emptyableItemStream.empty();
        l = emptyableItemStream.getStatistics().getAvailableItemCount();
        l2 = emptyableItemStream.getStatistics().getUnavailableItemCount();
        System.out.println("available = " + l + ", unavailable = " + l2);
        System.out.println("Commit the get then Empty the item stream");
        externalLocalTransaction2.commit();
        emptyableItemStream.empty();
        l = emptyableItemStream.getStatistics().getAvailableItemCount();
        l2 = emptyableItemStream.getStatistics().getUnavailableItemCount();
        System.out.println("available = " + l + ", unavailable = " + l2);
        messageStore.stop(0);
    }
}

