/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.example;

import com.ibm.ws.sib.msgstore.Configuration;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreConstants;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class ExampleXmlGeneration
implements MessageStoreConstants {
    public static final void example1(MessageStore messageStore) throws MessageStoreException {
        ItemStream itemStream = new ItemStream();
        ExternalAutoCommitTransaction externalAutoCommitTransaction = messageStore.getTransactionFactory().createAutoCommitTransaction();
        messageStore.add(itemStream, externalAutoCommitTransaction);
        ReferenceStream referenceStream = new ReferenceStream();
        itemStream.addReferenceStream(referenceStream, externalAutoCommitTransaction);
        Item item = new Item();
        itemStream.addItem(item, externalAutoCommitTransaction);
        Item item2 = new Item();
        itemStream.addItem(item2, externalAutoCommitTransaction);
        Item item3 = new Item();
        itemStream.addItem(item3, externalAutoCommitTransaction);
        referenceStream.add(new ItemReference(item), externalAutoCommitTransaction);
        referenceStream.add(new ItemReference(item), externalAutoCommitTransaction);
        referenceStream.add(new ItemReference(item), externalAutoCommitTransaction);
        referenceStream.add(new ItemReference(item2), externalAutoCommitTransaction);
        referenceStream.add(new ItemReference(item2), externalAutoCommitTransaction);
        ItemStream itemStream2 = new ItemStream();
        itemStream.addItemStream(itemStream2, externalAutoCommitTransaction);
        itemStream2.addItem(new Item(), externalAutoCommitTransaction);
        itemStream2.addItem(new Item(), externalAutoCommitTransaction);
        itemStream2.addItem(new Item(), externalAutoCommitTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        FormattedWriter formattedWriter;
        FileWriter fileWriter;
        Configuration configuration = Configuration.createBasicConfiguration();
        configuration.setCleanPersistenceOnStart(true);
        MessageStore messageStore = null;
        System.out.println("Dynamic Output.....");
        try {
            messageStore = MessageStore.createInstance();
            messageStore.initialize(configuration);
            messageStore.start();
            ExampleXmlGeneration.example1(messageStore);
            System.out.println("....Dynamic Output to file");
            fileWriter = null;
            try {
                fileWriter = new FileWriter("exampleDynamic.xml");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            formattedWriter = new FormattedWriter((Writer)fileWriter);
            messageStore.xmlRequestWriteOnFile(formattedWriter);
            System.out.println("....Dynamic Output to stdout");
            messageStore.xmlRequestWriteOnSystemOut();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (null != messageStore) {
                messageStore.stop(0);
            }
        }
        System.out.println();
        System.out.println();
        System.out.println("Persistent Output.....");
        configuration.setCleanPersistenceOnStart(false);
        messageStore = null;
        try {
            try {
                messageStore = MessageStore.createInstance();
                messageStore.initialize(configuration);
                System.setProperty("sib.msgstore.dumpDataStoreOnStartup", "startupXml.xml");
                messageStore.start();
                System.out.println("....Persistent Output to file");
                fileWriter = null;
                try {
                    fileWriter = new FileWriter("examplePersistent.xml");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                formattedWriter = new FormattedWriter((Writer)fileWriter);
                messageStore.xmlRequestWriteRawDataOnFile(formattedWriter);
                System.out.println("....Persistent Output to stdout");
                messageStore.xmlRequestWriteRawDataOnSystemOut();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var7_11 = null;
                if (null == messageStore) return;
                messageStore.stop(0);
                messageStore.destroy();
                return;
            }
            Object var7_10 = null;
            if (null == messageStore) return;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (null == messageStore) throw throwable;
            messageStore.stop(0);
            messageStore.destroy();
            throw throwable;
        }
        messageStore.stop(0);
        messageStore.destroy();
    }

    public static final class ReferenceStream
    extends com.ibm.ws.sib.msgstore.ReferenceStream {
        public int getStorageStrategy() {
            return 4;
        }
    }

    public static final class ItemReference
    extends com.ibm.ws.sib.msgstore.ItemReference {
        public ItemReference() {
        }

        public ItemReference(Item item) {
            super(item);
        }

        public int getStorageStrategy() {
            return 4;
        }
    }

    public static final class ItemStream
    extends com.ibm.ws.sib.msgstore.ItemStream {
        public int getStorageStrategy() {
            return 4;
        }
    }

    public static final class Item
    extends com.ibm.ws.sib.msgstore.Item {
        public int getStorageStrategy() {
            return 4;
        }
    }
}

