/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.statemodel;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class ListStatistics
implements Statistics {
    private static final int MOVING_AVERAGE_LENGTH = 20;
    private static final int NO_LIMIT = -1;
    private static TraceComponent tc = SibTr.register((Class)ListStatistics.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private long _countAdding = 0L;
    private long _countAvailable = 0L;
    private long _countExpiring = 0L;
    private long _countLocked = 0L;
    private long _countRemoving = 0L;
    private long _countTotal = 0L;
    private long _countTotalBytes = 0L;
    private long _countUpdating = 0L;
    private final MSInstrumentation _instrumentation;
    private int _maximumSize = -1;
    private final int _movingAverageHighLimit;
    private final int _movingAverageLowLimit;
    private long _movingTotal = 0L;
    private final LinkOwner _owningStreamLink;
    private boolean _spilling = false;
    private long _watermarkBytesHigh = 0L;
    private long _watermarkBytesLow = 0L;
    private long _watermarkCountHigh = 0L;
    private long _watermarkCountLow = 0L;

    public ListStatistics(LinkOwner linkOwner) {
        this._owningStreamLink = linkOwner;
        MessageStoreImpl messageStoreImpl = ((AbstractItemLink)this._owningStreamLink).getMessageStoreImpl();
        this._instrumentation = messageStoreImpl._getInstrumentation();
        this._movingAverageHighLimit = messageStoreImpl.getSpillUpperLimit();
        this._movingAverageLowLimit = messageStoreImpl.getSpillLowerLimit();
    }

    public final void assertCanAdd() throws StreamIsFull {
        if (-1 != this._maximumSize && this._countTotal >= (long)this._maximumSize) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Cannot add as stream is full (max size=" + this._maximumSize));
            }
            throw new StreamIsFull();
        }
    }

    public final void calculateMovingAverage() {
        int n = this.countTotalItems();
        if (this._spilling) {
            if (n <= this._movingAverageLowLimit) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stop spilling in response to lower limit");
                }
                this._instrumentation.decrement(22);
                this._spilling = false;
                this._movingTotal = this._movingAverageLowLimit * 19;
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("spilling; currentTotal=" + n));
            }
        } else {
            this._movingTotal += (long)n;
            long l = this._movingTotal / 20L;
            this._movingTotal -= l;
            if (l >= (long)this._movingAverageHighLimit) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Start spilling in response to moving average");
                }
                this._instrumentation.increment(22);
                this._spilling = true;
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("MA= " + l + "; currentTotal=" + n));
            }
        }
    }

    public final boolean canDelete(int n) {
        boolean bl = true;
        int n2 = this.countTotalItems();
        if (n2 > 0) {
            bl = false;
            int n3 = this.countRemovingItems();
            if (n2 == n3 && n3 == n) {
                bl = true;
            }
        }
        return bl;
    }

    public final synchronized int countAddingItems() {
        return (int)this.getAddingItemCount();
    }

    public final synchronized int countAvailableItems() {
        return (int)this.getAvailableItemCount();
    }

    public final synchronized int countExpiringItems() {
        return (int)this.getExpiringItemCount();
    }

    public final synchronized int countLockedItems() {
        return (int)this.getLockedItemCount();
    }

    public final synchronized int countRemovingItems() {
        return (int)this.getRemovingItemCount();
    }

    public synchronized long countTotalBytes() {
        return this._countTotalBytes;
    }

    public final synchronized int countTotalItems() {
        return (int)this.getTotalItemCount();
    }

    public final synchronized int countUnavailableItems() {
        return (int)this.getUnavailableItemCount();
    }

    public final synchronized int countUpdatingItems() {
        return (int)this.getUpdatingItemCount();
    }

    public final synchronized void decrementAdding() {
        --this._countAdding;
    }

    public final synchronized void decrementAvailable() {
        --this._countAvailable;
    }

    public final synchronized void decrementExpiring() {
        --this._countExpiring;
    }

    public final synchronized void decrementLocked() {
        --this._countLocked;
    }

    public final synchronized void decrementRemoving() {
        --this._countRemoving;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrementTotal(int n) {
        boolean bl = false;
        ListStatistics listStatistics = this;
        synchronized (listStatistics) {
            if (this._watermarkCountLow == this._countTotal) {
                bl = true;
            }
            --this._countTotal;
            long l = this._countTotalBytes - (long)n;
            if (l < this._watermarkBytesLow && this._countTotalBytes >= this._watermarkBytesLow) {
                bl = true;
            }
            this._countTotalBytes = l;
        }
        if (bl) {
            this._owningStreamLink.eventWatermarkBreached();
        }
    }

    public final synchronized void decrementUpdating() {
        --this._countUpdating;
    }

    public final synchronized long getAddingItemCount() {
        return this._countAdding;
    }

    public final synchronized long getAvailableItemCount() {
        return this._countAvailable;
    }

    public final synchronized long getExpiringItemCount() {
        return this._countExpiring;
    }

    public final synchronized long getLockedItemCount() {
        return this._countLocked;
    }

    public final synchronized long getRemovingItemCount() {
        return this._countRemoving;
    }

    public final synchronized long getTotalItemCount() {
        return this._countTotal;
    }

    public final synchronized long getUnavailableItemCount() {
        return this._countTotal - this._countAvailable;
    }

    public final synchronized long getUpdatingItemCount() {
        return this._countUpdating;
    }

    public final synchronized void incrementAdding() {
        ++this._countAdding;
    }

    public final synchronized void incrementAvailable() {
        ++this._countAvailable;
    }

    public final synchronized void incrementExpiring() {
        ++this._countExpiring;
    }

    public final synchronized void incrementLocked() {
        ++this._countLocked;
    }

    public final synchronized void incrementRemoving() {
        ++this._countRemoving;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementTotal(int n) {
        boolean bl = false;
        ListStatistics listStatistics = this;
        synchronized (listStatistics) {
            ++this._countTotal;
            if (this._watermarkCountHigh == this._countTotal) {
                bl = true;
            }
            boolean bl2 = this._countTotalBytes < this._watermarkBytesHigh;
            this._countTotalBytes += (long)n;
            if (bl2 && this._countTotalBytes >= this._watermarkBytesHigh) {
                bl = true;
            }
        }
        if (bl) {
            this._owningStreamLink.eventWatermarkBreached();
        }
    }

    public final synchronized void incrementUpdating() {
        ++this._countUpdating;
    }

    public final boolean isSpilling() {
        return this._spilling;
    }

    public final void setMaximumSize(int n) {
        if (n >= 0) {
            this._maximumSize = n;
        }
    }

    public final synchronized void setWatermarks(long l, long l2, long l3, long l4) {
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("setting watermarks count=" + l + "/" + l2 + " byte=" + l3 + "/" + l4));
        }
        this._watermarkCountHigh = l2;
        this._watermarkCountLow = l;
        this._watermarkBytesHigh = l4;
        this._watermarkBytesLow = l3;
    }
}

