/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.ref;

import com.ibm.ws.sib.msgstore.CacheStatistics;

final class Statistics
implements CacheStatistics {
    private long _currentCount = 0L;
    private long _currentSize = 0L;
    private long _discardableSize = 0L;
    private long _maximumSize = 10000L;
    private long _totalCount = 0L;
    private long _totalDiscardCount = 0L;
    private long _totalDiscardSize = 0L;
    private long _totalRefusalCount = 0L;
    private long _totalSize = 0L;

    Statistics(long l) {
        this._maximumSize = l;
    }

    final void addIndirection(int n) {
        this._currentSize += (long)n;
        ++this._currentCount;
        ++this._totalCount;
    }

    final synchronized void decrementDiscardable(int n) {
        this._discardableSize -= (long)n;
    }

    final synchronized void discardIndirection(int n) {
        this._currentSize -= (long)n;
        this._totalDiscardSize += (long)n;
        this._discardableSize -= (long)n;
        ++this._totalDiscardCount;
        --this._currentCount;
    }

    public final long getCurrentCount() {
        return this._currentCount;
    }

    public final long getCurrentSize() {
        return this._currentSize;
    }

    public final long getDiscardableSize() {
        return this._discardableSize;
    }

    public final long getMaximumSize() {
        return this._maximumSize;
    }

    public final long getTotalCount() {
        return this._totalCount;
    }

    public final long getTotalDiscardCount() {
        return this._totalDiscardCount;
    }

    public final long getTotalDiscardSize() {
        return this._totalDiscardSize;
    }

    public final long getTotalRefusalCount() {
        return this._totalRefusalCount;
    }

    public final long getTotalSize() {
        return this._totalSize;
    }

    final synchronized void incrementDiscardable(int n) {
        this._discardableSize += (long)n;
    }

    final synchronized void incrementRefusalCount() {
        ++this._totalRefusalCount;
    }

    final synchronized void indirectionReleased(int n) {
        this._currentSize -= (long)n;
        --this._currentCount;
    }

    final synchronized void indirectionDiscarded(int n) {
        this._currentSize -= (long)n;
        --this._currentCount;
        ++this._totalDiscardCount;
    }

    public final synchronized void resetTotals() {
        this._totalDiscardCount = 0L;
        this._totalDiscardSize = 0L;
        this._totalCount = 0L;
        this._totalRefusalCount = 0L;
        this._totalSize = 0L;
    }

    final synchronized void setMaximumSize(long l) {
        this._maximumSize = l;
    }
}

