/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.ref;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.cache.ref.Indirection;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

final class IndirectionList {
    public static final String $ssccid = "@(#) 1.3 SIB/ws/code/sib.msgstore.impl/src/com/ibm/ws/sib/msgstore/cache/ref/IndirectionList.java, SIB.msgstore.impl, WAS602.SIB, o0610.11 05/05/03 09:53:07 [3/13/06 13:38:27]";
    private static TraceComponent tc = SibTr.register((Class)IndirectionList.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private long _currentCount = 0L;
    private long _currentSize = 0L;
    private Indirection _first = null;
    private Indirection _last = null;

    IndirectionList() {
    }

    final synchronized boolean append(Indirection indirection, AbstractItem abstractItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_append", (Object)indirection);
        }
        boolean bl = false;
        if (null == indirection) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"ignoring null indirection");
            }
        } else if (null == abstractItem) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"ignoring append of indirection to null item");
            }
        } else if (null != indirection.itemCacheGetNextLink() || null != indirection.itemCacheGetPrevioustLink()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("indirection already linked: " + indirection.getID()));
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("link: " + indirection.getID() + " (count=" + this._currentCount + ",size=" + this._currentSize + ")"));
            }
            if (null == this._first || null == this._last) {
                indirection.itemCacheSetNextLink(null);
                indirection.itemCacheSetPreviousLink(null);
                this._last = indirection;
                this._first = indirection;
            } else if (this._first == this._last) {
                if (indirection == this._first) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("indirection already linked: " + indirection.getID()));
                    }
                } else {
                    indirection.itemCacheSetNextLink(null);
                    indirection.itemCacheSetPreviousLink(this._first);
                    this._last = indirection;
                    this._first.itemCacheSetNextLink(this._last);
                }
            } else {
                indirection.itemCacheSetNextLink(null);
                indirection.itemCacheSetPreviousLink(this._last);
                this._last.itemCacheSetNextLink(indirection);
                this._last = indirection;
            }
            indirection.itemCacheSetManagedReference(abstractItem);
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("linked: " + indirection.getID() + " (count=" + this._currentCount + ",size=" + this._currentSize + ")"));
            }
            bl = true;
            ++this._currentCount;
            this._currentSize += (long)indirection.getSize();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_append", (Object)new Boolean(bl));
        }
        return bl;
    }

    final synchronized long getCurrentCount() {
        return this._currentCount;
    }

    final synchronized long getCurrentSize() {
        return this._currentSize;
    }

    final synchronized Indirection getFirst() {
        return this._first;
    }

    final synchronized Indirection removeFirst() {
        Indirection indirection = this._first;
        if (null == indirection) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"list empty, reset counters");
            }
            this._currentCount = 0L;
            this._currentSize = 0L;
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("unlinking " + indirection.getID()));
            }
            if (indirection == this._last) {
                this._first = null;
                this._last = null;
                this._currentCount = 0L;
                this._currentSize = 0L;
            } else {
                this._first = indirection.itemCacheGetNextLink();
                this._first.itemCacheSetPreviousLink(null);
                --this._currentCount;
                this._currentSize -= (long)indirection.getSize();
            }
            indirection.itemCacheSetManagedReference(null);
            indirection.itemCacheSetNextLink(null);
            indirection.itemCacheSetPreviousLink(null);
        }
        return indirection;
    }

    final synchronized boolean unlink(Indirection indirection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_unlink", (Object)indirection);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("unlink: " + indirection.getID() + " (count=" + this._currentCount + ",size=" + this._currentSize + ")"));
        }
        boolean bl = false;
        if (null == this._first || null == this._last) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"empty list");
            }
        } else if (this._first == this._last) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"one element list");
            }
            if (indirection == this._first) {
                this._first = null;
                this._last = null;
                bl = true;
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"indirection not in list!");
            }
        } else if (null == indirection.itemCacheGetNextLink() && null == indirection.itemCacheGetPrevioustLink()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"indirection not linked");
            }
        } else if (indirection == this._first) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"indirection is first");
            }
            if (null == indirection.itemCacheGetNextLink()) {
                throw new MessageStoreRuntimeException("unexpected null forward link");
            }
            this._first = indirection.itemCacheGetNextLink();
            this._first.itemCacheSetPreviousLink(null);
            bl = true;
        } else if (indirection == this._last) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"indirection is last");
            }
            if (null == indirection.itemCacheGetPrevioustLink()) {
                throw new MessageStoreRuntimeException("unexpected null backward link");
            }
            this._last = indirection.itemCacheGetPrevioustLink();
            this._last.itemCacheSetNextLink(null);
            bl = true;
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"indirection is in middle");
            }
            if (null == indirection.itemCacheGetNextLink() || null == indirection.itemCacheGetPrevioustLink()) {
                throw new MessageStoreRuntimeException("unexpected null link");
            }
            Indirection indirection2 = indirection.itemCacheGetPrevioustLink();
            Indirection indirection3 = indirection.itemCacheGetNextLink();
            indirection2.itemCacheSetNextLink(indirection3);
            indirection3.itemCacheSetPreviousLink(indirection2);
            bl = true;
        }
        indirection.itemCacheSetNextLink(null);
        indirection.itemCacheSetPreviousLink(null);
        if (bl) {
            indirection.itemCacheSetManagedReference(null);
            --this._currentCount;
            this._currentSize -= (long)indirection.getSize();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_unlink", (Object)new Boolean(bl));
        }
        return bl;
    }

    final void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        for (Indirection indirection = this.getFirst(); null != indirection; indirection = indirection.itemCacheGetNextLink()) {
            formattedWriter.newLine();
            indirection.xmlShortWriteOn(formattedWriter);
        }
    }
}

