/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.ItemStreamLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.cache.links.NoLockNoPriorityCursor;
import com.ibm.ws.sib.msgstore.cache.statemodel.ListStatistics;
import com.ibm.ws.sib.msgstore.cache.xalist.Cursor;
import com.ibm.ws.sib.msgstore.cache.xalist.TransactionalList;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class RootMembership
extends LinkOwner {
    public static final long MEMBER_KEY = -2L;
    public static final long MEMBERSHIP_KEY = -3L;
    private static TraceComponent tc = SibTr.register((Class)RootMembership.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private TransactionalList _itemStreams;
    private final MessageStoreImpl _messageStore;
    private long _nextItemStreamSequenceToIssue = 0L;
    private final ListStatistics _statistics;

    public RootMembership(MessageStoreImpl messageStoreImpl, Persistable persistable) throws OutOfCacheSpace {
        super(persistable, true);
        this._messageStore = messageStoreImpl;
        this._statistics = new ListStatistics(this);
        this._restoreStateAvailable(this, null);
    }

    private void _buildStreamTree(HashMap hashMap) {
        this._itemStreams = new TransactionalList();
        ArrayList arrayList = (ArrayList)hashMap.remove(new Long(this.getID()));
        for (int i = 0; null != arrayList && i < arrayList.size(); ++i) {
            long l;
            Persistable persistable = (Persistable)arrayList.get(i);
            persistable.setContainingStream(this.getTuple());
            ItemStreamLink itemStreamLink = null;
            if (!persistable.getTupleType().equals(TupleTypeEnum.ITEM_STREAM)) {
                throw new MessageStoreRuntimeException("Wrong tuple type in ItemStream:" + persistable.getTupleType());
            }
            itemStreamLink = new ItemStreamLink(this, persistable);
            if (null != itemStreamLink) {
                itemStreamLink.restoreState(persistable);
                if (itemStreamLink.isInStore()) {
                    this._messageStore.register(itemStreamLink);
                }
                itemStreamLink._initializeChildren(hashMap);
            }
            if ((l = persistable.getSequence()) < this._nextItemStreamSequenceToIssue) continue;
            this._nextItemStreamSequenceToIssue = l + 1L;
        }
    }

    private final HashMap _buildTupleMap(PersistentMessageStore persistentMessageStore) throws PersistenceException {
        HashMap<Long, ArrayList<Persistable>> hashMap = new HashMap<Long, ArrayList<Persistable>>();
        List list = persistentMessageStore.readAllStreams();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Persistable persistable = (Persistable)iterator.next();
            long l = persistable.getContainingStreamId();
            Long l2 = new Long(l);
            ArrayList<Persistable> arrayList = (ArrayList<Persistable>)hashMap.get(l2);
            if (null == arrayList) {
                arrayList = new ArrayList<Persistable>();
                hashMap.put(l2, arrayList);
            }
            arrayList.add(persistable);
        }
        return hashMap;
    }

    private void _recoverStreamsWithInDoubts(PersistentMessageStore persistentMessageStore) throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_recoverStreamsWithInDoubts");
        }
        Iterator iterator = persistentMessageStore.identifyStreamsWithIndoubtItems().iterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            LinkOwner linkOwner = (LinkOwner)this._messageStore.getLink(l);
            if (null != linkOwner) {
                linkOwner.loadOwnedLinks();
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"no item?");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_recoverStreamsWithInDoubts");
        }
    }

    public final void addItemStream(ItemStream itemStream, long l, Transaction transaction) throws MessageStoreException {
        MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
        int n = itemStream.getStorageStrategy();
        long l2 = messageStoreImpl.getUniqueValue(n);
        TupleTypeEnum tupleTypeEnum = TupleTypeEnum.ITEM_STREAM;
        Persistable persistable = this.getTuple().createPersistable(l2, tupleTypeEnum);
        persistable.setStorageStrategy(n);
        ItemStreamLink itemStreamLink = new ItemStreamLink(itemStream, (LinkOwner)this, persistable);
        itemStreamLink.setParentWasSpillingAtAddTime(this.getListStatistics().isSpilling());
        messageStoreImpl.registerLink(itemStreamLink, itemStream);
        itemStreamLink.cmdAdd(this, l, transaction);
    }

    public final void append(AbstractItemLink abstractItemLink) {
        if (!abstractItemLink.isItemStreamLink()) {
            throw new MessageStoreRuntimeException("Cannot add this directly to message store");
        }
        this._itemStreams.append(abstractItemLink);
    }

    public final RuntimeException assertCanDelete(Transaction transaction) {
        return new MessageStoreRuntimeException("cannot delete root");
    }

    public final void calculateMovingAverage() {
    }

    public final void eventWatermarkBreached() {
    }

    public final boolean expirableExpire() {
        return false;
    }

    public final ItemStream findFirstMatchingItemStream(Filter filter) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItemStream", (Object)filter);
        }
        ItemStream itemStream = (ItemStream)this._itemStreams.findFirstMatching(filter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItemStream", (Object)itemStream);
        }
        return itemStream;
    }

    final ItemStream getItemStream() {
        return null;
    }

    public final ListStatistics getListStatistics() {
        return this._statistics;
    }

    public final long getMembershipKey() {
        return -3L;
    }

    public final MessageStoreImpl getMessageStoreImpl() {
        return this._messageStore;
    }

    public ListStatistics getParentStatistics() {
        return this._statistics;
    }

    final ReferenceStream getReferenceStream() {
        return null;
    }

    public final TupleTypeEnum getTupleType() {
        return TupleTypeEnum.ROOT;
    }

    public final void initialize() throws PersistenceException {
        PersistentMessageStore persistentMessageStore = this._messageStore.getPersistentMessageStore();
        HashMap hashMap = this._buildTupleMap(persistentMessageStore);
        this._buildStreamTree(hashMap);
        this._recoverStreamsWithInDoubts(persistentMessageStore);
    }

    public final void linkAvailable(AbstractItemLink abstractItemLink) {
    }

    public final boolean loadOwnedLinks() {
        return false;
    }

    public final NonLockingCursor newNonLockingItemStreamCursor(Filter filter) {
        Cursor cursor = new Cursor(this._itemStreams, filter);
        return new NoLockNoPriorityCursor(cursor);
    }

    public synchronized long nextSequence() {
        return this._nextItemStreamSequenceToIssue++;
    }

    public final ItemStream removeFirstMatchingItemStream(Filter filter, Transaction transaction) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItemStream");
        }
        ItemStream itemStream = (ItemStream)this._itemStreams.removeFirstMatching(filter, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItemStream", (Object)itemStream);
        }
        return itemStream;
    }

    protected final String xmlTagName() {
        return "Root";
    }

    protected final void xmlWriteChildrenOn(FormattedWriter formattedWriter) throws IOException {
        super.xmlWriteChildrenOn(formattedWriter);
        this.xmlWriteItemStreamsOn(formattedWriter);
    }

    public final void xmlWriteItemStreamsOn(FormattedWriter formattedWriter) throws IOException {
        if (null != this._itemStreams) {
            this._itemStreams.xmlWriteOn(formattedWriter, "itemStreams");
        }
    }
}

