/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemReference;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.ReferenceCollection;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.CursorImpl;
import com.ibm.ws.sib.msgstore.cache.links.ItemReferenceLink;
import com.ibm.ws.sib.msgstore.cache.links.ItemStreamLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.cache.links.PrioritisedList;
import com.ibm.ws.sib.msgstore.cache.statemodel.ListStatistics;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public final class ReferenceStreamLink
extends LinkOwner
implements ReferenceCollection {
    private static TraceComponent tc = SibTr.register((Class)ReferenceStreamLink.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private long _nextSequenceToIssue = 0L;
    private PrioritisedList _references = null;
    private final ListStatistics _statistics;

    public ReferenceStreamLink(LinkOwner linkOwner, Persistable persistable) {
        super(linkOwner, persistable);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ReferenceStreamLink", (Object)new Object[]{linkOwner, persistable});
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ReferenceStreamLink", (Object)this);
        }
        this._statistics = new ListStatistics(this);
    }

    public ReferenceStreamLink(ReferenceStream referenceStream, LinkOwner linkOwner, Persistable persistable) throws OutOfCacheSpace {
        super(referenceStream, linkOwner, persistable);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ReferenceStreamLink", (Object)new Object[]{linkOwner, referenceStream, persistable});
        }
        this._statistics = new ListStatistics(this);
        this._setWatermarks(referenceStream);
        this._references = new PrioritisedList();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ReferenceStreamLink", (Object)this);
        }
    }

    private final void _initializeReferences() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_initializeReferences");
        }
        MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
        PersistentMessageStore persistentMessageStore = messageStoreImpl.getPersistentMessageStore();
        try {
            List list = persistentMessageStore.readNonStreamItems(this.getTuple());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Persistable persistable = (Persistable)iterator.next();
                ItemReferenceLink itemReferenceLink = null;
                if (persistable.getTupleType().equals(TupleTypeEnum.ITEM_REFERENCE)) {
                    itemReferenceLink = new ItemReferenceLink(this, persistable);
                    itemReferenceLink.restoreState(persistable);
                    if (itemReferenceLink.isInStore()) {
                        messageStoreImpl.register(itemReferenceLink);
                    }
                } else {
                    throw new MessageStoreRuntimeException("Wrong tuple type in ReferenceStream:" + persistable.getTupleType());
                }
                long l = persistable.getSequence();
                if (l < this._nextSequenceToIssue) continue;
                this._nextSequenceToIssue = l + 1L;
            }
        }
        catch (PersistenceException persistenceException) {
            FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.cache.links.ReferenceStreamLink._initializeReferences", (String)"147", (Object)this);
            throw new MessageStoreRuntimeException((Throwable)((Object)persistenceException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_initializeReferences");
        }
    }

    private final PrioritisedList _references() {
        if (null == this._references) {
            this._references = new PrioritisedList();
            ((ItemStreamLink)this.getOwningStreamLink()).assertReadyForReferenceInitialisation();
            this._initializeReferences();
        }
        return this._references;
    }

    private final void _setWatermarks(ReferenceStream referenceStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_setWatermarks", (Object)referenceStream);
        }
        long l = referenceStream.getCountLowWaterMark();
        long l2 = referenceStream.getCountHighWaterMark();
        long l3 = referenceStream.getByteLowWaterMark();
        long l4 = referenceStream.getByteHighWaterMark();
        this._statistics.setWatermarks(l, l2, l3, l4);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_setWatermarks", (Object)this._statistics);
        }
    }

    public final void addReference(ItemReference itemReference, long l, Transaction transaction) throws OutOfCacheSpace, ProtocolException, StreamIsFull, TransactionException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addReference", (Object)new Object[]{itemReference, transaction});
        }
        this._references();
        MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
        int n = itemReference.getStorageStrategy();
        long l2 = messageStoreImpl.getUniqueValue(n);
        TupleTypeEnum tupleTypeEnum = TupleTypeEnum.ITEM_REFERENCE;
        Persistable persistable = this.getTuple().createPersistable(l2, tupleTypeEnum);
        ItemReferenceLink itemReferenceLink = new ItemReferenceLink(itemReference, this, persistable);
        itemReferenceLink.setParentWasSpillingAtAddTime(this.getListStatistics().isSpilling());
        messageStoreImpl.registerLink(itemReferenceLink, itemReference);
        itemReferenceLink.cmdAdd(this, l, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addReference");
        }
    }

    public final void append(AbstractItemLink abstractItemLink) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"append", (Object)abstractItemLink);
        }
        this._references().append(abstractItemLink);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"append");
        }
    }

    public final RuntimeException assertCanDelete(Transaction transaction) {
        Object object = super.assertCanDelete(transaction);
        if (null != object) {
            return object;
        }
        int n = 0;
        TaskList taskList = (TaskList)transaction.getWorkList();
        if (null != taskList) {
            n = taskList.countRemovingItems(this);
            boolean bl = this.getListStatistics().canDelete(n);
            if (!bl) {
                object = new MessageStoreRuntimeException("STREAM_NOT_EMPTY_SIMS0501");
            }
        }
        return object;
    }

    public final void calculateMovingAverage() {
        this._statistics.calculateMovingAverage();
    }

    protected final boolean canSoftenReference() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"canSoftenReference");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"canSoftenReference", (Object)new Boolean(false));
        }
        return false;
    }

    public final synchronized void ensureReferencesLoaded() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ensureReferencesLoaded");
        }
        this._references();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ensureReferencesLoaded");
        }
    }

    public final void eventWatermarkBreached() {
        ReferenceStream referenceStream;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"eventWatermarkBreached");
        }
        if (null != (referenceStream = (ReferenceStream)this.getItem())) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("notifying eventWatermarkBreached: " + referenceStream));
            }
            referenceStream.eventWatermarkBreached();
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("notified eventWatermarkBreached: " + referenceStream));
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"no referenceStream to notify");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventWatermarkBreached");
        }
    }

    public final boolean expirableExpire(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"expirableExpire", (Object)("tran=" + transaction));
        }
        this._references();
        boolean bl = true;
        if (this._statistics.countTotalItems() > 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"cannot expire a non-empty stream");
            }
            bl = false;
        } else {
            bl = super.expirableExpire(transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"expirableExpire", (Object)new Boolean(bl));
        }
        return bl;
    }

    public final AbstractItem findById(long l) {
        this.getStatistics();
        return this.getMessageStoreImpl()._findById(l);
    }

    public final AbstractItem findFirstMatching(Filter filter) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)filter);
        }
        AbstractItem abstractItem = this._references().findFirstMatching(filter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)abstractItem);
        }
        return abstractItem;
    }

    public final AbstractItem findOldestItem() throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findOldestItem");
        }
        AbstractItem abstractItem = this._references().findOldestItem();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findOldestItem", (Object)abstractItem);
        }
        return abstractItem;
    }

    final ItemStream getItemStream() {
        return null;
    }

    public final ListStatistics getListStatistics() {
        return this._statistics;
    }

    public final ItemStream getOwningItemStream() {
        return ((ItemStreamLink)this.getOwningStreamLink()).getItemStream();
    }

    final ReferenceStream getReferenceStream() {
        return (ReferenceStream)this.getItem();
    }

    public final Statistics getStatistics() {
        this._references();
        return this.getListStatistics();
    }

    public final boolean isReferenceStreamLink() {
        return true;
    }

    public final boolean isSpilling() {
        boolean bl = false;
        if (1 != this.getTuple().getStorageStrategy()) {
            bl = this.getListStatistics().isSpilling();
        }
        return bl;
    }

    protected final void itemHasBeenRestored(AbstractItem abstractItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"itemHasBeenRestored", (Object)abstractItem);
        }
        super.itemHasBeenRestored(abstractItem);
        this._setWatermarks((ReferenceStream)abstractItem);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"itemHasBeenRestored");
        }
    }

    public final void linkAvailable(AbstractItemLink abstractItemLink) {
        this._references().linkAvailable(abstractItemLink);
    }

    public final boolean loadOwnedLinks() {
        boolean bl = false;
        if (null == this._references) {
            this._references();
            bl = true;
        }
        return bl;
    }

    public final LockingCursor newLockingCursor(Filter filter) throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newLockingCursor", (Object)filter);
        }
        AbstractItem abstractItem = this.getItem();
        int n = abstractItem.getStorageStrategy();
        long l = this.getMessageStoreImpl().getUniqueLockID(n);
        CursorImpl cursorImpl = this._references().newCursor(filter, l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newLockingCursor", (Object)cursorImpl);
        }
        return cursorImpl;
    }

    public final NonLockingCursor newNonLockingCursor(Filter filter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingCursor", (Object)filter);
        }
        CursorImpl cursorImpl = this._references().newCursor(filter, -2L);
        cursorImpl.disableJumpback();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingCursor", (Object)cursorImpl);
        }
        return cursorImpl;
    }

    public final synchronized long nextSequence() {
        return this._nextSequenceToIssue++;
    }

    public final AbstractItem removeFirstMatching(Filter filter, Transaction transaction) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)new Object[]{filter, transaction});
        }
        PrioritisedList prioritisedList = this._references();
        AbstractItem abstractItem = prioritisedList.removeFirstMatching(filter, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)abstractItem);
        }
        return abstractItem;
    }

    public void setMaximumSize(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMaximumSize", (Object)new Integer(n));
        }
        if (!this.isAdding()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"ignoring as not adding");
            }
        } else if (n < 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"ignoring invalid value");
            }
        } else {
            this.getListStatistics().setMaximumSize(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMaximumSize");
        }
    }

    public final void setWatermarks(long l, long l2, long l3, long l4) {
        this._statistics.setWatermarks(l, l2, l3, l4);
    }

    public String toString() {
        return "ReferenceStreamLink(" + this.getID() + ")" + super.toString() + " state=" + this.getState();
    }

    protected final boolean xmlHasChildren() {
        if (null != this._references) {
            return this._references.xmlHasChildren();
        }
        return false;
    }

    protected final String xmlTagName() {
        return "ReferenceStream";
    }

    protected final void xmlWriteChildrenOn(FormattedWriter formattedWriter) throws IOException {
        super.xmlWriteChildrenOn(formattedWriter);
        if (null != this._references) {
            this._references.xmlWriteChildrenOn(formattedWriter, "references");
        }
    }
}

