/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemReference;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.ReferenceMembership;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.ItemLink;
import com.ibm.ws.sib.msgstore.cache.links.ReferenceStreamLink;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.SibTr;

final class ItemReferenceLink
extends AbstractItemLink
implements ReferenceMembership {
    public static final String $ssccid = "@(#) 1.43 SIB/ws/code/sib.msgstore.impl/src/com/ibm/ws/sib/msgstore/cache/links/ItemReferenceLink.java, SIB.msgstore.impl, WAS602.SIB, o0610.11 05/04/07 12:15:09 [3/13/06 13:37:49]";
    private static TraceComponent tc = SibTr.register((Class)ItemReferenceLink.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");

    ItemReferenceLink(ItemReference itemReference, ReferenceStreamLink referenceStreamLink, Persistable persistable) throws OutOfCacheSpace {
        super(itemReference, referenceStreamLink, persistable);
        Item item = itemReference.getReferredItem();
        if (item.isItemStream()) {
            throw new MessageStoreRuntimeException("cannot have reference to itemStream");
        }
        if (item.isReferenceStream()) {
            throw new MessageStoreRuntimeException("cannot have reference to referenceStream");
        }
        if (item.isItemReference()) {
            throw new MessageStoreRuntimeException("cannot have reference to reference");
        }
        long l = item.getID();
        this.getTuple().setReferredID(l);
        if (-1L == l) {
            throw new MessageStoreRuntimeException("Restored reference with invalid ID");
        }
        MessageStoreImpl messageStoreImpl = (MessageStoreImpl)this.getMessageStore();
        ItemLink itemLink = (ItemLink)messageStoreImpl.getMembership(l);
        if (null != itemLink) {
            itemLink.incrementReferenceCount();
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("reference to non-existent item: " + l));
        }
    }

    ItemReferenceLink(ReferenceStreamLink referenceStreamLink, Persistable persistable) {
        super(referenceStreamLink, persistable);
        long l = persistable.getReferredID();
        this.getTuple().setReferredID(l);
        if (-1L == l) {
            throw new MessageStoreRuntimeException("Restored reference with invalid ID");
        }
        MessageStoreImpl messageStoreImpl = (MessageStoreImpl)this.getMessageStore();
        ItemLink itemLink = (ItemLink)messageStoreImpl.getMembership(l);
        if (null != itemLink) {
            itemLink.incrementReferenceCount();
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("reference to non-existent item: " + l));
        }
    }

    public final void abortAdd(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abortAdd", (Object)transaction);
        }
        long l = this.getTuple().getReferredID();
        super.abortAdd(transaction);
        if (-1L != l) {
            MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
            ItemLink itemLink = (ItemLink)messageStoreImpl.getMembership(l);
            if (null != itemLink) {
                itemLink.rollbackIncrementReferenceCount(transaction);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("reference to non-existent item: " + l));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortAdd");
        }
    }

    public final ReferenceStream getOwningReferenceStream() {
        return ((ReferenceStreamLink)this.getOwningStreamLink()).getReferenceStream();
    }

    public final long getReferencedID() {
        return this.getTuple().getReferredID();
    }

    public final long getReferredID() {
        return this.getTuple().getReferredID();
    }

    public final void internalCommitRemove(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"internalCommitRemove");
        }
        long l = this.getTuple().getReferredID();
        super.internalCommitRemove(transaction);
        if (-1L != l) {
            MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
            ItemLink itemLink = (ItemLink)messageStoreImpl.getMembership(l);
            if (null != itemLink) {
                itemLink.commitDecrementReferenceCount(transaction);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("reference to non-existent item: " + l));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"internalCommitRemove");
        }
    }

    public String toString() {
        return "ItemReferenceLink(" + this.getID() + " --> " + this.getReferencedID() + ")" + super.toString() + " state=" + this.getState();
    }

    protected final String xmlTagName() {
        return "Reference";
    }
}

