/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemMembership;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.ItemStreamLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.TransactionCallback;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public final class ItemLink
extends AbstractItemLink
implements ItemMembership,
TransactionCallback {
    public static final String $ssccid = "@(#) 1.101 SIB/ws/code/sib.msgstore.impl/src/com/ibm/ws/sib/msgstore/cache/links/ItemLink.java, SIB.msgstore.impl, WAS602.SIB, o0610.11 05/04/07 12:15:06 [3/13/06 13:37:49]";
    private static TraceComponent tc = SibTr.register((Class)ItemLink.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private volatile int _referenceCount = 0;
    private boolean _referenceCountIsDecreasing = false;

    public ItemLink(AbstractItem abstractItem, LinkOwner linkOwner, Persistable persistable) throws OutOfCacheSpace {
        super(abstractItem, linkOwner, persistable);
    }

    public ItemLink(LinkOwner linkOwner, Persistable persistable) {
        super(linkOwner, persistable);
    }

    public RuntimeException assertCanDelete(Transaction transaction) {
        Object object = super.assertCanDelete(transaction);
        if (null == object && 0 < this._referenceCount) {
            object = new MessageStoreRuntimeException("Cannot delete Item with references");
            FFDCFilter.processException((Throwable)object, (String)"ItemLink.delete", (String)"1:102:1.101");
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception :  Cannot delete Item with references");
            }
        }
        return object;
    }

    public final synchronized void commitDecrementReferenceCount(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitDecrementReferenceCount");
        }
        if (this._referenceCount < 1) {
            MessageStoreRuntimeException messageStoreRuntimeException = new MessageStoreRuntimeException("Reference count decrement cannot be committed");
            FFDCFilter.processException((Throwable)((Object)messageStoreRuntimeException), (String)"com.ibm.ws.sib.msgstore.cache.links.ItemLink.commitDecrementReferenceCount", (String)"1:123:1.101");
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Reference count decrement cannot be committed");
            }
            throw messageStoreRuntimeException;
        }
        --this._referenceCount;
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("reference count dropped to: " + this._referenceCount));
        }
        if (0 == this._referenceCount) {
            transaction.registerCallback(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitDecrementReferenceCount");
        }
    }

    public final ItemStream getOwningItemStream() {
        return ((ItemStreamLink)this.getOwningStreamLink()).getItemStream();
    }

    public final int getReferenceCount() {
        return this._referenceCount;
    }

    public final synchronized void incrementReferenceCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"incrementReferenceCount");
        }
        if (this._referenceCountIsDecreasing) {
            throw new MessageStoreRuntimeException("Cannot add more references to an item after one has been removed");
        }
        ++this._referenceCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"incrementReferenceCount");
        }
    }

    protected boolean internalCanExpire() {
        boolean bl = super.internalCanExpire();
        if (bl && this._referenceCount > 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"preventing expiry as references remain");
            }
            bl = false;
        }
        return bl;
    }

    public final synchronized void rollbackIncrementReferenceCount(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollbackIncrementReferenceCount");
        }
        if (this._referenceCount < 1) {
            MessageStoreRuntimeException messageStoreRuntimeException = new MessageStoreRuntimeException("Reference count increment cannot be rolled back");
            FFDCFilter.processException((Throwable)((Object)messageStoreRuntimeException), (String)"com.ibm.ws.sib.msgstore.cache.links.ItemLink.rollbackIncrementReferenceCount", (String)"1:205:1.101");
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Reference count increment cannot be rolled back");
            }
            throw messageStoreRuntimeException;
        }
        --this._referenceCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollbackIncrementReferenceCount");
        }
    }

    public String toString() {
        return "ItemLink(" + this.getID() + ")" + super.toString() + " state=" + this.getState() + " refCount=" + this._referenceCount + " refCountDecreasing=" + Boolean.toString(this._referenceCountIsDecreasing);
    }

    protected final String xmlTagName() {
        return "Item";
    }

    protected void xmlWriteAttributesOn(FormattedWriter formattedWriter) throws IOException {
        super.xmlWriteAttributesOn(formattedWriter);
        formattedWriter.write(" refCount=\"");
        formattedWriter.write(Integer.toString(this._referenceCount));
        formattedWriter.write("\" refCountDecreasing=\"");
        formattedWriter.write(Boolean.toString(this._referenceCountIsDecreasing));
        formattedWriter.write(34);
    }

    public void beforeCompletion(Transaction transaction) {
    }

    public void afterCompletion(Transaction transaction, boolean bl) {
        Item item;
        if (this.isAvailable() && null != (item = (Item)this.getItem())) {
            item.itemReferencesDroppedToZero();
        }
    }
}

