/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.Priorities;
import com.ibm.ws.sib.msgstore.cache.links.PrioritisedList;
import com.ibm.ws.sib.msgstore.cache.xalist.Cursor;
import com.ibm.ws.sib.msgstore.cache.xalist.TransactionalList;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

class CursorImpl
implements LockingCursor,
NonLockingCursor,
Priorities {
    private static TraceComponent tc = SibTr.register((Class)CursorImpl.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private boolean _allowUnnavailableItems = false;
    private final Filter _itemFilter;
    private boolean _jumpbackEnabled = true;
    private final long _lockID;
    private CursorImpl _nextCursor = null;
    private final PrioritisedList _owningList;
    private final Cursor[] _subCursors;

    CursorImpl(PrioritisedList prioritisedList, Filter filter, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)prioritisedList);
        }
        this._owningList = prioritisedList;
        this._itemFilter = filter;
        this._lockID = l;
        this._subCursors = new Cursor[10];
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    private final Cursor _getSubCursor(int n) {
        TransactionalList transactionalList;
        Cursor cursor = this._subCursors[n];
        if (null == cursor && null != (transactionalList = this._owningList.getPrioritySublist(n))) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("lazy initialize sub cursor(" + n + ")"));
            }
            this._subCursors[n] = cursor = new Cursor(transactionalList, this._itemFilter);
            if (!this._jumpbackEnabled) {
                cursor.disableJumpback();
            }
        }
        return cursor;
    }

    public final void allowUnavailableItems() {
        this._allowUnnavailableItems = true;
    }

    public final void disableJumpback() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"disableJumpback");
        }
        this._jumpbackEnabled = false;
        for (int i = 0; i <= 9; ++i) {
            if (null == this._subCursors[i]) continue;
            this._subCursors[i].disableJumpback();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"disableJumpback");
        }
    }

    public final void finished() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"finished");
        }
        for (int i = 0; i <= 9; ++i) {
            if (null == this._subCursors[i]) continue;
            this._subCursors[i].finished();
        }
        this._owningList._removeCursor(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"finished");
        }
    }

    public final Filter getFilter() {
        return this._itemFilter;
    }

    public final long getLockID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLockID");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLockID", (Object)new Long(this._lockID));
        }
        return this._lockID;
    }

    final CursorImpl getNextCursor() {
        return this._nextCursor;
    }

    final void linkAvailable(AbstractItemLink abstractItemLink) {
        int n;
        Cursor cursor;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"linkAvailable", (Object)abstractItemLink);
        }
        if (null != (cursor = this._getSubCursor(n = abstractItemLink.getPriority()))) {
            cursor.available(abstractItemLink);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"linkAvailable");
        }
    }

    public final AbstractItem next() throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"next");
        }
        AbstractItem abstractItem = null;
        for (int i = 9; null == abstractItem && i >= 0; --i) {
            Cursor cursor = this._getSubCursor(i);
            if (null == cursor) continue;
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("search on subcursor (" + i + ")"));
            }
            abstractItem = -2L == this._lockID ? cursor.next(this._allowUnnavailableItems) : cursor.next(this._lockID);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"next", abstractItem);
        }
        return abstractItem;
    }

    final void setNextCursor(CursorImpl cursorImpl) {
        this._nextCursor = cursorImpl;
    }

    public final void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        formattedWriter.write("<cursor");
        formattedWriter.write(" sihc=\"");
        int n = System.identityHashCode(this);
        formattedWriter.write(Integer.toHexString(n));
        formattedWriter.write(34);
        if (-2L != this._lockID) {
            formattedWriter.write(" lockId=\"");
            formattedWriter.write(Long.toString(this._lockID));
            formattedWriter.write(34);
        }
        if (this._allowUnnavailableItems) {
            formattedWriter.write(" allowUnavailable=\"true\"");
        }
        if (this._jumpbackEnabled) {
            formattedWriter.write(" jumpbackEnabled=\"true\"");
        }
        formattedWriter.write(" >");
        formattedWriter.indent();
        for (int i = 9; i >= 0; --i) {
            Object object;
            Cursor cursor = this._subCursors[i];
            if (null == cursor || null == (object = cursor.peepLastLink())) continue;
            formattedWriter.newLine();
            formattedWriter.write("<priority_");
            formattedWriter.write(Integer.toString(i));
            formattedWriter.write(" lastLink=\"");
            int n2 = System.identityHashCode(object);
            formattedWriter.write(Integer.toHexString(n2));
            formattedWriter.write(34);
            formattedWriter.write(" />");
        }
        formattedWriter.outdent();
        formattedWriter.newLine();
        formattedWriter.write("<cursor/>");
    }
}

