/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.InvalidAddOperation;
import com.ibm.ws.sib.msgstore.Membership;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.cache.links.Priorities;
import com.ibm.ws.sib.msgstore.cache.ref.Indirection;
import com.ibm.ws.sib.msgstore.cache.ref.IndirectionCache;
import com.ibm.ws.sib.msgstore.cache.ref.ItemStorageManager;
import com.ibm.ws.sib.msgstore.cache.statemodel.ListStatistics;
import com.ibm.ws.sib.msgstore.cache.statemodel.LockIdMismatch;
import com.ibm.ws.sib.msgstore.cache.statemodel.StateException;
import com.ibm.ws.sib.msgstore.expiry.Expirable;
import com.ibm.ws.sib.msgstore.expiry.Expirer;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.task.AbstractRemoveTask;
import com.ibm.ws.sib.msgstore.task.AddTask;
import com.ibm.ws.sib.msgstore.task.PersistLock;
import com.ibm.ws.sib.msgstore.task.PersistUnlock;
import com.ibm.ws.sib.msgstore.task.RemoveLockedTask;
import com.ibm.ws.sib.msgstore.task.RemoveTask;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.task.UpdateTask;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.WorkItem;
import com.ibm.ws.sib.utils.collections.linkedlist.Link;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.lang.ref.WeakReference;

public abstract class AbstractItemLink
extends Link
implements Membership,
Priorities,
XmlConstants,
Expirable,
Indirection {
    public static final String $ssccid = "@(#) 1.199.1.1 SIB/ws/code/sib.msgstore.impl/src/com/ibm/ws/sib/msgstore/cache/links/AbstractItemLink.java, SIB.msgstore.impl, WAS602.SIB, o0610.11 05/08/08 08:06:28 [3/13/06 13:37:49]";
    static final long EXPIRY_LOCK_ID = 123456L;
    private static final long NO_LOCK_ID = -2L;
    private static final String[] STATE__NAMES = new String[]{"AddingLocked", "AddingUnlocked", "Available", "Locked", "LockedForExpiry", "NotStored", "PersistentlyLocked", "PersistingLock", "RemovingExpiring", "RemovingLocked", "RemovingPersistentlyLocked", "RemovingWithoutLock", "UnlockingPersistentlyLocked", "UpdatingData"};
    private static final int STATE_ADDING_LOCKED = 0;
    private static final int STATE_ADDING_UNLOCKED = 1;
    private static final int STATE_AVAILABLE = 2;
    private static final int STATE_LOCKED = 3;
    private static final int STATE_LOCKED_FOR_EXPIRY = 4;
    private static final int STATE_NOT_STORED = 5;
    private static final int STATE_PERSISTENTLY_LOCKED = 6;
    private static final int STATE_PERSISTING_LOCK = 7;
    private static final int STATE_REMOVING_EXPIRING = 8;
    private static final int STATE_REMOVING_LOCKED = 9;
    private static final int STATE_REMOVING_PERSISTENTLY_LOCKED = 10;
    private static final int STATE_REMOVING_WITHOUT_LOCK = 11;
    private static final int STATE_UNLOCKING_PERSISTENTLY_LOCKED = 12;
    private static final int STATE_UPDATING_DATA = 13;
    private static TraceComponent tc = SibTr.register((Class)AbstractItemLink.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private int _backoutCount = 0;
    private AbstractItem _strongReferenceToItem;
    private final int _invariantByteSize;
    private boolean _isStorageManaged = false;
    private IndirectionCache _itemCache;
    private Indirection _itemCacheLinkNext = null;
    private Indirection _itemCacheLinkPrevious = null;
    private AbstractItem _itemCacheManagedReference = null;
    private boolean _itemIsDiscardableIfPersistentRepresentationStable = false;
    private int _itemLinkState = 5;
    private long _lockID = -2L;
    private AbstractItemLink _nextMappedLink;
    private final LinkOwner _owningStreamLink;
    private boolean _persistentRepresentationIsStable = false;
    private PersistentTranId _transactionId;
    private final Persistable _tuple;
    private boolean _persistentDataEncodingFailed = false;
    private int _unlockCount = 0;
    private WeakReference _weakReferenceToItem;

    protected AbstractItemLink(AbstractItem abstractItem, LinkOwner linkOwner, Persistable persistable) throws OutOfCacheSpace {
        int n;
        this._itemLinkState = 5;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{linkOwner, persistable});
        }
        this._tuple = persistable;
        if (null == abstractItem) {
            n = 4;
            this._tuple.setStorageStrategy(4);
            this._tuple.setItemClassName(MessageStoreImpl.class.getName());
            this._invariantByteSize = 0;
        } else {
            n = abstractItem.getStorageStrategy();
            this._tuple.setStorageStrategy(n);
            this._tuple.setItemClassName(abstractItem.getClass().getName());
            this._invariantByteSize = abstractItem.getPersistentDataSize();
            this._tuple.setPersistentSize(this._invariantByteSize);
        }
        this._owningStreamLink = linkOwner;
        persistable.setAbstractItemLink(this);
        this._isStorageManaged = abstractItem.isItem() || abstractItem.isItemReference();
        MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
        if (this._isStorageManaged) {
            this._itemCache = messageStoreImpl.getManagedCache().register(this, n);
        }
        this._createWeakReference(abstractItem);
        this._strongReferenceToItem = abstractItem;
        if (1 == this._tuple.getStorageStrategy()) {
            this._persistentRepresentationIsStable = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected AbstractItemLink(LinkOwner linkOwner, Persistable persistable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{linkOwner, persistable});
        }
        this._itemLinkState = 5;
        this._tuple = persistable;
        this._invariantByteSize = this._tuple.getPersistentSize();
        persistable.setAbstractItemLink(this);
        this._owningStreamLink = linkOwner;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected AbstractItemLink(Persistable persistable, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)persistable);
        }
        this._itemLinkState = 5;
        this._tuple = persistable;
        this._invariantByteSize = this._tuple.getPersistentSize();
        persistable.setAbstractItemLink(this);
        this._owningStreamLink = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    final synchronized void _assertCanAddChild(Transaction transaction, ListStatistics listStatistics) throws StreamIsFull {
        boolean bl = false;
        switch (this._itemLinkState) {
            case 0: 
            case 1: {
                if (!this.getTransactionId().equals(transaction.getPersistentTranId())) break;
                bl = true;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (!bl) {
            throw new InvalidAddOperation("STREAM_WRONG_STATE_SIMS0006", this);
        }
        listStatistics.assertCanAdd();
        listStatistics.incrementAdding();
    }

    final void _assertCanAddChildUnder(Transaction transaction) {
        boolean bl = false;
        switch (this._itemLinkState) {
            case 0: 
            case 1: {
                if (!this.getTransactionId().equals(transaction.getPersistentTranId())) break;
                bl = true;
                break;
            }
            case 2: 
            case 13: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (!bl) {
            throw new InvalidAddOperation("STREAM_WRONG_STATE_SIMS0006", new Object[]{this});
        }
    }

    final void _assertCanRemoveChildUnder(Transaction transaction) {
        boolean bl = false;
        switch (this._itemLinkState) {
            case 2: 
            case 13: {
                bl = true;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                PersistentTranId persistentTranId = transaction.getPersistentTranId();
                if (!persistentTranId.equals(this.getTransactionId())) break;
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (!bl) {
            throw new MessageStoreRuntimeException(this.getStateName() + " - Wrong transaction(" + transaction.getPersistentTranId() + ") for action (old id=" + this.getTransactionId() + ")");
        }
    }

    private final void _assertCorrectTransaction(Transaction transaction) {
        PersistentTranId persistentTranId = transaction.getPersistentTranId();
        if (!persistentTranId.equals(this._transactionId)) {
            throw new MessageStoreRuntimeException(this.getStateName() + " - Wrong transaction(" + persistentTranId + ") for action (old id=" + this._transactionId + ")");
        }
    }

    private final void _createWeakReference(AbstractItem abstractItem) throws OutOfCacheSpace {
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"creating weak reference");
        }
        this._weakReferenceToItem = new WeakReference<AbstractItem>(abstractItem);
    }

    private final synchronized boolean _declareDiscardable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_declareDiscardable");
        }
        boolean bl = false;
        if (!this._itemIsDiscardableIfPersistentRepresentationStable) {
            bl = this._persistentRepresentationIsStable;
            if (bl) {
                this._strongReferenceToItem = null;
            }
            this._itemIsDiscardableIfPersistentRepresentationStable = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_declareDiscardable", (Object)new Boolean(bl));
        }
        return bl;
    }

    private final synchronized boolean _declareNotDiscardable(AbstractItem abstractItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_declareNotDiscardable");
        }
        boolean bl = false;
        this._strongReferenceToItem = abstractItem;
        if (this._itemIsDiscardableIfPersistentRepresentationStable) {
            bl = this._persistentRepresentationIsStable;
            this._itemIsDiscardableIfPersistentRepresentationStable = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_declareNotDiscardable", (Object)new Boolean(bl));
        }
        return bl;
    }

    private final void _declareNotReleasable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_declareNotReleasable");
        }
        if (this._isStorageManaged) {
            this._itemCache.unmanage(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_declareNotReleasable");
        }
    }

    private final void _declareReleasable(AbstractItem abstractItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_declareReleasable");
        }
        if (this._isStorageManaged) {
            this._itemCache.manage(this, abstractItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_declareReleasable");
        }
    }

    private final AbstractItem _getAndAssertItem() {
        AbstractItem abstractItem;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_getAndAssertItem");
        }
        if ((abstractItem = this._strongReferenceToItem) == null) {
            throw new MessageStoreRuntimeException("_getAndAssertItem");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_getAndAssertItem", (Object)abstractItem);
        }
        return abstractItem;
    }

    private final AbstractItem _getItemNoRestore() {
        AbstractItem abstractItem;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_getItemNoRestore");
        }
        if (null == (abstractItem = this._strongReferenceToItem) && null != this._weakReferenceToItem) {
            abstractItem = (AbstractItem)this._weakReferenceToItem.get();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_getItemNoRestore", (Object)abstractItem);
        }
        return abstractItem;
    }

    private final void _pmiIncrementAdd() {
        int n = 1;
        if (1 == this._tuple.getStorageStrategy()) {
            n = 2;
        }
        this.getInstrumentation().increment(n);
    }

    private final void _pmiIncrementRemove() {
        int n = 5;
        if (1 == this._tuple.getStorageStrategy()) {
            n = 6;
        }
        this.getInstrumentation().increment(n);
    }

    private final void _pmiIncrementUpdate() {
        int n = 3;
        if (1 == this._tuple.getStorageStrategy()) {
            n = 4;
        }
        this.getInstrumentation().increment(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final AbstractItem _restoreItem() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_restoreItem");
        }
        AbstractItem abstractItem = null;
        boolean bl = false;
        try {
            block28: {
                boolean bl2;
                block30: {
                    MessageStoreImpl messageStoreImpl;
                    block31: {
                        block29: {
                            AbstractItemLink abstractItemLink = this;
                            // MONITORENTER : abstractItemLink
                            bl2 = false;
                            abstractItem = this._getItemNoRestore();
                            if (null != abstractItem) break block28;
                            messageStoreImpl = this.getMessageStoreImpl();
                            if (this._tuple.getStorageStrategy() != 1) break block29;
                            if (5 != this._itemLinkState) {
                                if (2 != this._itemLinkState) throw new StateException(this.getStateName());
                                bl2 = true;
                            }
                            break block30;
                        }
                        if (!this._persistentDataEncodingFailed) break block31;
                        if (this._tuple.getStorageStrategy() == 2) {
                            if (5 != this._itemLinkState) {
                                if (2 != this._itemLinkState) throw new StateException(this.getStateName());
                                bl2 = true;
                            }
                            break block30;
                        } else {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"Attempted to restore data not in store");
                            }
                            MessageStoreRuntimeException messageStoreRuntimeException = new MessageStoreRuntimeException();
                            FFDCFilter.processException((Throwable)((Object)messageStoreRuntimeException), (String)(this.getClass().getName() + "._restoreItem"), (String)"1:635:1.199.1.1", (Object)this, (Object[])new Object[]{this._tuple});
                            throw messageStoreRuntimeException;
                        }
                    }
                    if (this.isInStore()) {
                        long l = this._tuple.getUniqueId();
                        byte[] byArray = this.readDataFromPersistence();
                        if (null != byArray) {
                            block27: {
                                try {
                                    String string = this._tuple.getItemClassName();
                                    abstractItem = (AbstractItem)Class.forName(string).newInstance();
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + "._restoreItem"), (String)"1:646:1.199.1.1", (Object)this);
                                    if (!tc.isDebugEnabled()) throw new MessageStoreRuntimeException("RESTORING_ITEM_SIMS0502" + l, exception);
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exception " + exception + " while restoring item "));
                                    throw new MessageStoreRuntimeException("RESTORING_ITEM_SIMS0502" + l, exception);
                                }
                                messageStoreImpl._setMembership(this, abstractItem);
                                try {
                                    abstractItem.restore(byArray);
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"item restored");
                                    }
                                }
                                catch (PersistentDataEncodingException persistentDataEncodingException) {
                                    FFDCFilter.processException((Throwable)((Object)persistentDataEncodingException), (String)(this.getClass().getName() + "._restoreItem"), (String)"1:664:1.199.1.1", (Object)this);
                                    if (!tc.isDebugEnabled()) break block27;
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("item restore, with exception " + (Object)((Object)persistentDataEncodingException)));
                                }
                            }
                            abstractItem.eventRestored();
                            this.itemHasBeenRestored(abstractItem);
                            messageStoreImpl._getInstrumentation().increment(7);
                        } else if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Indoubt item disappeared: ", (Object)this);
                        }
                        if (null != abstractItem) {
                            this._createWeakReference(abstractItem);
                            boolean bl3 = this._isStorageManaged = abstractItem.isItem() || abstractItem.isItemReference();
                            if (this._isStorageManaged) {
                                this._itemCache = messageStoreImpl.getManagedCache().register(this, this._tuple.getStorageStrategy());
                            } else {
                                this._strongReferenceToItem = abstractItem;
                            }
                            if (this.isAvailable() || this.isPersistentlyLocked()) {
                                this._declareDiscardable();
                            } else {
                                bl = this._declareNotDiscardable(abstractItem);
                            }
                        }
                    }
                }
                if (bl2) {
                    this._itemLinkState = 5;
                    ListStatistics listStatistics = this.getParentStatistics();
                    listStatistics.decrementTotal(this._invariantByteSize);
                    listStatistics.decrementAvailable();
                    this.getMessageStoreImpl().unregister(this);
                    this.unlink();
                }
            }
            // MONITOREXIT : abstractItemLink
            if (abstractItem != null) {
                this.persistentRepresentationIsStable();
            }
            if (bl) {
                this._declareNotReleasable();
            }
        }
        catch (OutOfCacheSpace outOfCacheSpace) {
            FFDCFilter.processException((Throwable)((Object)outOfCacheSpace), (String)(this.getClass().getName() + "._restoreItem"), (String)"1:724:1.199.1.1", (Object)this);
            if (!tc.isDebugEnabled()) throw new MessageStoreRuntimeException((Throwable)((Object)outOfCacheSpace));
            SibTr.debug((TraceComponent)tc, (String)("Exception " + (Object)((Object)outOfCacheSpace) + " while restoring item"));
            throw new MessageStoreRuntimeException((Throwable)((Object)outOfCacheSpace));
        }
        if (!tc.isEntryEnabled()) return abstractItem;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreItem", (Object)abstractItem);
        return abstractItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _restoreStateAdding(AbstractItemLink abstractItemLink, LinkOwner linkOwner, Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_restoreStateAdding", (Object)new Object[]{abstractItemLink, linkOwner, transaction});
        }
        AbstractItemLink abstractItemLink2 = this;
        synchronized (abstractItemLink2) {
            if (5 != this._itemLinkState) {
                throw new StateException(this.getStateName());
            }
            this._transactionId = transaction.getPersistentTranId();
            this._itemLinkState = 1;
            ListStatistics listStatistics = this.getParentStatistics();
            listStatistics.incrementAdding();
            listStatistics.incrementTotal(this._invariantByteSize);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateAdding");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void _restoreStateAvailable(AbstractItemLink abstractItemLink, LinkOwner linkOwner) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_restoreStateAvailable", (Object)new Object[]{abstractItemLink, linkOwner});
        }
        AbstractItemLink abstractItemLink2 = this;
        synchronized (abstractItemLink2) {
            if (5 != this._itemLinkState) {
                throw new StateException(this.getStateName());
            }
            ListStatistics listStatistics = this.getParentStatistics();
            listStatistics.incrementAvailable();
            listStatistics.incrementTotal(this._invariantByteSize);
            this._itemLinkState = 2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateAvailable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _restoreStatePersistentlyLocked(AbstractItemLink abstractItemLink, LinkOwner linkOwner, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_restoreStatePersistentlyLocked", (Object)new Object[]{abstractItemLink, linkOwner, new Long(l)});
        }
        AbstractItemLink abstractItemLink2 = this;
        synchronized (abstractItemLink2) {
            if (5 != this._itemLinkState) {
                throw new StateException(this.getStateName());
            }
            this._itemLinkState = 6;
            this._lockID = l;
            ListStatistics listStatistics = this.getParentStatistics();
            listStatistics.incrementLocked();
            listStatistics.incrementTotal(this._invariantByteSize);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStatePersistentlyLocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _restoreStateRemovingNoLock(AbstractItemLink abstractItemLink, LinkOwner linkOwner, Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_restoreStateRemovingNoLock", (Object)new Object[]{abstractItemLink, linkOwner, transaction});
        }
        AbstractItemLink abstractItemLink2 = this;
        synchronized (abstractItemLink2) {
            if (5 != this._itemLinkState) {
                throw new StateException(this.getStateName());
            }
            this._transactionId = transaction.getPersistentTranId();
            this._itemLinkState = 11;
            ListStatistics listStatistics = this.getParentStatistics();
            listStatistics.incrementRemoving();
            listStatistics.incrementTotal(this._invariantByteSize);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateRemovingNoLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _restoreStateRemovingPersistentlyLocked(AbstractItemLink abstractItemLink, LinkOwner linkOwner, long l, Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_restoreStateRemovingPersistentlyLocked", (Object)new Object[]{abstractItemLink, linkOwner, new Long(l), transaction});
        }
        AbstractItemLink abstractItemLink2 = this;
        synchronized (abstractItemLink2) {
            if (5 != this._itemLinkState) {
                throw new StateException(this.getStateName());
            }
            this._transactionId = transaction.getPersistentTranId();
            this._lockID = l;
            this._itemLinkState = 10;
            ListStatistics listStatistics = this.getParentStatistics();
            listStatistics.incrementTotal(this._invariantByteSize);
            listStatistics.incrementRemoving();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateRemovingPersistentlyLocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortAdd(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abortAdd", (Object)transaction);
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            switch (this._itemLinkState) {
                case 0: 
                case 1: {
                    this._assertCorrectTransaction(transaction);
                    this._owningStreamLink.getListStatistics().decrementAdding();
                    this._itemLinkState = 5;
                    ListStatistics listStatistics = this.getParentStatistics();
                    listStatistics.decrementTotal(this._invariantByteSize);
                    MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
                    messageStoreImpl.unregister(this);
                    Expirer expirer = messageStoreImpl._getExpirer();
                    long l = this.getTuple().getExpiryTime();
                    if (null != expirer && 0L != l) {
                        expirer.removeExpirable(this);
                    }
                    this._lockID = -2L;
                    break;
                }
                default: {
                    throw new StateException(this.getStateName());
                }
            }
            this._transactionId = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortAdd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abortPersistLock(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abortPersistLock", (Object)transaction);
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (7 != this._itemLinkState) {
                throw new StateException(this.getStateName());
            }
            this._assertCorrectTransaction(transaction);
            this._itemLinkState = 3;
            this._transactionId = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortPersistLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abortPersistUnlock(Transaction transaction) {
        AbstractItem abstractItem;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abortPersistUnlock", (Object)transaction);
        }
        boolean bl = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (12 == this._itemLinkState) {
                this._assertCorrectTransaction(transaction);
                abstractItem = this._getAndAssertItem();
                int n = this._tuple.getStorageStrategy();
                if (1 != n && 2 != n) {
                    bl = this._declareDiscardable();
                }
            } else {
                throw new StateException(this.getStateName());
            }
            this._itemLinkState = 6;
            this._transactionId = null;
        }
        if (bl) {
            this._declareReleasable(abstractItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortPersistUnlock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortRemove(Transaction transaction) {
        AbstractItem abstractItem;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abortRemove", (Object)transaction);
        }
        boolean bl = false;
        boolean bl2 = false;
        ListStatistics listStatistics = this.getParentStatistics();
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            switch (this._itemLinkState) {
                case 8: 
                case 11: {
                    this._assertCorrectTransaction(transaction);
                    abstractItem = this._getAndAssertItem();
                    ++this._backoutCount;
                    listStatistics.decrementRemoving();
                    listStatistics.incrementAvailable();
                    bl2 = this._declareDiscardable();
                    this._itemLinkState = 2;
                    bl = true;
                    break;
                }
                case 9: {
                    this._assertCorrectTransaction(transaction);
                    abstractItem = this._getAndAssertItem();
                    ++this._backoutCount;
                    listStatistics.decrementRemoving();
                    listStatistics.incrementLocked();
                    this._itemLinkState = 3;
                    break;
                }
                case 10: {
                    this._assertCorrectTransaction(transaction);
                    abstractItem = this._getAndAssertItem();
                    ++this._backoutCount;
                    listStatistics.decrementRemoving();
                    listStatistics.incrementLocked();
                    int n = this._tuple.getStorageStrategy();
                    if (1 != n && 2 != n) {
                        bl2 = this._declareDiscardable();
                    }
                    this._itemLinkState = 6;
                    break;
                }
                default: {
                    throw new StateException(this.getStateName());
                }
            }
            this._transactionId = null;
        }
        if (bl && null != this._owningStreamLink) {
            this._owningStreamLink.linkAvailable(this);
        }
        if (bl2) {
            this._declareReleasable(abstractItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abortUpdate(Transaction transaction) {
        AbstractItem abstractItem;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abortUpdate", (Object)transaction);
        }
        boolean bl = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (13 != this._itemLinkState) {
                throw new StateException(this.getStateName());
            }
            this._assertCorrectTransaction(transaction);
            abstractItem = this._getAndAssertItem();
            ListStatistics listStatistics = this.getParentStatistics();
            listStatistics.decrementUpdating();
            listStatistics.incrementAvailable();
            bl = this._declareDiscardable();
            this._itemLinkState = 2;
            this._transactionId = null;
        }
        if (bl) {
            this._declareReleasable(abstractItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortUpdate");
        }
    }

    public RuntimeException assertCanDelete(Transaction transaction) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cmdAdd(LinkOwner linkOwner, long l, Transaction transaction) throws StreamIsFull, ProtocolException, TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdAdd", (Object)new Object[]{linkOwner, new Long(l), transaction});
        }
        Object object = this;
        synchronized (object) {
            if (5 != this._itemLinkState) {
                throw new StateException(this.getStateName());
            }
            this._lockID = l;
            this._transactionId = transaction.getPersistentTranId();
            ListStatistics listStatistics = this.getParentStatistics();
            linkOwner._assertCanAddChild(transaction, listStatistics);
            this._itemLinkState = -2L == l ? 1 : 0;
            listStatistics.incrementTotal(this._invariantByteSize);
        }
        object = new AddTask(this);
        transaction.addWork((WorkItem)object);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdAdd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cmdLock(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdLock", (Object)new Long(l));
        }
        boolean bl = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (2 != this._itemLinkState) {
                throw new StateException(this.getStateName());
            }
            this._lockID = l;
            ListStatistics listStatistics = this.getParentStatistics();
            listStatistics.incrementLocked();
            listStatistics.decrementAvailable();
            bl = this._declareNotDiscardable(this._getItemNoRestore());
            this._itemLinkState = 3;
        }
        if (bl) {
            this._declareNotReleasable();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cmdPersistLock(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdPersistLock", (Object)transaction);
        }
        if (null != transaction) {
            boolean bl = false;
            AbstractItemLink abstractItemLink = this;
            synchronized (abstractItemLink) {
                if (3 != this._itemLinkState) {
                    throw new StateException(this.getStateName());
                }
                this._transactionId = transaction.getPersistentTranId();
                bl = this._declareNotDiscardable(this._getAndAssertItem());
                this._itemLinkState = 7;
            }
            if (bl) {
                this._declareNotReleasable();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdPersistLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cmdRemove(long l, Transaction transaction) throws ProtocolException, TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdRemove", (Object)new Object[]{new Long(l), transaction});
        }
        boolean bl = false;
        boolean bl2 = false;
        AbstractRemoveTask abstractRemoveTask = null;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            ListStatistics listStatistics = this.getParentStatistics();
            switch (this._itemLinkState) {
                case 2: {
                    if (-2L != l) {
                        throw new LockIdMismatch(-2L, l);
                    }
                    bl = this._declareNotDiscardable(this._getItemNoRestore());
                    this._transactionId = transaction.getPersistentTranId();
                    listStatistics.decrementAvailable();
                    listStatistics.incrementRemoving();
                    this._itemLinkState = 11;
                    abstractRemoveTask = new RemoveTask(this);
                    break;
                }
                case 3: {
                    if (this._lockID != l) {
                        throw new LockIdMismatch(this._lockID, l);
                    }
                    this._transactionId = transaction.getPersistentTranId();
                    listStatistics.decrementLocked();
                    listStatistics.incrementRemoving();
                    this._itemLinkState = 9;
                    abstractRemoveTask = new RemoveLockedTask(this);
                    break;
                }
                case 6: {
                    if (this._lockID != l) {
                        throw new LockIdMismatch(this._lockID, l);
                    }
                    bl = this._declareNotDiscardable(this._getItemNoRestore());
                    this._transactionId = transaction.getPersistentTranId();
                    listStatistics.decrementLocked();
                    listStatistics.incrementRemoving();
                    this._itemLinkState = 10;
                    abstractRemoveTask = new RemoveLockedTask(this);
                    break;
                }
                case 5: {
                    if (1 == this._tuple.getStorageStrategy()) {
                        if (!tc.isDebugEnabled()) break;
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"STORE_NEVER item is not in store - no exception thrown during remove");
                        break;
                    }
                    bl2 = true;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            throw new StateException(this.getStateName());
        }
        if (bl) {
            this._declareNotReleasable();
        }
        if (null != abstractRemoveTask) {
            transaction.addWork(abstractRemoveTask);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cmdRemoveExpiring(long l, Transaction transaction) throws ProtocolException, TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdRemoveExpiring", (Object)new Object[]{new Long(l), transaction});
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("expiring item " + this._tuple.getUniqueId()));
        }
        Object object = this;
        synchronized (object) {
            if (4 == this._itemLinkState) {
                if (this._lockID != l) {
                    throw new LockIdMismatch(this._lockID, l);
                }
            } else {
                throw new StateException(this.getStateName());
            }
            ListStatistics listStatistics = this.getParentStatistics();
            listStatistics.decrementExpiring();
            listStatistics.incrementRemoving();
            this._transactionId = transaction.getPersistentTranId();
            this._itemLinkState = 8;
        }
        object = new RemoveLockedTask(this);
        transaction.addWork((WorkItem)object);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdRemoveExpiring");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cmdRemoveExpiryLock() {
        AbstractItem abstractItem;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdRemoveExpiryLock");
        }
        boolean bl = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (4 != this._itemLinkState) {
                throw new StateException(this.getStateName());
            }
            abstractItem = this._getAndAssertItem();
            this._lockID = -2L;
            this._transactionId = null;
            ListStatistics listStatistics = this.getParentStatistics();
            listStatistics.decrementExpiring();
            listStatistics.incrementRemoving();
            bl = this._declareDiscardable();
            this._itemLinkState = 2;
        }
        if (bl) {
            this._declareReleasable(abstractItem);
        }
        if (null != this._owningStreamLink) {
            this._owningStreamLink.linkAvailable(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdRemoveExpiryLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final AbstractItem cmdRemoveIfMatches(Filter filter, Transaction transaction) {
        AbstractItem abstractItem;
        block15: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeIfMatches", (Object)new Object[]{filter, transaction});
            }
            abstractItem = null;
            this.isExpired();
            if (this.isAvailable()) {
                AbstractItem abstractItem2 = this.getItem();
                if (null == abstractItem2) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"item does not exist");
                    }
                } else {
                    try {
                        if (null != filter && !filter.filterMatches(abstractItem2)) break block15;
                        boolean bl = false;
                        Object object = this;
                        synchronized (object) {
                            if (this.isAvailable()) {
                                this._transactionId = transaction.getPersistentTranId();
                                ListStatistics listStatistics = this.getParentStatistics();
                                listStatistics.decrementAvailable();
                                listStatistics.incrementRemoving();
                                abstractItem = abstractItem2;
                                bl = this._declareNotDiscardable(abstractItem2);
                                this._itemLinkState = 11;
                            }
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"matched");
                            }
                        }
                        if (null != abstractItem) {
                            if (bl) {
                                this._declareNotReleasable();
                            }
                            object = new RemoveTask(this);
                            transaction.addWork((WorkItem)object);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeIfMatches", abstractItem);
        }
        return abstractItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cmdRequestUpdate(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdRequestUpdate", (Object)transaction);
        }
        boolean bl = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (2 != this._itemLinkState) {
                throw new StateException(this.getStateName());
            }
            ListStatistics listStatistics = this.getParentStatistics();
            listStatistics.decrementAvailable();
            listStatistics.incrementUpdating();
            this._transactionId = transaction.getPersistentTranId();
            bl = this._declareNotDiscardable(this._getItemNoRestore());
            this._itemLinkState = 13;
        }
        if (bl) {
            this._declareNotReleasable();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdRequestUpdate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitAdd(Transaction transaction) {
        AbstractItem abstractItem;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitAdd", (Object)transaction);
        }
        ListStatistics listStatistics = this.getParentStatistics();
        boolean bl = false;
        boolean bl2 = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            switch (this._itemLinkState) {
                case 0: {
                    this._assertCorrectTransaction(transaction);
                    abstractItem = this._getAndAssertItem();
                    listStatistics.incrementLocked();
                    listStatistics.decrementAdding();
                    this.registerWithExpirer();
                    this._pmiIncrementAdd();
                    this._owningStreamLink.calculateMovingAverage();
                    this._itemLinkState = 3;
                    break;
                }
                case 1: {
                    this._assertCorrectTransaction(transaction);
                    abstractItem = this._getAndAssertItem();
                    listStatistics.decrementAdding();
                    listStatistics.incrementAvailable();
                    this.registerWithExpirer();
                    this._pmiIncrementAdd();
                    this._owningStreamLink.calculateMovingAverage();
                    bl = true;
                    bl2 = this._declareDiscardable();
                    this._itemLinkState = 2;
                    break;
                }
                default: {
                    throw new StateException(this.getStateName());
                }
            }
            this._transactionId = null;
        }
        if (bl && null != this._owningStreamLink) {
            this._owningStreamLink.linkAvailable(this);
        }
        if (bl2) {
            this._declareReleasable(abstractItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitAdd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitPersistLock(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitPersistLock", (Object)transaction);
        }
        AbstractItem abstractItem = null;
        boolean bl = false;
        boolean bl2 = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (7 == this._itemLinkState) {
                this._assertCorrectTransaction(transaction);
                abstractItem = this._getAndAssertItem();
                int n = this._tuple.getStorageStrategy();
                if (1 != n && 2 != n) {
                    bl2 = this._declareDiscardable();
                }
            } else {
                throw new StateException(this.getStateName());
            }
            this._itemLinkState = 6;
            bl = true;
            this._transactionId = null;
        }
        if (bl && bl2) {
            this._declareReleasable(abstractItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitPersistLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitPersistUnlock(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitPersistUnlock", (Object)transaction);
        }
        AbstractItem abstractItem = null;
        boolean bl = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (12 == this._itemLinkState) {
                this._assertCorrectTransaction(transaction);
                ListStatistics listStatistics = this.getParentStatistics();
                listStatistics.decrementLocked();
                listStatistics.incrementAvailable();
                abstractItem = this.getItem();
                this._lockID = -2L;
                ++this._unlockCount;
            } else {
                throw new StateException(this.getStateName());
            }
            bl = this._declareDiscardable();
            this._itemLinkState = 2;
            this._transactionId = null;
        }
        if (bl) {
            this._declareReleasable(abstractItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitPersistUnlock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitRemove(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitRemove", (Object)transaction);
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            switch (this._itemLinkState) {
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this._assertCorrectTransaction(transaction);
                    this.unlink();
                    this._pmiIncrementRemove();
                    this._owningStreamLink.calculateMovingAverage();
                    ListStatistics listStatistics = this.getParentStatistics();
                    listStatistics.decrementRemoving();
                    listStatistics.decrementTotal(this._invariantByteSize);
                    MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
                    messageStoreImpl.unregister(this);
                    if (8 != this._itemLinkState) {
                        Expirer expirer = messageStoreImpl._getExpirer();
                        long l = this.getTuple().getExpiryTime();
                        if (null != expirer && 0L != l) {
                            expirer.removeExpirable(this);
                        }
                    }
                    this._itemLinkState = 5;
                    this._lockID = -2L;
                    break;
                }
                default: {
                    throw new StateException(this.getStateName());
                }
            }
            this._transactionId = null;
        }
        this.internalCommitRemove(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitUpdate(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitUpdate", (Object)transaction);
        }
        AbstractItem abstractItem = null;
        boolean bl = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (13 != this._itemLinkState) {
                throw new StateException(this.getStateName());
            }
            this._assertCorrectTransaction(transaction);
            abstractItem = this._getAndAssertItem();
            ListStatistics listStatistics = this.getParentStatistics();
            listStatistics.decrementUpdating();
            listStatistics.incrementAvailable();
            this._pmiIncrementUpdate();
            bl = this._declareDiscardable();
            this._itemLinkState = 2;
            this._transactionId = null;
        }
        if (bl) {
            this._declareReleasable(abstractItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitUpdate");
        }
    }

    public synchronized boolean expirableExpire(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"expirableExpire", (Object)("tran=" + transaction));
        }
        boolean bl = false;
        boolean bl2 = this.isExpired();
        if (bl2) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("item is expiring " + this.getID()));
            }
            try {
                AbstractItem abstractItem;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("expiring item " + this.getID()));
                }
                this.cmdRemoveExpiring(123456L, transaction);
                bl = true;
                boolean bl3 = this.getTuple().getCanExpireSilently();
                if (!bl3 && null != (abstractItem = this.getItem())) {
                    abstractItem.eventExpiryNotification(transaction);
                }
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink.expirableExpire", (String)"1:1615:1.199.1.1", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("failed to expire item " + this.getID() + " because: " + (Object)((Object)messageStoreException)));
                }
                this.cmdRemoveExpiryLock();
            }
        } else if (!this.isInStore()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"item already removed from store");
            }
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"expirableExpire", (Object)new Boolean(bl));
        }
        return bl;
    }

    public final long expirableGetExpiryTime() {
        long l = this.getTuple().getExpiryTime();
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"expirableGetExpiryTime");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"expirableGetExpiryTime", (Object)new Long(l));
        }
        return l;
    }

    public final long expirableGetID() {
        long l = this.getID();
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"expirableGetID");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"expirableGetID", (Object)new Long(l));
        }
        return l;
    }

    public final boolean expirableIsInStore() {
        return this.isInStore();
    }

    public final long getID() {
        return this.getTuple().getUniqueId();
    }

    ItemStorageManager getIndirectionCache() {
        return this._owningStreamLink.getIndirectionCache();
    }

    protected final MSInstrumentation getInstrumentation() {
        return this.getMessageStoreImpl()._getInstrumentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AbstractItem getItem() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getItem");
        }
        AbstractItem abstractItem = this._getItemNoRestore();
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (this.isExpired()) {
                abstractItem = null;
            } else if (null == abstractItem) {
                abstractItem = this._restoreItem();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getItem", (Object)abstractItem);
            }
        }
        return abstractItem;
    }

    public final synchronized long getLockID() {
        return this._lockID;
    }

    public final byte[] getMemberData() throws PersistentDataEncodingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMemberData");
        }
        byte[] byArray = null;
        try {
            AbstractItem abstractItem = this.getItem();
            if (null != abstractItem) {
                byArray = abstractItem.getPersistentData();
            }
        }
        catch (PersistentDataEncodingException persistentDataEncodingException) {
            FFDCFilter.processException((Throwable)((Object)persistentDataEncodingException), (String)(this.getClass().getName() + ".getMemberData"), (String)"1:1731:1.199.1.1", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exception " + (Object)((Object)persistentDataEncodingException)));
            }
            this._persistentDataEncodingFailed = true;
            throw persistentDataEncodingException;
        }
        if (tc.isEntryEnabled()) {
            if (null == byArray) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMemberData = null");
            } else {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)("getMemberData, hashcode=" + byArray.hashCode()));
            }
        }
        return byArray;
    }

    public final MessageStore getMessageStore() {
        return this.getMessageStoreImpl();
    }

    public MessageStoreImpl getMessageStoreImpl() {
        return this._owningStreamLink.getMessageStoreImpl();
    }

    public final AbstractItemLink getNextMappedLink() {
        return this._nextMappedLink;
    }

    public final LinkOwner getOwningStreamLink() {
        return this._owningStreamLink;
    }

    ListStatistics getParentStatistics() {
        return this._owningStreamLink.getListStatistics();
    }

    public final int getPriority() {
        int n = this.getTuple().getPriority();
        return n;
    }

    public final long getSequence() {
        long l = this.getTuple().getSequence();
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSequence");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSequence", (Object)new Long(l));
        }
        return l;
    }

    public final int getSize() {
        return this._invariantByteSize;
    }

    public final String getState() {
        return this.getStateName();
    }

    final String getStateName() {
        return STATE__NAMES[this._itemLinkState];
    }

    public final PersistentTranId getTransactionId() {
        return this._transactionId;
    }

    public final Persistable getTuple() {
        return this._tuple;
    }

    public final int guessBackoutCount() {
        return this._backoutCount;
    }

    public final int guessUnlockCount() {
        return this._unlockCount;
    }

    protected final void initializeSequenceNumber() {
        this.getTuple().setSequence(this._owningStreamLink.nextSequence());
    }

    boolean internalCanExpire() {
        return this.getMessageStoreImpl().itemsCanExpire();
    }

    public void internalCommitAdd() {
    }

    public void internalCommitRemove(Transaction transaction) {
    }

    public final boolean isAdding() {
        return 0 == this._itemLinkState || 1 == this._itemLinkState;
    }

    public final boolean isAvailable() {
        return 2 == this._itemLinkState;
    }

    public final synchronized boolean isCached() {
        return null != this._itemCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isExpired() {
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isExpired");
        }
        if (this.isAvailable() && this.internalCanExpire() && (l = this._tuple.getExpiryTime()) != 0L && l <= Expirer.timeNow()) {
            boolean bl = false;
            boolean bl2 = false;
            AbstractItemLink abstractItemLink = this;
            synchronized (abstractItemLink) {
                if (2 == this._itemLinkState) {
                    this._lockID = 123456L;
                    ListStatistics listStatistics = this.getParentStatistics();
                    listStatistics.incrementExpiring();
                    listStatistics.decrementAvailable();
                    AbstractItem abstractItem = this._getItemNoRestore();
                    if (null == abstractItem) {
                        abstractItem = this._restoreItem();
                    }
                    bl2 = this._declareNotDiscardable(abstractItem);
                    this._itemLinkState = 4;
                    bl = true;
                }
            }
            if (bl2) {
                this._declareNotReleasable();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isExpired", (Object)new Boolean(this.isExpiring()));
        }
        return this.isExpiring();
    }

    public final boolean isExpiring() {
        return this.isLockedForExpiry();
    }

    public final boolean isInStore() {
        return 5 != this._itemLinkState;
    }

    public boolean isItemStreamLink() {
        return false;
    }

    public final boolean isLocked() {
        switch (this._itemLinkState) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    final boolean isLockedForExpiry() {
        return 4 == this._itemLinkState;
    }

    public final boolean isPersistentDataImmutable() {
        return this.getItem().isPersistentDataImmutable();
    }

    public final boolean isPersistentDataNeverUpdated() {
        return this.getItem().isPersistentDataNeverUpdated();
    }

    public final boolean isPersistentlyLocked() {
        return 6 == this._itemLinkState;
    }

    public boolean isReferenceStreamLink() {
        return false;
    }

    public final boolean isRemoving() {
        switch (this._itemLinkState) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    final boolean isRemovingLocked() {
        return 9 == this._itemLinkState;
    }

    public boolean isStoreNever() {
        int n = this._tuple.getStorageStrategy();
        boolean bl = n == 1;
        return bl;
    }

    public final boolean isUpdating() {
        return 13 == this._itemLinkState;
    }

    public final Indirection itemCacheGetNextLink() {
        return this._itemCacheLinkNext;
    }

    public final Indirection itemCacheGetPrevioustLink() {
        return this._itemCacheLinkPrevious;
    }

    public final void itemCacheSetNextLink(Indirection indirection) {
        this._itemCacheLinkNext = indirection;
    }

    public final void itemCacheSetPreviousLink(Indirection indirection) {
        this._itemCacheLinkPrevious = indirection;
    }

    public AbstractItem itemCacheGetManagedReference() {
        return this._itemCacheManagedReference;
    }

    public void itemCacheSetManagedReference(AbstractItem abstractItem) {
        this._itemCacheManagedReference = abstractItem;
    }

    protected void itemHasBeenRestored(AbstractItem abstractItem) {
    }

    public final void lateInitialize() {
        int n;
        AbstractItem abstractItem;
        int n2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"lateInitialize");
        }
        if ((n2 = (abstractItem = this.getItem()).getPriority()) > 9 || n2 < 0) {
            throw new MessageStoreRuntimeException("invalid priority(" + n2 + ") supplied");
        }
        this.getTuple().setPriority(n2);
        this.getTuple().setCanExpireSilently(abstractItem.canExpireSilently());
        long l = 0L;
        long l2 = abstractItem.getMaximumTimeInStore();
        if (l2 != -2L) {
            long l3 = abstractItem.getExpiryStartTime();
            if (l3 == 0L) {
                l3 = Expirer.timeNow();
            }
            l = l3 + l2;
        }
        this.getTuple().setExpiryTime(l);
        int n3 = abstractItem.getStorageStrategy();
        int n4 = this.getTuple().getStorageStrategy();
        if (n4 != n3) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("StorageStrategy changing from " + n4 + " to " + n3));
            }
            if (1 == n4 || 1 == n3) {
                throw new MessageStoreRuntimeException("Invalid change of storage strategy from " + n4 + " to " + n3);
            }
            this.getTuple().setStorageStrategy(n3);
        }
        if (null != this._owningStreamLink && n3 > (n = this._owningStreamLink.getTuple().getStorageStrategy())) {
            throw new InvalidAddOperation("STREAM_STORAGE_MISMATCH_SIMS0500", new Object[]{new Integer(n3), new Integer(n)});
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"lateInitialize");
        }
    }

    public final void lock(long l) {
        this.cmdLock(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean lockIfMatches(Filter filter, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"lockIfMatches", (Object)new Object[]{filter, new Long(l)});
        }
        boolean bl = false;
        boolean bl2 = false;
        AbstractItem abstractItem = this.getItem();
        if (null == abstractItem) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"item does not exist");
            }
        } else {
            try {
                if (null == filter || filter.filterMatches(abstractItem)) {
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl3 = false;
        if (bl2) {
            AbstractItemLink abstractItemLink = this;
            synchronized (abstractItemLink) {
                if (this.isAvailable() && !this.isExpired()) {
                    if (2 != this._itemLinkState) {
                        throw new StateException(this.getStateName());
                    }
                    this._lockID = l;
                    ListStatistics listStatistics = this.getParentStatistics();
                    listStatistics.incrementLocked();
                    listStatistics.decrementAvailable();
                    bl3 = this._declareNotDiscardable(abstractItem);
                    this._itemLinkState = 3;
                    bl = true;
                }
            }
            if (bl3) {
                this._declareNotReleasable();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"lockIfMatches", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean lockItemIfAvailable(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"lockItemIfAvailable", (Object)new Long(l));
        }
        boolean bl = false;
        if (-2L == l) {
            throw new MessageStoreRuntimeException("invalid lockID - clashes with internal constant NO_LOCK_ID");
        }
        boolean bl2 = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (!this.isExpired() && this.isAvailable()) {
                if (2 != this._itemLinkState) {
                    throw new StateException(this.getStateName());
                }
                this._lockID = l;
                ListStatistics listStatistics = this.getParentStatistics();
                listStatistics.incrementLocked();
                listStatistics.decrementAvailable();
                bl = true;
                bl2 = this._declareNotDiscardable(this._getItemNoRestore());
                this._itemLinkState = 3;
            }
        }
        if (bl2) {
            this._declareNotReleasable();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"lockItemIfAvailable", (Object)new Boolean(bl));
        }
        return bl;
    }

    public final AbstractItem matches(Filter filter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"matches", (Object)filter);
        }
        AbstractItem abstractItem = null;
        if (this.isAvailable() && !this.isExpired()) {
            AbstractItem abstractItem2 = this.getItem();
            if (null == abstractItem2) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"item does not exist");
                }
            } else {
                try {
                    if (null == filter || filter.filterMatches(abstractItem2)) {
                        abstractItem = abstractItem2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"matches", abstractItem);
        }
        return abstractItem;
    }

    public final AbstractItem matches(Filter filter, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"matches", (Object)new Object[]{filter, new Boolean(bl)});
        }
        AbstractItem abstractItem = null;
        if ((bl || this.isAvailable()) && !this.isExpired()) {
            AbstractItem abstractItem2 = this.getItem();
            if (null == abstractItem2) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"item does not exist");
                }
            } else {
                try {
                    if (null == filter || filter.filterMatches(abstractItem2)) {
                        abstractItem = abstractItem2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"matches", abstractItem);
        }
        return abstractItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void persistentRepresentationIsStable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistentRepresentationIsStable");
        }
        boolean bl = false;
        AbstractItem abstractItem = null;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (!this._persistentRepresentationIsStable) {
                bl = this._itemIsDiscardableIfPersistentRepresentationStable;
                if (bl) {
                    abstractItem = this._getItemNoRestore();
                    this._strongReferenceToItem = null;
                }
                this._persistentRepresentationIsStable = true;
            }
        }
        if (bl) {
            this._declareReleasable(abstractItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persistentRepresentationIsStable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void persistentRepresentationIsUnstable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistentRepresentationIsUnstable");
        }
        boolean bl = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (null == this._strongReferenceToItem && null != this._weakReferenceToItem) {
                this._strongReferenceToItem = (AbstractItem)this._weakReferenceToItem.get();
            }
            if (this._persistentRepresentationIsStable) {
                bl = this._itemIsDiscardableIfPersistentRepresentationStable;
                this._persistentRepresentationIsStable = false;
            }
        }
        if (bl) {
            this._declareNotReleasable();
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("stable=false available=" + this._itemIsDiscardableIfPersistentRepresentationStable));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persistentRepresentationIsUnstable");
        }
    }

    public final void persistLock(Transaction transaction) throws ProtocolException, TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistLock", (Object)transaction);
        }
        if (null != transaction) {
            this.cmdPersistLock(transaction);
            this.getTuple().setLockID(this.getLockID());
            PersistLock persistLock = new PersistLock(this);
            transaction.addWork(persistLock);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persistLock");
        }
    }

    public final void postAbortAdd(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"postAbortAdd", (Object)transaction);
        }
        this.releaseItem();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"postAbortAdd");
        }
    }

    public final void postCommitRemove(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"postCommitRemove", (Object)transaction);
        }
        this.releaseItem();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"postCommitRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void preCommitAdd(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"preCommitAdd", (Object)transaction);
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            switch (this._itemLinkState) {
                case 0: 
                case 1: {
                    boolean bl = this.getItem().eventPrecommitAdd(transaction);
                    if (!bl) {
                        throw new MessageStoreRuntimeException("Not applicable");
                    }
                    this._assertCorrectTransaction(transaction);
                    this._owningStreamLink._assertCanAddChildUnder(transaction);
                    this.lateInitialize();
                    this.initializeSequenceNumber();
                    this._owningStreamLink.append(this);
                    break;
                }
                default: {
                    throw new StateException(this.getStateName());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"preCommitAdd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void preCommitRemove(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"preCommitRemove", (Object)transaction);
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            RuntimeException runtimeException = this.assertCanDelete(transaction);
            if (null != runtimeException) {
                throw runtimeException;
            }
            switch (this._itemLinkState) {
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this._assertCorrectTransaction(transaction);
                    this._owningStreamLink._assertCanRemoveChildUnder(transaction);
                    break;
                }
                default: {
                    throw new StateException(this.getStateName());
                }
            }
            this.getItem().eventPrecommitRemove(transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"preCommitRemove");
        }
    }

    public final void preCommitUpdate(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"preCommitUpdate", (Object)transaction);
        }
        this.getItem().eventPrecommitUpdate(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"preCommitUpdate");
        }
    }

    protected final byte[] readDataFromPersistence() {
        byte[] byArray;
        PersistentMessageStore persistentMessageStore = this.getMessageStoreImpl().getPersistentMessageStore();
        try {
            byArray = persistentMessageStore.readDataOnly(this.getTuple());
        }
        catch (PersistenceException persistenceException) {
            FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink.readDataFromPersistence", (String)"1:2486:1.199.1.1", (Object)this);
            throw new MessageStoreRuntimeException((Throwable)((Object)persistenceException));
        }
        return byArray;
    }

    public final void registerWithExpirer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerWithExpirer");
        }
        MessageStoreImpl messageStoreImpl = this.getMessageStoreImpl();
        Expirer expirer = messageStoreImpl._getExpirer();
        long l = this.getTuple().getExpiryTime();
        if (null != expirer && 0L != l) {
            expirer.addExpirable(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerWithExpirer");
        }
    }

    public final void releaseItem() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"releaseItem");
        }
        this._strongReferenceToItem = null;
        if (this._weakReferenceToItem != null) {
            this._weakReferenceToItem.clear();
        }
        if (this._isStorageManaged && null != this._itemCacheManagedReference) {
            this._itemCache.unregister(this);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("release item(" + this.getID() + ":" + this._invariantByteSize + ") new cacheSize = " + this._itemCache.getCurrentSize()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"releaseItem");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseIfDiscardable() {
        Object object;
        boolean bl = false;
        int n = this._invariantByteSize;
        if (this.isStoreNever()) {
            object = this;
            synchronized (object) {
                if (2 == this._itemLinkState) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"removing STORE_NEVER item as a result of discard");
                    }
                    this._itemLinkState = 5;
                    bl = true;
                }
            }
        }
        if (bl) {
            object = this.getParentStatistics();
            ((ListStatistics)object).decrementTotal(this._invariantByteSize);
            ((ListStatistics)object).decrementAvailable();
            this.getMessageStoreImpl().unregister(this);
            this.unlink();
        }
    }

    public final AbstractItem removeIfMatches(Filter filter, Transaction transaction) throws ProtocolException, TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeIfMatches", (Object)new Object[]{filter, transaction});
        }
        AbstractItem abstractItem = this.cmdRemoveIfMatches(filter, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeIfMatches", (Object)abstractItem);
        }
        return abstractItem;
    }

    public final void requestUpdate(Transaction transaction) throws ProtocolException, TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"requestUpdate", (Object)transaction);
        }
        this.cmdRequestUpdate(transaction);
        UpdateTask updateTask = new UpdateTask(this);
        transaction.addWork(updateTask);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"requestUpdate");
        }
    }

    public final void requestXmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        this.xmlWriteOn(formattedWriter);
    }

    final void restoreState(Persistable persistable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"restoreState", (Object)persistable);
        }
        PersistentTranId persistentTranId = persistable.getPersistentTranId();
        boolean bl = persistable.isLogicallyDeleted();
        Transaction transaction = null;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("xid = " + persistentTranId + "; logicallyDeleted = " + bl));
        }
        if (persistentTranId != null) {
            transaction = this.getMessageStoreImpl().getXidManager().getTransactionFromTranId(persistentTranId);
        }
        if (null == transaction) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"no transaction so tuple is not in doubt ");
            }
            if (bl) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"tuple is logically deleted - removing link");
                }
            } else {
                boolean bl2 = false;
                boolean bl3 = false;
                if (bl3 && bl2) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"tuple is expired and can expire silently - removing link");
                    }
                } else {
                    long l = persistable.getLockID();
                    if (-2L != l) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("tuple is locked. LockID = " + l));
                        }
                        this._restoreStatePersistentlyLocked(this, this._owningStreamLink, l);
                        this._owningStreamLink.append(this);
                    } else {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"tuple is not locked");
                        }
                        this._restoreStateAvailable(this, this._owningStreamLink);
                        this._owningStreamLink.append(this);
                    }
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Tuple is in doubt. transaction = " + transaction));
            }
            Task task = null;
            if (bl) {
                long l;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"tuple is logically deleted - tuple is deleting");
                }
                if (-2L != (l = persistable.getLockID())) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("tuple is 'removingLocked'. lockID = " + l));
                    }
                    this._restoreStateRemovingPersistentlyLocked(this, this._owningStreamLink, this.getLockID(), transaction);
                    this._owningStreamLink.append(this);
                    task = new RemoveLockedTask(this);
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"tuple is not locked");
                    }
                    this._restoreStateRemovingNoLock(this, this._owningStreamLink, transaction);
                    this._owningStreamLink.append(this);
                    task = new RemoveTask(this);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"tuple is not logicallyDeleted, so is adding");
                }
                this._restoreStateAdding(this, this._owningStreamLink, transaction);
                this._owningStreamLink.append(this);
                task = new AddTask(this);
            }
            try {
                transaction.addWork(task);
                ((TaskList)transaction.getWorkList()).declareAlreadyPrecommitted();
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink.restoreState", (String)"1:2717:1.199.1.1", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Exception " + (Object)((Object)messageStoreException) + " while adding task to tasklist"));
                }
                throw new MessageStoreRuntimeException("SIMS_NNNN", (Throwable)((Object)messageStoreException));
            }
        }
        this.registerWithExpirer();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"restoreState");
        }
    }

    public final void setNextMappedLink(AbstractItemLink abstractItemLink) {
        this._nextMappedLink = abstractItemLink;
    }

    public final void setParentWasSpillingAtAddTime(boolean bl) {
        this.getTuple().setWasSpillingAtAddition(bl);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Stub(");
        stringBuffer.append(this.getID());
        stringBuffer.append(", ");
        stringBuffer.append(this.getStateName());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlock(long l, Transaction transaction, boolean bl) throws ProtocolException, TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlock", (Object)new Object[]{new Long(l), transaction});
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        AbstractItem abstractItem = null;
        Object object = this;
        synchronized (object) {
            switch (this._itemLinkState) {
                case 3: {
                    if (this._lockID != l) {
                        throw new LockIdMismatch(this._lockID, l);
                    }
                    ListStatistics listStatistics = this.getParentStatistics();
                    listStatistics.decrementLocked();
                    listStatistics.incrementAvailable();
                    if (null != transaction) {
                        this._transactionId = transaction.getPersistentTranId();
                    }
                    abstractItem = this._getAndAssertItem();
                    bl4 = this._declareDiscardable();
                    this._lockID = -2L;
                    this._tuple.setLockID(-2L);
                    if (bl) {
                        ++this._unlockCount;
                    }
                    this._itemLinkState = 2;
                    bl2 = true;
                    bl3 = true;
                    break;
                }
                case 6: {
                    if (this._lockID != l) {
                        throw new LockIdMismatch(this._lockID, l);
                    }
                    if (null == transaction) {
                        throw new StateException("Unlock of Persistently locked requires transaction");
                    }
                    this._transactionId = transaction.getPersistentTranId();
                    bl5 = this._declareNotDiscardable(this._getItemNoRestore());
                    this._tuple.setLockID(-2L);
                    this._itemLinkState = 12;
                    bl6 = true;
                    break;
                }
                default: {
                    throw new StateException(this.getStateName());
                }
            }
        }
        if (bl4) {
            this._declareReleasable(this._getItemNoRestore());
        }
        if (bl5) {
            this._declareNotReleasable();
        }
        if (bl6) {
            object = new PersistUnlock(this);
            transaction.addWork((WorkItem)object);
        }
        if (bl3 && this.isAvailable() && null != this._owningStreamLink) {
            this._owningStreamLink.linkAvailable(this);
        }
        if (bl2 && abstractItem != null) {
            abstractItem.eventUnlocked();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlock");
        }
    }

    public void xmlShortWriteOn(FormattedWriter formattedWriter) throws IOException {
        String string = this.xmlTagName();
        formattedWriter.write(60);
        formattedWriter.write(string);
        super.xmlWriteAttributesOn(formattedWriter);
        formattedWriter.write(32);
        formattedWriter.write("id");
        formattedWriter.write("=\"");
        formattedWriter.write(Long.toString(this.getTuple().getUniqueId()));
        formattedWriter.write("\" ");
        formattedWriter.write("state");
        formattedWriter.write("=\"");
        formattedWriter.write(this.getStateName());
        formattedWriter.write(34);
        formattedWriter.write(" />");
    }

    abstract String xmlTagName();

    protected void xmlWriteAttributesOn(FormattedWriter formattedWriter) throws IOException {
        formattedWriter.write("state");
        formattedWriter.write("=\"");
        formattedWriter.write(this.getStateName());
        formattedWriter.write(34);
        formattedWriter.write(32);
        formattedWriter.write("id");
        formattedWriter.write("=\"");
        formattedWriter.write(Long.toString(this.getTuple().getUniqueId()));
        formattedWriter.write("\" ");
        super.xmlWriteAttributesOn(formattedWriter);
    }

    protected void xmlWriteChildrenOn(FormattedWriter formattedWriter) throws IOException {
        AbstractItem abstractItem = this._getItemNoRestore();
        if (null != abstractItem) {
            abstractItem.xmlWriteOn(formattedWriter);
        }
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        String string = this.xmlTagName();
        formattedWriter.write("<");
        formattedWriter.write(string);
        this.xmlWriteAttributesOn(formattedWriter);
        formattedWriter.write(" >");
        formattedWriter.indent();
        formattedWriter.newLine();
        if (null != this.getTuple()) {
            this.getTuple().xmlWrite(formattedWriter);
        }
        this.xmlWriteChildrenOn(formattedWriter);
        formattedWriter.outdent();
        formattedWriter.newLine();
        formattedWriter.write("</");
        formattedWriter.write(string);
        formattedWriter.write(">");
    }
}

