/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.InvalidAddOperation;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemReference;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.ReferenceCollection;
import com.ibm.ws.sib.msgstore.ReferenceConsistencyViolation;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.SibTr;

public class ReferenceStream
extends AbstractItem {
    private static TraceComponent tc = SibTr.register((Class)ReferenceStream.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");

    public void add(ItemReference itemReference, long l, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"add", (Object)new Object[]{itemReference, new Long(l), transaction});
        }
        if (null == this._getMembership()) {
            throw new InvalidAddOperation("STREAM_NOT_STORED_SIMS0004", new Object[]{itemReference, this});
        }
        if (null != itemReference._getMembership()) {
            throw new InvalidAddOperation("STREAM_ADD_CONFLICT_SIMS0005", new Object[]{itemReference, this});
        }
        Item item = itemReference.getReferredItem();
        if (null == item) {
            throw new ReferenceConsistencyViolation("REFERENCE_CONSISTENCY_SIMS0003", new Object[]{itemReference, this});
        }
        ReferenceCollection referenceCollection = (ReferenceCollection)this._getMembership();
        referenceCollection.addReference(itemReference, l, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"add");
        }
    }

    public void add(ItemReference itemReference, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException {
        this.add(itemReference, -2L, transaction);
    }

    public void eventWatermarkBreached() {
    }

    public final AbstractItem findById(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findById", (Object)new Long(l));
        }
        AbstractItem abstractItem = null;
        ReferenceCollection referenceCollection = (ReferenceCollection)this._getMembership();
        if (null == referenceCollection) {
            throw new InvalidAddOperation("STREAM_NOT_STORED_SIMS0004", new Object[]{this});
        }
        abstractItem = referenceCollection.findById(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findById", (Object)abstractItem);
        }
        return abstractItem;
    }

    public final ItemReference findFirstMatching(Filter filter) throws MessageStoreException {
        ReferenceCollection referenceCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)filter);
        }
        if (null == (referenceCollection = (ReferenceCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        ItemReference itemReference = null;
        if (referenceCollection != null) {
            itemReference = (ItemReference)referenceCollection.findFirstMatching(filter);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)itemReference);
        }
        return itemReference;
    }

    public final ItemReference findOldestReference() throws MessageStoreException {
        ReferenceCollection referenceCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findOldestReference");
        }
        if (null == (referenceCollection = (ReferenceCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        ItemReference itemReference = null;
        if (referenceCollection != null) {
            itemReference = (ItemReference)referenceCollection.findOldestItem();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findOldestReference", (Object)itemReference);
        }
        return itemReference;
    }

    public long getByteHighWaterMark() {
        return -1L;
    }

    public long getByteLowWaterMark() {
        return -1L;
    }

    public long getCountHighWaterMark() {
        return -1L;
    }

    public long getCountLowWaterMark() {
        return -1L;
    }

    public final ItemStream getItemStream() {
        ReferenceCollection referenceCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getItemStream");
        }
        if (null == (referenceCollection = (ReferenceCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        ItemStream itemStream = null;
        if (null != referenceCollection) {
            itemStream = referenceCollection.getOwningItemStream();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getItemStream", (Object)itemStream);
        }
        return itemStream;
    }

    public long getMaximumTimeInStore() {
        return -2L;
    }

    public final Statistics getStatistics() {
        ReferenceCollection referenceCollection = (ReferenceCollection)this._getMembership();
        if (null == referenceCollection) {
            throw new NotInMessageStore();
        }
        return referenceCollection.getStatistics();
    }

    public final boolean isCollection() {
        return true;
    }

    public final boolean isReferenceStream() {
        return true;
    }

    public boolean isSpilling() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isSpilling");
        }
        boolean bl = false;
        ReferenceCollection referenceCollection = (ReferenceCollection)this._getMembership();
        if (null == referenceCollection) {
            throw new NotInMessageStore();
        }
        if (null != referenceCollection) {
            bl = referenceCollection.isSpilling();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isSpilling", (Object)new Boolean(bl));
        }
        return bl;
    }

    public final LockingCursor newLockingCursor(Filter filter) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newLockingCursor", (Object)filter);
        }
        ReferenceCollection referenceCollection = (ReferenceCollection)this._getMembership();
        LockingCursor lockingCursor = null;
        if (null == referenceCollection) {
            throw new NotInMessageStore();
        }
        if (referenceCollection != null) {
            lockingCursor = referenceCollection.newLockingCursor(filter);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newLockingCursor", (Object)lockingCursor);
        }
        return lockingCursor;
    }

    public final NonLockingCursor newNonLockingCursor(Filter filter) throws MessageStoreException {
        ReferenceCollection referenceCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingCursor");
        }
        if (null == (referenceCollection = (ReferenceCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        NonLockingCursor nonLockingCursor = null;
        if (referenceCollection != null) {
            nonLockingCursor = referenceCollection.newNonLockingCursor(filter);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingCursor", (Object)nonLockingCursor);
        }
        return nonLockingCursor;
    }

    public final ItemReference removeFirstMatching(Filter filter, Transaction transaction) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)new Object[]{filter, transaction});
        }
        ReferenceCollection referenceCollection = (ReferenceCollection)this._getMembership();
        ItemReference itemReference = null;
        if (referenceCollection != null) {
            itemReference = (ItemReference)referenceCollection.removeFirstMatching(filter, transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)itemReference);
        }
        return itemReference;
    }

    public final void setWatermarks(long l, long l2, long l3, long l4) {
        ReferenceCollection referenceCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setWatermarks", (Object)new long[]{l, l2, l3, l4});
        }
        if (null == (referenceCollection = (ReferenceCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        if (null != referenceCollection) {
            referenceCollection.setWatermarks(l, l2, l3, l4);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setWatermarks");
        }
    }
}

