/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsHealthMonitor;
import com.ibm.ws.sib.admin.JsMonitoredComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.Membership;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.MessageStoreInterface;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public abstract class MessageStore
implements JsEngineComponent,
JsMonitoredComponent,
JsHealthMonitor,
MessageStoreInterface {
    private static final String MSGSTORE_CLASS_NAME = "com.ibm.ws.sib.msgstore.impl.MessageStoreImpl";
    private static TraceComponent tc = SibTr.register((Class)MessageStore.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");

    public static final MessageStore createInstance() throws ConfigurationError, RuntimeError, ConfigurationWarning, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createInstance");
        }
        MessageStore messageStore = null;
        try {
            messageStore = (MessageStore)Class.forName(MSGSTORE_CLASS_NAME).newInstance();
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.sib.msgstore.MessageStore.createInstance", (String)"134");
            throw new ConfigurationError((Throwable)instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.sib.msgstore.MessageStore.createInstance", (String)"137");
            throw new ConfigurationError((Throwable)classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.sib.msgstore.MessageStore.createInstance", (String)"140");
            throw new ConfigurationError((Throwable)illegalArgumentException);
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.sib.msgstore.MessageStore.createInstance", (String)"143");
            throw new ConfigurationError((Throwable)securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.sib.msgstore.MessageStore.createInstance", (String)"146");
            throw new ConfigurationError((Throwable)illegalAccessException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createInstance", (Object)messageStore);
        }
        return messageStore;
    }

    protected MessageStore() {
    }

    protected void _setMembership(Membership membership, AbstractItem abstractItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_setMembership", (Object)new Object[]{membership, abstractItem});
        }
        abstractItem._setMembership(membership);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_setMembership");
        }
    }

    public void add(ItemStream itemStream, Transaction transaction) throws MessageStoreException {
        this.add(itemStream, -2L, transaction);
    }

    public void expirerStart() {
    }

    public void expirerStop() {
    }

    protected abstract Membership getMembership(long var1);

    public void serverStarted() {
    }

    public void serverStopping() {
    }

    public void start() {
        this.start(0);
    }

    public final void xmlRequestWriteOnFile(FormattedWriter formattedWriter) throws IOException {
        this.xmlWriteOn(formattedWriter);
        formattedWriter.flush();
    }

    public final void xmlRequestWriteOnSystemOut() throws IOException {
        FormattedWriter formattedWriter = new FormattedWriter((Writer)new OutputStreamWriter(System.out));
        this.xmlWriteOn(formattedWriter);
        formattedWriter.flush();
    }

    public final void xmlRequestWriteRawDataOnFile(FormattedWriter formattedWriter) throws IOException {
        this.xmlWriteRawOn(formattedWriter);
        formattedWriter.flush();
    }

    public final void xmlRequestWriteRawDataOnSystemOut() throws IOException {
        FormattedWriter formattedWriter = new FormattedWriter((Writer)new OutputStreamWriter(System.out));
        this.xmlWriteRawOn(formattedWriter);
        formattedWriter.flush();
    }

    public void xmlWriteRawOn(FormattedWriter formattedWriter) throws IOException {
    }
}

