/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.InvalidAddOperation;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemCollection;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.SibTr;

public class ItemStream
extends AbstractItem {
    private static TraceComponent tc = SibTr.register((Class)ItemStream.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");

    public void addItem(Item item, long l, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addItem");
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new InvalidAddOperation("STREAM_NOT_STORED_SIMS0004", new Object[]{item, this});
        }
        if (null != item._getMembership()) {
            throw new InvalidAddOperation("STREAM_ADD_CONFLICT_SIMS0005", new Object[]{item, this});
        }
        itemCollection.addItem(item, l, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItem");
        }
    }

    public void addItem(Item item, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException {
        this.addItem(item, -2L, transaction);
    }

    public void addItemStream(ItemStream itemStream, long l, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addItemStream");
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new InvalidAddOperation("STREAM_NOT_STORED_SIMS0004", new Object[]{itemStream, this});
        }
        if (null != itemStream._getMembership()) {
            throw new InvalidAddOperation("STREAM_ADD_CONFLICT_SIMS0005", new Object[]{itemStream, this});
        }
        itemCollection.addItemStream(itemStream, l, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItemStream");
        }
    }

    public void addItemStream(ItemStream itemStream, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException {
        this.addItemStream(itemStream, -2L, transaction);
    }

    public void addReferenceStream(ReferenceStream referenceStream, long l, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addReferenceStream");
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new InvalidAddOperation("STREAM_NOT_STORED_SIMS0004", new Object[]{referenceStream, this});
        }
        if (null != referenceStream._getMembership()) {
            throw new InvalidAddOperation("STREAM_ADD_CONFLICT_SIMS0005", new Object[]{referenceStream, this});
        }
        itemCollection.addReferenceStream(referenceStream, l, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addReferenceStream");
        }
    }

    public void addReferenceStream(ReferenceStream referenceStream, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException {
        this.addReferenceStream(referenceStream, -2L, transaction);
    }

    public void eventWatermarkBreached() {
    }

    public final Item findFirstMatchingItem(Filter filter) throws MessageStoreException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItem", (Object)filter);
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        Item item = null;
        if (itemCollection != null) {
            item = (Item)itemCollection.findFirstMatchingItem(filter);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItem", (Object)item);
        }
        return item;
    }

    public final ItemStream findFirstMatchingItemStream(Filter filter) throws MessageStoreException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItemStream", (Object)filter);
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        ItemStream itemStream = null;
        if (itemCollection != null) {
            itemStream = itemCollection.findFirstMatchingItemStream(filter);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItemStream", (Object)itemStream);
        }
        return itemStream;
    }

    public final ReferenceStream findFirstMatchingReferenceStream(Filter filter) throws MessageStoreException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatchingReferenceStream", (Object)filter);
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        ReferenceStream referenceStream = null;
        if (itemCollection != null) {
            referenceStream = itemCollection.findFirstMatchingReferenceStream(filter);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingReferenceStream", (Object)referenceStream);
        }
        return referenceStream;
    }

    public final AbstractItem findById(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findById", (Object)new Long(l));
        }
        AbstractItem abstractItem = null;
        ItemCollection itemCollection = (ItemCollection)this._getMembership();
        if (null == itemCollection) {
            throw new InvalidAddOperation("STREAM_NOT_STORED_SIMS0004", new Object[]{this});
        }
        abstractItem = itemCollection.findById(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findById", (Object)abstractItem);
        }
        return abstractItem;
    }

    public final Item findOldestItem() throws MessageStoreException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findOldestItem");
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        Item item = null;
        if (itemCollection != null) {
            item = (Item)itemCollection.findOldestItem();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findOldestItem", (Object)item);
        }
        return item;
    }

    public long getByteHighWaterMark() {
        return -1L;
    }

    public long getByteLowWaterMark() {
        return -1L;
    }

    public long getCountHighWaterMark() {
        return -1L;
    }

    public long getCountLowWaterMark() {
        return -1L;
    }

    public final ItemStream getItemStream() {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getItemStream");
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        ItemStream itemStream = null;
        if (null != itemCollection) {
            itemStream = itemCollection.getOwningItemStream();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getItemStream", (Object)itemStream);
        }
        return itemStream;
    }

    public long getMaximumTimeInStore() {
        return -2L;
    }

    public final Statistics getStatistics() {
        if (null == (ItemCollection)this._getMembership()) {
            throw new NotInMessageStore();
        }
        ItemCollection itemCollection = (ItemCollection)this._getMembership();
        if (null == itemCollection) {
            throw new NotInMessageStore();
        }
        return itemCollection.getStatistics();
    }

    public final boolean isCollection() {
        return true;
    }

    public final boolean isItemStream() {
        return true;
    }

    public final boolean isSpilling() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isSpilling");
        }
        boolean bl = false;
        ItemCollection itemCollection = (ItemCollection)this._getMembership();
        if (null == itemCollection) {
            throw new NotInMessageStore();
        }
        if (null != itemCollection) {
            bl = itemCollection.isSpilling();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isSpilling", (Object)new Boolean(bl));
        }
        return bl;
    }

    public final LockingCursor newLockingItemCursor(Filter filter) throws MessageStoreException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newLockingItemCursor", (Object)filter);
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        LockingCursor lockingCursor = null;
        if (itemCollection != null) {
            lockingCursor = itemCollection.newLockingItemCursor(filter);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newLockingItemCursor", (Object)lockingCursor);
        }
        return lockingCursor;
    }

    public final NonLockingCursor newNonLockingItemCursor(Filter filter) throws MessageStoreException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingItemCursor");
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        NonLockingCursor nonLockingCursor = null;
        if (itemCollection != null) {
            nonLockingCursor = itemCollection.newNonLockingItemCursor(filter);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingItemCursor", (Object)nonLockingCursor);
        }
        return nonLockingCursor;
    }

    public final NonLockingCursor newNonLockingItemStreamCursor(Filter filter) throws MessageStoreException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingItemStreamCursor");
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        NonLockingCursor nonLockingCursor = null;
        if (itemCollection != null) {
            nonLockingCursor = itemCollection.newNonLockingItemStreamCursor(filter);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingItemStreamCursor", (Object)nonLockingCursor);
        }
        return nonLockingCursor;
    }

    public final NonLockingCursor newNonLockingReferenceStreamCursor(Filter filter) throws MessageStoreException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingReferenceStreamCursor");
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        NonLockingCursor nonLockingCursor = null;
        if (itemCollection != null) {
            nonLockingCursor = itemCollection.newNonLockingReferenceStreamCursor(filter);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingReferenceStreamCursor", (Object)nonLockingCursor);
        }
        return nonLockingCursor;
    }

    public final Item removeFirstMatchingItem(Filter filter, Transaction transaction) throws MessageStoreException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItem", (Object)new Object[]{filter, transaction});
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        Item item = null;
        if (itemCollection != null) {
            item = (Item)itemCollection.removeFirstMatchingItem(filter, transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItem", (Object)item);
        }
        return item;
    }

    public final ItemStream removeFirstMatchingItemStream(Filter filter, Transaction transaction) throws MessageStoreException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItemStream", (Object)new Object[]{filter, transaction});
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        ItemStream itemStream = null;
        if (itemCollection != null) {
            itemStream = itemCollection.removeFirstMatchingItemStream(filter, transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItemStream", (Object)itemStream);
        }
        return itemStream;
    }

    public final ReferenceStream removeFirstMatchingReferenceStream(Filter filter, Transaction transaction) throws MessageStoreException {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingReferenceStream", (Object)new Object[]{filter, transaction});
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        ReferenceStream referenceStream = null;
        if (itemCollection != null) {
            referenceStream = itemCollection.removeFirstMatchingReferenceStream(filter, transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingReferenceStream", (Object)referenceStream);
        }
        return referenceStream;
    }

    public void setMaximumSize(int n) {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMaximumSize", (Object)new Integer(n));
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        itemCollection.setMaximumSize(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMaximumSize");
        }
    }

    public final void setWatermarks(long l, long l2, long l3, long l4) {
        ItemCollection itemCollection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setWatermarks", (Object)new long[]{l, l2, l3, l4});
        }
        if (null == (itemCollection = (ItemCollection)this._getMembership())) {
            throw new NotInMessageStore();
        }
        itemCollection.setWatermarks(l, l2, l3, l4);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setWatermarks");
        }
    }
}

