/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemMembership;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.ReferenceMembership;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.utils.ras.SibTr;

public class ItemReference
extends AbstractItem {
    private static TraceComponent tc = SibTr.register((Class)ItemReference.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private Item _item;
    private ItemMembership _referredMembership;

    public ItemReference() {
    }

    public ItemReference(Item item) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>");
        }
        this._item = item;
        this._referredMembership = (ItemMembership)item._getMembership();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ItemReference");
        }
    }

    public final Item getReferredItem() {
        if (null == this._item) {
            if (null == this._referredMembership) {
                MessageStore messageStore;
                long l;
                ReferenceMembership referenceMembership = (ReferenceMembership)this._getMembership();
                if (null == referenceMembership) {
                    throw new NotInMessageStore();
                }
                if (null != referenceMembership && -1L != (l = referenceMembership.getReferencedID()) && null != (messageStore = this.getOwningMessageStore())) {
                    this._referredMembership = (ItemMembership)messageStore.getMembership(l);
                }
            }
            if (null != this._referredMembership) {
                this._item = (Item)this._referredMembership.getItem();
            }
        }
        return this._item;
    }

    public int getPriority() {
        if (null != this._item) {
            return this._item.getPriority();
        }
        return this._referredMembership.getPriority();
    }

    public final boolean isItemReference() {
        return true;
    }

    public void restore(byte[] byArray) throws PersistentDataEncodingException {
        super.restore(byArray);
        long l = ((ReferenceMembership)this._getMembership()).getReferencedID();
        this._referredMembership = (ItemMembership)this.getOwningMessageStore().getMembership(l);
    }

    public final ReferenceStream getReferenceStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReferenceStream");
        }
        ReferenceStream referenceStream = null;
        ReferenceMembership referenceMembership = (ReferenceMembership)this._getMembership();
        if (null == referenceMembership) {
            throw new NotInMessageStore();
        }
        if (null != referenceMembership) {
            referenceStream = referenceMembership.getOwningReferenceStream();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReferenceStream", (Object)referenceStream);
        }
        return referenceStream;
    }
}

