/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.Membership;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public abstract class AbstractItem {
    public static final String $ssccid = "@(#) 1.118.1.1 SIB/ws/code/sib.msgstore/src/com/ibm/ws/sib/msgstore/AbstractItem.java, SIB.msgstore, WAS602.SIB, o0610.11 05/08/08 08:07:42 [3/13/06 13:38:04]";
    protected static final boolean STRICT_ENFORCED_IN_MESSAGESTORE = true;
    private final MembershipLock _membershipLock = new MembershipLock();
    public static final int DEFAULT_PRIORITY = 5;
    public static final long NEVER_EXPIRES = -2L;
    public static final long NO_ID = -1L;
    public static final long NO_LOCK_ID = -2L;
    public static final int STORE_ALWAYS = 4;
    public static final int STORE_EVENTUALLY = 3;
    public static final int STORE_MAYBE = 2;
    public static final int STORE_NEVER = 1;
    private static TraceComponent tc = SibTr.register((Class)AbstractItem.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private long _cachedId = -1L;
    private Membership _membership = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Membership _getMembership() {
        MembershipLock membershipLock = this._membershipLock;
        synchronized (membershipLock) {
            return this._membership;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void _setMembership(Membership membership) {
        MembershipLock membershipLock = this._membershipLock;
        synchronized (membershipLock) {
            this._membership = membership;
            if (null != this._membership) {
                this._cachedId = this._membership.getID();
            }
        }
    }

    public boolean canExpireSilently() {
        return true;
    }

    public boolean deferDataPersistence() {
        return false;
    }

    public void eventExpiryNotification(Transaction transaction) {
    }

    public void eventPostCommitAdd(Transaction transaction) {
    }

    public void eventPostCommitRemove(Transaction transaction) {
        this._setMembership(null);
    }

    public void eventPostCommitUpdate(Transaction transaction) {
    }

    public void eventPostRollbackAdd(Transaction transaction) {
        this._setMembership(null);
    }

    public void eventPostRollbackRemove(Transaction transaction) {
    }

    public void eventPostRollbackUpdate(Transaction transaction) {
    }

    public boolean eventPrecommitAdd(Transaction transaction) {
        return true;
    }

    public void eventPrecommitRemove(Transaction transaction) {
    }

    public void eventPrecommitUpdate(Transaction transaction) {
    }

    public void eventRestored() {
    }

    public void eventUnlocked() {
    }

    public long getExpiryStartTime() {
        return 0L;
    }

    public final long getID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getID");
        }
        long l = -1L;
        Membership membership = this._getMembership();
        if (null == membership) {
            throw new NotInMessageStore();
        }
        if (null != membership) {
            l = membership.getID();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getID", (Object)new Long(l));
        }
        return l;
    }

    public final long getLockID() throws MessageStoreException {
        Membership membership = this._getMembership();
        if (null == membership) {
            throw new NotInMessageStore();
        }
        return membership.getLockID();
    }

    public long getMaximumTimeInStore() {
        return -2L;
    }

    protected final MessageStore getOwningMessageStore() {
        Membership membership;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOwningMessageStore");
        }
        if (null == (membership = this._getMembership())) {
            throw new NotInMessageStore();
        }
        MessageStore messageStore = membership.getMessageStore();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getOwningMessageStore", (Object)messageStore);
        }
        return messageStore;
    }

    public byte[] getPersistentData() throws PersistentDataEncodingException {
        return null;
    }

    public int getPersistentDataSize() {
        return 100;
    }

    public int getPriority() {
        return 5;
    }

    public int getStorageStrategy() {
        return 1;
    }

    public final PersistentTranId getTransactionId() {
        PersistentTranId persistentTranId = null;
        Membership membership = this._getMembership();
        if (null != membership) {
            persistentTranId = membership.getTransactionId();
        }
        return persistentTranId;
    }

    public final int guessBackoutCount() {
        int n = 0;
        Membership membership = this._getMembership();
        if (null != membership) {
            n = membership.guessBackoutCount();
        }
        return n;
    }

    public final int guessUnlockCount() {
        int n = 0;
        Membership membership = this._getMembership();
        if (null != membership) {
            n = membership.guessUnlockCount();
        }
        return n;
    }

    public final boolean isAdding() {
        boolean bl = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            bl = membership.isAdding();
        }
        return bl;
    }

    public final boolean isAvailable() {
        boolean bl = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            bl = membership.isAvailable();
        }
        return bl;
    }

    public boolean isCollection() {
        return false;
    }

    public final boolean isExpiring() {
        boolean bl = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            bl = membership.isExpiring();
        }
        return bl;
    }

    public final boolean isInStore() {
        boolean bl = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            bl = membership.isInStore();
        }
        return bl;
    }

    public boolean isItem() {
        return false;
    }

    public boolean isItemReference() {
        return false;
    }

    public boolean isItemStream() {
        return false;
    }

    public final boolean isLocked() {
        boolean bl = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            bl = membership.isLocked();
        }
        return bl;
    }

    public boolean isPersistentDataImmutable() {
        return false;
    }

    public boolean isPersistentDataNeverUpdated() {
        return false;
    }

    public final boolean isPersistentlyLocked() {
        boolean bl = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            bl = membership.isPersistentlyLocked();
        }
        return bl;
    }

    public boolean isReferenceStream() {
        return false;
    }

    public final boolean isRemoving() {
        boolean bl = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            bl = membership.isRemoving();
        }
        return bl;
    }

    public final synchronized boolean isUpdating() {
        boolean bl = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            bl = membership.isUpdating();
        }
        return bl;
    }

    public final boolean lockItemIfAvailable(long l) {
        boolean bl = false;
        Membership membership = this._getMembership();
        if (null != membership) {
            bl = membership.lockItemIfAvailable(l);
        }
        return bl;
    }

    public final void persistLock(Transaction transaction) throws ProtocolException, TransactionException {
        Membership membership = this._getMembership();
        if (null == membership) {
            throw new NotInMessageStore();
        }
        membership.persistLock(transaction);
    }

    public final void remove(Transaction transaction, long l) throws MessageStoreException {
        Membership membership;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove");
        }
        if (null == (membership = this._getMembership())) {
            throw new NotInMessageStore();
        }
        membership.cmdRemove(l, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public final void requestUpdate(Transaction transaction) throws MessageStoreException {
        Membership membership;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requestUpdate", (Object)transaction);
        }
        if (null == (membership = this._getMembership())) {
            throw new NotInMessageStore();
        }
        membership.requestUpdate(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestUpdate");
        }
    }

    public void restore(byte[] byArray) throws PersistentDataEncodingException {
    }

    public final void unlock(long l) throws MessageStoreException {
        this.unlock(l, null);
    }

    public final void unlock(long l, Transaction transaction) throws MessageStoreException {
        Membership membership = this._getMembership();
        if (null == membership) {
            throw new NotInMessageStore();
        }
        membership.unlock(l, transaction, true);
    }

    public final void unlock(long l, Transaction transaction, boolean bl) throws MessageStoreException {
        Membership membership = this._getMembership();
        if (null == membership) {
            throw new NotInMessageStore();
        }
        membership.unlock(l, transaction, bl);
    }

    public final void xmlRequestWriteOn(FormattedWriter formattedWriter) throws IOException {
        Membership membership = this._getMembership();
        if (null == membership) {
            throw new NotInMessageStore();
        }
        if (null != membership) {
            membership.requestXmlWriteOn(formattedWriter);
            formattedWriter.flush();
        }
    }

    public final void xmlRequestWriteOnSystemOut() throws IOException {
        Membership membership = this._getMembership();
        if (null == membership) {
            throw new NotInMessageStore();
        }
        if (null != membership) {
            FormattedWriter formattedWriter = new FormattedWriter((Writer)new OutputStreamWriter(System.out));
            membership.requestXmlWriteOn(formattedWriter);
            formattedWriter.flush();
        }
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
    }

    private final class MembershipLock {
        private MembershipLock() {
        }
    }
}

