/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mqfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.mqfapchannel.DataSentListener;
import com.ibm.ws.sib.mqfapchannel.impl.ConnectionImpl;
import com.ibm.ws.sib.mqfapchannel.impl.MQFapConstants;
import com.ibm.ws.sib.utils.Semaphore;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.util.List;

public class MQFapWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = SibTr.register((Class)MQFapWriteCallback.class, (String)"SIBMqFapChannel", (String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages");
    private volatile List data = null;
    private volatile DataSentListener listener = null;
    private volatile boolean returnToPool = false;
    private Connection connection;
    private Semaphore okayToSendSemaphore = null;
    private TCPWriteRequestContext tcpWriteCtx;

    protected MQFapWriteCallback(Connection connection, Semaphore semaphore, TCPWriteRequestContext tCPWriteRequestContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{connection, semaphore});
        }
        this.connection = connection;
        this.okayToSendSemaphore = semaphore;
        this.tcpWriteCtx = tCPWriteRequestContext;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public void setData(List list) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setData", (Object)list);
        }
        this.data = list;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setData");
        }
    }

    public void setDataSentListener(DataSentListener dataSentListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDataSentListener", (Object)dataSentListener);
        }
        this.listener = dataSentListener;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDataSentListener");
        }
    }

    public void setReturnToPool(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReturnToPool", (Object)("" + bl));
        }
        this.returnToPool = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReturnToPool");
        }
    }

    private void freeBuffers() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"freeBuffers");
        }
        for (int i = 0; i < this.data.size(); ++i) {
            WsByteBuffer wsByteBuffer = (WsByteBuffer)this.data.get(i);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("attempting to free buffer: " + wsByteBuffer));
            }
            wsByteBuffer.release();
            this.tcpWriteCtx.setBuffers(null);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"freeBuffers");
        }
    }

    public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
        block7: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"complete", (Object)new Object[]{virtualConnection, tCPWriteRequestContext});
            }
            if (this.listener != null) {
                try {
                    this.listener.dataSent(this.connection, this.data, this.returnToPool);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.mqfapchannel.impl.MQFapReadCallback.complete", (String)MQFapConstants.MQFAP_WRITE_CALLBACK_COMPLETE_01);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Data Sent Listener dataSent method threw throwable");
                    }
                    if (!tc.isEventEnabled()) break block7;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)throwable);
                }
            }
        }
        if (this.returnToPool) {
            this.freeBuffers();
        }
        this.okayToSendSemaphore.post();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"complete");
        }
    }

    public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
        block13: {
            block12: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"error", (Object)new Object[]{virtualConnection, tCPWriteRequestContext, iOException});
                }
                if (this.listener != null) {
                    try {
                        this.listener.errorOccurred(this.connection, this.data, this.returnToPool, iOException);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.mqfapchannel.impl.MQFapWriteCallback.error", (String)MQFapConstants.MQFAP_WRITE_CALLBACK_ERROR_01);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Data Sent Listener errorOccurred method threw throwable");
                        }
                        if (!tc.isEventEnabled()) break block12;
                        SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)throwable);
                    }
                }
            }
            if (this.returnToPool) {
                this.freeBuffers();
            }
            try {
                SIConnectionLostException sIConnectionLostException = new SIConnectionLostException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages", (String)"MQWRITECALL_ERROR_SICM0025", null, (String)"MQWRITECALL_ERROR_SICM0025"), (Throwable)iOException);
                ((ConnectionImpl)this.connection).close((Exception)((Object)sIConnectionLostException));
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mqfapchannel.impl.MQFapWriteCallback.ErrorCloseThread.run", (String)MQFapConstants.MQFAP_WRITE_CALLBACK_ERROR_CLOSE_THREAD_RUN_01);
                if (!tc.isEventEnabled()) break block13;
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        this.okayToSendSemaphore.post();
        if (((ConnectionImpl)this.connection).getType() == Connection.QMGR) {
            CommsPMI.getMQLinkStats().onCommsError();
        } else if (((ConnectionImpl)this.connection).getType() == Connection.CLIENT) {
            CommsPMI.getMQClientLinkStats().onCommsError();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"error");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.mqfapchannel.impl/src/com/ibm/ws/sib/mqfapchannel/impl/MQFapWriteCallback.java, SIB.comms, WAS602.SIB, o0610.11 1.18");
        }
    }
}

