/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mqfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.mqfapchannel.ConnectionManager;
import com.ibm.ws.sib.mqfapchannel.DataSentListener;
import com.ibm.ws.sib.mqfapchannel.ReceiveListener;
import com.ibm.ws.sib.mqfapchannel.impl.ConnectionImpl;
import com.ibm.ws.sib.mqfapchannel.impl.MQFapConstants;
import com.ibm.ws.sib.utils.Semaphore;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MQFapReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = SibTr.register((Class)MQFapReadCallback.class, (String)"SIBMqFapChannel", (String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages");
    private volatile ReceiveListener receiveListener = null;
    private Connection connection = null;
    private TCPReadRequestContext tcpReadCtx = null;
    private boolean inMiddleOfTransmission = false;
    private WsByteBuffer transmissionBuffer = null;
    private static final int MINIMUM_USEFUL_TRANSMISSION_LENGTH = 8;
    private static final int DEFAULT_READ_AMOUNT = 31744;
    private boolean issueMoreReadRequests = true;
    private int timeout = -1;

    protected MQFapReadCallback(Connection connection, TCPReadRequestContext tCPReadRequestContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{connection, tCPReadRequestContext});
        }
        this.connection = connection;
        this.tcpReadCtx = tCPReadRequestContext;
        int n = 1024;
        if (tCPReadRequestContext.getBuffer() != null && n < tCPReadRequestContext.getBuffer().capacity()) {
            n = tCPReadRequestContext.getBuffer().capacity();
        }
        WsByteBuffer wsByteBuffer = this.allocateBufferFromPool(n);
        if (tCPReadRequestContext.getBuffer() != null) {
            tCPReadRequestContext.getBuffer().flip();
            wsByteBuffer.put(tCPReadRequestContext.getBuffer());
        }
        tCPReadRequestContext.setBuffer(wsByteBuffer);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected void setReceiveListener(ReceiveListener receiveListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReceiveListener", (Object)receiveListener);
        }
        this.receiveListener = receiveListener;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReceiveListener");
        }
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"complete", (Object)new Object[]{virtualConnection, tCPReadRequestContext});
        }
        boolean bl = true;
        do {
            bl = true;
            int n = 0;
            boolean bl2 = true;
            WsByteBuffer wsByteBuffer = this.tcpReadCtx.getBuffer();
            if (wsByteBuffer != null) {
                ((ConnectionImpl)this.connection).incrementBuffersReceived();
                ((ConnectionImpl)this.connection).addBytesReceived(wsByteBuffer.position());
                if (((ConnectionImpl)this.connection).getType() == Connection.CLIENT) {
                    CommsPMI.getMQClientLinkStats().onReceiveBytes(wsByteBuffer.position());
                }
                wsByteBuffer.flip();
                if (tc.isDumpEnabled()) {
                    SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])wsByteBuffer.array(), (int)wsByteBuffer.arrayOffset(), (int)wsByteBuffer.remaining(), (String)"data passed to complete callback");
                }
            }
            while (bl2) {
                int n2;
                int n3;
                if (this.inMiddleOfTransmission) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"complete", (Object)("In middle of transmission\nbuffer.remaining: " + wsByteBuffer.remaining() + "\ntransmissionBuffer.remaining: " + this.transmissionBuffer.remaining()));
                    }
                    if (wsByteBuffer.remaining() >= this.transmissionBuffer.remaining()) {
                        block37: {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"complete", (Object)"Enough data for transmission");
                            }
                            int n4 = wsByteBuffer.limit();
                            wsByteBuffer.limit(wsByteBuffer.position() + this.transmissionBuffer.remaining());
                            this.transmissionBuffer.put(wsByteBuffer);
                            wsByteBuffer.limit(n4);
                            this.transmissionBuffer.position(0);
                            try {
                                ReceiveListener receiveListener = null;
                                do {
                                    n3 = this.transmissionBuffer.position();
                                    int n5 = this.transmissionBuffer.limit();
                                    receiveListener = this.receiveListener.dataReceived(this.connection, this.transmissionBuffer);
                                    if (receiveListener == null) continue;
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Change of receive listener: " + receiveListener));
                                    }
                                    this.transmissionBuffer.position(n3);
                                    this.transmissionBuffer.limit(n5);
                                    this.receiveListener = receiveListener;
                                } while (receiveListener != null);
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.mqfapchannel.impl.MQFapReadCallback.complete", (String)"29");
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Receive Listener dataReceived method threw throwable");
                                }
                                if (!tc.isEventEnabled()) break block37;
                                SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)throwable);
                            }
                        }
                        this.transmissionBuffer = null;
                        this.inMiddleOfTransmission = false;
                        bl2 = true;
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"complete", (Object)"Insufficient data for transmission");
                    }
                    this.transmissionBuffer.put(wsByteBuffer);
                    wsByteBuffer.clear();
                    n = Math.min(this.transmissionBuffer.remaining(), wsByteBuffer.remaining());
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"complete", (Object)("nextReadMinAmount: " + n));
                    }
                    bl2 = false;
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"complete", (Object)"Start of new transmission");
                }
                if (wsByteBuffer == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"complete", (Object)"buffer == null");
                    }
                    n = 8;
                    bl2 = false;
                    WsByteBuffer wsByteBuffer2 = this.allocateBufferFromPool(31744);
                    wsByteBuffer2.limit(31744);
                    this.tcpReadCtx.setBuffer(wsByteBuffer2);
                    wsByteBuffer = wsByteBuffer2;
                    continue;
                }
                if (wsByteBuffer.remaining() < 8) {
                    if (wsByteBuffer.position() > 0) {
                        wsByteBuffer.compact();
                        wsByteBuffer.limit(wsByteBuffer.position());
                        wsByteBuffer.position(0);
                    }
                    n = 8 - wsByteBuffer.remaining();
                    if (wsByteBuffer.capacity() - wsByteBuffer.limit() < n) {
                        WsByteBuffer wsByteBuffer3 = this.allocateBufferFromPool(31744);
                        wsByteBuffer3.limit(31744);
                        wsByteBuffer3.put(wsByteBuffer);
                        this.tcpReadCtx.setBuffer(wsByteBuffer3);
                        wsByteBuffer.release();
                        wsByteBuffer = wsByteBuffer3;
                    } else {
                        wsByteBuffer.position(wsByteBuffer.limit());
                        wsByteBuffer.limit(wsByteBuffer.capacity());
                    }
                    bl2 = false;
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"complete", (Object)"Enough data present to determine transmission length");
                }
                int n6 = wsByteBuffer.position();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"complete", (Object)("buffer.position: " + n6));
                }
                if ((n2 = wsByteBuffer.getInt()) != 1414744096 && n2 != -471676864) {
                    WsByteBuffer wsByteBuffer4;
                    block38: {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"complete", (Object)"Bad eyecatcher detected");
                        }
                        wsByteBuffer.position(n6);
                        if (tc.isDebugEnabled()) {
                            SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])wsByteBuffer.array(), (int)wsByteBuffer.arrayOffset(), (int)wsByteBuffer.remaining(), (String)"data with bad eyecatcher");
                        }
                        wsByteBuffer4 = null;
                        try {
                            wsByteBuffer4 = this.receiveListener.buildErrorCloseFapFlow();
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.mqfapchannel.impl.MQFapReadCallback.complete", (String)"30");
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Receive Listener buildErrorCloseFapFlow method threw throwable");
                            }
                            if (!tc.isEventEnabled()) break block38;
                            SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)throwable);
                        }
                    }
                    ErrorCloseThread errorCloseThread = new ErrorCloseThread(wsByteBuffer4, this.connection);
                    errorCloseThread.start();
                    this.inMiddleOfTransmission = false;
                    bl2 = false;
                    this.issueMoreReadRequests = false;
                    if (((ConnectionImpl)this.connection).getType() == Connection.QMGR) {
                        CommsPMI.getMQLinkStats().onCommsError();
                        continue;
                    }
                    if (((ConnectionImpl)this.connection).getType() != Connection.CLIENT) continue;
                    CommsPMI.getMQClientLinkStats().onCommsError();
                    continue;
                }
                n3 = wsByteBuffer.getInt();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"complete", (Object)("Transmission length: " + n3));
                }
                this.transmissionBuffer = this.allocateBufferFromPool(n3);
                this.transmissionBuffer.limit(n3);
                wsByteBuffer.position(n6);
                this.inMiddleOfTransmission = true;
                bl2 = true;
            }
            if (!this.issueMoreReadRequests || ((ConnectionImpl)this.connection).isClosing()) continue;
            virtualConnection = this.tcpReadCtx.read((long)n, (TCPReadCompletedCallback)this, false, this.timeout);
            if (virtualConnection != null) {
                bl = false;
                continue;
            }
            if (((ConnectionImpl)this.connection).getType() == Connection.QMGR) {
                CommsPMI.getMQLinkStats().onReadBlocked();
                continue;
            }
            if (((ConnectionImpl)this.connection).getType() != Connection.CLIENT) continue;
            CommsPMI.getMQClientLinkStats().onReadBlocked();
        } while (!bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"complete");
        }
    }

    private WsByteBuffer allocateBufferFromPool(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"allocateBufferFromPool", (Object)("" + n));
        }
        WsByteBuffer wsByteBuffer = null;
        wsByteBuffer = ConnectionManager.getPoolMgr().allocate(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"allocateBufferFromPool", (Object)wsByteBuffer);
        }
        return wsByteBuffer;
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"error", (Object)new Object[]{virtualConnection, tCPReadRequestContext, iOException});
        }
        if (((ConnectionImpl)this.connection).isClosing()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"error occurred while closing connection");
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)iOException);
            }
        } else {
            block15: {
                block14: {
                    try {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mqfapchannel.impl.ConnectionManager.error", (String)MQFapConstants.MQFAP_READ_CALLBACK_ERROR_01);
                        if (tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)iOException);
                        }
                        SIConnectionLostException sIConnectionLostException = new SIConnectionLostException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages", (String)"MQREADCALL_ERROR_SICM0024", null, (String)"MQREADCALL_ERROR_SICM0024"), (Throwable)iOException);
                        ((ConnectionImpl)this.connection).close((Exception)((Object)sIConnectionLostException));
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mqfapchannel.MQFapReadCallback.error", (String)MQFapConstants.MQFAP_READ_CALLBACK_ERROR_02);
                        if (!tc.isEventEnabled()) break block14;
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIException));
                    }
                }
                try {
                    this.receiveListener.errorOccurred(this.connection, iOException);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.mqfapchannel.impl.MQFapReadCallback.error", (String)MQFapConstants.MQFAP_READ_CALLBACK_ERROR_03);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Receive Listener errorOccurred method threw throwable");
                    }
                    if (!tc.isEventEnabled()) break block15;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)throwable);
                }
            }
            if (((ConnectionImpl)this.connection).getType() == Connection.QMGR) {
                CommsPMI.getMQLinkStats().onCommsError();
            } else if (((ConnectionImpl)this.connection).getType() == Connection.CLIENT) {
                CommsPMI.getMQClientLinkStats().onCommsError();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"error");
        }
    }

    protected void setReceiveTimeout(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReceiveTimeout", (Object)("" + n));
        }
        if (n == 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Receive timeout is disabled");
            }
            this.timeout = -1;
        } else {
            this.timeout = n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReceiveTimeout");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.mqfapchannel.impl/src/com/ibm/ws/sib/mqfapchannel/impl/MQFapReadCallback.java, SIB.comms, WAS602.SIB, o0610.11 1.21");
        }
    }

    private class ErrorCloseThread
    extends Thread {
        private WsByteBuffer errorFlow = null;
        private Connection connection = null;
        private Semaphore sentSemaphore = null;

        protected ErrorCloseThread(WsByteBuffer wsByteBuffer, Connection connection) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"ErrorCloseThread.<init>", (Object)new Object[]{wsByteBuffer, connection});
            }
            this.errorFlow = wsByteBuffer;
            this.connection = connection;
            this.sentSemaphore = new Semaphore();
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"ErrorCloseThread.<init>");
            }
        }

        public void run() {
            block7: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"ErrorCloseThread.run");
                }
                try {
                    if (this.errorFlow != null) {
                        ArrayList<WsByteBuffer> arrayList = new ArrayList<WsByteBuffer>(1);
                        arrayList.add(this.errorFlow);
                        this.connection.send(arrayList, new ErrorCloseDataSentListener(this.sentSemaphore), true);
                        try {
                            this.sentSemaphore.waitOn();
                        }
                        catch (InterruptedException interruptedException) {
                            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.mqfapchannel.impl.MQFapWriteCallback.ErrorCloseThread.send", (String)MQFapConstants.MQFAP_READ_CALLBACK_ERRORCLOSE_THREAD_SEND_01);
                        }
                    }
                    this.connection.close();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mqfapchannel.impl.MQFapReadCallback.ErrorCloseThread.run", (String)MQFapConstants.MQFAP_READ_CALLBACK_ERRORCLOSE_THREAD_RUN_01);
                    if (!tc.isEventEnabled()) break block7;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIException));
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"ErrorCloseThread.run");
            }
        }

        private class ErrorCloseDataSentListener
        implements DataSentListener {
            private Semaphore semaphore = null;

            public ErrorCloseDataSentListener(Semaphore semaphore) {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"ErrorCloseThread.ErrorCloseDataSentListener.<init>", (Object)semaphore);
                }
                this.semaphore = semaphore;
                if (tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"ErrorCloseThread.ErrorCloseDataSentListener.<init>");
                }
            }

            public void dataSent(Connection connection, List list, boolean bl) {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"ErrorCloseThread.ErrorCloseDataSentListener.dataSent", (Object)new Object[]{connection, list, "" + bl});
                }
                this.semaphore.post();
                if (tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"ErrorCloseThread.ErrorCloseDataSentListener.dataSent");
                }
            }

            public void errorOccurred(Connection connection, List list, boolean bl, Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"ErrorCloseThread.ErrorCloseDataSentListener.errorOccurred", (Object)new Object[]{connection, list, "" + bl, throwable});
                }
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.mqfapchannel.impl.MQFapReadCallback.ErrorCloseThread.errorOccurred", (String)MQFapConstants.MQFAP_READ_CALLBACK_ERRORCLOSE_THREAD_ERROR_OCCURRED_01);
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)throwable);
                }
                this.semaphore.post();
                if (tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"ErrorCloseThread.ErrorCloseDataSentListener.errorOccurred");
                }
            }
        }
    }
}

