/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mqfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mqfapchannel.AcceptListener;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.mqfapchannel.ReceiveListener;
import com.ibm.ws.sib.mqfapchannel.impl.ConnectionImpl;
import com.ibm.ws.sib.mqfapchannel.impl.ConnectionManagerImpl;
import com.ibm.ws.sib.mqfapchannel.impl.MQFapChannelFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.base.InboundApplicationLink;
import com.ibm.wsspi.channel.framework.ChannelFactoryData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;

public class MQFapInboundConnLink
extends InboundApplicationLink {
    private static final TraceComponent tc = SibTr.register((Class)MQFapInboundConnLink.class, (String)"SIBMqFapChannel", (String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages");
    private ChannelData config;
    private ObjectPool owningPool;
    private String chainName;

    public MQFapInboundConnLink(VirtualConnection virtualConnection, ChannelFactoryData channelFactoryData, ChannelData channelData, ObjectPool objectPool) {
        block9: {
            this.config = null;
            this.owningPool = null;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"<init>", (Object)new Object[]{virtualConnection, channelFactoryData, channelData, objectPool});
            }
            this.config = channelData;
            this.owningPool = objectPool;
            try {
                ChainData[] chainDataArray = null;
                String string = channelData.getName();
                chainDataArray = channelFactoryData.getChannelFramework().getInternalRunningChains(string);
                if (chainDataArray != null) {
                    if (chainDataArray.length != 1 && tc.isDebugEnabled()) {
                        SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"chain data contains more than one entry!");
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("channelName=" + string + " chainData=" + chainDataArray[0]));
                    }
                    this.chainName = chainDataArray[0].getName();
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("cannot find a running chain for channel: " + string));
                }
            }
            catch (ChannelException channelException) {
                FFDCFilter.processException((Throwable)channelException, (String)"com.ibm.ws.sib.mqfapchannel.impl.MQFapInboundConnLink", (String)"42");
                if (!tc.isEventEnabled()) break block9;
                SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Exception)((Object)channelException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"<init>");
        }
    }

    public void ready(VirtualConnection virtualConnection) {
        ReceiveListener receiveListener;
        Object object;
        block12: {
            AcceptListener acceptListener;
            block11: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"ready", (Object)virtualConnection);
                }
                if ((acceptListener = (AcceptListener)this.config.getPropertyBag().get(MQFapChannelFactory.ACCEPT_LISTENER)) == null) {
                    object = ((ConnectionManagerImpl)ConnectionManagerImpl.getRef()).getAcceptListenerFactory();
                    try {
                        acceptListener = object.manufactureAcceptListener();
                    }
                    catch (Throwable throwable) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Accept listener factory has thrown an exception");
                        }
                        if (!tc.isEventEnabled()) break block11;
                        SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Throwable)throwable);
                    }
                }
            }
            if (acceptListener == null) {
                throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages", (String)"MQINBOUNDCONN_INTERNAL_SICM0022", null, (String)"MQINBOUNDCONN_INTERNAL_SICM0022"));
            }
            object = new ConnectionImpl((ConnectionLink)this, virtualConnection);
            receiveListener = null;
            try {
                receiveListener = acceptListener.acceptConnection((Connection)object);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.mqfapchannel.impl.MQFapInboundConnLink.ready", (String)"28");
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Accept Listener acceptConnection method threw throwable");
                }
                if (!tc.isEventEnabled()) break block12;
                SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Throwable)throwable);
            }
        }
        if (receiveListener == null) {
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages", (String)"MQINBOUNDCONN_INTERNAL_SICM0022", null, (String)"MQINBOUNDCONN_INTERNAL_SICM0022"));
        }
        ((ConnectionImpl)object).start(receiveListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"ready");
        }
    }

    protected void destroyLink(Exception exception) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"destroyLink", (Object)exception);
        }
        if (tc.isEventEnabled() && exception != null) {
            SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Exception)exception);
        }
        this.owningPool.add((Object)this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"destroyLink");
        }
    }

    public void reset(VirtualConnection virtualConnection, ChannelData channelData) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"reset", (Object)new Object[]{virtualConnection, channelData});
        }
        this.vc = virtualConnection;
        this.config = channelData;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"reset");
        }
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"close", (Object)new Object[]{virtualConnection, exception});
        }
        if (tc.isEventEnabled() && exception != null) {
            SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Exception)exception);
        }
        super.close(virtualConnection, exception);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"close");
        }
    }

    public void destroy(Exception exception) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"destroy", (Object)exception);
        }
        if (tc.isEventEnabled() && exception != null) {
            SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Exception)exception);
        }
        super.destroy(exception);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"destroy");
        }
    }

    protected String getChainName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getChainName");
        }
        String string = this.chainName;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getChainName", (Object)string);
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.mqfapchannel.impl/src/com/ibm/ws/sib/mqfapchannel/impl/MQFapInboundConnLink.java, SIB.comms, WAS602.SIB, o0610.11 1.15");
        }
    }
}

