/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mqfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mqfapchannel.AcceptListener;
import com.ibm.ws.sib.mqfapchannel.AcceptListenerFactory;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.mqfapchannel.ConnectionManager;
import com.ibm.ws.sib.mqfapchannel.ReceiveListener;
import com.ibm.ws.sib.mqfapchannel.impl.ChannelFrameworkReference;
import com.ibm.ws.sib.mqfapchannel.impl.ConnectionImpl;
import com.ibm.ws.sib.mqfapchannel.impl.MQFapAddress;
import com.ibm.ws.sib.mqfapchannel.impl.MQFapChannelFactory;
import com.ibm.ws.sib.mqfapchannel.impl.MQFapOutboundConnLink;
import com.ibm.ws.sib.utils.Semaphore;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.HashMap;

public class ConnectionManagerImpl
extends ConnectionManager {
    private static final TraceComponent tc = SibTr.register((Class)ConnectionManagerImpl.class, (String)"SIBMqFapChannel", (String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages");
    private static boolean initialiseFailed = false;
    private WsByteBufferPoolManager bufferPool = null;
    private boolean bufferPoolLookupFailed = false;
    private static AcceptListenerFactory acceptListenerFactory;

    public static void initialise(AcceptListenerFactory acceptListenerFactory) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialise");
        }
        ConnectionManagerImpl.acceptListenerFactory = acceptListenerFactory;
        ChannelFramework channelFramework = ChannelFrameworkReference.getInstance();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialise");
        }
    }

    protected void listen(String string, AcceptListener acceptListener) throws SIResourceException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"listen", (Object)new Object[]{string, acceptListener});
        }
        if (string == null || acceptListener == null) {
            throw new SIErrorException(nls.getFormattedMessage("CONNMGRIMPL_INTERNAL_SICM0021", null, "CONNMGRIMPL_INTERNAL_SICM0021"));
        }
        if (initialiseFailed) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"initialisation previously failed");
            }
            String string2 = nls.getFormattedMessage("CF_INIT_FAILED_SICM0007", null, null);
            throw new SIResourceException(string2);
        }
        ChannelFramework channelFramework = ChannelFrameworkReference.getInstance();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)numberFormatException);
            }
            throw new SIErrorException(nls.getFormattedMessage("CONNMGRIMPL_INTERNAL_SICM0021", null, "CONNMGRIMPL_INTERNAL_SICM0021"), (Throwable)numberFormatException);
        }
        String string3 = "tcp.channel.inbound.port." + n;
        String string4 = "mqfap.channel.inbound.port." + n;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"listen", (Object)("tcpChannelName: " + string3));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"listen", (Object)("mqfapChannelName: " + string4));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("port", "" + n);
        hashMap.put("maxConnectionsPerServer", "0");
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.ws.tcp.channel.impl.TCPChannelFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.sib.mqfapchannel.listen", (String)"09");
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)classNotFoundException);
            }
            throw new SIErrorException(nls.getFormattedMessage("EXCP_DURING_INIT_SICM0003", new Object[]{ConnectionManagerImpl.class, classNotFoundException}, null), (Throwable)classNotFoundException);
        }
        try {
            if (channelFramework.getChannel(string3) == null) {
                channelFramework.addChannel(string3, clazz, hashMap, 10);
                HashMap<String, AcceptListener> hashMap2 = new HashMap<String, AcceptListener>();
                hashMap2.put(MQFapChannelFactory.ACCEPT_LISTENER, acceptListener);
                channelFramework.addChannel(string4, MQFapChannelFactory.class, hashMap2, 10);
                String[] stringArray = new String[]{string3, string4};
                channelFramework.addChain(string, FlowType.INBOUND, stringArray);
            }
            channelFramework.initChain(string);
            channelFramework.startChain(string);
        }
        catch (ChannelException channelException) {
            FFDCFilter.processException((Throwable)channelException, (String)"com.ibm.ws.sib.mqfapchannel.impl.ConnectionManagerImpl.listen", (String)"11", (Object[])new Object[]{string, channelFramework});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)channelException));
            }
            throw new SIResourceException(nls.getFormattedMessage("EXCP_DURING_INIT_SICM0003", new Object[]{ConnectionManagerImpl.class, channelException}, null), (Throwable)channelException);
        }
        catch (ChainException chainException) {
            FFDCFilter.processException((Throwable)chainException, (String)"com.ibm.ws.sib.mqfapchannel.impl.ConnectionManagerImpl.listen", (String)"12", (Object[])new Object[]{string, channelFramework});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)chainException));
            }
            throw new SIResourceException(nls.getFormattedMessage("EXCP_DURING_INIT_SICM0003", new Object[]{ConnectionManagerImpl.class, chainException}, null), (Throwable)chainException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"listen");
        }
    }

    public Connection connect(InetSocketAddress inetSocketAddress, ReceiveListener receiveListener, String string, String string2, String string3) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connect", (Object)new Object[]{inetSocketAddress, receiveListener, string});
        }
        if (inetSocketAddress == null || receiveListener == null || string == null) {
            throw new SIErrorException(nls.getFormattedMessage("CONNMGRIMPL_INTERNAL_SICM0021", null, "CONNMGRIMPL_INTERNAL_SICM0021"));
        }
        if (initialiseFailed) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"initalise previously failed");
            }
            String string4 = nls.getFormattedMessage("CF_INIT_FAILED_SICM0007", null, null);
            throw new SIErrorException(string4);
        }
        OutboundVirtualConnection outboundVirtualConnection = null;
        VirtualConnectionFactory virtualConnectionFactory = null;
        ChannelFramework channelFramework = ChannelFrameworkReference.getInstance();
        try {
            virtualConnectionFactory = channelFramework.getOutboundVCFactory(string);
            outboundVirtualConnection = (OutboundVirtualConnection)virtualConnectionFactory.createConnection();
        }
        catch (ChainException chainException) {
            FFDCFilter.processException((Throwable)chainException, (String)"com.ibm.ws.sib.mqfapchannel.impl.ConnectionManagerImpl.connect", (String)"18", (Object[])new Object[]{string, virtualConnectionFactory, outboundVirtualConnection});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)chainException));
            }
            throw new SIErrorException(nls.getFormattedMessage("CONNMGRIMPL_INTERNAL_SICM0021", null, "CONNMGRIMPL_INTERNAL_SICM0021"), (Throwable)chainException);
        }
        catch (ChannelException channelException) {
            FFDCFilter.processException((Throwable)channelException, (String)"com.ibm.ws.sib.mqfapchannel.impl.ConnectionManagerImpl.connect", (String)"19", (Object[])new Object[]{string, virtualConnectionFactory, outboundVirtualConnection});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)channelException));
            }
            throw new SIErrorException(nls.getFormattedMessage("CONNMGRIMPL_INTERNAL_SICM0021", null, "CONNMGRIMPL_INTERNAL_SICM0021"), (Throwable)channelException);
        }
        Semaphore semaphore = new Semaphore();
        ConnectionCallback connectionCallback = new ConnectionCallback(semaphore);
        outboundVirtualConnection.connectAsynch((Object)new MQFapAddress(inetSocketAddress), (ConnectionReadyCallback)connectionCallback);
        semaphore.waitOnIgnoringInterruptions();
        if (!connectionCallback.connectionSucceeded()) {
            String string5 = inetSocketAddress.isUnresolved() ? inetSocketAddress.getHostName() : inetSocketAddress.getAddress().toString();
            SibTr.error((TraceComponent)tc, (String)nls.getFormattedMessage("SENDERCHL_NO_LISTENER_SICM0017", new Object[]{string3, string2, string5, "" + inetSocketAddress.getPort()}, null));
            Exception exception = connectionCallback.getException();
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw new SIResourceException(nls.getFormattedMessage("CONNMGR_CONNFAILED_SICM0022", new Object[]{inetSocketAddress.getAddress().getHostAddress(), "" + inetSocketAddress.getPort(), string}, "CONNMGR_CONNFAILED_SICM0022"), (Throwable)exception);
        }
        MQFapOutboundConnLink mQFapOutboundConnLink = (MQFapOutboundConnLink)((Object)outboundVirtualConnection.getChannelAccessor());
        ConnectionImpl connectionImpl = new ConnectionImpl((ConnectionLink)mQFapOutboundConnLink, (VirtualConnection)outboundVirtualConnection);
        connectionImpl.start(receiveListener);
        connectionImpl.setType(Connection.QMGR);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect", (Object)connectionImpl);
        }
        return connectionImpl;
    }

    protected WsByteBufferPoolManager getPoolMgrInternal() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPoolMgrInternal");
        }
        if (!this.bufferPoolLookupFailed && this.bufferPool == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.sib.jfapchannel.impl.BufferPoolManagerReference");
                Method method = clazz.getMethod("getInstance", new Class[0]);
                this.bufferPool = (WsByteBufferPoolManager)method.invoke(null, null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mqfapchannel.impl.ConnectionManagerImpl.getPoolMgrInternal", (String)"231");
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                }
                this.bufferPoolLookupFailed = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPoolMgrInternal");
        }
        return this.bufferPool;
    }

    protected AcceptListenerFactory getAcceptListenerFactory() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAcceptListenerFactory");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAcceptListenerFactory", (Object)acceptListenerFactory);
        }
        return acceptListenerFactory;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.mqfapchannel.impl/src/com/ibm/ws/sib/mqfapchannel/impl/ConnectionManagerImpl.java, SIB.comms, WAS602.SIB, o0610.11 1.26");
        }
    }

    private class ConnectionCallback
    implements ConnectionReadyCallback {
        private boolean connected = false;
        private Semaphore semaphore;
        private Exception exception;

        protected ConnectionCallback(Semaphore semaphore) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"ConnectionCallback.<init>");
            }
            this.semaphore = semaphore;
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"ConnectionCallback.<init>");
            }
        }

        protected Exception getException() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"ConnectionCallback.getException");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"ConnectionCallback.getException");
            }
            return this.exception;
        }

        protected boolean connectionSucceeded() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"ConnectionCallback.connectionSucceeded");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"ConnectionCallback.connectionSucceeded");
            }
            return this.exception == null;
        }

        public void ready(VirtualConnection virtualConnection) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"ConnectionCallback.ready");
            }
            this.connected = true;
            this.semaphore.post();
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"ConnectionCallback.ready");
            }
        }

        public void destroy(Exception exception) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"ConnectionCallback.destory");
            }
            this.exception = exception;
            if (!this.connected) {
                this.semaphore.post();
            }
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"ConnectionCallback.exit");
            }
        }
    }
}

