/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mqfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.mqfapchannel.DataSentListener;
import com.ibm.ws.sib.mqfapchannel.ReceiveListener;
import com.ibm.ws.sib.mqfapchannel.impl.ConnectionManagerImpl;
import com.ibm.ws.sib.mqfapchannel.impl.MQFapInboundConnLink;
import com.ibm.ws.sib.mqfapchannel.impl.MQFapOutboundConnLink;
import com.ibm.ws.sib.mqfapchannel.impl.MQFapReadCallback;
import com.ibm.ws.sib.mqfapchannel.impl.MQFapWriteCallback;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.Semaphore;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.net.InetAddress;
import java.util.List;

public class ConnectionImpl
implements Connection {
    private static final TraceComponent tc = SibTr.register((Class)ConnectionImpl.class, (String)"SIBMqFapChannel", (String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages");
    private Object attachment = null;
    private ConnectionLink connLink = null;
    private Semaphore okayToSendSemaphore = null;
    private TCPReadRequestContext tcpReadCtx = null;
    private TCPWriteRequestContext tcpWriteCtx = null;
    private boolean closed = false;
    private VirtualConnection vc = null;
    private MQFapWriteCallback writeCallback = null;
    private MQFapReadCallback readCallback = null;
    private boolean closing = false;
    private String localNetworkAddress = null;
    private boolean localNetworkAddressCached = false;
    private String remoteNetworkAddress = null;
    private boolean remoteNetworkAddressCached = false;
    private volatile long bytesReceived = 0L;
    private volatile long bytesSent = 0L;
    private volatile long buffersReceived = 0L;
    private volatile long buffersSent = 0L;
    private Connection.ConnectionType type = UNKNOWN;

    public ConnectionImpl(ConnectionLink connectionLink, VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{connectionLink, virtualConnection});
        }
        this.connLink = connectionLink;
        this.okayToSendSemaphore = new Semaphore(1);
        TCPConnectionContext tCPConnectionContext = (TCPConnectionContext)connectionLink.getDeviceLink().getChannelAccessor();
        this.tcpReadCtx = tCPConnectionContext.getReadInterface();
        this.tcpWriteCtx = tCPConnectionContext.getWriteInterface();
        this.closed = false;
        this.vc = virtualConnection;
        this.writeCallback = new MQFapWriteCallback(this, this.okayToSendSemaphore, this.tcpWriteCtx);
        this.readCallback = new MQFapReadCallback(this, this.tcpReadCtx);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected synchronized boolean isClosing() {
        return this.closing;
    }

    protected synchronized void close(Exception exception) throws SIConnectionDroppedException, SIConnectionLostException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)exception);
        }
        if (tc.isEventEnabled() && exception != null) {
            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
        }
        if (!this.closed) {
            this.closing = true;
            while (!this.vc.requestPermissionToClose(5000L)) {
            }
            this.connLink.close(this.vc, exception);
            this.closed = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    public synchronized void close() throws SIConnectionDroppedException, SIConnectionLostException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        this.okayToSendSemaphore.waitOnIgnoringInterruptions();
        this.close(new Exception());
        this.closed = true;
        if (this.type == QMGR) {
            CommsPMI.getMQLinkStats().onQmDetach();
        } else if (this.type == CLIENT) {
            CommsPMI.getMQClientLinkStats().onClientDetach();
        }
        this.okayToSendSemaphore.post();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    public synchronized void send(List list, DataSentListener dataSentListener, boolean bl) throws SIConnectionDroppedException, SIConnectionLostException {
        VirtualConnection virtualConnection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{list, dataSentListener, "" + bl});
        }
        if (list == null) {
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages", (String)"CONNIMPL_INTERNAL_SICM0019", null, (String)"CONNIMPL_INTERNAL_SICM0019"));
        }
        if (this.closed) {
            throw new SIConnectionDroppedException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages", (String)"CONNIMPL_CLOSED_SICM0020", null, (String)"CONNIMPL_CLOSED_SICM0020"));
        }
        this.okayToSendSemaphore.waitOnIgnoringInterruptions();
        this.writeCallback.setData(list);
        this.writeCallback.setDataSentListener(dataSentListener);
        this.writeCallback.setReturnToPool(bl);
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[list.size()];
        list.toArray(wsByteBufferArray);
        this.tcpWriteCtx.setBuffers(wsByteBufferArray);
        WsByteBuffer wsByteBuffer = null;
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < list.size(); ++i) {
            wsByteBuffer = (WsByteBuffer)list.get(i);
            ++l2;
            l += (long)wsByteBuffer.remaining();
        }
        if (this.type == CLIENT) {
            CommsPMI.getMQClientLinkStats().onSendBytes((int)l);
        }
        if ((virtualConnection = this.tcpWriteCtx.write(-1L, (TCPWriteCompletedCallback)this.writeCallback, false, -1)) != null) {
            this.bytesSent += l;
            this.buffersSent += l2;
            this.writeCallback.complete(virtualConnection, this.tcpWriteCtx);
        } else if (this.type == Connection.QMGR) {
            CommsPMI.getMQLinkStats().onWriteBlocked();
        } else if (this.type == Connection.CLIENT) {
            CommsPMI.getMQClientLinkStats().onWriteBlocked();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    public void setAttachment(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAttachment", (Object)object);
        }
        this.attachment = object;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAttachment");
        }
    }

    public Object getAttachment() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAttachment");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAttachment", (Object)this.attachment);
        }
        return this.attachment;
    }

    public void start(ReceiveListener receiveListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)receiveListener);
        }
        this.readCallback.setReceiveListener(receiveListener);
        if (this.tcpReadCtx.getBuffer() == null) {
            this.tcpReadCtx.setBuffer(ConnectionManagerImpl.getPoolMgr().allocate(32768));
            this.tcpReadCtx.read(1L, (TCPReadCompletedCallback)this.readCallback, true, -1);
        } else {
            this.readCallback.complete(this.vc, this.tcpReadCtx);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    private TCPConnectionContext findTCPConnectionContext() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findTCPConnectionContext");
        }
        TCPConnectionContext tCPConnectionContext = null;
        ConnectionLink connectionLink = this.connLink;
        connectionLink = this.connLink.getDeviceLink();
        if (connectionLink != null) {
            tCPConnectionContext = (TCPConnectionContext)connectionLink.getChannelAccessor();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findTCPConnectionContext");
        }
        return tCPConnectionContext;
    }

    private String formatHostAndPort(InetAddress inetAddress, int n) {
        String string = null;
        if (inetAddress != null) {
            String string2 = RuntimeInfo.getProperty((String)"com.ibm.ws.sib.mqfapchannel.DISPLAY_INETADDRESS", (String)"HOSTNAME");
            string = string2.equalsIgnoreCase("NUMERIC") ? inetAddress.getHostAddress() + ":" + n : (string2.equalsIgnoreCase("BOTH") ? inetAddress.getHostName() + "(" + inetAddress.getHostAddress() + "):" + n : inetAddress.getHostName() + ":" + n);
        }
        return string;
    }

    public String getLocalNetworkAddress() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLocalNetworkAddress");
        }
        if (!this.localNetworkAddressCached) {
            this.localNetworkAddressCached = true;
            TCPConnectionContext tCPConnectionContext = this.findTCPConnectionContext();
            if (tCPConnectionContext != null) {
                this.localNetworkAddress = this.formatHostAndPort(tCPConnectionContext.getLocalAddress(), tCPConnectionContext.getLocalPort());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLocalNetworkAddress", (Object)this.localNetworkAddress);
        }
        return this.localNetworkAddress;
    }

    public String getRemoteNetworkAddress() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRemoteNetworkAddress");
        }
        if (!this.remoteNetworkAddressCached) {
            this.remoteNetworkAddressCached = true;
            TCPConnectionContext tCPConnectionContext = this.findTCPConnectionContext();
            if (tCPConnectionContext != null) {
                this.remoteNetworkAddress = this.formatHostAndPort(tCPConnectionContext.getRemoteAddress(), tCPConnectionContext.getRemotePort());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRemoteNetworkAddress", (Object)this.remoteNetworkAddress);
        }
        return this.remoteNetworkAddress;
    }

    protected void incrementBuffersReceived() {
        ++this.buffersReceived;
    }

    protected void addBytesReceived(long l) {
        this.bytesReceived += l;
    }

    public long getBuffersReceived() {
        return this.buffersReceived;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public long getBuffersSent() {
        return this.buffersSent;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public void setReceiveTimeout(int n) {
        this.readCallback.setReceiveTimeout(n);
    }

    public void setType(Connection.ConnectionType connectionType) {
        if (connectionType != UNKNOWN && this.type == UNKNOWN) {
            if (connectionType == QMGR) {
                CommsPMI.getMQLinkStats().onQmAttach();
            } else if (connectionType == CLIENT) {
                CommsPMI.getMQClientLinkStats().onClientAttach();
            }
            this.type = connectionType;
        }
    }

    protected Connection.ConnectionType getType() {
        return this.type;
    }

    public String getChainName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getChainName");
        }
        String string = null;
        if (this.connLink instanceof MQFapInboundConnLink) {
            string = ((MQFapInboundConnLink)this.connLink).getChainName();
        } else if (this.connLink instanceof MQFapOutboundConnLink) {
            string = ((MQFapOutboundConnLink)this.connLink).getChainName();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getChainName", (Object)string);
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.mqfapchannel.impl/src/com/ibm/ws/sib/mqfapchannel/impl/ConnectionImpl.java, SIB.comms, WAS602.SIB, o0610.11 1.27");
        }
    }
}

