/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mqfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainStartMode;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mqfapchannel.impl.MQFapChannelFactory;
import com.ibm.ws.sib.mqfapchannel.impl.MQFapConstants;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.exception.ChannelFrameworkException;
import java.lang.reflect.Method;

public class ChannelFrameworkReference {
    private static final TraceComponent tc = SibTr.register((Class)ChannelFrameworkReference.class, (String)"SIBMqFapChannel", (String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages");
    private static ChannelFramework channelFramework = null;
    private static boolean failed = false;

    protected static ChannelFramework getInstance() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInstance");
        }
        if (!failed && channelFramework == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference");
                Method method = clazz.getMethod("getInstance", new Class[0]);
                channelFramework = (ChannelFramework)method.invoke(null, null);
                ChannelFrameworkReference.verifyOutboundChains();
                ChannelFrameworkReference.startInboundChains();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mqfapchannel.impl.ChannelFrameworkReference.getInstance()", (String)MQFapConstants.CHANNELFRAMEWORKREFERENCE_GETINSTANCE_01);
                SibTr.warning((TraceComponent)tc, (String)"EXCP_DURING_INIT_SICM0011", (Object)new Object[]{"com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference", exception});
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                }
                failed = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getInstance", (Object)channelFramework);
        }
        return channelFramework;
    }

    private static void verifyOutboundChains() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"verifyOutboundChains");
        }
        if (channelFramework != null) {
            if (channelFramework.getChain("OutboundBasicMQLink") == null) {
                SibTr.warning((TraceComponent)tc, (String)"NO_DEFAULT_MQLINK_OUTBOUND_SICM0009", (Object)new Object[]{"OutboundBasicMQLink"});
                if (RuntimeInfo.isClientContainer() || RuntimeInfo.isThinClient()) {
                    ChannelFrameworkReference.testDefineOutboundChain();
                }
            }
            if (channelFramework.getChain("OutboundSecureMQLink") == null) {
                SibTr.warning((TraceComponent)tc, (String)"NO_DEFAULT_SECURE_MQLINK_OUTBOUND_SICM0010", (Object)new Object[]{"OutboundSecureMQLink"});
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"verifyOutboundChains");
        }
    }

    private static void testDefineOutboundChain() {
        block5: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"testDefineOutboundChain");
            }
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory");
                channelFramework.addChannel("TestMQFapChannel", MQFapChannelFactory.class, null);
                channelFramework.addChannel("TestTCPChannel", clazz, null);
                channelFramework.addChain("OutboundBasicMQLink", FlowType.OUTBOUND, new String[]{"TestMQFapChannel", "TestTCPChannel"});
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"test define of outbound chains failed");
                }
                if (!tc.isEventEnabled()) break block5;
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"testDefineOutboundChain");
        }
    }

    private static void startInboundChains() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startInboundChains");
        }
        if (channelFramework != null && (RuntimeInfo.isClusteredServer() || RuntimeInfo.isServer())) {
            try {
                ((ChannelFrameworkService)channelFramework).startChainsByAcceptorID("MQFapChannelAcceptorID", ChainStartMode.RETRY_EACH_ON_FAIL);
            }
            catch (ChannelFrameworkException channelFrameworkException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"No inbound MQFAP chains appear to have been defined.  Exception follows");
                }
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)channelFrameworkException));
                }
                SibTr.warning((TraceComponent)tc, (String)"CANNOT_START_INBOUND_CHAINS_SICM0008");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startInboundChains");
        }
    }
}

