/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mqfapchannel;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mqfapchannel.AcceptListenerFactory;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.mqfapchannel.ReceiveListener;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;

public abstract class ConnectionManager {
    private static final TraceComponent tc = SibTr.register((Class)ConnectionManager.class, (String)"SIBMqFapChannel", (String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mqfapchannel.CWSIQMessages");
    private static ConnectionManager instance;
    private static AcceptListenerFactory acceptListenerFactory;
    private static boolean initialised;
    private static boolean initialisationFailed;

    public static void initialise(AcceptListenerFactory acceptListenerFactory) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialise", (Object)acceptListenerFactory);
        }
        if (!initialised || ConnectionManager.acceptListenerFactory == null && acceptListenerFactory != null) {
            Class<?> clazz = instance.getClass();
            try {
                Method method = clazz.getMethod("initialise", AcceptListenerFactory.class);
                method.invoke(null, acceptListenerFactory);
                initialised = true;
                ConnectionManager.acceptListenerFactory = acceptListenerFactory;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mqfapchannel.ConnectionManager.initialise", (String)"01");
                initialisationFailed = true;
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"EXCP_DURING_INIT_SICM0001", (Object)exception);
                }
                SIConnectionLostException sIConnectionLostException = new SIConnectionLostException(nls.getFormattedMessage("EXCP_DURING_INIT_SICM0001", new Object[]{exception}, null), (Throwable)exception);
                throw sIConnectionLostException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialise");
        }
    }

    public static synchronized ConnectionManager getRef() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRef");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRef", (Object)instance);
        }
        return instance;
    }

    public abstract Connection connect(InetSocketAddress var1, ReceiveListener var2, String var3, String var4, String var5) throws SIResourceException;

    protected abstract WsByteBufferPoolManager getPoolMgrInternal();

    public static WsByteBufferPoolManager getPoolMgr() {
        return ConnectionManager.getRef().getPoolMgrInternal();
    }

    static {
        acceptListenerFactory = null;
        initialised = false;
        initialisationFailed = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"{}");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.mqfapchannel/src/com/ibm/ws/sib/mqfapchannel/ConnectionManager.java, SIB.comms, WAS602.SIB, o0610.11 1.16");
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.sib.mqfapchannel.impl.ConnectionManagerImpl");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            instance = (ConnectionManager)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mqfapchannel.ConnectionManager.{}", (String)"02");
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"EXCP_DURING_INIT_SICM0002", (Object)exception);
            }
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("EXCP_DURING_INIT_SICM0002", new Object[]{exception}, null), (Throwable)exception);
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"{}");
        }
    }
}

