/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mediation.runtime.PMIDestinationInfo;
import com.ibm.ws.sib.mediation.runtime.PMIEngineInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPIRangeStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.HashMap;
import java.util.Map;

public class PMIMediationInfo
implements StatisticActionListener {
    private static final TraceComponent _tc = SibTr.register((Class)PMIMediationInfo.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");
    private String _name;
    private StatsInstance _instance;
    private StatsGroup _group;
    private StatsGroup _destinationsGroup;
    private Map _map;
    private int _threadsAllocated;
    private int _highWaterMark;
    private SPIRangeStatistic _threadStat;
    private long _startTime;
    private long _lastSampleTime;
    private int _previous;
    private long _integral;
    private PMIEngineInfo _engineInfo;
    private TraceNLS _nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mediation.stats.PMITitles");

    public PMIMediationInfo(String string, PMIEngineInfo pMIEngineInfo, StatsGroup statsGroup) throws StatsFactoryException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"PMIMediationInfo", (Object)new Object[]{string, pMIEngineInfo, statsGroup});
        }
        this._name = string;
        this._engineInfo = pMIEngineInfo;
        this._map = new HashMap();
        this._threadsAllocated = 0;
        this._highWaterMark = 0;
        this._lastSampleTime = this._startTime = System.currentTimeMillis();
        this._integral = 0L;
        if (StatsFactory.isPMIEnabled()) {
            try {
                this._group = StatsFactory.createStatsGroup((String)string, (String)"/com/ibm/ws/sib/mediation/stats/Mediation.xml", (StatsGroup)statsGroup, null);
                this._instance = StatsFactory.createStatsInstance((String)this._nls.getFormattedMessage("THREAD_POOL", new Object[]{string}, null), (String)"/com/ibm/ws/sib/mediation/stats/Mediation.xml", (StatsGroup)this._group, null, (StatisticActionListener)this);
                this._destinationsGroup = StatsFactory.createStatsGroup((String)this._nls.getFormattedMessage("DESTINATIONS", new Object[]{string}, null), (String)"/com/ibm/ws/sib/mediation/stats/Destinations.xml", (StatsGroup)this._group, null);
            }
            catch (StatsFactoryException statsFactoryException) {
                FFDCFilter.processException((Throwable)statsFactoryException, (String)"com.ibm.ws.sib.mediation.runtime.PMIMediationInfo.PMIMediationInfo", (String)"127", (Object)this);
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"PMIMediationInfo", (Object)((Object)statsFactoryException));
                }
                throw statsFactoryException;
            }
        } else if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)"PMI not enabled in WAS. No stats instance created.");
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"PMIMediationInfo", (Object)this);
        }
    }

    public synchronized PMIDestinationInfo getDestinationInfo(String string) throws StatsFactoryException {
        PMIDestinationInfo pMIDestinationInfo;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getDestinationInfo", (Object)new Object[]{this, string});
        }
        if ((pMIDestinationInfo = (PMIDestinationInfo)this._map.get(string)) == null) {
            try {
                pMIDestinationInfo = this.createDestinationInfo(string);
            }
            catch (StatsFactoryException statsFactoryException) {
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getDestinationInfo", (Object)((Object)statsFactoryException));
                }
                throw statsFactoryException;
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getDestinationInfo", (Object)pMIDestinationInfo);
        }
        return pMIDestinationInfo;
    }

    public void removeDestinationInfo(String string) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"removeDestinationInfo", (Object)new Object[]{this, string});
        }
        this._map.remove(string);
        if (this._map.size() == 0) {
            this.removeDestinationsStatsGroup();
            this.removeStatsInstance();
            this.removeStatsGroup();
            this._engineInfo.removeMediationInfo(this._name);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"removeDestinationInfo");
        }
    }

    private PMIDestinationInfo createDestinationInfo(String string) throws StatsFactoryException {
        PMIDestinationInfo pMIDestinationInfo;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"createDestinationInfo", (Object)new Object[]{this, string});
        }
        try {
            pMIDestinationInfo = new PMIDestinationInfo(string, this, this._destinationsGroup);
        }
        catch (StatsFactoryException statsFactoryException) {
            FFDCFilter.processException((Throwable)statsFactoryException, (String)"com.ibm.ws.sib.mediation.runtime.PMIMediationInfo.createDestinationInfo", (String)"305", (Object)this);
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"createDestinationInfo", (Object)((Object)statsFactoryException));
            }
            throw statsFactoryException;
        }
        PMIDestinationInfo pMIDestinationInfo2 = pMIDestinationInfo;
        this._map.put(string, pMIDestinationInfo2);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"createDestinationInfo", (Object)pMIDestinationInfo);
        }
        return pMIDestinationInfo;
    }

    private void removeDestinationsStatsGroup() {
        block4: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc, (String)"removeDestinationsStatsGroup", (Object)this);
            }
            try {
                StatsFactory.removeStatsGroup((StatsGroup)this._destinationsGroup);
                this._destinationsGroup = null;
            }
            catch (StatsFactoryException statsFactoryException) {
                FFDCFilter.processException((Throwable)statsFactoryException, (String)"com.ibm.ws.sib.mediation.runtime.PMIMediationInfo.removeDestinationsStatsGroup", (String)"294", (Object)this);
                if (!_tc.isEventEnabled()) break block4;
                SibTr.exception((TraceComponent)_tc, (Exception)((Object)statsFactoryException));
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"removeDestinationsStatsGroup");
        }
    }

    private void removeStatsGroup() {
        block4: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc, (String)"removeStatsGroup", (Object)this);
            }
            try {
                StatsFactory.removeStatsGroup((StatsGroup)this._group);
                this._group = null;
            }
            catch (StatsFactoryException statsFactoryException) {
                FFDCFilter.processException((Throwable)statsFactoryException, (String)"com.ibm.ws.sib.mediation.runtime.PMIMediationInfo.removeStatsGroup", (String)"294", (Object)this);
                if (!_tc.isEventEnabled()) break block4;
                SibTr.exception((TraceComponent)_tc, (Exception)((Object)statsFactoryException));
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"removeStatsGroup");
        }
    }

    private void removeStatsInstance() {
        block4: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc, (String)"removeStatsInstance", (Object)this);
            }
            try {
                StatsFactory.removeStatsInstance((StatsInstance)this._instance);
                this._instance = null;
            }
            catch (StatsFactoryException statsFactoryException) {
                FFDCFilter.processException((Throwable)statsFactoryException, (String)"com.ibm.ws.sib.mediation.runtime.PMIMediationInfo.removeStatsInstance", (String)"307", (Object)this);
                if (!_tc.isEventEnabled()) break block4;
                SibTr.exception((TraceComponent)_tc, (Exception)((Object)statsFactoryException));
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"removeStatsInstance");
        }
    }

    public synchronized void allocateThread() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"allocateThread", (Object)this);
        }
        long l = System.currentTimeMillis();
        ++this._threadsAllocated;
        if (this._threadsAllocated > this._highWaterMark) {
            this._highWaterMark = this._threadsAllocated;
        }
        if (l != this._lastSampleTime) {
            this.updateIntegral(l);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"allocateThread");
        }
    }

    public synchronized void reclaimThread() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"reclaimThread", (Object)this);
        }
        long l = System.currentTimeMillis();
        --this._threadsAllocated;
        if (l != this._lastSampleTime) {
            this.updateIntegral(l);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"reclaimThread");
        }
    }

    private void updateIntegral(long l) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"updateIntegral", (Object)new Object[]{this, new Long(l)});
        }
        long l2 = l - this._lastSampleTime;
        this._integral = l2 * (long)(this._threadsAllocated + this._previous) / 2L;
        this._lastSampleTime = l;
        this._previous = this._threadsAllocated;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"updateIntegral");
        }
    }

    private synchronized void updateThreadStatistics() {
        long l;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"updateThreadStatistics", (Object)this);
        }
        if ((l = System.currentTimeMillis()) != this._lastSampleTime) {
            this.updateIntegral(System.currentTimeMillis());
        }
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)("_highWaterMark=" + this._highWaterMark));
            SibTr.debug((TraceComponent)_tc, (String)("_threadsAllocated=" + this._threadsAllocated));
            SibTr.debug((TraceComponent)_tc, (String)("_integral=" + this._integral));
            SibTr.debug((TraceComponent)_tc, (String)("_startTime=" + this._startTime));
            SibTr.debug((TraceComponent)_tc, (String)("_lastSampleTime=" + this._lastSampleTime));
        }
        if (this._threadStat != null) {
            this._threadStat.set(0L, (long)this._highWaterMark, (long)this._threadsAllocated, (double)this._integral, this._startTime, this._lastSampleTime);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"updateThreadStatistics");
        }
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"statisticCreated", (Object)new Object[]{this, sPIStatistic});
        }
        switch (sPIStatistic.getId()) {
            case 1: {
                this._threadStat = (SPIRangeStatistic)sPIStatistic;
                break;
            }
            default: {
                if (!_tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)_tc, (String)("Invalid id " + sPIStatistic.getId() + " specified"));
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"statisticCreated");
        }
    }

    public void updateStatisticOnRequest(int n) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"updateStatisticOnRequest", (Object)new Object[]{this, new Integer(n)});
        }
        if (n == 1) {
            this.updateThreadStatistics();
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"updateStatisticOnRequest");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)"Source info: @(#)SIB/ws/code/sib.mediation.destination.impl/src/com/ibm/ws/sib/mediation/runtime/PMIMediationInfo.java, SIB.mediation.runtime, WAS602.SIB, o0610.11 1.17");
        }
    }
}

