/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.mediation.runtime.AbstractDestinationMediationDispatcher;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationRunnable;
import com.ibm.ws.sib.mediation.runtime.MediationPMIInstrumentation;
import com.ibm.ws.sib.mediation.runtime.MediationThreadPool;
import com.ibm.ws.sib.mediation.runtime.ThreadCoordinator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.mediation.runtime.MediationControl;
import com.ibm.wsspi.sib.mediation.runtime.StopReason;
import com.ibm.wsspi.sib.mediation.runtime.StopReasonFactory;
import com.ibm.wsspi.sib.mediation.runtime.StoppedListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MultiThreadedDispatcher
extends AbstractDestinationMediationDispatcher
implements ThreadCoordinator {
    private MediationThreadPool _pool;
    private StoppedListener _listener;
    private List _runnables = new LinkedList();
    private MediationPMIInstrumentation _pmi;
    protected MediationControl _control;
    private boolean _singleThreaded;
    private ConsumerSession _session;
    private static final TraceComponent _tc = SibTr.register((Class)MultiThreadedDispatcher.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");
    private boolean _started = true;
    private boolean _once;
    private boolean _onceDone;

    public void dispatch(SIBusMessage sIBusMessage, ConsumerSession consumerSession, MediationControl mediationControl) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"dispatch", (Object)new Object[]{this, sIBusMessage.getSystemMessageId(), consumerSession, mediationControl});
        }
        DestinationMediationRunnable destinationMediationRunnable = null;
        DestinationMediationParameters destinationMediationParameters = null;
        this._session = consumerSession;
        destinationMediationParameters = this.createDestinationMediationParameters(consumerSession, sIBusMessage, mediationControl);
        if (destinationMediationParameters != null) {
            boolean bl;
            destinationMediationRunnable = new DestinationMediationRunnable(destinationMediationParameters, this, this.getPMIInstrumentation());
            this.add(destinationMediationRunnable);
            if (this._once) {
                bl = this._pool.execute(destinationMediationRunnable);
                this._onceDone = true;
            } else {
                bl = this._pool.execute(destinationMediationRunnable, this);
            }
            if (!bl) {
                this.remove(destinationMediationRunnable);
                try {
                    consumerSession.unlockSet(destinationMediationParameters.getMessageIds());
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.MultiThreadedDispatcher.dispatch", (String)"322", (Object)this);
                    if (_tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)_tc, (String)"While unlocking the message that could not be mediated an exception was thrown");
                    }
                    if (_tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
                    }
                }
            }
        } else if (_tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unable to create DestinationMediationParameters");
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"dispatch");
        }
    }

    public synchronized void resume() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"resume", (Object)this);
        }
        if (!this._started) {
            this._started = true;
            this._listener = null;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"resume");
        }
    }

    public synchronized void stop(StoppedListener stoppedListener) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"stop", (Object)new Object[]{this, stoppedListener});
        }
        if (this._started) {
            this._started = false;
            if (stoppedListener != null && this.getAllocatedThreadCount() == 0) {
                stoppedListener.stopped();
            } else {
                this._listener = stoppedListener;
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"stop");
        }
    }

    public synchronized boolean add(DestinationMediationRunnable destinationMediationRunnable) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"add", (Object)new Object[]{this, destinationMediationRunnable});
        }
        if (this._singleThreaded) {
            try {
                this._session.stop();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.MultiThreadedDispatcher.add", (String)"432", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"An error occurred while stopping the session while in single threaded mode");
                }
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
                }
                StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.mediation.runtime.CWSIZMessages", "UNABLE_TO_STOP_CONSUMER_IN_SINGLE_THREADED_MODE_CWSIZ0039E", new Object[]{sIException}, false);
                this._control.stopMediating(stopReason);
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"add", (Object)Boolean.FALSE);
                }
                return false;
            }
        }
        this._runnables.add(destinationMediationRunnable);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"add", (Object)Boolean.TRUE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DestinationMediationRunnable destinationMediationRunnable) {
        boolean bl;
        StoppedListener stoppedListener;
        boolean bl2;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"remove", (Object)new Object[]{this, destinationMediationRunnable});
        }
        MultiThreadedDispatcher multiThreadedDispatcher = this;
        synchronized (multiThreadedDispatcher) {
            this._runnables.remove(destinationMediationRunnable);
            bl2 = this._started;
            stoppedListener = this._listener;
            bl = !bl2 && this._runnables.isEmpty() && stoppedListener != null;
        }
        if (this._singleThreaded && bl2) {
            try {
                this._session.start(false);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.MultiThreadedDispatcher.remove", (String)"499", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)"An error has occurred when starting the consumer in single threaded mode");
                }
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
                }
                StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.mediation.runtime.CWSIZMessages", "UNABLE_TO_START_CONSUMER_IN_SINGLE_THREADED_MODE_CWSIZ0040E", new Object[]{sIException}, false);
                this._control.stopMediating(stopReason);
            }
        } else if (bl) {
            stoppedListener.stopped();
            this._listener = null;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"remove");
        }
    }

    public boolean dispatchOnce() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"dispatchOnce", (Object)this);
        }
        if (this._started) {
            block6: {
                this._onceDone = false;
                this._once = true;
                try {
                    this._session.activateAsynchConsumer(true);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.MultiThreadedDispatcher.dispatchOnce", (String)"564", (Object)this);
                    if (!_tc.isEventEnabled()) break block6;
                    SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
                }
            }
            this._once = false;
        } else {
            this._onceDone = false;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"dispatchOnce", (Object)(this._onceDone ? Boolean.TRUE : Boolean.FALSE));
        }
        return this._onceDone;
    }

    public int getAllocatedThreadCount() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getAllocatedThreadCount", (Object)this);
        }
        int n = this._runnables.size();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getAllocatedThreadCount", (Object)new Integer(n));
        }
        return n;
    }

    public synchronized MediationPMIInstrumentation getPMIInstrumentation() {
        if (this._pmi == null) {
            DestinationDefinition destinationDefinition = this.getDestinationDefinition();
            this._pmi = new MediationPMIInstrumentation(this.getMessagingEngine(), destinationDefinition.getMediationDefinition().getMediationName(), destinationDefinition.getName());
        }
        return this._pmi;
    }

    public boolean block() {
        boolean bl;
        block5: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc, (String)"block", (Object)this);
            }
            bl = false;
            try {
                this._session.stop();
                bl = true;
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.MultiThreadedDispatcher.block", (String)"638", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unable to stop the consumer on a block request.");
                }
                if (!_tc.isEventEnabled()) break block5;
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"block", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    public void unBlock() {
        block5: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc, (String)"unBlock", (Object)this);
            }
            try {
                this._session.start(false);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.MultiThreadedDispatcher.unBlock", (String)"775", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unable to start the consumer on a block request.");
                }
                if (!_tc.isEventEnabled()) break block5;
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"unBlock");
        }
    }

    public synchronized void cancelWaitingWorkAndStop() throws IllegalStateException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"cancelWaitingWorkAndStop", (Object)this);
        }
        Iterator iterator = this._runnables.iterator();
        while (iterator.hasNext()) {
            DestinationMediationRunnable destinationMediationRunnable = (DestinationMediationRunnable)iterator.next();
            destinationMediationRunnable.cancel();
        }
        this.stop(null);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"cancelWaitingWorkAndStop");
        }
    }

    public void setDestinationDefinition(DestinationDefinition destinationDefinition) throws IllegalStateException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setDestinationDefinition", (Object)new Object[]{this, destinationDefinition});
        }
        super.setDestinationDefinition(destinationDefinition);
        boolean bl = this._singleThreaded = !destinationDefinition.getMediationDefinition().isConcurrentMediationAllowed();
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)("single threaded mode = " + this._singleThreaded));
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setDestinationDefinition");
        }
    }

    public void setMessagingEngine(JsMessagingEngine jsMessagingEngine) throws IllegalStateException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setMessagingEngine", (Object)new Object[]{this, jsMessagingEngine});
        }
        super.setMessagingEngine(jsMessagingEngine);
        this._pool = MediationThreadPool.get(jsMessagingEngine);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setMessagingEngine");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)"Source info: @(#)SIB/ws/code/sib.mediation.destination.impl/src/com/ibm/ws/sib/mediation/runtime/MultiThreadedDispatcher.java, SIB.mediation.runtime, WAS602.SIB, o0610.11 1.21");
        }
    }
}

