/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationRunnable;
import com.ibm.ws.sib.mediation.runtime.RoundRobinThreadCoordinatorChooser;
import com.ibm.ws.sib.mediation.runtime.ThreadCoordinator;
import com.ibm.ws.sib.mediation.runtime.ThreadCoordinatorChooser;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.util.ThreadPoolListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class MediationThreadPool
implements ThreadPoolListener {
    private static Map _pools = new HashMap();
    private ThreadPool _pool;
    private List _blockedCoordinators;
    private volatile boolean _blocked;
    private int _maxPoolsize;
    private int _activeThreads;
    private int _threadCount;
    private ThreadCoordinatorChooser _chooser;
    private static final TraceComponent _tc = SibTr.register((Class)MediationThreadPool.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");

    private MediationThreadPool(ThreadPool threadPool) {
        block7: {
            this._blockedCoordinators = new LinkedList();
            this._maxPoolsize = -1;
            if (_tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)_tc, (String)"<init>", (Object)threadPool);
            }
            try {
                this._chooser = (ThreadCoordinatorChooser)ImplFactory.loadImplFromKey((Class)ThreadCoordinatorChooser.class);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.mediation.runtime.MediationThreadPool.MediationThreadPool", (String)"95", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"The ThreadCoordinatorChooser could not be loaded");
                }
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"absorbing", (Object)throwable);
                }
                this._chooser = new RoundRobinThreadCoordinatorChooser();
                if (!(throwable instanceof ThreadDeath)) break block7;
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)_tc, (String)"MediationThreadPool");
                }
                throw (ThreadDeath)throwable;
            }
        }
        this._pool = threadPool;
        this._pool.addThreadPoolListener((ThreadPoolListener)this);
        this._pool.setRequestBufferExpansionLimit(Integer.MAX_VALUE);
        this._maxPoolsize = this._pool.getMaximumPoolSize();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediationThreadPool get(JsMessagingEngine jsMessagingEngine) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"get", (Object)jsMessagingEngine);
        }
        Object object = _pools;
        synchronized (object) {
            if (!_pools.containsKey(jsMessagingEngine)) {
                MediationThreadPool mediationThreadPool = new MediationThreadPool(jsMessagingEngine.getMediationThreadPool());
                _pools.put(jsMessagingEngine, mediationThreadPool);
            }
        }
        object = (MediationThreadPool)_pools.get(jsMessagingEngine);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"get", (Object)object);
        }
        return object;
    }

    public boolean execute(DestinationMediationRunnable destinationMediationRunnable) {
        boolean bl;
        block7: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)_tc, (String)"execute", (Object)destinationMediationRunnable);
            }
            bl = false;
            try {
                this._pool.execute((Runnable)destinationMediationRunnable, 2);
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.mediation.runtime.MediationThreadPool.execute", (String)"148", (Object)this);
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)interruptedException);
                }
            }
            catch (ThreadPool.ThreadPoolQueueIsFullException threadPoolQueueIsFullException) {
                FFDCFilter.processException((Throwable)threadPoolQueueIsFullException, (String)"com.ibm.ws.sib.mediation.runtime.MediationThreadPool.execute", (String)"157", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"The ThreadPool Queue is unexpectidly full.");
                }
                if (!_tc.isEventEnabled()) break block7;
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)threadPoolQueueIsFullException));
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"execute", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    public synchronized boolean execute(DestinationMediationRunnable destinationMediationRunnable, ThreadCoordinator threadCoordinator) {
        boolean bl;
        block10: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)_tc, (String)"execute", (Object)new Object[]{destinationMediationRunnable, threadCoordinator});
            }
            bl = false;
            try {
                boolean bl2;
                this._maxPoolsize = this._pool.getMaximumPoolSize();
                boolean bl3 = bl2 = !this._blocked && (this._pool.isGrowAsNeeded() || this._activeThreads < this._maxPoolsize);
                if (bl2) {
                    this._pool.execute((Runnable)destinationMediationRunnable, 1);
                    bl = true;
                } else {
                    if (threadCoordinator.block()) {
                        this._blockedCoordinators.add(threadCoordinator);
                        this._blocked = true;
                    }
                    bl = false;
                }
            }
            catch (ThreadPool.ThreadPoolQueueIsFullException threadPoolQueueIsFullException) {
                FFDCFilter.processException((Throwable)threadPoolQueueIsFullException, (String)"com.ibm.ws.sib.mediation.runtime.MediationThreadPool.execute", (String)"145", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"The ThreadPool Queue was full");
                }
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)threadPoolQueueIsFullException));
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.mediation.runtime.MediationThreadPool.execute", (String)"175", (Object)this);
                if (!_tc.isEventEnabled()) break block10;
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)interruptedException);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"execute", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    public void threadPoolCreated(ThreadPool threadPool) {
    }

    public synchronized void threadCreated(ThreadPool threadPool, int n) {
        ++this._threadCount;
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)("threadCount is " + this._threadCount));
        }
    }

    public synchronized void threadStarted(ThreadPool threadPool, int n, int n2) {
        ++this._activeThreads;
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)("activeThread count is " + this._activeThreads));
        }
    }

    public synchronized void threadReturned(ThreadPool threadPool, int n, int n2) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"threadReturned", (Object)new Object[]{threadPool, new Integer(n), new Integer(n2)});
        }
        --this._activeThreads;
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)("activeThread count is " + this._activeThreads));
        }
        if (this._blocked) {
            this._maxPoolsize = this._pool.getMaximumPoolSize();
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)("max pool size " + this._maxPoolsize));
            }
            if (this._activeThreads < this._maxPoolsize) {
                boolean bl;
                do {
                    ThreadCoordinator threadCoordinator;
                    if (bl = (threadCoordinator = this._chooser.choose(this._blockedCoordinators)).dispatchOnce()) {
                        this._blockedCoordinators.add(threadCoordinator);
                        continue;
                    }
                    threadCoordinator.unBlock();
                } while (!bl && this._blockedCoordinators.size() != 0);
            }
            if (this._blockedCoordinators.size() == 0) {
                this._blocked = false;
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"threadReturned");
        }
    }

    public synchronized void threadDestroyed(ThreadPool threadPool, int n) {
        --this._threadCount;
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)("Thread count is " + this._activeThreads));
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)"Source info: @(#)SIB/ws/code/sib.mediation.destination.impl/src/com/ibm/ws/sib/mediation/runtime/MediationThreadPool.java, SIB.mediation.runtime, WAS602.SIB, o0610.11 1.11");
        }
    }
}

