/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mediation.runtime.ConcurrencyCoordinator;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters;
import com.ibm.ws.sib.mediation.runtime.MediationFrameworkDiagnosticModule;
import com.ibm.ws.sib.mediation.runtime.MediationPMIInstrumentation;
import com.ibm.ws.sib.utils.ras.SibTr;

public class DestinationMediationRunnable
implements Runnable {
    private static final TraceComponent _tc = SibTr.register((Class)DestinationMediationRunnable.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");
    private DestinationMediationParameters _parameters;
    private ConcurrencyCoordinator _coordinator;
    private static DestinationMediationInvocationInstance _instance;
    private volatile boolean _canceled = false;
    private MediationPMIInstrumentation _pmi;

    public DestinationMediationRunnable(DestinationMediationParameters destinationMediationParameters, ConcurrencyCoordinator concurrencyCoordinator, MediationPMIInstrumentation mediationPMIInstrumentation) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"DestinationMediationRunnable", (Object)new Object[]{destinationMediationParameters, concurrencyCoordinator, mediationPMIInstrumentation});
        }
        this._parameters = destinationMediationParameters;
        this._coordinator = concurrencyCoordinator;
        this._pmi = mediationPMIInstrumentation;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"DestinationMediationRunnable", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this._parameters != null) {
            SibTr.push((Object)this._parameters.getMessagingEngine());
        }
        try {
            block19: {
                if (_tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)_tc, (String)"run", (Object)this);
                }
                if (!this._canceled) {
                    MediationFrameworkDiagnosticModule.addDiagnosticData(this._parameters);
                    try {
                        this._pmi.onThreadAllocatedToMediation();
                        try {
                            boolean bl = _instance.invoke(this._parameters);
                            this._parameters.close();
                            if (bl) {
                                this._pmi.onMessageMediated(System.currentTimeMillis() - this._parameters.getCreationTimestamp());
                            }
                            break block19;
                        }
                        finally {
                            this._pmi.onThreadReclaimedFromMediation();
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationRunnable.run", (String)"104", (Object)this);
                        throwable.printStackTrace();
                        if (_tc.isEventEnabled()) {
                            SibTr.exception((TraceComponent)_tc, (Throwable)throwable);
                        }
                        if (throwable instanceof ThreadDeath) {
                            if (!_tc.isEntryEnabled()) throw (ThreadDeath)throwable;
                            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"run", (Object)throwable);
                            throw (ThreadDeath)throwable;
                        }
                        break block19;
                    }
                    finally {
                        this._coordinator.remove(this);
                        MediationFrameworkDiagnosticModule.clearDiagnosticData();
                    }
                }
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)("Canceled runnable " + this));
                }
            }
            if (!_tc.isEntryEnabled()) return;
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"run");
            return;
        }
        finally {
            if (this._parameters != null) {
                SibTr.pop();
            }
        }
    }

    public void cancel() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"cancel", (Object)this);
        }
        this._canceled = true;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"cancel");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)"Source info: @(#)SIB/ws/code/sib.mediation.destination.impl/src/com/ibm/ws/sib/mediation/runtime/DestinationMediationRunnable.java, SIB.mediation.runtime, WAS602.SIB, o0610.11 1.22");
        }
        _instance = new DestinationMediationInvocationInstance();
    }
}

