/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.websphere.sib.mediation.handler.MediationHandler;
import com.ibm.ws.Transaction.UtxFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.MediationDefinition;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.mediation.common.ConnectionPropertiesProvider;
import com.ibm.ws.sib.mediation.runtime.HandlerListStillAwaitingInitializationException;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.security.auth.AuthUtilsFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.handlerfw.HandlerConfig;
import com.ibm.wsspi.handlerfw.HandlerFramework;
import com.ibm.wsspi.handlerfw.HandlerList;
import com.ibm.wsspi.handlerfw.HandlerListStatus;
import com.ibm.wsspi.handlerfw.exception.HFConfigException;
import com.ibm.wsspi.handlerfw.exception.HFRuntimeException;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIInsufficientDataForFactoryTypeException;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import com.ibm.wsspi.sib.core.selector.SICoreConnectionFactorySelector;
import com.ibm.wsspi.sib.mediation.runtime.MediationControl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class DestinationMediationParameters
implements ConnectionPropertiesProvider,
Externalizable {
    private static final TraceComponent _tc = SibTr.register((Class)DestinationMediationParameters.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");
    private static UserTransaction _ut;
    private static AuthUtils _authUtils;
    private static HandlerFramework _theHandlerFramework;
    private long _timestamp = System.currentTimeMillis();
    private SICoreConnection _transactedConnection;
    private DestinationDefinition _dd;
    private MediationDefinition _md;
    private MediationControl _mc;
    private JsMessagingEngine _engine;
    private SIDestinationAddress _address;
    private SICoreConnectionFactory _transactedFactory;
    private String _traceMessageId;
    private Map _contextMap;
    private String _string = null;
    private long _consumerId;
    private SIMessageHandle _messageHandle;
    private Map _connectionProperties;
    private ProducerSession _producer;
    private BifurcatedConsumerSession _bcs;
    private SITransaction _tran;
    private boolean _tranInitialized;
    private String _meuuid;
    private static final long serialVersionUID = 2828042910439681L;
    private boolean _denyReadExternal = true;
    private static final Map _jcaFactories;
    private static final String _sourceInfo = "Source Info: @(#)SIB/ws/code/sib.mediation.destination.impl/src/com/ibm/ws/sib/mediation/runtime/DestinationMediationParameters.java, SIB.mediation.runtime, WAS602.SIB, o0610.11 1.30";

    public DestinationMediationParameters() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"DestinationMediationParameters");
        }
        this._denyReadExternal = false;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"DestinationMediationParameters", (Object)this);
        }
    }

    public DestinationMediationParameters(SICoreConnection sICoreConnection, ConsumerSession consumerSession, SIBusMessage sIBusMessage, DestinationDefinition destinationDefinition, JsMessagingEngine jsMessagingEngine, SIDestinationAddress sIDestinationAddress, MediationControl mediationControl) throws SIException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"DestinationMediationParameters", (Object)new Object[]{sICoreConnection, consumerSession, sIBusMessage, destinationDefinition, jsMessagingEngine, sIDestinationAddress, mediationControl});
        }
        this._dd = destinationDefinition;
        this._engine = jsMessagingEngine;
        this._address = sIDestinationAddress;
        this._mc = mediationControl;
        try {
            this._consumerId = consumerSession.getId();
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.<init>", (String)"217", (Object)this);
            this.traceRethrowing("Error occurred getting the consumer id", (Exception)((Object)sIException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"DestinationMediationParameters", (Object)((Object)sIException));
            }
            throw sIException;
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.<init>", (String)"227", (Object)this);
            this.traceRethrowing("Error occurred getting the consumer id", (Exception)((Object)sIErrorException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"DestinationMediationParameters", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        this._messageHandle = sIBusMessage.getMessageHandle();
        this._meuuid = sICoreConnection.getMeUuid();
        this._transactedFactory = this.getJCAFactory(this._engine.getBusName());
        this._traceMessageId = sIBusMessage.getSystemMessageId();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"DestinationMediationParameters", (Object)this);
        }
    }

    public SICoreConnection getConnection() throws SIException, SIErrorException, SystemException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getConnection", (Object)this);
        }
        if (this._transactedConnection == null) {
            try {
                Subject subject = _authUtils.getSIBServerSubject();
                this._transactedConnection = this._transactedFactory.createConnection(subject, this.getConnectionProperties());
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.getConnection", (String)"303", (Object)this);
                this.traceRethrowing("Error occurred while creating a connection", (Exception)((Object)sIErrorException));
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getConnection", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getConnection", (Object)this._transactedConnection);
        }
        return this._transactedConnection;
    }

    public BifurcatedConsumerSession getBifurcatedConsumerSession() throws SIException, SIErrorException, SystemException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getBifurcatedConsumerSession", (Object)this);
        }
        if (this._bcs == null) {
            try {
                this._bcs = this.getConnection().createBifurcatedConsumerSession(this._consumerId);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.getBifurcatedConsumerSession", (String)"357", (Object)this);
                this.traceRethrowing("Error occurred trying to establish bifurcated consumer", (Exception)((Object)sIException));
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getBifurcatedConsumerSession", (Object)((Object)sIException));
                }
                throw sIException;
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.getBifurcatedConsumerSession", (String)"367", (Object)this);
                this.traceRethrowing("Error occurred trying to establish bifurcated consumer", (Exception)((Object)sIErrorException));
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getBifurcatedConsumerSession", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
            catch (SystemException systemException) {
                this.traceRethrowing((Exception)((Object)systemException));
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getBifurcatedConsumerSession", (Object)((Object)systemException));
                }
                throw systemException;
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getBifurcatedConsumerSession", (Object)this._bcs);
        }
        return this._bcs;
    }

    public SITransaction getTransaction() throws SIException, SIErrorException, SystemException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getTransaction", (Object)this);
        }
        if (!this._tranInitialized) {
            try {
                this._tran = this.isGlobalTransactionInEffect() ? null : this.getConnection().createUncoordinatedTransaction();
                this._tranInitialized = true;
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.getTransaction", (String)"496", (Object)this);
                this.traceRethrowing("Error occurred while creating transaction", (Exception)((Object)sIException));
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getTransaction", (Object)((Object)sIException));
                }
                throw sIException;
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.getTransaction", (String)"506", (Object)this);
                this.traceRethrowing("Error occurred while creating transaction", (Exception)((Object)sIErrorException));
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getTransaction", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
            catch (SystemException systemException) {
                this.traceRethrowing((Exception)((Object)systemException));
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getTransaction", (Object)((Object)systemException));
                }
                throw systemException;
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getTransaction", (Object)this._tran);
        }
        return this._tran;
    }

    public SIMessageHandle[] getMessageIds() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getMessageIds", (Object)this);
        }
        SIMessageHandle[] sIMessageHandleArray = new SIMessageHandle[]{this._messageHandle};
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getMessageIds", (Object)new Object[]{sIMessageHandleArray});
        }
        return sIMessageHandleArray;
    }

    public DestinationDefinition getDestinationDefinition() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getDestinationDefinition", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getDestinationDefinition", (Object)this._dd);
        }
        return this._dd;
    }

    public MediationDefinition getMediationDefinition() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getMediationDefinition", (Object)this);
        }
        if (this._md == null) {
            this._md = this._dd.getMediationDefinition();
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getMediationDefinition", (Object)this._md);
        }
        return this._md;
    }

    public JsMessagingEngine getMessagingEngine() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getMessagingEngine", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getMessagingEngine", (Object)this._engine);
        }
        return this._engine;
    }

    public MediationControl getMediationControl() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getMediationControl", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getMediationControl", (Object)this._mc);
        }
        return this._mc;
    }

    public Map getConnectionProperties() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getConnectionProperties", (Object)this);
        }
        if (this._connectionProperties == null) {
            this._connectionProperties = new HashMap();
            this._connectionProperties.put("busName", this._engine.getBusName());
            this._connectionProperties.put("targetGroup", this._meuuid);
            this._connectionProperties.put("targetType", "MEUuid");
            this._connectionProperties.put("connectionProximity", "Server");
            this._connectionProperties.put("targetSignificance", "Required");
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getConnectionProperties", (Object)this._connectionProperties);
        }
        return this._connectionProperties;
    }

    private boolean isGlobalTransactionInEffect() throws SystemException {
        boolean bl;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"isGlobalTransactionInEffect", (Object)this);
        }
        try {
            bl = _ut.getStatus() != 6;
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.isGlobalTransactionInEffect", (String)"702", (Object)this);
            this.traceRethrowing("Error occurred determining the transactional state", (Exception)((Object)systemException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"isGlobalTransactionInEffect", (Object)((Object)systemException));
            }
            throw systemException;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"isGlobalTransactionInEffect", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    private void traceRethrowing(String string, Exception exception) {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)_tc, (String)string);
        }
        if (_tc.isEventEnabled()) {
            SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)exception);
        }
    }

    private void traceRethrowing(Exception exception) {
        if (_tc.isEventEnabled()) {
            SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)exception);
        }
    }

    public String getMediationName() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getMediationName", (Object)this);
        }
        String string = this.getMediationDefinition().getMediationName();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getMediationName", (Object)string);
        }
        return string;
    }

    public String getDestinationName() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getDestinationName", (Object)this);
        }
        String string = this._dd.getName();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getDestinationName", (Object)string);
        }
        return string;
    }

    public String getTraceMessageId() {
        return this._traceMessageId;
    }

    public Map getContextMap() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getContextMap", (Object)this);
        }
        if (this._contextMap == null) {
            this._contextMap = new HashMap();
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getContextMap", (Object)this._contextMap);
        }
        return this._contextMap;
    }

    public HandlerList getHandlerList() throws HFConfigException, HFRuntimeException {
        HandlerList handlerList;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getHandlerList", (Object)this);
        }
        HandlerFramework handlerFramework = this.getHandlerFramework();
        String string = this.getMediationDefinition().getHandlerListName();
        if (handlerFramework != null) {
            try {
                handlerList = handlerFramework.getHandlerList(string);
            }
            catch (HFConfigException hFConfigException) {
                FFDCFilter.processException((Throwable)hFConfigException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.getHandlerList", (String)"859", (Object)this);
                this.traceRethrowing((Exception)((Object)hFConfigException));
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getHandlerList", (Object)((Object)hFConfigException));
                }
                throw hFConfigException;
            }
            catch (HFRuntimeException hFRuntimeException) {
                FFDCFilter.processException((Throwable)hFRuntimeException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.getHandlerList", (String)"869", (Object)this);
                this.traceRethrowing((Exception)((Object)hFRuntimeException));
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getHandlerList", (Object)((Object)hFRuntimeException));
                }
                throw hFRuntimeException;
            }
        } else {
            handlerList = null;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getHandlerList", (Object)handlerList);
        }
        return handlerList;
    }

    public MediationHandler getHandlerListProxy() throws HandlerListStillAwaitingInitializationException, HFConfigException, HFRuntimeException {
        MediationHandler mediationHandler;
        HandlerList handlerList;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getHandlerListProxy", (Object)this);
        }
        try {
            handlerList = this.getHandlerList();
        }
        catch (HFConfigException hFConfigException) {
            this.traceRethrowing((Exception)((Object)hFConfigException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getHandlerListProxy", (Object)((Object)hFConfigException));
            }
            throw hFConfigException;
        }
        catch (HFRuntimeException hFRuntimeException) {
            this.traceRethrowing((Exception)((Object)hFRuntimeException));
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getHandlerListProxy", (Object)((Object)hFRuntimeException));
            }
            throw hFRuntimeException;
        }
        if (handlerList != null) {
            HandlerListStatus handlerListStatus = handlerList.getStatus();
            HandlerConfig[] handlerConfigArray = handlerListStatus.getFailedHandlers();
            HandlerConfig[] handlerConfigArray2 = handlerListStatus.getWaitingHandlers();
            if (handlerConfigArray == null) {
                handlerConfigArray = new HandlerConfig[]{};
            }
            if (handlerConfigArray2 == null) {
                handlerConfigArray2 = new HandlerConfig[]{};
            }
            if (handlerConfigArray.length + handlerConfigArray2.length > 0) {
                int n;
                HashSet<String> hashSet = new HashSet<String>();
                for (n = 0; n < handlerConfigArray.length; ++n) {
                    hashSet.add(handlerConfigArray[n].getApplicationName());
                }
                for (n = 0; n < handlerConfigArray2.length; ++n) {
                    hashSet.add(handlerConfigArray2[n].getApplicationName());
                }
                HandlerListStillAwaitingInitializationException handlerListStillAwaitingInitializationException = new HandlerListStillAwaitingInitializationException(handlerList, hashSet);
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getHandlerListProxy", (Object)handlerListStillAwaitingInitializationException);
                }
                throw handlerListStillAwaitingInitializationException;
            }
            mediationHandler = (MediationHandler)handlerList.getProxy(MediationHandler.class);
        } else {
            mediationHandler = null;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getHandlerListProxy", mediationHandler);
        }
        return mediationHandler;
    }

    private final HandlerFramework getHandlerFramework() {
        block9: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getHandlerFramework", (Object)this);
            }
            if (_theHandlerFramework == null) {
                try {
                    InitialContext initialContext = new InitialContext();
                    _theHandlerFramework = (HandlerFramework)initialContext.lookup("services:websphere/HandlerFrameworkService");
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.getHandlerFramework", (String)"1005", (Object)this);
                    if (_tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Object bound in as the HandlerFramework does not implement HandlerFramework interface");
                    }
                    if (_tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)classCastException);
                    }
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.getHandlerFramework", (String)"1019", (Object)this);
                    if (_tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unable to obtain HandlerFramework");
                    }
                    if (!_tc.isEventEnabled()) break block9;
                    SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)namingException);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getHandlerFramework", (Object)_theHandlerFramework);
        }
        return _theHandlerFramework;
    }

    public void close() {
        block25: {
            block24: {
                block23: {
                    if (_tc.isEntryEnabled()) {
                        SibTr.entry((Object)this, (TraceComponent)_tc, (String)"close", (Object)this);
                    }
                    if (this._producer != null) {
                        try {
                            this._producer.close();
                        }
                        catch (SIException sIException) {
                            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.close", (String)"1056", (Object)this);
                            if (_tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"while closing the MediationParameters an exception was received");
                            }
                            if (_tc.isEventEnabled()) {
                                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
                            }
                        }
                        catch (SIErrorException sIErrorException) {
                            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.close", (String)"1066", (Object)this);
                            if (_tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"while closing the MediationParameters an exception was received");
                            }
                            if (!_tc.isEventEnabled()) break block23;
                            SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIErrorException));
                        }
                    }
                }
                if (this._bcs != null) {
                    try {
                        this._bcs.close();
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.close", (String)"1078", (Object)this);
                        if (_tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)_tc, (String)"while closing the MediationParameters an exception was received");
                        }
                        if (_tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
                        }
                    }
                    catch (SIErrorException sIErrorException) {
                        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.close", (String)"1092", (Object)this);
                        if (_tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)_tc, (String)"while closing the MediationParameters an exception was received");
                        }
                        if (!_tc.isEventEnabled()) break block24;
                        SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIErrorException));
                    }
                }
            }
            if (this._transactedConnection != null) {
                try {
                    this._transactedConnection.close();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.close", (String)"1114", (Object)this);
                    if (_tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)_tc, (String)"while closing the MediationParameters an exception was received");
                    }
                    if (_tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
                    }
                }
                catch (SIErrorException sIErrorException) {
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.close", (String)"1128", (Object)this);
                    if (_tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)_tc, (String)"while closing the MediationParameters an exception was received");
                    }
                    if (!_tc.isEventEnabled()) break block25;
                    SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIErrorException));
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"close");
        }
    }

    public SIDestinationAddress getSIDestinationAddress() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getSIDestinationAddress", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIDestinationAddress", (Object)this._address);
        }
        return this._address;
    }

    public SICoreConnectionFactory getTransactedSICoreConnectionFactory() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getTransactedSICoreConnectionFactory", (Object)this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getTransactedSICoreConnectionFactory", (Object)this._transactedFactory);
        }
        return this._transactedFactory;
    }

    public long getCreationTimestamp() {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)_tc, (String)("timestamp = " + this._timestamp));
        }
        return this._timestamp;
    }

    public void clearTransaction() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"clearTransaction", (Object)this);
        }
        this._tranInitialized = false;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"clearTransaction");
        }
    }

    public String toString() {
        if (this._string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[bus=");
            stringBuffer.append(this._engine.getBusName());
            stringBuffer.append(", engine=");
            stringBuffer.append(this._engine.getName());
            stringBuffer.append(", destination=");
            stringBuffer.append(this._dd.getName());
            stringBuffer.append(", mediation=");
            stringBuffer.append(this._dd.getMediationDefinition().getMediationName());
            stringBuffer.append("]");
            this._string = stringBuffer.toString();
        }
        return this._string;
    }

    public void setContextMap(Map map) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setContextMap", (Object)new Object[]{this, map});
        }
        if (this._contextMap == null) {
            this._contextMap = map;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setContextMap");
        }
    }

    public void setMediationControl(MediationControl mediationControl) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"setMediationControl", (Object)new Object[]{this, mediationControl});
        }
        if (this._mc == null) {
            this._mc = mediationControl;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"setMediationControl");
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"writeExternal", (Object)new Object[]{this, objectOutput});
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeLong(2828042910439681L);
        objectOutputStream.writeObject(this._address);
        objectOutputStream.writeUTF(this._engine.getBusName());
        objectOutputStream.writeUTF(this._engine.getName());
        objectOutputStream.writeUTF(this._meuuid);
        objectOutputStream.writeUTF(this._traceMessageId);
        objectOutputStream.writeLong(this._consumerId);
        objectOutputStream.writeLong(this._timestamp);
        objectOutputStream.writeObject(this._messageHandle);
        objectOutput.writeObject(byteArrayOutputStream.toByteArray());
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"writeExternal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"readExternal", (Object)new Object[]{this, objectInput});
        }
        Object object = this;
        synchronized (object) {
            if (this._denyReadExternal) {
                IOException iOException = new IOException();
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"readExternal", (Object)iOException);
                }
                throw iOException;
            }
            this._denyReadExternal = true;
        }
        object = objectInput.readObject();
        if (object instanceof byte[]) {
            String string;
            ObjectInputStream objectInputStream;
            try {
                objectInputStream = new ObjectInputStream(new ByteArrayInputStream((byte[])object));
                objectInputStream.readLong();
                this._address = (SIDestinationAddress)objectInputStream.readObject();
                string = objectInputStream.readUTF();
                String string2 = objectInputStream.readUTF();
                this._meuuid = objectInputStream.readUTF();
                this._traceMessageId = objectInputStream.readUTF();
                this._engine = JsAdminService.getInstance().getMessagingEngine(string, string2);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.readExternal", (String)"1293", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)"An error occurred deserializing", (Object)object);
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"readExternal", (Object)iOException);
                }
                throw iOException;
            }
            try {
                this._dd = (DestinationDefinition)this._engine.getSIBDestination(string, this._address.getDestinationName());
            }
            catch (SIBExceptionDestinationNotFound sIBExceptionDestinationNotFound) {
                FFDCFilter.processException((Throwable)sIBExceptionDestinationNotFound, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.readExternal", (String)"1297", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)"An error occurred deserializing", (Object)object);
                }
                IOException iOException = new IOException();
                iOException.initCause(sIBExceptionDestinationNotFound);
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"readExternal", (Object)iOException);
                }
                throw iOException;
            }
            catch (SIBExceptionBase sIBExceptionBase) {
                FFDCFilter.processException((Throwable)sIBExceptionBase, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.readExternal", (String)"1317", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)"An error occurred deserializing", (Object)object);
                }
                IOException iOException = new IOException();
                iOException.initCause(sIBExceptionBase);
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"readExternal", (Object)iOException);
                }
                throw iOException;
            }
            try {
                this._consumerId = objectInputStream.readLong();
                this._timestamp = objectInputStream.readLong();
                this._messageHandle = (SIMessageHandle)objectInputStream.readObject();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.readExternal", (String)"1348", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)"An error occurred deserializing", (Object)object);
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"readExternal", (Object)iOException);
                }
                throw iOException;
            }
            try {
                this._transactedFactory = this.getJCAFactory(string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.readExternal", (String)"1387", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)"An error occurred deserializing", (Object)object);
                }
                IOException iOException = new IOException();
                iOException.initCause(exception);
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"readExternal", (Object)iOException);
                }
                throw iOException;
            }
        }
        IOException iOException = new IOException();
        if (_tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)_tc, (String)"The data is not a byte array", (Object)object);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"readExternal", (Object)iOException);
        }
        throw iOException;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"readExternal");
        }
    }

    private final synchronized SICoreConnectionFactory getJCAFactory(String string) throws SIException {
        SICoreConnectionFactory sICoreConnectionFactory;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getJCAFactory", (Object)new Object[]{this, string});
        }
        if (!_jcaFactories.containsKey(string)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("CONNECTION_SHARING", "CONNECTION_SHARING_ENABLED");
            hashMap.put("XA_RECOVERY_ALIAS", this._engine.getBus().getAttribute("mediationsAuthAlias"));
            hashMap.put("CREDENTIAL_PROVIDER", "CREDENTIAL_PROVIDER_CALLER");
            hashMap.put("MISSING_TRANSACTION_CONTEXT", "MISSING_TRANSACTION_CONTEXT_IGNORE");
            try {
                sICoreConnectionFactory = SICoreConnectionFactorySelector.getSICoreConnectionFactory((FactoryType)FactoryType.RA_CONNECTION, hashMap);
                _jcaFactories.put(string, sICoreConnectionFactory);
            }
            catch (SIInsufficientDataForFactoryTypeException sIInsufficientDataForFactoryTypeException) {
                FFDCFilter.processException((Throwable)sIInsufficientDataForFactoryTypeException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.getJCAFactory", (String)"1418", (Object)this);
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)((Object)sIInsufficientDataForFactoryTypeException));
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getJCAFactory", (Object)((Object)sIInsufficientDataForFactoryTypeException));
                }
                throw sIInsufficientDataForFactoryTypeException;
            }
            catch (SIIncorrectCallException sIIncorrectCallException) {
                FFDCFilter.processException((Throwable)sIIncorrectCallException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.getJCAFactory", (String)"1431", (Object)this);
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)((Object)sIIncorrectCallException));
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getJCAFactory", (Object)((Object)sIIncorrectCallException));
                }
                throw sIIncorrectCallException;
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters.getJCAFactory", (String)"1443", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"Some JCA related error has occurred");
                }
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)((Object)sIResourceException));
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getJCAFactory", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
        } else {
            sICoreConnectionFactory = (SICoreConnectionFactory)_jcaFactories.get(string);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getJCAFactory", (Object)sICoreConnectionFactory);
        }
        return sICoreConnectionFactory;
    }

    static {
        _jcaFactories = new HashMap();
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"<clinit>");
        }
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)_sourceInfo);
        }
        _ut = UtxFactory.createUserTransaction();
        _authUtils = AuthUtilsFactory.getInstance().createNewAuthUtils();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"<clinit>");
        }
    }
}

