/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIMessage;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.mediation.handler.MediationHandler;
import com.ibm.websphere.sib.mediation.handler.MessageContextException;
import com.ibm.websphere.sib.mediation.messagecontext.SIMessageContext;
import com.ibm.websphere.sib.mediation.session.SIMediationSession;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sib.mediation.handler.ejb.UnCheckedException;
import com.ibm.ws.sib.mediation.runtime.ContextHelper;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationHandlerListEventListener;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationParameters;
import com.ibm.ws.sib.mediation.runtime.ErrorHandler;
import com.ibm.ws.sib.mediation.runtime.HandlerListStillAwaitingInitializationException;
import com.ibm.ws.sib.mediation.runtime.MessageContextInitializer;
import com.ibm.ws.sib.mediation.runtime.SIMediationContextSetupException;
import com.ibm.ws.sib.mediation.runtime.TraceMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.security.auth.SIBAccessControl;
import com.ibm.ws.sib.security.auth.SIBAccessControlFactory;
import com.ibm.ws.sib.security.context.SecurityContextException;
import com.ibm.ws.sib.security.context.SecurityContextFactory;
import com.ibm.ws.sib.security.context.SecurityContextHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.handlerfw.exception.HFConfigException;
import com.ibm.wsspi.handlerfw.exception.HFRuntimeException;
import com.ibm.wsspi.handlerfw.exception.HandlerListNotFoundException;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SISystemMessage;
import com.ibm.wsspi.sib.core.SISystemMessageFactory;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.mediation.messagecontext.SIMessageContextCreationException;
import com.ibm.wsspi.sib.mediation.messagecontext.SIMessageContextFactory;
import com.ibm.wsspi.sib.mediation.runtime.StopReason;
import com.ibm.wsspi.sib.mediation.runtime.StopReasonFactory;
import com.ibm.wsspi.sib.mediation.session.SIMediationSessionFactory;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.transaction.SystemException;

public class DestinationMediationInvocationInstance {
    private static final String $ssccid = "Source info: @(#) 1.63.1.1 SIB/ws/code/sib.mediation.destination.impl/src/com/ibm/ws/sib/mediation/runtime/DestinationMediationInvocationInstance.java, SIB.mediation.runtime, WAS602.SIB, o0610.11 05/11/23 12:11:09 [3/13/06 13:33:47]";
    private static final TraceComponent _tc;
    private static SelectionCriteriaFactory _selectionCriteriaFactory;
    private static StopReason _frameworkFailureReason;
    private static Map _controls;
    private static SecurityContextHelper _helper;
    private static Subject _wasServerSubject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(DestinationMediationParameters destinationMediationParameters) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"invoke", (Object)new Object[]{this, destinationMediationParameters});
        }
        SIBusMessage sIBusMessage = null;
        SIMessage sIMessage = null;
        SIMessage sIMessage2 = null;
        MediationHandler mediationHandler = null;
        SIMediationSession sIMediationSession = null;
        SIMessageContext sIMessageContext = null;
        boolean bl = false;
        boolean bl2 = true;
        if (_frameworkFailureReason != null) {
            ErrorHandler.handleErrorWhenThereIsNoContext(destinationMediationParameters, _frameworkFailureReason);
            bl2 = false;
        }
        if (bl2) {
            sIBusMessage = this.getSIBusMessageForMediation(destinationMediationParameters);
            boolean bl3 = bl2 = sIBusMessage != null;
        }
        if (bl2) {
            bl2 = this.startContext(destinationMediationParameters, sIBusMessage);
        }
        if (bl2) {
            sIMessage2 = this.createSISystemMessage(destinationMediationParameters, sIBusMessage);
            boolean bl4 = bl2 = sIMessage2 != null;
        }
        if (bl2) {
            sIMessage = this.makeCloneOfMessage(destinationMediationParameters, sIMessage2);
            boolean bl5 = bl2 = sIMessage != null;
        }
        if (bl2) {
            sIMediationSession = this.createSIMediationSession(destinationMediationParameters);
            boolean bl6 = bl2 = sIMediationSession != null;
        }
        if (bl2) {
            sIMessageContext = this.createSIMessageContext(destinationMediationParameters, sIMessage, sIMediationSession);
            if (sIMessageContext != null) {
                MessageContextInitializer.initializeMessageContext(sIMessageContext, destinationMediationParameters.getDestinationDefinition());
            } else {
                bl2 = false;
            }
        }
        if (bl2) {
            mediationHandler = this.getMediationHandler(destinationMediationParameters);
            boolean bl7 = bl2 = mediationHandler != null;
        }
        if (bl2) {
            try {
                if (TraceMessage.isEnabled()) {
                    TraceMessage.traceMessageDeliveredToMediation(sIMessage, destinationMediationParameters.getMediationName());
                }
                if (bl = mediationHandler.handle(sIMessageContext)) {
                    if (TraceMessage.isEnabled()) {
                        TraceMessage.traceMessageForwardedByMediation(sIMessage, destinationMediationParameters.getDestinationName(), destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationDefinition().getForwardRoutingPath());
                    }
                    bl2 = this.attemptToSendMessage(destinationMediationParameters, sIMessage2, sIMessageContext);
                } else if (TraceMessage.isEnabled()) {
                    TraceMessage.traceMessageDiscardedByMediation(sIMessage, destinationMediationParameters.getMediationName());
                }
            }
            catch (UnCheckedException unCheckedException) {
                FFDCFilter.processException((Throwable)unCheckedException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.invoke", (String)"279", (Object)this);
                Throwable throwable = unCheckedException.getCause();
                String string = this.getUserId(destinationMediationParameters, sIMessage2);
                ErrorHandler.handleMediationError(destinationMediationParameters, string, sIMessage2, unCheckedException);
                bl2 = false;
                if (throwable instanceof ThreadDeath) {
                    if (_tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)_tc, (String)"invoke", (Object)throwable);
                    }
                    throw (ThreadDeath)throwable;
                }
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)throwable);
                }
            }
            catch (MessageContextException messageContextException) {
                FFDCFilter.processException((Throwable)messageContextException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.invoke", (String)"298", (Object)this);
                String string = this.getUserId(destinationMediationParameters, sIMessage2);
                bl2 = ErrorHandler.handleMediationError(destinationMediationParameters, string, sIMessage2, messageContextException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.invoke", (String)"317", (Object)this);
                StopReason stopReason = ErrorHandler.createStopReason("UNEXPECTED_EXCEPTION_FROM_HANDLER_FRAMEWORK_CWSIZ007E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), sIMessage2.getSystemMessageId(), ErrorHandler.extractStackTrace(throwable)}, false);
                ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
                bl2 = false;
                if (throwable instanceof ThreadDeath) {
                    if (_tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)_tc, (String)"invoke");
                    }
                    throw (ThreadDeath)throwable;
                }
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)throwable);
                }
            }
            finally {
                SIMediationSessionFactory.invalidate(sIMediationSession);
            }
            if (bl2) {
                bl2 = this.deleteMessage(destinationMediationParameters);
            }
            if (bl2) {
                bl2 = this.completeContext(destinationMediationParameters);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"invoke", (Object)(bl2 ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl2;
    }

    private boolean deleteMessage(DestinationMediationParameters destinationMediationParameters) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"deleteMessage", (Object)new Object[]{this, destinationMediationParameters});
        }
        boolean bl = false;
        try {
            destinationMediationParameters.getBifurcatedConsumerSession().deleteSet(destinationMediationParameters.getMessageIds(), destinationMediationParameters.getTransaction());
            bl = true;
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.deleteMessage", (String)"430", (Object)this);
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("ERROR_DELETE_SET_CWSIZ0016E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), sIException}, false);
            ErrorHandler.handleDeleteMessageError(destinationMediationParameters, stopReason);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.deleteMessage", (String)"438", (Object)this);
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIErrorException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("ERROR_DELETE_SET_CWSIZ0016E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), sIErrorException}, false);
            ErrorHandler.handleDeleteMessageError(destinationMediationParameters, stopReason);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.deleteMessage", (String)"446", (Object)this);
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)systemException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("UNABLE_TO_DETERMINE_TRANSACTIONAL_STATE_CWSIZ0028E", new Object[]{destinationMediationParameters.getMediationName(), systemException}, false);
            ErrorHandler.handleDeleteMessageError(destinationMediationParameters, stopReason);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"deleteMessage", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    private boolean attemptToSendMessage(DestinationMediationParameters destinationMediationParameters, SIMessage sIMessage, SIMessageContext sIMessageContext) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"attemptToSendMessage", (Object)new Object[]{this, destinationMediationParameters, sIMessage.getSystemMessageId(), sIMessageContext});
        }
        boolean bl = true;
        SIMessage sIMessage2 = sIMessageContext.getSIMessage();
        if (sIMessage2 instanceof SISystemMessage) {
            bl = this.isWellFormed(destinationMediationParameters, sIMessage2) ? this.sendMessageAlongForwardRoutingPath(destinationMediationParameters, ((SISystemMessage)sIMessage2).toSIBusMessage()) : this.sendMalformedMessageToExceptionDestination(destinationMediationParameters, sIMessage);
        } else {
            StopReason stopReason = ErrorHandler.createStopReason("INVALID_SIMESSAGE_IMPLEMENTATION_CWSIZ0027E", new Object[]{destinationMediationParameters.getMediationName(), sIMessage2.getClass().getName()}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
            bl = false;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"attemptToSendMessage", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    private boolean isWellFormed(DestinationMediationParameters destinationMediationParameters, SIMessage sIMessage) {
        Object v;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"isWellFormed", (Object)new Object[]{this, destinationMediationParameters, sIMessage});
        }
        Map map = destinationMediationParameters.getMediationDefinition().getMediationContext();
        boolean bl = true;
        boolean bl2 = true;
        if (sIMessage.getReliability() != Reliability.ASSURED_PERSISTENT && map.containsKey("sib:SkipWellFormedCheck") && (v = map.get("sib:SkipWellFormedCheck")) instanceof Boolean) {
            boolean bl3 = bl2 = (Boolean)v == false;
        }
        if (bl2) {
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Mediation Framework is performing the isWellFormed check");
            }
            bl = sIMessage.isWellFormed();
        } else if (_tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Mediation Framework is not performing the isWellFromed check");
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"isWellFormed", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    private boolean sendMalformedMessageToExceptionDestination(DestinationMediationParameters destinationMediationParameters, SIMessage sIMessage) {
        boolean bl;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"sendMalformedMessageToExceptionDestination", (Object)new Object[]{this, destinationMediationParameters, sIMessage});
        }
        if (TraceMessage.isEnabled()) {
            TraceMessage.traceMalformedMessageReroutedToExceptionDestination(sIMessage, destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationDefinition().getExceptionDestination());
        }
        try {
            SIBAccessControl sIBAccessControl = this.getSIBAccessControl(destinationMediationParameters);
            SIBusMessage sIBusMessage = ((SISystemMessage)sIMessage).toSIBusMessage();
            String string = sIBAccessControl.getSecurityIDFromMessage((JsMessage)sIBusMessage);
            destinationMediationParameters.getConnection().sendToExceptionDestination(destinationMediationParameters.getSIDestinationAddress(), sIBusMessage, 103, new String[]{sIMessage.getSystemMessageId(), destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName()}, destinationMediationParameters.getTransaction(), string);
            bl = true;
        }
        catch (SecurityContextException securityContextException) {
            FFDCFilter.processException((Throwable)securityContextException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.sendMalformedMessageToExceptionDestination", (String)"725", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)("Unable to create a SIBAccessControl for bus " + destinationMediationParameters.getMessagingEngine().getBusName()));
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)securityContextException);
            }
            StopReason stopReason = ErrorHandler.createStopReason("UNABLE_TO_OBTAIN_AUTHORIZATION_DATA_CWSIZ0048E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), destinationMediationParameters.getMessagingEngine().getBusName(), ErrorHandler.extractStackTrace(securityContextException)}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
            bl = false;
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.sendMalformedMessageToExceptionDestination", (String)"586", (Object)this);
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)systemException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("UNABLE_TO_DETERMINE_TRANSACTIONAL_STATE_CWSIZ0028E", new Object[]{destinationMediationParameters.getMediationName(), systemException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
            bl = false;
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.sendMalformedMessageToExceptionDestination", (String)"597", (Object)this);
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("SEND_TO_EXCEPTION_DESTINATION_EXCEPTION_CWSIZ0055E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getTraceMessageId(), destinationMediationParameters.getDestinationName(), sIException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
            bl = false;
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.sendMalformedMessageToExceptionDestination", (String)"608", (Object)this);
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIErrorException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("SEND_TO_EXCEPTION_DESTINATION_EXCEPTION_CWSIZ0055E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getTraceMessageId(), destinationMediationParameters.getDestinationName(), sIErrorException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
            bl = false;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"sendMalformedMessageToExceptionDestination", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    private SIBusMessage getSIBusMessageForMediation(DestinationMediationParameters destinationMediationParameters) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getSIBusMessageForMediation", (Object)new Object[]{this, destinationMediationParameters});
        }
        SIBusMessage sIBusMessage = null;
        try {
            BifurcatedConsumerSession bifurcatedConsumerSession = destinationMediationParameters.getBifurcatedConsumerSession();
            sIBusMessage = bifurcatedConsumerSession.readSet(destinationMediationParameters.getMessageIds())[0];
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.getSIBusMessageForMediation", (String)"682", (Object)this);
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("NEXT_LOCKED_EXCEPTION_CWSIZ0012E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), sIException}, false);
            ErrorHandler.handleErrorWhenThereIsNoContext(destinationMediationParameters, stopReason);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.getSIBusMessageForMediation", (String)"697", (Object)this);
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIErrorException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("NEXT_LOCKED_EXCEPTION_CWSIZ0012E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), sIErrorException}, false);
            ErrorHandler.handleErrorWhenThereIsNoContext(destinationMediationParameters, stopReason);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.getSIBusMessageForMediation", (String)"709", (Object)this);
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)systemException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("UNABLE_TO_DETERMINE_TRANSACTIONAL_STATE_CWSIZ0028E", new Object[]{destinationMediationParameters.getMediationName(), systemException}, false);
            ErrorHandler.handleErrorWhenThereIsNoContext(destinationMediationParameters, stopReason);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIBusMessageForMediation", (Object)(sIBusMessage == null ? null : sIBusMessage.getSystemMessageId()));
        }
        return sIBusMessage;
    }

    private boolean startContext(DestinationMediationParameters destinationMediationParameters, SIBusMessage sIBusMessage) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"startContext", (Object)new Object[]{this, destinationMediationParameters, sIBusMessage});
        }
        boolean bl = false;
        try {
            if (sIBusMessage != null && !(bl = ContextHelper.startContext(sIBusMessage, destinationMediationParameters.getDestinationDefinition(), destinationMediationParameters.getMessagingEngine(), destinationMediationParameters.getContextMap()))) {
                StopReason stopReason = ErrorHandler.createStopReason("CONTEXT_START_EXCEPTION_CWSIZ0013E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId()}, false);
                ErrorHandler.handleErrorWhenThereIsNoContext(destinationMediationParameters, stopReason);
            }
        }
        catch (SIMediationContextSetupException sIMediationContextSetupException) {
            FFDCFilter.processException((Throwable)((Object)sIMediationContextSetupException), (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.startContext", (String)"771", (Object)this);
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIMediationContextSetupException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("CONTEXT_HELPER_EXCEPTION_CWSIZ0004E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), sIMediationContextSetupException}, false);
            ErrorHandler.handleErrorWhenThereIsNoContext(destinationMediationParameters, stopReason);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"startContext", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    private SIMessage createSISystemMessage(DestinationMediationParameters destinationMediationParameters, SIBusMessage sIBusMessage) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"createSISystemMessage", (Object)new Object[]{this, destinationMediationParameters, sIBusMessage.getSystemMessageId()});
        }
        SISystemMessage sISystemMessage = null;
        try {
            sISystemMessage = ((SISystemMessageFactory)SISystemMessageFactory.getInstance()).createSISystemMessage(sIBusMessage);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.createSISystemMessage", (String)"819", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unable to convert SIBusMessage to an SIMessage");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIErrorException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("CREATE_SISYSTEM_MESSAGE_EXCEPTION_CWSIZ0005E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), sIErrorException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.createSISystemMessage", (String)"843", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unexpected Exception was thrown");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)exception);
            }
            StopReason stopReason = ErrorHandler.createStopReason("CREATE_SISYSTEM_MESSAGE_EXCEPTION_CWSIZ0005E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), exception}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"createSISystemMessage", (Object)(sISystemMessage == null ? null : sISystemMessage.getSystemMessageId()));
        }
        return sISystemMessage;
    }

    private SIMessage makeCloneOfMessage(DestinationMediationParameters destinationMediationParameters, SIMessage sIMessage) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"makeCloneOfMessage", (Object)new Object[]{this, destinationMediationParameters, sIMessage.getSystemMessageId()});
        }
        SIMessage sIMessage2 = null;
        if (_tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Mediation Framework will attempt to clone the message");
        }
        try {
            sIMessage2 = (SIMessage)sIMessage.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FFDCFilter.processException((Throwable)cloneNotSupportedException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.makeCloneOfMessage", (String)"918", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)("Unable to locate class: " + cloneNotSupportedException.getMessage()));
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)cloneNotSupportedException);
            }
            StopReason stopReason = ErrorHandler.createStopReason("CLONE_SIMESSAGE_EXCEPTION_CWSIZ0019E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), sIMessage, cloneNotSupportedException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"makeCloneOfMessage", (Object)(sIMessage2 == null ? null : sIMessage2.getSystemMessageId()));
        }
        return sIMessage2;
    }

    private SIMediationSession createSIMediationSession(DestinationMediationParameters destinationMediationParameters) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"createSIMediationSession", (Object)new Object[]{this, destinationMediationParameters});
        }
        SIMediationSession sIMediationSession = null;
        try {
            SIBAccessControl sIBAccessControl = this.getSIBAccessControl(destinationMediationParameters);
            sIMediationSession = SIMediationSessionFactory.createSIMediationSession(destinationMediationParameters.getConnection(), destinationMediationParameters.getMessagingEngine().getBusName(), destinationMediationParameters.getMessagingEngine().getName(), destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getMediationDefinition().getDiscriminator(), destinationMediationParameters.getMediationDefinition().getSelector(), destinationMediationParameters, destinationMediationParameters.getSIDestinationAddress(), destinationMediationParameters.getTransactedSICoreConnectionFactory(), _selectionCriteriaFactory, sIBAccessControl);
        }
        catch (SecurityContextException securityContextException) {
            FFDCFilter.processException((Throwable)securityContextException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.createSIMediationSession", (String)"1146", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unable to push or pop server subject");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)securityContextException);
            }
            StopReason stopReason = ErrorHandler.createStopReason("UNABLE_TO_OBTAIN_AUTHORIZATION_DATA_CWSIZ0048E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), destinationMediationParameters.getMessagingEngine().getBusName(), ErrorHandler.extractStackTrace(securityContextException)}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.createSIMediationSession", (String)"989", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)("Unable to locate class: " + classNotFoundException.getMessage()));
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)classNotFoundException);
            }
            StopReason stopReason = ErrorHandler.createStopReason("CREATE_SIMEDIATION_SESSION_EXCEPTION_CWSIZ0008E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), classNotFoundException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.createSIMediationSession", (String)"1012", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)("Unable to locate class: " + instantiationException.getMessage()));
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)instantiationException);
            }
            StopReason stopReason = ErrorHandler.createStopReason("CREATE_SIMEDIATION_SESSION_EXCEPTION_CWSIZ0008E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), instantiationException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.createSIMediationSession", (String)"1035", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)("Unable to locate class: " + illegalAccessException.getMessage()));
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)illegalAccessException);
            }
            StopReason stopReason = ErrorHandler.createStopReason("CREATE_SIMEDIATION_SESSION_EXCEPTION_CWSIZ0008E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), illegalAccessException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.createSIMediationSession", (String)"1055", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"An error occurred while creating the producer session");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("UNABLE_TO_CREATE_PRODUCER_SESSION_CWSIZ0030E", new Object[]{destinationMediationParameters.getMediationName(), sIException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.createSIMediationSession", (String)"1074", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"An error occurred while creating the producer session");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIErrorException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("UNABLE_TO_CREATE_PRODUCER_SESSION_CWSIZ0030E", new Object[]{destinationMediationParameters.getMediationName(), sIErrorException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.createSIMediationSession", (String)"1093", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"An error occurred while determining the transactional state");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)systemException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("UNABLE_TO_DETERMINE_TRANSACTIONAL_STATE_CWSIZ0028E", new Object[]{destinationMediationParameters.getMediationName(), systemException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"createSIMediationSession", (Object)sIMediationSession);
        }
        return sIMediationSession;
    }

    private SIMessageContext createSIMessageContext(DestinationMediationParameters destinationMediationParameters, SIMessage sIMessage, SIMediationSession sIMediationSession) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"createSIMessageContext", (Object)new Object[]{this, destinationMediationParameters, sIMessage.getSystemMessageId(), sIMediationSession});
        }
        SIMessageContext sIMessageContext = null;
        try {
            sIMessageContext = SIMessageContextFactory.getInstance().createMessageContext(sIMessage, sIMediationSession);
        }
        catch (SIMessageContextCreationException sIMessageContextCreationException) {
            FFDCFilter.processException((Throwable)sIMessageContextCreationException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.createSIMessageContext", (String)"1142", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unable to create message context");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)sIMessageContextCreationException);
            }
            StopReason stopReason = ErrorHandler.createStopReason("SIMESSAGECONTEXT_CREATION_EXCEPTION_CWSIZ0018E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), sIMessageContextCreationException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"createSIMessageContext", (Object)sIMessageContext);
        }
        return sIMessageContext;
    }

    private MediationHandler getMediationHandler(DestinationMediationParameters destinationMediationParameters) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getMediationHandler", (Object)new Object[]{this, destinationMediationParameters});
        }
        MediationHandler mediationHandler = null;
        try {
            mediationHandler = destinationMediationParameters.getHandlerListProxy();
        }
        catch (HandlerListStillAwaitingInitializationException handlerListStillAwaitingInitializationException) {
            FFDCFilter.processException((Throwable)handlerListStillAwaitingInitializationException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.getMediationHandler", (String)"1196", (Object)this);
            DestinationMediationHandlerListEventListener destinationMediationHandlerListEventListener = new DestinationMediationHandlerListEventListener(destinationMediationParameters.getMessagingEngine(), handlerListStillAwaitingInitializationException.getHandlerList(), destinationMediationParameters.getMediationControl());
            destinationMediationHandlerListEventListener.startListening();
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)("Specified HandlerList " + destinationMediationParameters.getMediationName() + " is not initialized. Application(s)" + handlerListStillAwaitingInitializationException.getApplicationName() + " is/are not initialized"));
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)handlerListStillAwaitingInitializationException);
            }
            StopReason stopReason = ErrorHandler.createStopReason("APPLICATION_FOR_MEDIATION_NOT_STARTED_CWSIZ0011E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), handlerListStillAwaitingInitializationException.getApplicationName()}, true);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (HandlerListNotFoundException handlerListNotFoundException) {
            FFDCFilter.processException((Throwable)handlerListNotFoundException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.getMediationHandler", (String)"1233", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)("Specified HandlerList " + destinationMediationParameters.getMediationDefinition().getHandlerListName() + " no longer exists in the configuration"));
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)handlerListNotFoundException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("HANDLER_LIST_EXCEPTION_CWSIZ0009E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), handlerListNotFoundException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (HFConfigException hFConfigException) {
            FFDCFilter.processException((Throwable)hFConfigException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.getMediationHandler", (String)"1253", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)("Error occurred looking up handler list " + destinationMediationParameters.getMediationDefinition().getHandlerListName()));
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)hFConfigException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("HANDLER_LIST_EXCEPTION_CWSIZ0009E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), hFConfigException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (HFRuntimeException hFRuntimeException) {
            FFDCFilter.processException((Throwable)hFRuntimeException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.getMediationHandler", (String)"1271", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)("Error occurred looking up handler list " + destinationMediationParameters.getMediationDefinition().getHandlerListName()));
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)hFRuntimeException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("HANDLER_LIST_EXCEPTION_CWSIZ0009E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), hFRuntimeException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.getMediationHandler", (String)"1290", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)("Handler list Name " + destinationMediationParameters.getMediationDefinition().getHandlerListName() + " was invalid"));
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)illegalArgumentException);
            }
            StopReason stopReason = ErrorHandler.createStopReason("HANDLER_LIST_EXCEPTION_CWSIZ0009E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), illegalArgumentException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getMediationHandler", (Object)mediationHandler);
        }
        return mediationHandler;
    }

    private boolean sendMessageAlongForwardRoutingPath(DestinationMediationParameters destinationMediationParameters, SIBusMessage sIBusMessage) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"sendMessageAlongForwardRoutingPath", (Object)new Object[]{this, destinationMediationParameters, sIBusMessage.getSystemMessageId()});
        }
        boolean bl = false;
        try {
            this.updateExpiryTime(System.currentTimeMillis() - destinationMediationParameters.getCreationTimestamp(), sIBusMessage);
            SIBAccessControl sIBAccessControl = this.getSIBAccessControl(destinationMediationParameters);
            String string = sIBAccessControl.getSecurityIDFromMessage((JsMessage)sIBusMessage);
            destinationMediationParameters.getConnection().send(sIBusMessage, destinationMediationParameters.getTransaction(), destinationMediationParameters.getSIDestinationAddress(), null, null, string);
            bl = true;
        }
        catch (SILimitExceededException sILimitExceededException) {
            FFDCFilter.processException((Throwable)sILimitExceededException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.sendMessageAlongForwardRoutingPath", (String)"1527", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unable to deliver message to next destination");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sILimitExceededException));
            }
            StopReason stopReason = sIBusMessage.getForwardRoutingPath().size() == 0 ? ErrorHandler.createStopReason("PRODUCER_SEND_MESSAGE_LIMIT_EXCEEDED_HERE_EXCEPTION_CWSIZ0057E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), ErrorHandler.extractStackTrace(sILimitExceededException)}, false) : ErrorHandler.createStopReason("PRODUCER_SEND_MESSAGE_LIMIT_EXCEEDED_AT_NEXT_EXCEPTION_CWSIZ0056E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), sIBusMessage.getForwardRoutingPath().get(0), ErrorHandler.extractStackTrace(sILimitExceededException)}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (SIConnectionLostException sIConnectionLostException) {
            FFDCFilter.processException((Throwable)sIConnectionLostException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.sendMessageAlongForwardRoutingPath", (String)"1564", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Connection with the messaging engine lost");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIConnectionLostException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("PRODUCER_SEND_MESSAGE_CONNECTION_EXCEPTION_CWSIZ0058E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), ErrorHandler.extractStackTrace(sIConnectionLostException)}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
            FFDCFilter.processException((Throwable)sIConnectionUnavailableException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.sendMessageAlongForwardRoutingPath", (String)"1586", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Connection with the messaging engine lost");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIConnectionUnavailableException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("PRODUCER_SEND_MESSAGE_CONNECTION_EXCEPTION_CWSIZ0058E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), ErrorHandler.extractStackTrace(sIConnectionUnavailableException)}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (SecurityContextException securityContextException) {
            FFDCFilter.processException((Throwable)securityContextException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.sendMessageAlongForwardRoutingPath", (String)"1513", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)("Unable to create a SIBAccessControl for bus " + destinationMediationParameters.getMessagingEngine().getBusName()));
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)securityContextException);
            }
            StopReason stopReason = ErrorHandler.createStopReason("UNABLE_TO_OBTAIN_AUTHORIZATION_DATA_CWSIZ0048E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), destinationMediationParameters.getMessagingEngine().getBusName(), ErrorHandler.extractStackTrace(securityContextException)}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.sendMessageAlongForwardRoutingPath", (String)"1343", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unexpected Exception was thrown");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("PRODUCER_SEND_MESSAGE_EXCEPTION_CWSIZ0014E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), sIException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.sendMessageAlongForwardRoutingPath", (String)"1366", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unexpected Exception was thrown");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIErrorException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("PRODUCER_SEND_MESSAGE_EXCEPTION_CWSIZ0014E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), sIErrorException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.sendMessageAlongForwardRoutingPath", (String)"1386", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"An error occurred determining the transactional state");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)systemException));
            }
            StopReason stopReason = ErrorHandler.createStopReason("UNABLE_TO_DETERMINE_TRANSACTIONAL_STATE_CWSIZ0028E", new Object[]{destinationMediationParameters.getMediationName(), systemException}, false);
            ErrorHandler.handleErrorWhenThereIsAContext(destinationMediationParameters, stopReason);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"sendMessageAlongForwardRoutingPath", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    private void updateExpiryTime(long l, SIBusMessage sIBusMessage) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"updateExpiryTime", (Object)new Object[]{this, new Long(l), sIBusMessage});
        }
        JsMessage jsMessage = (JsMessage)sIBusMessage;
        jsMessage.setMessageWaitTime(jsMessage.getMessageWaitTime() + l);
        long l2 = jsMessage.getTimeToLive();
        if (jsMessage.wasRemainingTimeToLiveChanged() && l2 != 0L) {
            long l3 = l2 + l;
            if (l3 > 9191815209357175807L) {
                l3 = 9191815209357175807L;
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)"The new time to live is greater than max allowable time to live. Setting to max time to live");
                }
            }
            jsMessage.setTimeToLive(l3);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"updateExpiryTime");
        }
    }

    private boolean completeContext(DestinationMediationParameters destinationMediationParameters) {
        StopReason stopReason;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"completeContext", (Object)new Object[]{this, destinationMediationParameters});
        }
        boolean bl = false;
        try {
            ContextHelper.completeContext(destinationMediationParameters.getContextMap());
            bl = true;
        }
        catch (SIMediationContextSetupException sIMediationContextSetupException) {
            if (_tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unexpected Exception was thrown");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIMediationContextSetupException));
            }
            stopReason = ErrorHandler.createStopReason("CONTEXT_COMPLETE_EXCEPTION_CWSIZ0017E", new Object[]{destinationMediationParameters.getMediationName(), destinationMediationParameters.getDestinationName(), destinationMediationParameters.getTraceMessageId(), sIMediationContextSetupException}, false);
            ErrorHandler.handleErrorWhenThereIsNoContext(destinationMediationParameters, stopReason);
        }
        try {
            SITransaction sITransaction = destinationMediationParameters.getTransaction();
            if (sITransaction != null && sITransaction instanceof SIUncoordinatedTransaction) {
                ((SIUncoordinatedTransaction)sITransaction).commit();
            }
        }
        catch (SIException sIException) {
            stopReason = ErrorHandler.createStopReason("MEDIATION_LOCAL_TRANSACTION_COMMIT_ERROR_CWSIZ0032E", new Object[]{destinationMediationParameters.getMediationName(), sIException}, false);
            ErrorHandler.handleErrorWhenThereIsNoContext(destinationMediationParameters, stopReason);
        }
        catch (SIErrorException sIErrorException) {
            stopReason = ErrorHandler.createStopReason("MEDIATION_LOCAL_TRANSACTION_COMMIT_ERROR_CWSIZ0032E", new Object[]{destinationMediationParameters.getMediationName(), sIErrorException}, false);
            ErrorHandler.handleErrorWhenThereIsNoContext(destinationMediationParameters, stopReason);
        }
        catch (SystemException systemException) {
            stopReason = ErrorHandler.createStopReason("UNABLE_TO_DETERMINE_TRANSACTIONAL_STATE_CWSIZ0028E", new Object[]{destinationMediationParameters.getMediationName(), systemException}, false);
            ErrorHandler.handleErrorWhenThereIsNoContext(destinationMediationParameters, stopReason);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"completeContext", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    private String getUserId(DestinationMediationParameters destinationMediationParameters, SIMessage sIMessage) {
        String string;
        block5: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getUserId", (Object)new Object[]{this, destinationMediationParameters, sIMessage});
            }
            string = null;
            try {
                SIBAccessControl sIBAccessControl = this.getSIBAccessControl(destinationMediationParameters);
                SIBusMessage sIBusMessage = ((SISystemMessage)sIMessage).toSIBusMessage();
                string = sIBAccessControl.getSecurityIDFromMessage((JsMessage)sIBusMessage);
            }
            catch (SecurityContextException securityContextException) {
                FFDCFilter.processException((Throwable)securityContextException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.getUserId", (String)"1888", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)("Unable to create a SIBAccessControl for bus " + destinationMediationParameters.getMessagingEngine().getBusName()));
                }
                if (!_tc.isEventEnabled()) break block5;
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)securityContextException);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getUserId", (Object)string);
        }
        return string;
    }

    private SIBAccessControl getSIBAccessControl(DestinationMediationParameters destinationMediationParameters) throws SecurityContextException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getSIBAccessControl", (Object)new Object[]{this, destinationMediationParameters});
        }
        String string = destinationMediationParameters.getMessagingEngine().getBusName();
        SIBAccessControl sIBAccessControl = null;
        if (!_controls.containsKey(string)) {
            try {
                _helper.pushRunAs(_wasServerSubject);
                sIBAccessControl = SIBAccessControlFactory.getInstance().createNewSIBAccessControl(string);
                _controls.put(string, sIBAccessControl);
                _helper.popRunAs();
            }
            catch (SecurityContextException securityContextException) {
                FFDCFilter.processException((Throwable)securityContextException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.getSIBAccessControl", (String)"1946", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)_tc, (String)"Unable to push or pop server subject.");
                }
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"rethrowing", (Object)securityContextException);
                }
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIBAccessControl", (Object)securityContextException);
                }
                throw securityContextException;
            }
        } else {
            sIBAccessControl = (SIBAccessControl)_controls.get(string);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIBAccessControl", (Object)sIBAccessControl);
        }
        return sIBAccessControl;
    }

    static {
        Object[] objectArray;
        _tc = SibTr.register((Class)DestinationMediationInvocationInstance.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"<clinit>");
        }
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)$ssccid);
        }
        try {
            _selectionCriteriaFactory = SelectionCriteriaFactory.getInstance();
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.<clinit>", (String)"125");
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)"Unable to obtain the selection criteria factory. Mediations will not function");
            }
            objectArray = new Object[]{ErrorHandler.extractStackTrace(sIErrorException)};
            SibTr.error((TraceComponent)_tc, (String)"UNABLE_TO_OBTAIN_SELECTION_CRITERIA_FACTORY_CWSIZ006E", (Object)objectArray);
            _frameworkFailureReason = StopReasonFactory.create("com.ibm.ws.sib.mediation.runtime.CWSIZMessages", "UNABLE_TO_OBTAIN_SELECTION_CRITERIA_FACTORY_CWSIZ006E", objectArray, false);
        }
        _helper = SecurityContextFactory.getInstance().createNewSecurityContextHelper();
        _controls = new HashMap();
        try {
            _wasServerSubject = ContextManagerFactory.getInstance().getServerSubject();
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationInvocationInstance.<clinit>", (String)"162");
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)"Unable to obtain the WAS Server Subject");
            }
            objectArray = new Object[]{ErrorHandler.extractStackTrace(wSSecurityException)};
            SibTr.error((TraceComponent)_tc, (String)"UNABLE_TO_OBTAIN_WAS_SERVER_SUBJECT_CWSIZ0046E", (Object)objectArray);
            _frameworkFailureReason = StopReasonFactory.create("com.ibm.ws.sib.mediation.runtime.CWSIZMessages", "UNABLE_TO_OBTAIN_WAS_SERVER_SUBJECT_CWSIZ0046E", objectArray, false);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"<clinit>");
        }
    }
}

