/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationDispatcher;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationDispatcherManager;
import com.ibm.ws.sib.mediation.runtime.MediationFrameworkDiagnosticModule;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.mediation.runtime.DestinationMediation;
import com.ibm.wsspi.sib.mediation.runtime.MediationControl;
import com.ibm.wsspi.sib.mediation.runtime.SIMediationInvalidException;
import com.ibm.wsspi.sib.mediation.runtime.StopReason;
import com.ibm.wsspi.sib.mediation.runtime.StopReasonFactory;
import com.ibm.wsspi.sib.mediation.runtime.StoppedListener;

public class DestinationMediationImpl
implements DestinationMediation {
    private DestinationMediationDispatcher _dispatcher;
    private MediationControl _control;
    private static final TraceComponent _tc = SibTr.register((Class)DestinationMediationImpl.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");

    public DestinationMediationImpl(JsMessagingEngine jsMessagingEngine, DestinationDefinition destinationDefinition, SIDestinationAddress sIDestinationAddress) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"DestinationMediationImpl", (Object)new Object[]{jsMessagingEngine, destinationDefinition, sIDestinationAddress});
        }
        this._dispatcher = DestinationMediationDispatcherManager.create(destinationDefinition, jsMessagingEngine, sIDestinationAddress);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"DestinationMediationImpl", (Object)this);
        }
    }

    public void mediate(LockedMessageEnumeration lockedMessageEnumeration) throws SIMediationInvalidException {
        ConsumerSession consumerSession;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"mediate", (Object)new Object[]{this, lockedMessageEnumeration});
        }
        if ((consumerSession = this.getConsumerSession(lockedMessageEnumeration)) != null) {
            SIBusMessage sIBusMessage;
            while ((sIBusMessage = this.getSIBusMessage(lockedMessageEnumeration)) != null) {
                MediationFrameworkDiagnosticModule.addDiagnosticData(sIBusMessage);
                this._dispatcher.dispatch(sIBusMessage, consumerSession, this._control);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"mediate");
        }
    }

    private SIBusMessage getSIBusMessage(LockedMessageEnumeration lockedMessageEnumeration) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getSIBusMessage", (Object)new Object[]{this, lockedMessageEnumeration});
        }
        SIBusMessage sIBusMessage = null;
        try {
            sIBusMessage = lockedMessageEnumeration.nextLocked();
        }
        catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
            FFDCFilter.processException((Throwable)sIConnectionUnavailableException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationImpl.getSIBusMessage", (String)"195", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)"The message processor passed a closed ConsumerSession");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIConnectionUnavailableException));
            }
        }
        catch (SIConnectionLostException sIConnectionLostException) {
            FFDCFilter.processException((Throwable)sIConnectionLostException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationImpl.getSIBusMessage", (String)"210", (Object)this);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)"The message processor passed a remote connection");
            }
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIConnectionLostException));
            }
            StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.mediation.runtime.CWSIZMessages", "COMMS_ERROR_GETTING_NEXT_LOCKED_CWSIZ0037E", new Object[]{sIConnectionLostException}, false);
            this._control.stopMediating(stopReason);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationImpl.getSIBusMessage", (String)"232", (Object)this);
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIException));
            }
            StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.mediation.runtime.CWSIZMessages", "UNEXPECTED_ERROR_GETTING_NEXT_LOCKED_CWSIZ0038E", new Object[]{sIException}, false);
            this._control.stopMediating(stopReason);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationImpl.getSIBusMessage", (String)"232", (Object)this);
            if (_tc.isEventEnabled()) {
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIErrorException));
            }
            StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.mediation.runtime.CWSIZMessages", "UNEXPECTED_ERROR_GETTING_NEXT_LOCKED_CWSIZ0038E", new Object[]{sIErrorException}, false);
            this._control.stopMediating(stopReason);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIBusMessage", (Object)sIBusMessage);
        }
        return sIBusMessage;
    }

    private ConsumerSession getConsumerSession(LockedMessageEnumeration lockedMessageEnumeration) {
        ConsumerSession consumerSession;
        block17: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getConsumerSession", (Object)new Object[]{this, lockedMessageEnumeration});
            }
            consumerSession = null;
            try {
                consumerSession = lockedMessageEnumeration.getConsumerSession();
            }
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
                FFDCFilter.processException((Throwable)sIConnectionDroppedException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationImpl.getConsumerSession", (String)"301", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"The message processor passed a remote connection");
                }
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIConnectionDroppedException));
                }
                StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.mediation.runtime.CWSIZMessages", "COMMS_ERROR_GETTING_CONSUMER_SESSION_CWSIZ0036E", new Object[]{sIConnectionDroppedException}, false);
                this._control.stopMediating(stopReason);
            }
            catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                FFDCFilter.processException((Throwable)sIConnectionUnavailableException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationImpl.getConsumerSession", (String)"286", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"The message processor passed a closed ConsumerSession");
                }
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIConnectionUnavailableException));
                }
            }
            catch (SISessionDroppedException sISessionDroppedException) {
                FFDCFilter.processException((Throwable)sISessionDroppedException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationImpl.getConsumerSession", (String)"301", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"The message processor passed a remote connection");
                }
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sISessionDroppedException));
                }
                StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.mediation.runtime.CWSIZMessages", "COMMS_ERROR_GETTING_CONSUMER_SESSION_CWSIZ0036E", new Object[]{sISessionDroppedException}, false);
                this._control.stopMediating(stopReason);
            }
            catch (SISessionUnavailableException sISessionUnavailableException) {
                FFDCFilter.processException((Throwable)sISessionUnavailableException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationImpl.getConsumerSession", (String)"286", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"The message processor passed a closed ConsumerSession");
                }
                if (_tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sISessionUnavailableException));
                }
            }
            catch (SIIncorrectCallException sIIncorrectCallException) {
                FFDCFilter.processException((Throwable)sIIncorrectCallException, (String)"com.ibm.ws.sib.mediation.runtime.DestinationMediationImpl.getConsumerSession", (String)"389", (Object)this);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)"The message processor passed us a LockedMessageEnumeration not applicable for this thread.");
                }
                if (!_tc.isEventEnabled()) break block17;
                SibTr.event((TraceComponent)_tc, (String)"absorbing", (Object)((Object)sIIncorrectCallException));
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getConsumerSession", (Object)consumerSession);
        }
        return consumerSession;
    }

    public void stop() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"stop", (Object)this);
        }
        this._dispatcher.stop(null);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"stop");
        }
    }

    public void start(MediationControl mediationControl) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"start", (Object)new Object[]{this, mediationControl});
        }
        this._control = mediationControl;
        this._dispatcher.resume();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"start");
        }
    }

    public void initiateStop(StoppedListener stoppedListener) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"initiateStop", (Object)new Object[]{this, stoppedListener});
        }
        this._dispatcher.stop(stoppedListener);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"initiateStop");
        }
    }

    public String toString() {
        return "DestinationMediationImpl: " + this._dispatcher.toString();
    }
}

