/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.handlerfw.HandlerList;
import com.ibm.wsspi.handlerfw.HandlerListEventListener;
import com.ibm.wsspi.handlerfw.HandlerListStatus;
import com.ibm.wsspi.sib.mediation.runtime.MediationControl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DestinationMediationHandlerListEventListener
implements HandlerListEventListener {
    private static final TraceComponent _tc = SibTr.register((Class)DestinationMediationHandlerListEventListener.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");
    private JsMessagingEngine _engine;
    private HandlerList _list;
    private MediationControl _control;
    private boolean _triggered = false;
    private static Map _enginesToListenerSets;

    public DestinationMediationHandlerListEventListener(JsMessagingEngine jsMessagingEngine, HandlerList handlerList, MediationControl mediationControl) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"<init>", (Object)new Object[]{handlerList, mediationControl});
        }
        this._control = mediationControl;
        this._list = handlerList;
        this._engine = jsMessagingEngine;
        this.workingForEngine();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"startListening", (Object)this);
        }
        this._list.addListener((HandlerListEventListener)this);
        DestinationMediationHandlerListEventListener destinationMediationHandlerListEventListener = this;
        synchronized (destinationMediationHandlerListEventListener) {
            if (!this._triggered) {
                HandlerListStatus handlerListStatus = this._list.getStatus();
                this.listChanged(handlerListStatus);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"startListening");
        }
    }

    public void listChanged(HandlerListStatus handlerListStatus) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"listChanged", (Object)handlerListStatus);
        }
        if (handlerListStatus.getInitializedCount() == handlerListStatus.getHandlerCount()) {
            this.resumeMediatingIfFirstCall();
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"listChanged");
        }
    }

    private void resumeMediatingIfFirstCall() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"resumeMediatingIfFirstCall", (Object)this);
        }
        if (this.isFirstCall()) {
            this._control.resumeMediating();
            this.stopListening();
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"resumeMediatingIfFirstCall");
        }
    }

    private synchronized boolean isFirstCall() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"isFirstCall", (Object)this);
        }
        boolean bl = false;
        if (!this._triggered) {
            bl = true;
            this._triggered = true;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"isFirstCall", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    private void stopListeningIfFirstCall() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"stopListeningIfFirstCall", (Object)this);
        }
        if (this.isFirstCall()) {
            this.stopListening();
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"stopListeningIfFirstCall");
        }
    }

    private void stopListening() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"stopListening", (Object)this);
        }
        this._list.removeListener((HandlerListEventListener)this);
        this.noLongerWorkingForEngine();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"stopListening");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workingForEngine() {
        Set<DestinationMediationHandlerListEventListener> set;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"workingForEngine", (Object)new Object[]{this});
        }
        Class clazz = DestinationMediationHandlerListEventListener.class;
        synchronized (clazz) {
            set = (Set<DestinationMediationHandlerListEventListener>)_enginesToListenerSets.get(this._engine);
            if (set == null) {
                set = Collections.synchronizedSet(new HashSet());
                _enginesToListenerSets.put(this._engine, set);
            }
        }
        set.add(this);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"workingForEngine");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noLongerWorkingForEngine() {
        Set set;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"noLongerWorkingForEngine", (Object)new Object[]{this});
        }
        Class clazz = DestinationMediationHandlerListEventListener.class;
        synchronized (clazz) {
            set = (Set)_enginesToListenerSets.get(this._engine);
        }
        if (set != null) {
            set.remove(this);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"noLongerWorkingForEngine");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void engineStopping(JsMessagingEngine jsMessagingEngine) {
        Set set;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"engineStopping", (Object)jsMessagingEngine);
        }
        Object object = DestinationMediationHandlerListEventListener.class;
        synchronized (object) {
            set = (Set)_enginesToListenerSets.remove(jsMessagingEngine);
        }
        if (set != null) {
            object = set.iterator();
            while (object.hasNext()) {
                DestinationMediationHandlerListEventListener destinationMediationHandlerListEventListener = (DestinationMediationHandlerListEventListener)object.next();
                destinationMediationHandlerListEventListener.stopListeningIfFirstCall();
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"engineStopping");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void engineReloaded(JsMessagingEngine jsMessagingEngine) {
        Set set;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"engineReloaded", (Object)jsMessagingEngine);
        }
        Object object = DestinationMediationHandlerListEventListener.class;
        synchronized (object) {
            set = (Set)_enginesToListenerSets.remove(jsMessagingEngine);
        }
        if (set != null) {
            object = set.iterator();
            while (object.hasNext()) {
                DestinationMediationHandlerListEventListener destinationMediationHandlerListEventListener = (DestinationMediationHandlerListEventListener)object.next();
                destinationMediationHandlerListEventListener.resumeMediatingIfFirstCall();
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"engineReloaded");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)"Source info: @(#)SIB/ws/code/sib.mediation.destination.impl/src/com/ibm/ws/sib/mediation/runtime/DestinationMediationHandlerListEventListener.java, SIB.mediation.runtime, WAS602.SIB, o0610.11 1.12");
        }
        _enginesToListenerSets = new HashMap();
    }
}

