/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mediation.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationDispatcherManager;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationFactoryImpl;
import com.ibm.ws.sib.mediation.runtime.DestinationMediationHandlerListEventListener;
import com.ibm.ws.sib.mediation.runtime.MediationFrameworkDiagnosticModule;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.mediation.runtime.DestinationMediationFactory;
import com.ibm.wsspi.sib.mediation.runtime.DestinationMediationFramework;

public final class DestinationMediationFrameworkImpl
implements DestinationMediationFramework {
    private static final TraceComponent _tc = SibTr.register((Class)DestinationMediationFrameworkImpl.class, (String)"SIBMediations.Destination", (String)"com.ibm.ws.sib.mediation.runtime.CWSIZMessages");
    private DestinationMediationFactory _theDestinationMediationFactory;
    private JsMessagingEngine _theMessagingEngine;
    private boolean _serverStarted = false;
    private boolean _engineStarted = false;
    private boolean _managerStarted = false;

    public final DestinationMediationFactory getDestinationMediationFactory() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"getDestinationMediationFactory", (Object)this);
        }
        this.setupFFDC();
        if (this._theDestinationMediationFactory == null) {
            this.createDestinationMediationFactory();
        }
        this.cleanupFFDC();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"getDestinationMediationFactory", (Object)this._theDestinationMediationFactory);
        }
        return this._theDestinationMediationFactory;
    }

    public void initialize(JsMessagingEngine jsMessagingEngine) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"initialize", (Object)new Object[]{this, jsMessagingEngine});
        }
        this.setupFFDC();
        this._theMessagingEngine = jsMessagingEngine;
        if (this._theDestinationMediationFactory != null) {
            this._theDestinationMediationFactory.setMessagingEngine(jsMessagingEngine);
        }
        this.cleanupFFDC();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"initialize");
        }
    }

    public synchronized void start(int n) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"start", (Object)new Object[]{this, new Integer(n)});
        }
        this.setupFFDC();
        this._engineStarted = true;
        this.startManagerIfPossible();
        this.cleanupFFDC();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"start");
        }
    }

    public synchronized void serverStarted() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"serverStarted", (Object)this);
        }
        this.setupFFDC();
        this._serverStarted = true;
        this.startManagerIfPossible();
        this.cleanupFFDC();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"serverStarted");
        }
    }

    public synchronized void serverStopping() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"serverStopping", (Object)this);
        }
        this.setupFFDC();
        this._serverStarted = false;
        this.stopManagerIfNecessary();
        this.cleanupFFDC();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"serverStopping");
        }
    }

    public synchronized void stop(int n) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"stop", (Object)new Object[]{this, new Integer(n)});
        }
        this.setupFFDC();
        this._engineStarted = false;
        this.stopManagerIfNecessary();
        DestinationMediationHandlerListEventListener.engineStopping(this._theMessagingEngine);
        this.cleanupFFDC();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"stop");
        }
    }

    public void destroy() {
    }

    public void setCustomProperty(String string, String string2) {
    }

    public void setAttribute(String string, String string2) {
    }

    private void createDestinationMediationFactory() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"createDestinationMediationFactory", (Object)this);
        }
        this._theDestinationMediationFactory = new DestinationMediationFactoryImpl();
        if (this._theMessagingEngine != null) {
            this._theDestinationMediationFactory.setMessagingEngine(this._theMessagingEngine);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"createDestinationMediationFactory");
        }
    }

    private synchronized void startManagerIfPossible() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"startManagerIfPossible", (Object)this);
        }
        if (this._serverStarted && this._engineStarted && !this._managerStarted) {
            DestinationMediationDispatcherManager.start(this._theMessagingEngine);
            this._managerStarted = true;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"startManagerIfPossible");
        }
    }

    private synchronized void stopManagerIfNecessary() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"stopManagerIfNecessary", (Object)this);
        }
        if (this._managerStarted) {
            DestinationMediationDispatcherManager.stop(this._theMessagingEngine);
            this._managerStarted = false;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"stopManagerIfNecessary");
        }
    }

    public void busReloaded(SIBus sIBus, boolean bl, boolean bl2, boolean bl3) {
    }

    public void engineReloaded(JsMessagingEngine jsMessagingEngine) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"engineReloaded", (Object)new Object[]{this, jsMessagingEngine});
        }
        DestinationMediationHandlerListEventListener.engineReloaded(this._theMessagingEngine);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"engineReloaded");
        }
    }

    private void setupFFDC() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"setupFFDC", (Object)this);
        }
        MediationFrameworkDiagnosticModule.addDiagnosticData(this._theMessagingEngine);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"setupFFDC");
        }
    }

    private void cleanupFFDC() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"cleanupFFDC", (Object)this);
        }
        MediationFrameworkDiagnosticModule.clearDiagnosticData();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"cleanupFFDC");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)"Source info: @(#)SIB/ws/code/sib.mediation.destination.impl/src/com/ibm/ws/sib/mediation/runtime/DestinationMediationFrameworkImpl.java, SIB.mediation.runtime, WAS602.SIB, o0610.11 1.11");
        }
        MediationFrameworkDiagnosticModule.register();
    }
}

