/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.Matching;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.selector.impl.LiteralImpl;
import com.ibm.ws.sib.matchspace.selector.impl.OperatorImpl;
import java.util.List;

public final class ParseUtil {
    private ParseUtil() {
    }

    static Selector parseStringLiteral(String string) {
        return new LiteralImpl(ParseUtil.reduceStringLiteralToken(string));
    }

    private static String reduceStringLiteralToken(String string) {
        string = string.substring(1, string.length() - 1);
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\'') continue;
            string = string.substring(0, i + 1) + string.substring(i + 2);
        }
        return string;
    }

    static Selector parseIntegerLiteral(String string) {
        char c = string.charAt(string.length() - 1);
        boolean bl = false;
        if (c == 'l' || c == 'L') {
            string = string.substring(0, string.length() - 1);
            bl = true;
        }
        long l = Long.decode(string);
        if (bl || l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            return new LiteralImpl(new Long(l));
        }
        return new LiteralImpl(new Integer((int)l));
    }

    static Selector parseFloatingLiteral(String string) {
        char c = string.charAt(string.length() - 1);
        Number number = c == 'f' || c == 'F' ? (Number)new Float(string) : (Number)new Double(string);
        return new LiteralImpl(number);
    }

    static Selector convertSet(Selector selector, List list) {
        OperatorImpl operatorImpl = null;
        for (int i = 0; i < list.size(); ++i) {
            Selector selector2 = (Selector)list.get(i);
            OperatorImpl operatorImpl2 = new OperatorImpl(45, (Selector)selector.clone(), selector2);
            operatorImpl = operatorImpl == null ? operatorImpl2 : new OperatorImpl(47, operatorImpl, operatorImpl2);
        }
        return operatorImpl;
    }

    static Selector convertRange(Selector selector, Selector selector2, Selector selector3) {
        return new OperatorImpl(46, new OperatorImpl(43, (Selector)selector.clone(), selector2), new OperatorImpl(44, (Selector)selector.clone(), selector3));
    }

    static Selector convertLike(Selector selector, String string, String string2) {
        try {
            string = ParseUtil.reduceStringLiteralToken(string);
            boolean bl = false;
            char c = '\u0000';
            if (string2 != null) {
                if ((string2 = ParseUtil.reduceStringLiteralToken(string2)).length() != 1) {
                    return null;
                }
                bl = true;
                c = string2.charAt(0);
            }
            return Matching.getInstance().createLikeOperator(selector, string, bl, c);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.matchspace.selector.impl.ParseUtil.convertLike", (String)"179");
            throw new RuntimeException(exception);
        }
    }
}

