/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.Literal;
import com.ibm.ws.sib.matchspace.selector.impl.EvaluatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.SelectorImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public final class LiteralImpl
extends SelectorImpl
implements Literal {
    public Object value;

    static int objectType(Object object) {
        if (object instanceof String) {
            return -5;
        }
        if (object instanceof Boolean) {
            return -6;
        }
        if (object instanceof Number) {
            return EvaluatorImpl.getType((Number)object) + -4;
        }
        if (object instanceof Serializable) {
            return -7;
        }
        return 2;
    }

    public LiteralImpl(Object object) {
        this.value = object;
        this.type = LiteralImpl.objectType(object);
    }

    public LiteralImpl(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this.type = objectInput.readByte();
        switch (this.type) {
            case -2: {
                this.value = new Float(objectInput.readFloat());
                return;
            }
            case -1: {
                this.value = new Double(objectInput.readDouble());
                return;
            }
            case -4: {
                this.value = new Integer(objectInput.readInt());
                return;
            }
            case -3: {
                this.value = new Long(objectInput.readLong());
                return;
            }
            case -5: {
                this.value = objectInput.readUTF();
                return;
            }
            case -6: {
                this.value = objectInput.readBoolean();
                return;
            }
            case -7: {
                this.value = objectInput.readObject();
            }
        }
        this.type = 2;
    }

    public void encodeSelf(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte((byte)this.type);
        switch (this.type) {
            case -5: {
                objectOutput.writeUTF((String)this.value);
                return;
            }
            case -3: {
                objectOutput.writeLong((Long)this.value);
                return;
            }
            case -1: {
                objectOutput.writeDouble((Double)this.value);
                return;
            }
            case -4: {
                objectOutput.writeInt((Integer)this.value);
                return;
            }
            case -2: {
                objectOutput.writeFloat(((Float)this.value).floatValue());
                return;
            }
            case -6: {
                objectOutput.writeBoolean((Boolean)this.value);
                return;
            }
            case -7: {
                objectOutput.writeObject(this.value);
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object object) {
        if (object instanceof Literal && super.equals(object)) {
            return ((Literal)object).getValue().equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        if (this.type == -5) {
            return "'" + this.value + "'";
        }
        return this.value.toString();
    }

    public Object getValue() {
        return this.value;
    }
}

