/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.EvalCache;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.Literal;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.matchspace.Operator;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.selector.impl.LikeOperatorImpl;
import com.ibm.ws.sib.matchspace.tools.Evaluator;
import java.io.Serializable;

public final class EvaluatorImpl
implements Evaluator {
    private static final Boolean[][] andTable = new Boolean[][]{{Boolean.TRUE, Boolean.FALSE, null}, {Boolean.FALSE, Boolean.FALSE, Boolean.FALSE}, {null, Boolean.FALSE, null}};
    private static final Boolean[][] orTable = new Boolean[][]{{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}, {Boolean.TRUE, Boolean.FALSE, null}, {Boolean.TRUE, null, null}};
    private static final int BYTE = -2;
    private static final int SHORT = -1;
    private static final int INT = 0;
    private static final int LONG = 1;
    private static final int FLOAT = 2;
    private static final int DOUBLE = 3;

    public Object eval(Selector selector, MatchSpaceKey matchSpaceKey, EvalCache evalCache, boolean bl) throws BadMessageFormatMatchingException {
        Object object;
        if (selector.getType() == 2) {
            throw new IllegalArgumentException();
        }
        if (selector.getUniqueId() != 0 && (object = evalCache.getExprValue(selector.getUniqueId())) != null) {
            return object;
        }
        object = this.evalInternal(selector, matchSpaceKey, evalCache, bl);
        if (selector.getUniqueId() != 0) {
            evalCache.saveExprValue(selector.getUniqueId(), object);
        }
        return object;
    }

    public Object eval(Selector selector) {
        try {
            return this.eval(selector, MatchSpaceKey.DUMMY, EvalCache.DUMMY, false);
        }
        catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
            FFDCFilter.processException((Throwable)badMessageFormatMatchingException, (String)"com.ibm.ws.sib.matchspace.selector.impl.Evaluator.eval", (String)"115", (Object)selector);
            throw new IllegalStateException();
        }
    }

    private Object evalInternal(Selector selector, MatchSpaceKey matchSpaceKey, EvalCache evalCache, boolean bl) throws BadMessageFormatMatchingException {
        if (selector instanceof Literal) {
            return ((Literal)selector).getValue();
        }
        if (selector instanceof Identifier) {
            Identifier identifier = (Identifier)selector;
            if (bl && identifier.getType() != 0) {
                Object object = matchSpaceKey.getIdentifierValue(identifier, true);
                if (object == null) {
                    return null;
                }
                switch (identifier.getType()) {
                    case 1: {
                        if (object instanceof Number) {
                            return object;
                        }
                        return EvaluatorImpl.castToNumber(object);
                    }
                    case -5: {
                        return object.toString();
                    }
                    case -6: {
                        if (object instanceof Boolean) {
                            return object;
                        }
                        return EvaluatorImpl.castToBoolean(object);
                    }
                }
                return null;
            }
            return matchSpaceKey.getIdentifierValue(identifier, false);
        }
        Operator operator = (Operator)selector;
        Object object = this.eval(operator.getOperands()[0], matchSpaceKey, evalCache, false);
        Object object2 = operator.getOperands().length == 1 ? null : this.eval(operator.getOperands()[1], matchSpaceKey, evalCache, false);
        switch (operator.getOp()) {
            case 1: {
                if (object instanceof Boolean) {
                    return EvaluatorImpl.not((Boolean)object);
                }
                if (bl && object != null) {
                    return EvaluatorImpl.not(EvaluatorImpl.castToBoolean(object));
                }
                return null;
            }
            case 2: {
                if (!(object instanceof Number)) {
                    if (bl && object != null) {
                        if ((object = EvaluatorImpl.castToNumber(object)) == null) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                return EvaluatorImpl.neg((Number)object);
            }
            case 3: {
                return object == null;
            }
            case 4: 
            case 5: {
                if (!(object instanceof String)) {
                    if (bl && object != null) {
                        object = object.toString();
                    } else {
                        return null;
                    }
                }
                return ((LikeOperatorImpl)operator).getInternalPattern().match((String)object);
            }
            case 40: {
                return EvaluatorImpl.not(EvaluatorImpl.compare(object, object2, false, bl));
            }
            case 45: {
                return EvaluatorImpl.compare(object, object2, false, bl);
            }
            case 41: {
                return EvaluatorImpl.compare(object2, object, true, bl);
            }
            case 42: {
                return EvaluatorImpl.compare(object, object2, true, bl);
            }
            case 43: {
                return EvaluatorImpl.not(EvaluatorImpl.compare(object, object2, true, bl));
            }
            case 44: {
                return EvaluatorImpl.not(EvaluatorImpl.compare(object2, object, true, bl));
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                return EvaluatorImpl.promoteAndEvaluate(operator.getOp(), object, object2, bl);
            }
            case 46: 
            case 47: {
                if (!(object instanceof Boolean) && bl && object != null) {
                    object = EvaluatorImpl.castToBoolean(object);
                }
                if (!(object2 instanceof Boolean) && bl && object2 != null) {
                    object2 = EvaluatorImpl.castToBoolean(object2);
                }
                if (operator.getOp() == 46) {
                    return EvaluatorImpl.and((Boolean)object, (Boolean)object2);
                }
                return EvaluatorImpl.or((Boolean)object, (Boolean)object2);
            }
        }
        throw new IllegalStateException();
    }

    /*
     * Loose catch block
     */
    private static Number castToNumber(Object object) {
        if (!(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        switch (string.charAt(string.length() - 1)) {
            case 'L': 
            case 'l': {
                string = string.substring(0, string.length() - 1);
                return new Long(string);
            }
            case 'F': 
            case 'f': {
                return new Float(string);
            }
            case 'D': 
            case 'd': {
                return new Double(string);
            }
        }
        {
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        try {
            return new Long(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new Double(string);
        }
    }

    private static Boolean castToBoolean(Object object) {
        if (!(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static Boolean compare(Object object, Object object2, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3 = object instanceof Number ? 0 : (object instanceof Boolean ? 1 : (object instanceof String ? 2 : (n2 = object instanceof Serializable ? 3 : 4)));
        int n4 = object2 instanceof Number ? 0 : (object2 instanceof Boolean ? 1 : (object2 instanceof String ? 2 : (n = object2 instanceof Serializable ? 3 : 4)));
        if (n2 > 3 || n > 3) {
            return null;
        }
        int n5 = n2 * 4 + n;
        if (bl2) {
            switch (n5) {
                case 0: 
                case 5: 
                case 10: 
                case 15: {
                    break;
                }
                case 2: {
                    object2 = EvaluatorImpl.castToNumber(object2);
                    if (object2 == null) {
                        return null;
                    }
                    n5 = 0;
                    break;
                }
                case 6: {
                    object2 = EvaluatorImpl.castToBoolean(object2);
                    if (object2 == null) {
                        return null;
                    }
                    n5 = 5;
                    break;
                }
                case 8: {
                    object = EvaluatorImpl.castToNumber(object);
                    if (object == null) {
                        return null;
                    }
                    n5 = 0;
                    break;
                }
                case 9: {
                    object = EvaluatorImpl.castToBoolean(object);
                    if (object == null) {
                        return null;
                    }
                    n5 = 4;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        switch (n5) {
            case 0: {
                int n6 = EvaluatorImpl.compare((Number)object, (Number)object2);
                if (bl) {
                    return n6 < 0;
                }
                return n6 == 0;
            }
            case 5: 
            case 10: 
            case 15: {
                if (bl) {
                    return null;
                }
                return object.equals(object2);
            }
        }
        return null;
    }

    private static Object promoteAndEvaluate(int n, Object object, Object object2, boolean bl) {
        if (!(object instanceof Number)) {
            if (bl && object != null) {
                object = EvaluatorImpl.castToNumber(object);
            } else {
                return null;
            }
        }
        if (!(object2 instanceof Number)) {
            if (bl && object2 != null) {
                object2 = EvaluatorImpl.castToNumber(object2);
            } else {
                return null;
            }
        }
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 48: {
                return EvaluatorImpl.plus((Number)object, (Number)object2);
            }
            case 49: {
                return EvaluatorImpl.minus((Number)object, (Number)object2);
            }
            case 50: {
                return EvaluatorImpl.times((Number)object, (Number)object2);
            }
            case 51: {
                return EvaluatorImpl.div((Number)object, (Number)object2);
            }
        }
        throw new IllegalStateException();
    }

    public static int ttIndex(Boolean bl) {
        int n = 2;
        if (bl != null) {
            if (bl.booleanValue()) {
                n = 0;
            } else if (!bl.booleanValue()) {
                n = 1;
            }
        }
        return n;
    }

    public static Boolean and(Boolean bl, Boolean bl2) {
        return andTable[EvaluatorImpl.ttIndex(bl)][EvaluatorImpl.ttIndex(bl2)];
    }

    public static Boolean or(Boolean bl, Boolean bl2) {
        return orTable[EvaluatorImpl.ttIndex(bl)][EvaluatorImpl.ttIndex(bl2)];
    }

    public static Boolean not(Boolean bl) {
        if (bl == null) {
            return null;
        }
        if (bl.equals(Boolean.TRUE)) {
            return Boolean.FALSE;
        }
        if (bl.equals(Boolean.FALSE)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static int compare(Number number, Number number2) {
        int n;
        int n2 = EvaluatorImpl.getType(number);
        int n3 = n2 >= (n = EvaluatorImpl.getType(number2)) ? n2 : n;
        switch (n3) {
            case 0: {
                int n4 = number.intValue();
                int n5 = number2.intValue();
                return n4 < n5 ? -1 : (n4 == n5 ? 0 : 1);
            }
            case 1: {
                long l = number.longValue();
                long l2 = number2.longValue();
                return l < l2 ? -1 : (l == l2 ? 0 : 1);
            }
            case 2: {
                float f = number.floatValue();
                float f2 = number2.floatValue();
                return f < f2 ? -1 : (f == f2 ? 0 : 1);
            }
            case 3: {
                double d = number.doubleValue();
                double d2 = number2.doubleValue();
                return d < d2 ? -1 : (d == d2 ? 0 : 1);
            }
        }
        throw new IllegalStateException();
    }

    public static int getType(Number number) {
        if (number instanceof Integer) {
            return 0;
        }
        if (number instanceof Long) {
            return 1;
        }
        if (number instanceof Short) {
            return -1;
        }
        if (number instanceof Byte) {
            return -2;
        }
        if (number instanceof Double) {
            return 3;
        }
        if (number instanceof Float) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    private static Number neg(Number number) {
        switch (EvaluatorImpl.getType(number)) {
            case 0: {
                return new Integer(-number.intValue());
            }
            case 1: {
                return new Long(-number.longValue());
            }
            case 2: {
                return new Float(-number.floatValue());
            }
            case 3: {
                return new Double(-number.doubleValue());
            }
        }
        throw new IllegalStateException();
    }

    private static Number plus(Number number, Number number2) {
        int n;
        int n2 = EvaluatorImpl.getType(number);
        int n3 = n2 >= (n = EvaluatorImpl.getType(number2)) ? n2 : n;
        switch (n3) {
            case 0: {
                return new Integer(number.intValue() + number2.intValue());
            }
            case 1: {
                return new Long(number.longValue() + number2.longValue());
            }
            case 2: {
                return new Float(number.floatValue() + number2.floatValue());
            }
            case 3: {
                return new Double(number.doubleValue() + number2.doubleValue());
            }
        }
        throw new IllegalStateException();
    }

    private static Number times(Number number, Number number2) {
        int n;
        int n2 = EvaluatorImpl.getType(number);
        int n3 = n2 >= (n = EvaluatorImpl.getType(number2)) ? n2 : n;
        switch (n3) {
            case 0: {
                return new Integer(number.intValue() * number2.intValue());
            }
            case 1: {
                return new Long(number.longValue() * number2.longValue());
            }
            case 2: {
                return new Float(number.floatValue() * number2.floatValue());
            }
            case 3: {
                return new Double(number.doubleValue() * number2.doubleValue());
            }
        }
        throw new IllegalStateException();
    }

    private static Number minus(Number number, Number number2) {
        int n;
        int n2 = EvaluatorImpl.getType(number);
        int n3 = n2 >= (n = EvaluatorImpl.getType(number2)) ? n2 : n;
        switch (n3) {
            case 0: {
                return new Integer(number.intValue() - number2.intValue());
            }
            case 1: {
                return new Long(number.longValue() - number2.longValue());
            }
            case 2: {
                return new Float(number.floatValue() - number2.floatValue());
            }
            case 3: {
                return new Double(number.doubleValue() - number2.doubleValue());
            }
        }
        throw new IllegalStateException();
    }

    private static Number div(Number number, Number number2) {
        int n;
        int n2 = EvaluatorImpl.getType(number);
        int n3 = n2 >= (n = EvaluatorImpl.getType(number2)) ? n2 : n;
        switch (n3) {
            case 0: {
                return new Integer(number.intValue() / number2.intValue());
            }
            case 1: {
                return new Long(number.longValue() / number2.longValue());
            }
            case 2: {
                return new Float(number.floatValue() / number2.floatValue());
            }
            case 3: {
                return new Double(number.doubleValue() / number2.doubleValue());
            }
        }
        throw new IllegalStateException();
    }

    public static int hash(Object object) {
        int n;
        if (object instanceof Number) {
            long l;
            if (EvaluatorImpl.getType((Number)object) > 1) {
                double d = ((Number)object).doubleValue();
                if (d != (double)(l = (long)d)) {
                    l = Double.doubleToLongBits(d);
                }
            } else {
                l = ((Number)object).longValue();
            }
            n = (int)(l ^ l >> 32);
        } else {
            n = object.hashCode();
        }
        return n;
    }

    public static boolean equals(Object object, Object object2) {
        if (object instanceof Number) {
            if (object2 instanceof Number) {
                return EvaluatorImpl.compare((Number)object, (Number)object2) == 0;
            }
            return false;
        }
        return object.equals(object2);
    }
}

