/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.matchspace.Conjunction;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.SimpleTest;
import com.ibm.ws.sib.matchspace.impl.BooleanMatcher;
import com.ibm.ws.sib.matchspace.impl.ContentMatcher;
import com.ibm.ws.sib.matchspace.impl.DifficultMatcher;
import com.ibm.ws.sib.matchspace.impl.EqualityMatcher;
import com.ibm.ws.sib.matchspace.impl.NumericMatcher;
import com.ibm.ws.sib.matchspace.impl.SimpleMatcher;
import com.ibm.ws.sib.matchspace.impl.StringMatcher;
import com.ibm.ws.sib.utils.ras.SibTr;

final class Factory {
    private static final TraceComponent tc = SibTr.register((Class)Factory.class, (String)"SIBMatchSpace", (String)"com.ibm.ws.sib.matchspace.CWSIHMessages");

    private Factory() {
    }

    static ContentMatcher createMatcher(int n, Conjunction conjunction, ContentMatcher contentMatcher) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMatcher", (Object)("lastOrdinalPosition: " + new Integer(n) + ",selector: " + conjunction + ", oldmatcher: " + contentMatcher));
        }
        if (contentMatcher instanceof DifficultMatcher) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"createMatcher", (Object)("Reusing old DifficultMatcher with position: " + contentMatcher.ordinalPosition + " for position " + n));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createMatcher");
            }
            return contentMatcher;
        }
        if (contentMatcher != null && contentMatcher.ordinalPosition < n) {
            throw new IllegalStateException();
        }
        if (conjunction != null) {
            for (int i = 0; i < conjunction.getSimpleTests().length; ++i) {
                int n2 = conjunction.getSimpleTests()[i].getIdentifier().getOrdinalPosition();
                if (contentMatcher != null && n2 >= contentMatcher.ordinalPosition) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"createMatcher", (Object)("Reusing " + contentMatcher.getClass().getName() + " for position: " + n + "; next test is at: " + n2));
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"createMatcher");
                    }
                    return contentMatcher;
                }
                if (n2 <= n) continue;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"createMatcher", (Object)("Creating new matcher at position " + n2));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createMatcher");
                }
                return Factory.createMatcher(conjunction.getSimpleTests()[i], contentMatcher);
            }
        }
        DifficultMatcher difficultMatcher = new DifficultMatcher(n);
        if (tc.isDebugEnabled()) {
            if (contentMatcher != null) {
                SibTr.debug((TraceComponent)tc, (String)"createMatcher", (Object)("New DifficultMatcher at position " + n + " with successor " + contentMatcher.getClass().getName() + " at position " + contentMatcher.ordinalPosition));
            } else {
                SibTr.debug((TraceComponent)tc, (String)"createMatcher", (Object)("New DifficultMatcher at position " + n + " with null successor."));
            }
        }
        difficultMatcher.vacantChild = contentMatcher;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMatcher");
        }
        return difficultMatcher;
    }

    private static ContentMatcher createMatcher(SimpleTest simpleTest, ContentMatcher contentMatcher) {
        SimpleMatcher simpleMatcher;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMatcher", (Object)("test: " + simpleTest + ", oldmatcher: " + contentMatcher));
        }
        Identifier identifier = simpleTest.getIdentifier();
        switch (identifier.getType()) {
            case -6: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"createMatcher", (Object)("New BooleanMatcher for id " + identifier.getName()));
                }
                simpleMatcher = new BooleanMatcher(identifier);
                break;
            }
            case -7: 
            case 0: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"createMatcher", (Object)("New EqualityMatcher for id " + identifier.getName()));
                }
                simpleMatcher = new EqualityMatcher(identifier);
                break;
            }
            case -5: 
            case 3: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"createMatcher", (Object)("New StringMatcher for id " + identifier.getName()));
                }
                simpleMatcher = new StringMatcher(identifier);
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"createMatcher", (Object)("New NumericMatcher for id " + identifier.getName()));
                }
                simpleMatcher = new NumericMatcher(identifier);
            }
        }
        simpleMatcher.vacantChild = contentMatcher;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMatcher");
        }
        return simpleMatcher;
    }

    static SimpleTest findTest(int n, Conjunction conjunction) {
        if (conjunction == null) {
            return null;
        }
        for (int i = 0; i < conjunction.getSimpleTests().length; ++i) {
            SimpleTest simpleTest = conjunction.getSimpleTests()[i];
            if (simpleTest.getIdentifier().getOrdinalPosition() != n) continue;
            return simpleTest;
        }
        return null;
    }
}

