/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ibl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.cred.AuthDataCredential;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsEObject;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.ibl.InterBusLink;
import com.ibm.ws.sib.trm.TrmMeMain;
import com.ibm.ws.sib.trm.links.ibl.InterBusLinkConfig;
import com.ibm.ws.sib.trm.links.ibl.InterBusLinkManager;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class InterBusLinkImpl
implements InterBusLink {
    private static final String className = InterBusLinkImpl.class.getName();
    private static final TraceComponent tc = SibTr.register((String)className, (String)"SIBIbl", (String)"com.ibm.ws.sib.ibl.CWSJBMessages");
    private static final String ATTR_NAME = "name";
    private static final String ATTR_UUID = "targetUuid";
    private static final String ATTR_REMOTE_ME = "remoteMessagingEngineName";
    private static final String ATTR_PROTOCOL = "protocolName";
    private static final String ATTR_BOOTSTRAP = "bootstrapEndpoints";
    private static final String ATTR_AUTHALIAS = "authAlias";
    private static final String ATTR_INITSTATE = "initialState";
    private String remoteBus;
    private String linkName;
    private SIBUuid12 linkUuid;
    private String remote_me_name;
    private String transportChain;
    private String bootstrap;
    private String authAlias;
    private boolean initState;
    private RuntimeEventListener runtimeEventListener;
    private JsMessagingEngine jsme;
    private InterBusLinkManager interBusLinkManager;
    private boolean recovery = false;

    public void initialize(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("engine=" + jsMessagingEngine));
        }
        this.jsme = jsMessagingEngine;
        JsBus jsBus = (JsBus)this.jsme.getBus();
        ForeignBusDefinition foreignBusDefinition = jsBus.getForeignBusForLink(this.linkUuid.toString());
        this.remoteBus = foreignBusDefinition.getName();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("remoteBus=" + this.remoteBus + ",linkName=" + this.linkName + ",linkUuid=" + this.linkUuid + ",remote_me_name=" + this.remote_me_name + ",transportChain=" + this.transportChain + ",bootstrap=" + this.bootstrap + ",authAlias=" + this.authAlias));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void start(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)("mode=" + n));
        }
        if ((n & 2) == 2) {
            this.recovery = true;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("recovery=" + this.recovery));
        }
        TrmMeMain trmMeMain = (TrmMeMain)this.jsme.getEngineComponent("com.ibm.ws.sib.trm.TrmMeMainImpl");
        this.interBusLinkManager = trmMeMain.getInterBusLinkManager();
        String string = "";
        String string2 = "";
        AuthDataCredential authDataCredential = null;
        if (this.authAlias != null && !this.authAlias.equals("")) {
            try {
                authDataCredential = WSDefaultPrincipalMapping.getAuthData((String)this.authAlias);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(className + ".start"), (String)"1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
            if (authDataCredential != null && authDataCredential.getStatus() == 0) {
                try {
                    string = authDataCredential.getUserName();
                    string2 = authDataCredential.getPassword();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(className + ".start"), (String)"2", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                    SibTr.warning((TraceComponent)tc, (String)"UNABLE_TO_OBTAIN_AUTHDATA_CWSJB0001", (Object)new Object[]{this.authAlias, this.linkName, this.jsme.getName()});
                }
            } else {
                SibTr.warning((TraceComponent)tc, (String)"UNABLE_TO_OBTAIN_AUTHDATA_CWSJB0001", (Object)new Object[]{this.authAlias, this.linkName, this.jsme.getName()});
            }
        } else {
            SibTr.warning((TraceComponent)tc, (String)"NO_AUTHALIAS_CWSJB0002", (Object)new Object[]{this.linkName, this.jsme.getName()});
        }
        if (this.initState && this.recovery) {
            SibTr.info((TraceComponent)tc, (String)"RECOVERY_MODE_CWSJB0003", (Object)new Object[]{this.linkName});
            this.initState = false;
        }
        InterBusLinkConfig interBusLinkConfig = new InterBusLinkConfig(this.remote_me_name, this.remoteBus, this.linkName, this.transportChain, this.bootstrap, string, string2, this.linkUuid, this.initState, this.getRuntimeEventListener());
        try {
            this.interBusLinkManager.define(interBusLinkConfig);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(className + ".start"), (String)"3", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("mode=" + n));
        }
        try {
            this.interBusLinkManager.undefine(this.linkUuid);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(className + ".stop"), (String)"6", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        this.interBusLinkManager = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destroy");
        }
        this.linkUuid = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public void setCustomProperty(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCustomProperty");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("name=" + string + ",value=" + string2));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCustomProperty");
        }
    }

    public void setAttribute(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAttribute");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("key=" + string + ",value=" + string2));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAttribute");
        }
    }

    public void serverStarted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"serverStarted");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"serverStarted");
        }
    }

    public void serverStopping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"serverStopping");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"serverStopping");
        }
    }

    public void busReloaded(SIBus sIBus, boolean bl, boolean bl2, boolean bl3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"busReloaded");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"busReloaded");
        }
    }

    public void engineReloaded(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"engineReloaded");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"engineReloaded");
        }
    }

    public void setRuntimeEventListener(RuntimeEventListener runtimeEventListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRuntimeEventListener");
        }
        this.runtimeEventListener = runtimeEventListener;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRuntimeEventListener");
        }
    }

    public RuntimeEventListener getRuntimeEventListener() {
        return this.runtimeEventListener;
    }

    public void configure(JsEObject jsEObject) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"configure");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("config=" + jsEObject));
        }
        String[] stringArray = jsEObject.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = jsEObject.getAttribute(string);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("key=" + string + ",value=" + string2));
            }
            if (string.equals(ATTR_NAME)) {
                this.linkName = string2;
                continue;
            }
            if (string.equals(ATTR_UUID)) {
                this.linkUuid = new SIBUuid12(string2);
                continue;
            }
            if (string.equals(ATTR_REMOTE_ME)) {
                this.remote_me_name = string2;
                continue;
            }
            if (string.equals(ATTR_PROTOCOL)) {
                this.transportChain = string2;
                continue;
            }
            if (string.equals(ATTR_BOOTSTRAP)) {
                this.bootstrap = string2;
                continue;
            }
            if (string.equals(ATTR_AUTHALIAS)) {
                this.authAlias = string2;
                continue;
            }
            if (!string.equals(ATTR_INITSTATE)) continue;
            this.initState = string2.equals("STARTED");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"configure");
        }
    }

    public void startLink() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startLink");
        }
        if (!this.isLinkStarted()) {
            if (this.recovery) {
                SibTr.info((TraceComponent)tc, (String)"RECOVERY_MODE_CWSJB0003", (Object)new Object[]{this.linkName});
            } else {
                try {
                    this.interBusLinkManager.start(this.linkUuid);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(className + ".startLink"), (String)"4", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startLink");
        }
    }

    public void stopLink() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopLink");
        }
        if (this.isLinkStarted()) {
            try {
                this.interBusLinkManager.stop(this.linkUuid);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(className + ".stopLink"), (String)"5", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopLink");
        }
    }

    public boolean isLinkStarted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLinkStarted");
        }
        boolean bl = this.interBusLinkManager.isStarted(this.linkUuid);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + bl));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isLinkStarted");
        }
        return bl;
    }

    public boolean isLinkActive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLinkActive");
        }
        boolean bl = this.interBusLinkManager.isActive(this.linkUuid);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + bl));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isLinkActive");
        }
        return bl;
    }
}

