/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.sib.utils.ras.SibTr;

public class MQTimer
implements AlarmListener {
    static final TraceComponent tc = SibTr.register((Class)MQTimer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private long[] reqTime;
    private boolean[] timerEnabled;
    private long[] timerInterval;
    private int numTimers;
    private Alarm alarm;
    private long alarmTime;
    private AlarmListener listener;

    public MQTimer(AlarmListener alarmListener, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{alarmListener, "" + n});
        }
        this.listener = alarmListener;
        this.numTimers = n;
        this.reqTime = new long[n];
        this.timerInterval = new long[n];
        this.timerEnabled = new boolean[n];
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public void setListener(AlarmListener alarmListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setListener ", (Object)("listener = " + alarmListener));
        }
        this.listener = alarmListener;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setListener");
        }
    }

    public synchronized void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm", (Object)("arg = " + object));
        }
        long l = System.currentTimeMillis();
        this.alarm = null;
        for (int i = 0; i < this.numTimers; ++i) {
            if (!this.timerEnabled[i] || this.reqTime[i] == 0L || l < this.reqTime[i]) continue;
            this.timerEnabled[i] = false;
            this.listener.alarm((Object)new Integer(i));
        }
        this.startAlarm(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"alarm");
        }
    }

    public synchronized void startAlarm(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"startAlarm", (Object)("now = " + l));
        }
        long l2 = 0L;
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        for (int i = 0; i < this.numTimers; ++i) {
            if (!this.timerEnabled[i] || this.reqTime[i] == 0L) continue;
            if (l2 == 0L) {
                l2 = this.reqTime[i];
                continue;
            }
            if (this.reqTime[i] >= l2) continue;
            l2 = this.reqTime[i];
        }
        if (l2 > 0L) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("requiredAlarm = " + l2));
            }
            if (this.alarm != null) {
                if (this.alarmTime < l2 + 100L) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"startAlarm");
                    }
                    return;
                }
                this.alarm.cancel();
                this.alarm = null;
            }
            long l3 = l2 - l;
            this.alarm = AlarmManager.createNonDeferrable((long)l3, (AlarmListener)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Started a new alarm with interval = " + l3));
            }
            this.alarmTime = l2;
        } else if (this.alarm != null) {
            this.alarm.cancel();
            this.alarm = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"startAlarm");
        }
    }

    public synchronized void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        if (this.alarm != null) {
            this.alarm.cancel();
        }
        this.alarm = null;
        for (int i = 0; i < this.numTimers; ++i) {
            this.timerEnabled[i] = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    public void enable(int n, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"enable", (Object)new Object[]{"" + n, "" + l});
        }
        long l2 = System.currentTimeMillis();
        this.timerInterval[n] = l;
        this.reqTime[n] = l2 + l > 0L ? l2 + l : Long.MAX_VALUE;
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("requiredTime = " + this.reqTime[n]));
        }
        this.timerEnabled[n] = true;
        this.startAlarm(l2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"enable");
        }
    }

    public void restart(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"restart", (Object)("timerType = " + n));
        }
        this.enable(n, this.timerInterval[n]);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"restart");
        }
    }

    public void disable(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"disable", (Object)("timerType = " + n));
        }
        this.timerEnabled[n] = false;
        this.startAlarm(0L);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"disable");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/util/MQTimer.java, SIB.comms, WAS602.SIB, o0610.11 1.9");
        }
    }
}

