/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine;
import com.ibm.ws.sib.comms.mq.client.MQException;
import com.ibm.ws.sib.comms.mq.client.MQHObject;
import com.ibm.ws.sib.comms.mq.client.MQHandleStore;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.comms.mq.util.MQUtil;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsMessageFactory;
import com.ibm.ws.sib.mfp.MQJsMessageEncoder;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.mqinterop.CCSID;
import com.ibm.ws.sib.mfp.mqinterop.MQBufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.MQHeaderFactory;
import com.ibm.ws.sib.mfp.mqinterop.api.MQMD1;
import com.ibm.ws.sib.mfp.mqinterop.api.MQPMO;
import com.ibm.ws.sib.mfp.mqinterop.api.MQRFH2;
import com.ibm.ws.sib.mfp.mqinterop.api.MQXQH;
import com.ibm.ws.sib.mfp.mqinterop.fap.ErrorData;
import com.ibm.ws.sib.mfp.mqinterop.fap.InitData;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQAPI;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQClose;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQConn;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQFAP;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQGet;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQInq;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQOpen;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQPut;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQPut1;
import com.ibm.ws.sib.mfp.mqinterop.fap.MSH;
import com.ibm.ws.sib.mfp.mqinterop.fap.PingData;
import com.ibm.ws.sib.mfp.mqinterop.fap.Reset;
import com.ibm.ws.sib.mfp.mqinterop.fap.Resync;
import com.ibm.ws.sib.mfp.mqinterop.fap.SecurityData;
import com.ibm.ws.sib.mfp.mqinterop.fap.TSH;
import com.ibm.ws.sib.mfp.mqinterop.fap.UseridData;
import com.ibm.ws.sib.mfp.mqinterop.spi.InSPI;
import com.ibm.ws.sib.mfp.mqinterop.spi.OutSPI;
import com.ibm.ws.sib.mfp.mqinterop.xa.XaComplete;
import com.ibm.ws.sib.mfp.mqinterop.xa.XaId;
import com.ibm.ws.sib.mfp.mqinterop.xa.XaIds;
import com.ibm.ws.sib.mfp.mqinterop.xa.XaIdsCount;
import com.ibm.ws.sib.mfp.mqinterop.xa.XaInfo;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.mqfapchannel.ConnectionManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

public class MQFap
implements MQFAP,
MQConstants {
    private static final TraceComponent tc = SibTr.register((Class)MQFap.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private byte segmentType;
    private TSH tsh;
    private InitData initData;
    private Reset resetData;
    private Resync resyncData;
    private UseridData useridData;
    private SecurityData securityData;
    private ErrorData errorData;
    private PingData pingData;
    private MQAPI mqapi;
    private MQConn mqconn;
    private MQOpen mqopen;
    private MQClose mqclose;
    private MQGet mqget;
    private MQPut mqput;
    private MQPut1 mqput1;
    private MQInq mqinq;
    private MSH msh;
    private XaInfo xaInfo;
    private XaId xaId;
    private XaIdsCount xaIdsCount;
    private XaIds xaIds;
    private XaComplete xaComplete;
    private InSPI spiIn;
    private OutSPI spiOut;
    private MQMD1 mqmd;
    private WsByteBuffer firstMessageSegment;
    private MQRFH2 rfh;
    private byte encoding;
    private short ccsid;
    private MQBufferedHeader header1;
    private MQBufferedHeader header2;
    private WsByteBuffer data;
    private ArrayList dataList;
    private MQHeaderFactory factory;
    private boolean preserveBufferAfterSend;
    private byte idFlags;
    private boolean unSupportedCCSID;

    public MQFap() {
        this.idFlags = 0;
        this.unSupportedCCSID = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MQFap");
        }
        this.factory = MQHeaderFactory.instance();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MQFap");
        }
    }

    public MQFap(byte by, byte by2, byte by3, short s) {
        this.idFlags = 0;
        this.unSupportedCCSID = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MQFap");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("SegmentType: " + MQUtil.getSegmentTypeConstant(by) + " : " + "0x" + Integer.toHexString(by & 0xFF).toUpperCase()));
        }
        this.factory = MQHeaderFactory.instance();
        this.tsh = this.factory.createTSH(0, by3, by, by2);
        this.tsh.setCCSID(s);
        this.segmentType = by;
        switch (by) {
            case 1: {
                this.initData = this.factory.createInitData();
                this.header1 = this.initData;
                this.tsh.setTransLength(this.tsh.size() + this.initData.size());
                break;
            }
            case 3: {
                this.resetData = this.factory.createReset();
                this.header1 = this.resetData;
                this.tsh.setTransLength(this.tsh.size() + this.resetData.size());
                break;
            }
            case 2: {
                this.resyncData = this.factory.createResync();
                this.header1 = this.resyncData;
                this.tsh.setTransLength(this.tsh.size() + this.resyncData.size());
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.useridData = this.factory.createUseridData();
                this.header1 = this.useridData;
                this.tsh.setTransLength(this.tsh.size() + this.useridData.size());
                break;
            }
            case 6: {
                this.securityData = this.factory.createSecurityData();
                this.header1 = this.securityData;
                this.tsh.setTransLength(this.tsh.size() + this.securityData.size());
                break;
            }
            case 5: 
            case 9: {
                this.tsh.setTransLength(this.tsh.size());
                break;
            }
            case -122: 
            case -121: 
            case -106: 
            case -105: {
                break;
            }
            default: {
                SibTr.error((TraceComponent)tc, (String)"ERR_MQLINK_SEGMENT_SICO3239", (Object)new Integer(this.segmentType));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MQFap");
        }
    }

    public MQFap(WsByteBuffer wsByteBuffer) throws IOException {
        this(wsByteBuffer, 0);
    }

    public MQFap(WsByteBuffer wsByteBuffer, int n) throws IOException {
        block51: {
            this.idFlags = 0;
            this.unSupportedCCSID = false;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"MQFap");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("FapLevel = " + n));
            }
            this.data = wsByteBuffer;
            wsByteBuffer.rewind();
            this.factory = MQHeaderFactory.instance();
            this.tsh = this.factory.createTSH(wsByteBuffer);
            this.segmentType = this.tsh.getSegmentType();
            int n2 = this.tsh.nextEncoding();
            int n3 = this.tsh.nextCharacterSet();
            this.encoding = (byte)this.tsh.getMQEncoding();
            this.ccsid = this.tsh.getCCSID();
            try {
                block2 : switch (this.segmentType) {
                    case 1: {
                        this.idFlags = wsByteBuffer.get(wsByteBuffer.position() + 5);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("idFlags = " + Integer.toHexString(this.idFlags)));
                        }
                        try {
                            if (this.ccsid != 1208) {
                                CCSID.getCodepage((int)this.ccsid);
                            }
                            this.initData = this.factory.createInitData(wsByteBuffer, n2, (int)this.ccsid);
                            this.header1 = this.initData;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"Caught an UnsupportedEncodingException", (Object)unsupportedEncodingException);
                            }
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Tsh.Encoding = " + n2 + " Tsh.CCSID = " + this.ccsid + " Tsh.nextCharacterSet = " + n3));
                            }
                            this.unSupportedCCSID = true;
                        }
                        break;
                    }
                    case 5: {
                        if ((this.tsh.getControlFlags1() & 2) != 0 && this.tsh.getTransLength() > this.tsh.size()) {
                            this.errorData = this.factory.createErrorData(wsByteBuffer, n2, n3);
                            this.header1 = this.errorData;
                        }
                        break;
                    }
                    case 3: {
                        this.resetData = this.factory.createReset(wsByteBuffer, n2, n3);
                        this.header1 = this.resetData;
                        break;
                    }
                    case 2: {
                        this.resyncData = this.factory.createResync(wsByteBuffer, n2, n3);
                        this.header1 = this.resyncData;
                        break;
                    }
                    case 8: {
                        this.useridData = this.factory.createUseridData(n, wsByteBuffer, n2, n3);
                        this.header1 = this.useridData;
                        break;
                    }
                    case 6: {
                        this.securityData = this.factory.createSecurityData(wsByteBuffer, n2, n3);
                        this.header1 = this.securityData;
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 4: {
                        this.msh = this.factory.createMSH(wsByteBuffer, n2, n3);
                        break;
                    }
                    case 7: {
                        this.pingData = this.factory.createPingData(wsByteBuffer, n2, n3);
                        this.header1 = this.pingData;
                        break;
                    }
                    case -127: 
                    case -126: 
                    case -125: 
                    case -124: 
                    case -123: 
                    case -120: 
                    case -119: 
                    case -118: 
                    case -117: 
                    case -116: 
                    case -95: 
                    case -94: 
                    case -93: 
                    case -92: 
                    case -91: 
                    case -90: 
                    case -89: 
                    case -88: 
                    case -87: 
                    case -86: {
                        this.mqapi = this.factory.createMQAPI(this.tsh, wsByteBuffer);
                        this.header1 = this.mqapi;
                        switch (this.segmentType) {
                            case -127: {
                                this.mqconn = this.factory.createMQConn(wsByteBuffer, n2, n3);
                                this.header2 = this.mqconn;
                                break block2;
                            }
                            case -126: {
                                break block2;
                            }
                            case -125: {
                                this.mqopen = this.factory.createMQOpen(wsByteBuffer, n2, n3);
                                this.header2 = this.mqopen;
                                break block2;
                            }
                            case -124: {
                                this.mqclose = this.factory.createMQClose(wsByteBuffer, n2, n3);
                                this.header2 = this.mqclose;
                                break block2;
                            }
                            case -123: {
                                this.mqget = this.factory.createMQGet(wsByteBuffer, n2, n3);
                                this.header2 = this.mqget;
                                this.mqmd = this.mqget.getMsgDesc();
                                break block2;
                            }
                            case -120: {
                                break block2;
                            }
                            case -119: {
                                this.mqinq = this.factory.createMQInq(wsByteBuffer, n2, n3);
                                this.header2 = this.mqinq;
                                break block2;
                            }
                            case -118: {
                                break block2;
                            }
                            case -117: {
                                break block2;
                            }
                            case -116: {
                                this.spiIn = this.factory.createInSPI(wsByteBuffer, n2, n3);
                                this.header2 = this.spiIn;
                                break block2;
                            }
                            case -95: {
                                this.xaId = this.factory.createXaId(wsByteBuffer, n2, n3);
                                this.header2 = this.xaId;
                                break block2;
                            }
                            case -94: {
                                this.xaId = this.factory.createXaId(wsByteBuffer, n2, n3);
                                this.header2 = this.xaId;
                                break block2;
                            }
                            case -93: {
                                this.xaInfo = this.factory.createXaInfo(wsByteBuffer, n2, n3);
                                this.header2 = this.xaInfo;
                                break block2;
                            }
                            case -92: {
                                this.xaInfo = this.factory.createXaInfo(wsByteBuffer, n2, n3);
                                this.header2 = this.xaInfo;
                                break block2;
                            }
                            case -91: {
                                this.xaId = this.factory.createXaId(wsByteBuffer, n2, n3);
                                this.header2 = this.xaId;
                                break block2;
                            }
                            case -90: {
                                this.xaId = this.factory.createXaId(wsByteBuffer, n2, n3);
                                this.header2 = this.xaId;
                                break block2;
                            }
                            case -89: {
                                this.xaId = this.factory.createXaId(wsByteBuffer, n2, n3);
                                this.header2 = this.xaId;
                                break block2;
                            }
                            case -88: {
                                this.xaId = this.factory.createXaId(wsByteBuffer, n2, n3);
                                this.header2 = this.xaId;
                                break block2;
                            }
                            case -87: {
                                this.xaIdsCount = this.factory.createXaIdsCount(wsByteBuffer, n2, n3);
                                this.header2 = this.xaIdsCount;
                                break block2;
                            }
                            case -86: {
                                this.xaComplete = this.factory.createXaComplete(wsByteBuffer, n2, n3);
                                this.header2 = this.xaComplete;
                                break block2;
                            }
                        }
                        SibTr.error((TraceComponent)tc, (String)"ERR_MQLINK_SEGMENT_SICO3239", (Object)new Integer(this.segmentType));
                        break;
                    }
                    case -122: 
                    case -121: {
                        if ((this.tsh.getControlFlags1() & 0x10) != 0) {
                            this.mqapi = this.factory.createMQAPI(this.tsh, wsByteBuffer);
                            this.header1 = this.mqapi;
                            if (this.segmentType == -122) {
                                this.mqput = this.factory.createMQPut(wsByteBuffer, n2, n3);
                                this.header2 = this.mqput;
                                this.mqmd = this.mqput.getMsgDesc();
                            } else {
                                this.mqput1 = this.factory.createMQPut1(wsByteBuffer, n2, n3);
                                this.header2 = this.mqput1;
                                this.mqmd = this.mqput1.getMsgDesc();
                            }
                            if (this.mqmd.getFormat().trim().equals("MQHRF2") && wsByteBuffer.hasRemaining()) {
                                this.rfh = this.factory.createMQRFH2(wsByteBuffer, this.mqmd.nextEncoding(), this.mqmd.nextCharacterSet());
                            }
                            this.firstMessageSegment = wsByteBuffer.slice();
                        }
                        break;
                    }
                    default: {
                        SibTr.error((TraceComponent)tc, (String)"ERR_MQLINK_SEGMENT_SICO3239", (Object)new Integer(this.segmentType));
                        break;
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block51;
                SibTr.debug((TraceComponent)tc, (String)"Caught an MQException", (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MQFap");
        }
    }

    public MQFap(ArrayList arrayList, int n) throws IOException {
        this((WsByteBuffer)arrayList.get(0), n);
        this.dataList = arrayList;
        this.data = null;
    }

    public void addSegment(MQFap mQFap) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)("addSegment: " + MQUtil.getSegmentTypeConstant(this.segmentType) + " : " + "0x" + Integer.toHexString(this.segmentType & 0xFF).toUpperCase()));
        }
        if (this.segmentType != 4 && this.segmentType != -122 && this.segmentType != -121 || mQFap.data == null) {
            throw new IOException();
        }
        if (this.dataList == null) {
            this.dataList = new ArrayList();
        }
        mQFap.data.rewind();
        this.dataList.add(mQFap.data);
        mQFap.data = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSegment");
        }
    }

    public void release() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"release");
        }
        if (this.data != null) {
            this.data.release();
        }
        if (this.dataList != null) {
            for (int i = 0; i < this.dataList.size(); ++i) {
                WsByteBuffer wsByteBuffer = (WsByteBuffer)this.dataList.get(i);
                wsByteBuffer.release();
            }
        }
        this.data = null;
        this.dataList = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"release");
        }
    }

    public TSH getTsh() {
        return this.tsh;
    }

    public InitData getInitData() {
        return this.initData;
    }

    public Reset getReset() {
        return this.resetData;
    }

    public Resync getResync() {
        return this.resyncData;
    }

    public MSH getMsh() {
        return this.msh;
    }

    public UseridData getUseridData() {
        return this.useridData;
    }

    public SecurityData getSecurityData() {
        return this.securityData;
    }

    public ErrorData getErrorData() {
        return this.errorData;
    }

    public PingData getPingData() {
        return this.pingData;
    }

    public MQAPI getMQAPI() {
        return this.mqapi;
    }

    public MQConn getMQConn() {
        return this.mqconn;
    }

    public MQOpen getMQOpen() {
        return this.mqopen;
    }

    public MQClose getMQClose() {
        return this.mqclose;
    }

    public MQGet getMQGet() {
        return this.mqget;
    }

    public MQInq getMQInq() {
        return this.mqinq;
    }

    public MQPut getMQPut() {
        return this.mqput;
    }

    public MQPut1 getMQPut1() {
        return this.mqput1;
    }

    public XaId getXaId() {
        return this.xaId;
    }

    public XaIdsCount getXaIdsCount() {
        return this.xaIdsCount;
    }

    public XaInfo getXaInfo() {
        return this.xaInfo;
    }

    public XaComplete getXaComplete() {
        return this.xaComplete;
    }

    public MQRFH2 getRFH2() {
        return this.rfh;
    }

    public MQMD1 getMQMD() {
        return this.mqmd;
    }

    public InSPI getInSPI() {
        return this.spiIn;
    }

    public OutSPI getOutSPI() {
        return this.spiOut;
    }

    public byte getSegmentType() {
        return this.segmentType;
    }

    public byte getEncoding() {
        return this.encoding;
    }

    public short getCCSID() {
        return this.ccsid;
    }

    public WsByteBuffer getData() {
        return this.data;
    }

    public byte getIdFlags() {
        return this.idFlags;
    }

    public boolean isUnsupportedCCSID() {
        return this.unSupportedCCSID;
    }

    public void setMQMD(MQMD1 mQMD1) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMQMD");
        }
        this.mqmd = mQMD1;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMQMD");
        }
    }

    public void setXaIds(XaIds xaIds) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setXaIds");
        }
        this.xaIds = xaIds;
        this.header2 = this.xaIds;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setXaIds");
        }
    }

    public void createStatus(byte by, int n, Integer n2, byte by2, short s) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStatus");
        }
        this.header2 = null;
        this.header1 = null;
        if (n != 0) {
            by = (byte)(by | 2);
        }
        if (this.tsh == null) {
            this.tsh = this.factory.createTSH(0, by2, (byte)5, by);
            this.segmentType = (byte)5;
        } else {
            this.tsh.setSegmentType((byte)5);
            this.tsh.setControlFlags1(by);
            this.tsh.setEncoding(by2);
        }
        this.tsh.setCCSID(s);
        if (n != 0) {
            this.errorData = this.factory.createErrorData();
            this.header1 = this.errorData;
            this.errorData.setReturnCode(n);
            if (n2 != null) {
                this.errorData.setUserData(n2.intValue());
            }
            this.tsh.setTransLength(this.tsh.size() + this.errorData.size());
            this.writeHeaders();
        } else {
            this.tsh.setTransLength(this.tsh.size());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStatus");
        }
    }

    public void createErrorStatus(byte by, byte by2, short s) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createErrorStatus");
        }
        by = (byte)(by | 2);
        this.tsh.setSegmentType((byte)5);
        this.tsh.setControlFlags1(by);
        this.tsh.setEncoding(by2);
        this.tsh.setCCSID(s);
        this.tsh.setTransLength(this.tsh.size());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createErrorStatus");
        }
    }

    public MQFap createAPIReply() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createAPIReply");
        }
        MQFap mQFap = new MQFap(this.tsh.getSegmentType(), this.tsh.getControlFlags1(), this.tsh.getEncoding(), this.tsh.getCCSID());
        mQFap.tsh = this.tsh;
        mQFap.header1 = this.header1;
        mQFap.header2 = this.header2;
        mQFap.mqapi = this.mqapi;
        mQFap.mqput = this.mqput;
        mQFap.mqput1 = this.mqput1;
        mQFap.mqmd = this.mqmd;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createAPIReply");
        }
        return mQFap;
    }

    public void writeRFH(MQRFH2 mQRFH2) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeRFH");
        }
        if (this.segmentType != -122 && this.segmentType != -121 && this.segmentType != -107 && this.segmentType != 4) {
            this.writeHeaders();
        } else {
            this.rfh = mQRFH2;
            if (this.dataList == null) {
                this.dataList = new ArrayList(1);
                this.dataList.add(this.data);
            } else {
                this.data = (WsByteBuffer)this.dataList.get(0);
            }
            int n = this.tsh.size();
            if (this.header1 != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("header1 length = " + this.header1.size()));
                }
                n += this.header1.size();
            }
            if (this.header2 != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("header2 length = " + this.header2.size()));
                }
                n += this.header2.size();
            }
            if (mQRFH2 != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("rfh2 length = " + mQRFH2.size()));
                }
                n += mQRFH2.size();
            }
            if (this.firstMessageSegment != null) {
                n += this.firstMessageSegment.limit();
            }
            this.tsh.setTransLength(n);
            WsByteBuffer wsByteBuffer = this.data;
            if (this.data == null || this.data.capacity() < n) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Buffer is not able to hold data - reallocating");
                }
                wsByteBuffer = this.data;
                this.data = ConnectionManager.getPoolMgr().allocateDirect(n);
                this.dataList.set(0, this.data);
            }
            this.data.rewind();
            this.data.limit(n);
            int n2 = this.tsh.nextEncoding();
            int n3 = this.tsh.nextCharacterSet();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("About to write TSH in encoding = " + n2 + " CCSID = " + n3));
            }
            this.tsh.write(this.data, n2, n3);
            if (this.header1 != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("About to write Header1 in encoding = " + n2 + " CCSID = " + n3));
                }
                this.header1.write(this.data, n2, n3);
                n2 = this.header1.nextEncoding();
                n3 = this.header1.nextCharacterSet();
            }
            if (this.header2 != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("About to write header2 in encoding = " + n2 + " CCSID = " + n3));
                }
                this.header2.write(this.data, n2, n3);
                n2 = this.header2.nextEncoding();
                n3 = this.header2.nextCharacterSet();
            }
            if (mQRFH2 != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("About to write RFH in encoding = " + n2 + " CCSID = " + n3));
                }
                mQRFH2.write(this.data, n2, n3);
            }
            if (this.firstMessageSegment != null) {
                this.data.put(this.firstMessageSegment);
            }
            if (wsByteBuffer != null) {
                wsByteBuffer.release();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeRFH");
            }
        }
    }

    public long send(Connection connection) throws SIConnectionLostException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"send");
        }
        long l = 0L;
        try {
            this.writeHeaders();
            if (this.dataList == null) {
                this.dataList = new ArrayList();
                this.dataList.add(this.data);
                this.data = null;
            }
            for (int i = 0; i < this.dataList.size(); ++i) {
                WsByteBuffer wsByteBuffer = (WsByteBuffer)this.dataList.get(i);
                wsByteBuffer.rewind();
                l += (long)(wsByteBuffer.limit() - wsByteBuffer.position());
                if (!tc.isDebugEnabled() || !wsByteBuffer.hasArray()) continue;
                SibTr.bytes((TraceComponent)tc, (byte[])wsByteBuffer.array());
            }
            connection.send(this.dataList, null, !this.preserveBufferAfterSend);
            this.dataList = null;
            this.data = null;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"send", (String)"1", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Caught an IOException", (Object)iOException);
            }
            l = 0L;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("length of data sent = " + l));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"send");
        }
        return l;
    }

    private void writeHeaders() throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeHeaders");
        }
        this.segmentType = this.tsh.getSegmentType();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("SegmentType: " + MQUtil.getSegmentTypeConstant(this.segmentType) + " : " + "0x" + Integer.toHexString(this.segmentType & 0xFF).toUpperCase()));
        }
        if (this.dataList != null && (this.segmentType == 4 || this.segmentType == -122 || this.segmentType == -121 || this.segmentType == -107)) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeHeaders");
            }
            return;
        }
        int n = this.tsh.size();
        if (this.header1 != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("header1 length = " + this.header1.size()));
            }
            n += this.header1.size();
        }
        if (this.header2 != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("header2 length = " + this.header2.size()));
            }
            n += this.header2.size();
        }
        this.tsh.setTransLength(n);
        if (this.mqapi != null) {
            this.mqapi.setCallLength(n);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Tranmission size", (Object)("" + n));
        }
        if (this.dataList != null) {
            while (this.dataList.size() > 1) {
                WsByteBuffer wsByteBuffer = (WsByteBuffer)this.dataList.remove(1);
                wsByteBuffer.release();
            }
            this.data = (WsByteBuffer)this.dataList.get(0);
        }
        if (this.data == null || this.data.capacity() < n) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Buffer is not able to hold data - reallocating");
            }
            this.data = ConnectionManager.getPoolMgr().allocateDirect(n);
        }
        this.data.rewind();
        this.data.limit(n);
        int n2 = this.tsh.nextEncoding();
        int n3 = this.tsh.nextCharacterSet();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("About to write TSH in encoding = " + n2 + " CCSID = " + n3));
        }
        this.tsh.write(this.data, n2, n3);
        if (this.header1 != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("About to write Header1 in encoding = " + n2 + "CCSID = " + n3));
            }
            this.header1.write(this.data, n2, n3);
            n2 = this.header1.nextEncoding();
            n3 = this.header1.nextCharacterSet();
        }
        if (this.header2 != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("About to write Header2 in encoding = " + n2 + " CCSID = " + n3));
            }
            this.header2.write(this.data, n2, n3);
        }
        this.data.flip();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeHeaders");
        }
    }

    public long size() {
        long l;
        block8: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"size");
            }
            l = 0L;
            try {
                if (this.dataList != null) {
                    for (int i = 0; i < this.dataList.size(); ++i) {
                        WsByteBuffer wsByteBuffer = (WsByteBuffer)this.dataList.get(i);
                        wsByteBuffer.rewind();
                        l += (long)(wsByteBuffer.limit() - wsByteBuffer.position());
                    }
                } else {
                    this.writeHeaders();
                    this.data.rewind();
                    l = this.data.limit() - this.data.position();
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"size", (String)"2", (Object)this);
                if (!tc.isDebugEnabled()) break block8;
                SibTr.debug((TraceComponent)tc, (String)"IOException", (Object)iOException);
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("data length = " + l));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"size");
        }
        return l;
    }

    private static String fixedWidthInt(int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fixedWidthInt");
        }
        String string = Integer.toString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        if (string.length() > n2) {
            return string.substring(0, n2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fixedWitdhInt");
        }
        return string;
    }

    public static void setDateAndTime(MQMD1 mQMD1) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDateAndTime");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string = MQFap.fixedWidthInt(gregorianCalendar.get(1), 4);
        string = string + MQFap.fixedWidthInt(gregorianCalendar.get(2) + 1, 2);
        string = string + MQFap.fixedWidthInt(gregorianCalendar.get(5), 2);
        mQMD1.setPutDate(string);
        String string2 = MQFap.fixedWidthInt(gregorianCalendar.get(11), 2);
        string2 = string2 + MQFap.fixedWidthInt(gregorianCalendar.get(12), 2);
        string2 = string2 + MQFap.fixedWidthInt(gregorianCalendar.get(13), 2);
        string2 = string2 + "00";
        mQMD1.setPutTime(string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDateAndTime");
        }
    }

    public JsMessage decodeMessage(Reliability reliability, Reliability reliability2, String string, String string2, String string3, boolean bl, String string4) throws MessageDecodeFailedException, Exception, MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"decodeMessage");
        }
        JsMessageFactory jsMessageFactory = JsMessageFactory.getInstance();
        JsMessage jsMessage = jsMessageFactory.createInboundMQLinkMessage((List)this.dataList, string2, string, string3, reliability2, reliability);
        this.preserveBufferAfterSend = true;
        if (bl) {
            if (string4 != null && string4.trim().length() > 0) {
                jsMessage.setSecurityUserid(string4);
            } else {
                jsMessage.setSecurityUserid("");
            }
        } else if (string4 != null && string4.trim().length() > 0) {
            jsMessage.setSecurityUserid("");
        } else {
            jsMessage.setSecurityUserid("");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"decodeMessage");
        }
        return jsMessage;
    }

    public static MQFap encodeMessage(JsMessage jsMessage, String string, String string2, long l, int n, int n2, byte by, short s, int n3, int n4, boolean bl, String string3) throws IOException {
        Object object;
        String string4;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"encodeMessage");
        }
        if (string3 != null && string3.trim().length() > 0) {
            jsMessage.setApiUserId(string3);
        }
        JsDestinationAddress jsDestinationAddress = jsMessage.getRoutingDestination();
        String string5 = null;
        String string6 = null;
        if (jsDestinationAddress != null) {
            int n5;
            string4 = jsDestinationAddress.getDestinationName();
            object = jsDestinationAddress.getBusName();
            if (string4 != null && (n5 = string4.indexOf(64)) >= 0) {
                string5 = string4.substring(0, n5);
                string6 = string4.substring(n5 + 1);
            } else {
                string5 = string4;
                string6 = object;
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Using destQ=" + string5 + " and destQMgr=" + string6));
        }
        string4 = jsMessage.getMQEncoder(string5, string6, string2, string, (int)by, (int)s);
        object = (ArrayList)string4.encodeForMQLink(n, n2, n4, jsMessage.isMQRFH2Allowed());
        MQFap mQFap = new MQFap((ArrayList)object, 0);
        mQFap.preserveBufferAfterSend = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"encodeMessage");
        }
        return mQFap;
    }

    public JsMessage decodeClientMessage(Reliability reliability, Reliability reliability2, String string, MQHObject mQHObject, MQClientServerStateMachine mQClientServerStateMachine, boolean bl) throws MessageDecodeFailedException, Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"decodeClientMessage");
        }
        this.setContextSecurity(mQHObject, mQClientServerStateMachine);
        JsMessageFactory jsMessageFactory = JsMessageFactory.getInstance();
        JsMessage jsMessage = jsMessageFactory.createInboundMQClientMessage((List)this.dataList, mQClientServerStateMachine.getMQClientLink().getBusName(), mQClientServerStateMachine.getMQClientLink().getVirtualQmgrName(), reliability2, reliability, bl);
        if (this.dataList == null || this.dataList.size() == 0 || this.segmentType != -122 && this.segmentType != -121) {
            throw new MessageDecodeFailedException();
        }
        this.preserveBufferAfterSend = true;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("mqmd.expiry = " + this.mqmd.getExpiry() + " JMS Message Expiry = " + jsMessage.getTimeToLive() + " System current time " + System.currentTimeMillis()));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"decodeClientMessage");
        }
        return jsMessage;
    }

    public void encodeClientMessage(JsMessage jsMessage, String string, String string2, String string3, int n, byte by, short s) throws IOException, Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"encodeClientMessage");
        }
        MQJsMessageEncoder mQJsMessageEncoder = jsMessage.getMQEncoder(string, null, string2, string3, (int)by, (int)s);
        this.dataList = (ArrayList)mQJsMessageEncoder.encodeForMQClient(this.tsh, this.mqapi, this.mqget, n, true);
        this.preserveBufferAfterSend = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"encodeClientMessage");
        }
    }

    public String toString() {
        StringBuffer stringBuffer;
        block24: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"toString");
            }
            if (this.tsh == null) {
                return "Warning: No TSH header";
            }
            stringBuffer = new StringBuffer();
            if (this.tsh != null) {
                stringBuffer.append(this.tsh);
            }
            if (this.header1 != null) {
                stringBuffer.append(this.header1);
            }
            if (this.header2 != null) {
                stringBuffer.append(this.header2);
            }
            if (this.data == null && this.dataList == null) {
                return stringBuffer.toString();
            }
            try {
                block1 : switch (this.segmentType) {
                    case 4: {
                        WsByteBuffer wsByteBuffer = this.data;
                        if (this.data == null) {
                            wsByteBuffer = (WsByteBuffer)this.dataList.get(0);
                        }
                        wsByteBuffer.position(this.tsh.size());
                        int n = 1;
                        TSH tSH = this.tsh;
                        while (true) {
                            stringBuffer.append(this.factory.createMSH(wsByteBuffer, tSH.nextEncoding(), tSH.nextCharacterSet()));
                            if ((tSH.getControlFlags1() & 0x10) != 0) {
                                stringBuffer.append(this.factory.createMQXQH(wsByteBuffer, tSH.nextEncoding(), tSH.nextCharacterSet()));
                            }
                            stringBuffer.append("\nMessage data: \n");
                            while (wsByteBuffer.hasRemaining()) {
                                stringBuffer.append((char)wsByteBuffer.get());
                            }
                            if (this.dataList == null || n == this.dataList.size()) break block1;
                            wsByteBuffer = (WsByteBuffer)this.dataList.get(n++);
                            wsByteBuffer.rewind();
                            tSH = this.factory.createTSH(wsByteBuffer);
                            stringBuffer.append(tSH);
                        }
                    }
                    case -122: 
                    case -121: 
                    case -107: {
                        WsByteBuffer wsByteBuffer = this.data;
                        if (this.data == null) {
                            wsByteBuffer = (WsByteBuffer)this.dataList.get(0);
                        }
                        int n = this.tsh.size();
                        if (this.header1 != null) {
                            n += this.header1.size();
                        }
                        if (this.header2 != null) {
                            n += this.header2.size();
                        }
                        wsByteBuffer.position(n);
                        int n2 = 1;
                        TSH tSH = this.tsh;
                        while (true) {
                            stringBuffer.append("\nMessage data: \n");
                            while (wsByteBuffer.hasRemaining()) {
                                stringBuffer.append((char)wsByteBuffer.get());
                            }
                            if (this.dataList == null || n2 == this.dataList.size()) break block1;
                            wsByteBuffer = (WsByteBuffer)this.dataList.get(n2++);
                            wsByteBuffer.rewind();
                            tSH = this.factory.createTSH(wsByteBuffer);
                            stringBuffer.append(tSH);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                stringBuffer.append("Warning: Data format error");
                if (this.data != null) {
                    stringBuffer.append("Data :" + MQUtil.byteBufferToString(this.data));
                }
                if (this.dataList == null) break block24;
                for (int i = 0; i < this.dataList.size(); ++i) {
                    stringBuffer.append("Data :" + MQUtil.byteBufferToString((WsByteBuffer)this.dataList.get(i)));
                }
            }
        }
        stringBuffer.append('\n');
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"toString");
        }
        return stringBuffer.toString();
    }

    public void processMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processMessage");
        }
        try {
            WsByteBuffer wsByteBuffer = (WsByteBuffer)this.dataList.get(0);
            wsByteBuffer.rewind();
            this.factory = MQHeaderFactory.instance();
            this.tsh = this.factory.createTSH(wsByteBuffer);
            this.segmentType = this.tsh.getSegmentType();
            if (this.segmentType == 4) {
                this.msh = this.factory.createMSH(wsByteBuffer, this.tsh.nextEncoding(), this.tsh.nextCharacterSet());
                this.header1 = this.msh;
                MQXQH mQXQH = this.factory.createMQXQH(wsByteBuffer, this.tsh.nextEncoding(), this.tsh.nextCharacterSet());
                this.header2 = mQXQH;
                this.mqmd = mQXQH.getMsgDesc();
                if (this.mqmd.getFormat().trim().equals("MQHRF2") && wsByteBuffer.hasRemaining()) {
                    this.rfh = this.factory.createMQRFH2(wsByteBuffer, this.mqmd.nextEncoding(), this.mqmd.nextCharacterSet());
                }
                this.firstMessageSegment = wsByteBuffer.slice();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processMessage");
        }
    }

    private void setContextSecurity(MQHObject mQHObject, MQClientServerStateMachine mQClientServerStateMachine) throws MQException {
        MQPMO mQPMO = null;
        mQPMO = this.mqput != null ? this.mqput.getPutMsgOpts() : this.mqput1.getPutMsgOpts();
        int n = mQPMO.getOptions();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setContextSecurity");
        }
        if ((n & 0x4000) != 0) {
            this.mqmd.setAccountingToken(null);
            this.mqmd.setApplIdentityData(null);
            this.mqmd.setUserIdentifier(null);
            this.mqmd.setApplOriginData(null);
            this.mqmd.setPutApplName(null);
            this.mqmd.setPutApplType(0);
            this.mqmd.setPutDate(null);
            this.mqmd.setPutTime(null);
        } else if ((n & 0x400) != 0) {
            this.setOriginContext(mQClientServerStateMachine);
        } else if ((n & 0x800) == 0) {
            if ((n & 0x100) != 0) {
                this.passIdentityContext(mQClientServerStateMachine, mQPMO);
                this.setOriginContext(mQClientServerStateMachine);
            } else if ((n & 0x200) != 0) {
                this.passAllContext(mQClientServerStateMachine, mQPMO);
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"Default Context requested");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"AccountingToken");
                }
                this.mqmd.setAccountingToken(mQClientServerStateMachine.getAcctToken());
                if (tc.isDebugEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"ApplIdentityData");
                }
                this.mqmd.setApplIdentityData(null);
                if (tc.isDebugEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"UserIdentifier");
                }
                this.mqmd.setUserIdentifier(mQClientServerStateMachine.getUserId());
                this.setOriginContext(mQClientServerStateMachine);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setContextSecurity");
        }
    }

    private void setOriginContext(MQClientServerStateMachine mQClientServerStateMachine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setOriginContext");
        }
        this.mqmd.setApplOriginData(null);
        this.mqmd.setPutApplName(mQClientServerStateMachine.getApplName());
        this.mqmd.setPutApplType(mQClientServerStateMachine.getApplType());
        this.mqmd.setPutDateTime(System.currentTimeMillis());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setOriginContext");
        }
    }

    private void passIdentityContext(MQClientServerStateMachine mQClientServerStateMachine, MQPMO mQPMO) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"passIdentityContext");
        }
        MQHObject mQHObject = this.validateInputHandle(mQClientServerStateMachine, mQPMO);
        this.mqmd.setApplIdentityData(mQHObject.getApplIdentityData());
        this.mqmd.setAccountingToken(mQHObject.getAccountingToken());
        this.mqmd.setUserIdentifier(mQHObject.getUserIdentifier());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"passIdentiyContext");
        }
    }

    private void passOriginContext(MQClientServerStateMachine mQClientServerStateMachine, MQPMO mQPMO) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"passOriginContext");
        }
        MQHObject mQHObject = this.validateInputHandle(mQClientServerStateMachine, mQPMO);
        this.mqmd.setApplOriginData(mQHObject.getApplOriginData());
        this.mqmd.setPutApplName(mQHObject.getPutApplName());
        this.mqmd.setPutApplType(mQHObject.getPutApplType());
        this.mqmd.setPutDate(mQHObject.getPutDate());
        this.mqmd.setPutTime(mQHObject.getPutTime());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"passOriginContext");
        }
    }

    private void passAllContext(MQClientServerStateMachine mQClientServerStateMachine, MQPMO mQPMO) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"passAllContext");
        }
        this.passIdentityContext(mQClientServerStateMachine, mQPMO);
        this.passOriginContext(mQClientServerStateMachine, mQPMO);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"passAllContext");
        }
    }

    private MQHObject validateInputHandle(MQClientServerStateMachine mQClientServerStateMachine, MQPMO mQPMO) throws MQException {
        MQHandleStore mQHandleStore;
        int n = mQPMO.getContext();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"validateInputHandle");
        }
        if ((mQHandleStore = mQClientServerStateMachine.getMQHandleStore()) == null) {
            throw new MQException(2097);
        }
        MQHObject mQHObject = mQHandleStore.getMQHObject(mQClientServerStateMachine.getConnection(), n);
        if (mQHObject == null) {
            throw new MQException(2097);
        }
        if ((mQHObject.getOpenOptions() & 0x80) == 0) {
            throw new MQException(2098);
        }
        if (!mQHObject.getSavedContext()) {
            throw new MQException(2098);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"validateInputHandle");
        }
        return mQHObject;
    }
}

