/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.link;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.admin.SIBMQLinkSenderCurrentStatus;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.SIBExceptionNoLinkExists;
import com.ibm.ws.sib.admin.SIBMQLinkNPMSpeed;
import com.ibm.ws.sib.admin.SIBMQLinkState;
import com.ibm.ws.sib.comms.mq.link.LinkConstants;
import com.ibm.ws.sib.comms.mq.link.MQLink;
import com.ibm.ws.sib.comms.mq.link.MQLinkStats;
import com.ibm.ws.sib.comms.mq.link.MQSync;
import com.ibm.ws.sib.comms.mq.link.MQSyncItem;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.comms.mq.util.MQFap;
import com.ibm.ws.sib.comms.mq.util.MQTimer;
import com.ibm.ws.sib.comms.mq.util.MQUtil;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MQJsException;
import com.ibm.ws.sib.mfp.MQJsMessageTooBigForChannelException;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.mqinterop.CCSID;
import com.ibm.ws.sib.mfp.mqinterop.fap.ErrorData;
import com.ibm.ws.sib.mfp.mqinterop.fap.InitData;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQFAP;
import com.ibm.ws.sib.mfp.mqinterop.fap.TSH;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.mqfapchannel.ConnectionManager;
import com.ibm.ws.sib.mqfapchannel.ReceiveListener;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.ExceptionDestinationHandler;
import com.ibm.ws.sib.processor.MPConsumerSession;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.SIMPFactory;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.security.auth.AuthUtilsFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.security.auth.Subject;

public class MQLinkSender
implements LinkConstants,
MQConstants,
MQFAP,
AlarmListener {
    private JsMessagingEngine engine;
    private SICoreConnection jsConnection;
    private Connection mqConnection;
    private MQLink mqlink;
    private JsBus bus;
    private ConsumerSession consumerSession;
    private ConsumerCallback asyncConsumerCallback;
    private SenderStateMachine stateMachine;
    private MQSync mqSync;
    private long currLuwid;
    private int nextSequenceNum = 1;
    private MQTimer timer;
    private LockedMessageEnumeration messageList;
    private SIUncoordinatedTransaction transaction;
    private MQLinkStats stats;
    private int senderStatus = 0;
    private MessageStore messageStore;
    private long bytesSent;
    private long bytesReceived;
    private long buffersSent;
    private long buffersReceived;
    private long numberBatches;
    private long numberMessages;
    private int msgsInBatch;
    private String partnerAddress;
    private MQLinkSender thisSender;
    private SIDestinationAddressFactory destFactory;
    private boolean disconnectIntervalReached = false;
    private String foreignBusName;
    private String outboundUserId;
    private boolean localBusSecurity;
    private String localBusName;
    private String senderChannelName;
    private String senderHostName;
    private short senderPort;
    private String qmgrName;
    private String remoteQmgrName;
    private int resetSequenceNumber;
    private int batchSize;
    private int heartbeatInterval;
    private int disconnectInterval;
    private int shortRetryCount;
    private int shortRetryInterval;
    private int longRetryCount;
    private int longRetryInterval;
    private int maxMessageSize;
    private int maxTransmissionSize;
    private int messageSeqWrapValue;
    private boolean npmSpeedFast;
    private byte fapLevel;
    private SIBMQLinkSenderCurrentStatus currentStatus = new SIBMQLinkSenderCurrentStatus();
    private final int MAX_BIND_ATTEMPT = 10;
    private byte senderEnc = 1;
    private short senderCCSID = (short)1208;
    private MQSyncItem syncItem;
    private long startTime;
    private long lastMessageTime;
    private boolean stopRequested = false;
    private static final int DISCONNECT_TIMER = 0;
    private static final int HEARTBEAT_TIMER = 1;
    private static final int RETRY_TIMER = 2;
    private static final int NUM_TIMERS = 3;
    private static final TraceComponent tc = SibTr.register((Class)MQLinkSender.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");

    MQLinkSender(MQLink mQLink) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"MQLinkSender");
        }
        this.mqlink = mQLink;
        this.engine = mQLink.getEngine();
        this.stats = mQLink.getStats();
        this.thisSender = this;
        this.shortRetryCount = mQLink.getShortRetryCount();
        this.shortRetryInterval = mQLink.getShortRetryInterval();
        this.longRetryCount = mQLink.getLongRetryCount();
        this.longRetryInterval = mQLink.getLongRetryInterval();
        this.senderChannelName = mQLink.getSenderChannelName();
        this.qmgrName = mQLink.getQMName();
        this.resetSequenceNumber = mQLink.getSenderResetSequenceNumber();
        this.batchSize = mQLink.getBatchSize();
        this.disconnectInterval = mQLink.getDisconnectInterval();
        this.maxMessageSize = mQLink.getMaxMessageSize();
        this.messageSeqWrapValue = mQLink.getMessageSeqWrapValue();
        this.maxTransmissionSize = mQLink.getTransmissionSize();
        this.npmSpeedFast = mQLink.isNpmSpeedFast();
        this.senderHostName = mQLink.getSenderHostName();
        this.senderPort = mQLink.getSenderPort();
        this.heartbeatInterval = mQLink.getHeartbeatInterval();
        if (!mQLink.setSender(this)) {
            throw new SIErrorException();
        }
        this.messageStore = (MessageStore)mQLink.getEngine().getMessageStore();
        try {
            this.destFactory = SIDestinationAddressFactory.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"MQLinkSender.MQLinkSender", (String)"1", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw new SIErrorException((Throwable)exception);
        }
        this.bus = (JsBus)this.engine.getBus();
        this.localBusName = this.bus.getName();
        String string = mQLink.getMQLinkTargetUuid();
        ForeignBusDefinition foreignBusDefinition = this.bus.getForeignBusForLink(string);
        if (foreignBusDefinition != null) {
            this.foreignBusName = foreignBusDefinition.getName();
        }
        try {
            this.outboundUserId = foreignBusDefinition.getLink().getOutboundUserid();
        }
        catch (SIBExceptionNoLinkExists sIBExceptionNoLinkExists) {
            FFDCFilter.processException((Throwable)sIBExceptionNoLinkExists, (String)"MQLinkSender.MQLinkSender", (String)"2", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIBExceptionNoLinkExists));
            }
            throw new SIErrorException((Throwable)sIBExceptionNoLinkExists);
        }
        this.localBusSecurity = mQLink.isBusSecure(this.bus.getName());
        this.timer = new MQTimer(this, 3);
        this.stateMachine = new SenderStateMachine();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"MQLinkSender");
        }
    }

    public SIBMQLinkSenderCurrentStatus getSenderCurrentStatus() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSenderCurrentStatus");
        }
        this.currentStatus.setStatus(new SIBMQLinkState(this.senderStatus));
        this.currentStatus.setBatchSize(new Integer(this.batchSize));
        if (this.mqConnection != null) {
            this.buffersReceived = this.mqConnection.getBuffersReceived();
            this.buffersSent = this.mqConnection.getBuffersSent();
            this.bytesReceived = this.mqConnection.getBytesReceived();
            this.bytesSent = this.mqConnection.getBytesSent();
        }
        this.currentStatus.setBuffersReceived(new Long(this.buffersReceived));
        this.currentStatus.setBuffersSent(new Long(this.buffersSent));
        this.currentStatus.setBytesReceived(new Long(this.bytesReceived));
        this.currentStatus.setBytesSent(new Long(this.bytesSent));
        if (this.partnerAddress != null) {
            this.currentStatus.setIpAddress(this.partnerAddress);
        }
        if (this.syncItem == null) {
            try {
                this.syncItem = this.mqSync.readSync(1, this.qmgrName, this.senderChannelName, this.mqlink.getMQLinkName());
            }
            catch (MessageStoreException messageStoreException) {
                // empty catch block
            }
        }
        if (this.syncItem != null) {
            this.currentStatus.setCurrentLUWID(Long.toHexString(this.currLuwid));
            this.currentStatus.setCurrentSequenceNumber(new Long(this.nextSequenceNum));
            this.currentStatus.setLastLUWID(Long.toHexString(this.syncItem.getCommittedLuwid()));
            this.currentStatus.setLastSequenceNumber(new Long(this.syncItem.getCommittedSequenceNumber()));
            this.currentStatus.setInDoubt(Boolean.valueOf(this.syncItem.isInDoubt()));
        }
        this.currentStatus.setHeartbeatInterval(new Integer(this.heartbeatInterval));
        if (this.lastMessageTime != 0L) {
            this.currentStatus.setLastMessageSendTimeMillis(new Long(this.lastMessageTime));
        }
        if (this.startTime != 0L) {
            this.currentStatus.setChannelStartTimeMillis(new Long(this.startTime));
        }
        this.currentStatus.setMaxMessageLength(new Integer(this.maxMessageSize));
        this.currentStatus.setMessagesInCurrentBatch(new Integer(this.msgsInBatch));
        this.currentStatus.setNpmSpeed(new SIBMQLinkNPMSpeed(this.npmSpeedFast ? 0 : 1));
        this.currentStatus.setNumberOfBatchesSent(new Long(this.numberBatches));
        this.currentStatus.setNumberOfMessagesSent(new Long(this.numberMessages));
        this.currentStatus.setQueueManager(this.qmgrName);
        this.currentStatus.setRemainingLongRetryStarts(new Integer(this.longRetryCount));
        this.currentStatus.setRemainingShortRetryStarts(new Integer(this.shortRetryCount));
        this.currentStatus.setStopRequested(Boolean.valueOf(this.stopRequested));
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSenderCurrentStatus");
        }
        return this.currentStatus;
    }

    void startSender() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"startSender");
        }
        this.stopRequested = false;
        int n = this.stateMachine.state;
        if (this.mqlink.isAuditEnabled()) {
            object = new Object[]{this.mqlink.getMQLinkName()};
            SibTr.audit((TraceComponent)tc, (String)"INFO_MQLINKSENDER_START_SICO3201", (Object)object);
        }
        switch (n) {
            case 12: 
            case 23: {
                try {
                    if (this.consumerSession == null) {
                        object = (MPCoreConnection)this.jsConnection;
                        this.consumerSession = object.createMQLinkConsumerSession(this.mqlink.getMQLinkUuid(), null, Reliability.RELIABLE_PERSISTENT);
                    }
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"MQLinkSender.startSender", (String)"3", (Object)this);
                }
                if (this.consumerSession == null) break;
                this.stopConsumerSession(true);
                if (n != this.stateMachine.state) break;
                this.stateMachine.gotoState(13);
                break;
            }
            case 0: 
            case 2: {
                this.stateMachine.start();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"startSender");
        }
    }

    void stop(int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        this.stateMachine.stop(n2);
        if (this.remoteQmgrName != null) {
            this.mqlink.emitNotification(6, 1, this.remoteQmgrName);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    void destroy() {
    }

    public Properties display(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"display");
        }
        Properties properties = new Properties();
        properties.setProperty("CHANNEL", this.senderChannelName);
        properties.setProperty("CHLTYPE", "SDR");
        properties.setProperty("TRPTYPE", "TCP");
        properties.setProperty("CONNAME", this.senderHostName + "(" + this.senderPort + ")");
        if (string.equalsIgnoreCase("channel")) {
            properties.setProperty("DESCR", "Sender channel for MQLink " + this.mqlink.getMQLinkName());
            properties.setProperty("ALTDATE", MQUtil.timeToMQDate(this.mqlink.getAltTime()));
            properties.setProperty("ALTTIME", MQUtil.timeToMQTime(this.mqlink.getAltTime()));
            properties.setProperty("BATCHSZ", new Integer(this.mqlink.getBatchSize()).toString());
            properties.setProperty("DISCINT", new Integer(this.mqlink.getDisconnectInterval()).toString());
            properties.setProperty("SHORTRTY", new Integer(this.mqlink.getShortRetryCount()).toString());
            properties.setProperty("SHORTTMR", new Integer(this.mqlink.getShortRetryInterval()).toString());
            properties.setProperty("LONGRTY", new Long(this.mqlink.getLongRetryCount()).toString());
            properties.setProperty("LONGTMR", new Integer(this.mqlink.getLongRetryInterval()).toString());
            properties.setProperty("SEQWRAP", new Integer(this.mqlink.getMessageSeqWrapValue()).toString());
            properties.setProperty("MAXMSGL", new Integer(this.mqlink.getMaxMessageSize()).toString());
            properties.setProperty("HBINT", new Integer(this.mqlink.getHeartbeatInterval()).toString());
            properties.setProperty("NPMSPEED", this.npmSpeedFast ? "FAST" : "NORMAL");
        } else if (string.equalsIgnoreCase("chstatus")) {
            properties.setProperty("CURLUWID", new Long(this.currLuwid).toString());
            properties.setProperty("CURSEQNO", new Long(this.nextSequenceNum).toString());
            properties.setProperty("INDOUBT", this.syncItem == null || !this.syncItem.isInDoubt() ? "NO" : "YES");
            properties.setProperty("LSTLUWID", new Long(this.syncItem != null ? this.syncItem.getCommittedLuwid() : 0L).toString());
            properties.setProperty("LSTSEQNO", new Long(this.syncItem != null ? (long)this.syncItem.getCommittedSequenceNumber() : 0L).toString());
            properties.setProperty("CURMSGS", new Integer(this.syncItem != null && this.syncItem.isInDoubt() ? this.syncItem.getInDoubtMsgIds().size() : this.stateMachine.numMessages).toString());
            String string2 = "INACTIVE";
            switch (this.stateMachine.state) {
                case 11: {
                    string2 = "STARTING";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    string2 = "BINDING";
                    break;
                }
                case 21: 
                case 22: {
                    string2 = "STOPPING";
                    break;
                }
                case 12: {
                    string2 = "RETRYING";
                    break;
                }
                case 2: {
                    string2 = "STOPPED";
                    break;
                }
                case 19: 
                case 20: 
                case 23: {
                    string2 = "RUNNING";
                    break;
                }
                default: {
                    string2 = "ERROR";
                }
            }
            properties.setProperty("STATUS", string2);
            properties.setProperty("BATCHSZ", new Integer(this.batchSize).toString());
            properties.setProperty("BATCHES", new Long(this.stats.getStatValue(1)).toString());
            properties.setProperty("BUFSRCVD", new Long(this.stats.getStatValue(10)).toString());
            properties.setProperty("BUFSSENT", new Long(this.stats.getStatValue(9)).toString());
            properties.setProperty("BYTSRCVD", new Long(this.stats.getStatValue(6)).toString());
            properties.setProperty("BYTSSENT", new Long(this.stats.getStatValue(5)).toString());
            properties.setProperty("CHSTADA", MQUtil.timeToMQDate(this.startTime));
            properties.setProperty("CHSTATI", MQUtil.timeToMQTime(this.startTime));
            properties.setProperty("HBINT", new Integer(this.heartbeatInterval).toString());
            properties.setProperty("LONGRTS", new Long(this.longRetryCount).toString());
            properties.setProperty("LSTMSGDA", MQUtil.timeToMQDate(this.lastMessageTime));
            properties.setProperty("LSTMSGTI", MQUtil.timeToMQTime(this.lastMessageTime));
            properties.setProperty("MAXMSGL", new Long(this.maxMessageSize).toString());
            properties.setProperty("MSGS", new Long(this.stats.getStatValue(3)).toString());
            properties.setProperty("NPMSPEED", this.npmSpeedFast ? "FAST" : "NORMAL");
            properties.setProperty("RQMNAME", this.remoteQmgrName);
            properties.setProperty("SHORTRTS", new Integer(this.shortRetryCount).toString());
            properties.setProperty("STOPREQ", this.stopRequested ? "TRUE" : "FALSE");
            properties.setProperty("QMNAME", this.qmgrName);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"display");
        }
        return properties;
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm");
        }
        switch ((Integer)object) {
            case 1: {
                this.stateMachine.doHeartbeat();
                break;
            }
            case 0: {
                this.stateMachine.doDisconnect();
                break;
            }
            case 2: {
                this.stateMachine.retry();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"alarm");
        }
    }

    private void startConsumerSession(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"startConsumerSession");
        }
        try {
            if (bl) {
                ConsumerCallback consumerCallback = new ConsumerCallback();
                MPConsumerSession mPConsumerSession = (MPConsumerSession)this.consumerSession;
                mPConsumerSession.registerAsynchConsumerCallback(consumerCallback, 0, 0L, this.batchSize, (Reliability)(this.npmSpeedFast ? Reliability.RELIABLE_NONPERSISTENT : null), true, null);
            }
            this.consumerSession.start(false);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"MQLinkSender.startSession", (String)"4", (Object)this);
            this.stateMachine.doError(null, 22, null);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"startConsumerSession");
        }
    }

    private void stopConsumerSession(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopConsumerSession");
        }
        try {
            if (this.consumerSession != null) {
                this.consumerSession.stop();
                if (bl) {
                    this.consumerSession.deregisterAsynchConsumerCallback();
                }
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"MQLinkSender.stopSession", (String)"5", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopConsumerSession");
        }
    }

    private void dlqMessage(SIBusMessage sIBusMessage, Transaction transaction, int n, String[] stringArray) {
        boolean bl = this.isRecoverable(sIBusMessage);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dlqMessage");
        }
        SIMPFactory sIMPFactory = (SIMPFactory)this.engine.getMessageProcessor();
        ExceptionDestinationHandler exceptionDestinationHandler = null;
        try {
            exceptionDestinationHandler = sIMPFactory.createExceptionDestinationHandler(null);
        }
        catch (SIException sIException) {
            if (bl) {
                this.stateMachine.doError(null, 6, null);
            }
            return;
        }
        UndeliverableReturnCode undeliverableReturnCode = exceptionDestinationHandler.handleUndeliverableMessage(sIBusMessage, ((JsMessage)sIBusMessage).getSecurityUserid(), transaction, n, stringArray);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Undeliverable rc =" + undeliverableReturnCode));
        }
        if (undeliverableReturnCode != UndeliverableReturnCode.OK) {
            if (bl) {
                this.stateMachine.doError(null, 6, null);
            }
            return;
        }
        Object[] objectArray = new Object[]{this.mqlink.getMQLinkName(), this.remoteQmgrName};
        SibTr.info((TraceComponent)tc, (String)"INFO_SND_PUT_TO_DLQ_SICO3096", (Object)objectArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dlqMessage");
        }
    }

    private boolean sendMessagetoMQ(SIBusMessage sIBusMessage, long l, int n, List list, Transaction transaction) throws SIConnectionLostException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendMessagetoMQ");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("luwid = " + Long.toHexString(l) + " seq = " + Integer.toHexString(n) + " trans = " + transaction));
        }
        try {
            int n2 = sIBusMessage.getReliability() == Reliability.ASSURED_PERSISTENT || sIBusMessage.getReliability() == Reliability.RELIABLE_PERSISTENT ? 1 : 0;
            MQFap mQFap = MQFap.encodeMessage(((JsMessage)sIBusMessage).getSent(), this.qmgrName, this.localBusName, l, n, this.maxTransmissionSize, this.senderEnc, this.senderCCSID, n2, this.maxMessageSize, this.localBusSecurity, this.outboundUserId);
            if (transaction != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)(" SystemMessageId = " + sIBusMessage.getSystemMessageId()));
                }
                list.add(sIBusMessage.getSystemMessageId());
            }
            long l2 = mQFap.send(this.mqConnection);
            ++this.buffersSent;
            if (this.stats != null) {
                this.stats.onSendMessage(l2);
            }
            this.lastMessageTime = System.currentTimeMillis();
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendMessagetoMQ");
            }
            return true;
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"MQLinkSender.sendMessageToMQ", (String)"6", (Object)this);
            this.dlqMessage(sIBusMessage, transaction, sIException.getExceptionReason(), sIException.getExceptionInserts());
            if (sIException instanceof SIConnectionDroppedException) {
                throw (SIConnectionDroppedException)((Object)sIException);
            }
            if (sIException instanceof SIConnectionLostException) {
                throw (SIConnectionLostException)((Object)sIException);
            }
        }
        catch (MQJsMessageTooBigForChannelException mQJsMessageTooBigForChannelException) {
            if (mQJsMessageTooBigForChannelException.getReason() == 2218) {
                Object[] objectArray = new Object[]{this.mqlink.getMQLinkName(), new Long(mQJsMessageTooBigForChannelException.getMessageSize()), new Integer(this.maxMessageSize)};
                SibTr.error((TraceComponent)tc, (String)"ERR_MSG_TOO_BIG_SICO3205", (Object)objectArray);
                this.dlqMessage(sIBusMessage, transaction, 104, new String[]{objectArray[0].toString(), objectArray[1].toString()});
            }
        }
        catch (MQJsException mQJsException) {
            this.dlqMessage(sIBusMessage, transaction, 105, null);
        }
        catch (MessageCopyFailedException messageCopyFailedException) {
            FFDCFilter.processException((Throwable)messageCopyFailedException, (String)"MQLinkSender.sendMessagetoMQ", (String)"7", (Object)this);
            this.dlqMessage(sIBusMessage, transaction, 105, null);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"MQLinkSender.sendMessageToMQ", (String)"8", (Object)this);
            this.dlqMessage(sIBusMessage, transaction, 105, null);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendMessagetoMQ");
        }
        return false;
    }

    private int nextSequenceNumber() {
        int n = this.nextSequenceNum++;
        if (this.nextSequenceNum > this.messageSeqWrapValue) {
            this.nextSequenceNum = 1;
        }
        return n;
    }

    private void rollbackSequenceNumber() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollbackSequenceNumber");
        }
        this.nextSequenceNum = this.nextSequenceNum == 1 ? this.messageSeqWrapValue : --this.nextSequenceNum;
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("nextSequenceNum = " + this.nextSequenceNum));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollbackSequenceNumber");
        }
    }

    private boolean isRecoverable(SIBusMessage sIBusMessage) {
        if (this.npmSpeedFast) {
            return sIBusMessage.getReliability() == Reliability.ASSURED_PERSISTENT || sIBusMessage.getReliability() == Reliability.RELIABLE_PERSISTENT;
        }
        return true;
    }

    private boolean logMQError(MQFap mQFap) {
        Object[] objectArray = null;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"logMQError");
        }
        String string = "ERR_MQLINK_FAILURE_SICO3237";
        objectArray = new Object[]{this.mqlink.getSenderChannelName()};
        TSH tSH = mQFap.getTsh();
        if (tSH.getSegmentType() == 5 || tSH.getSegmentType() == 9) {
            ErrorData errorData = mQFap.getErrorData();
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error buffer: ", (Object)new Object[]{tSH, errorData});
            }
            if (errorData != null) {
                switch (errorData.getReturnCode()) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        string = "ERR_REMOTE_PROTOCOL_ERROR_SICO3007";
                        Integer n = new Integer(errorData.getReturnCode());
                        Integer n2 = errorData.getErrorDataLength() >= 12 ? new Integer(errorData.getUserData()) : new Integer(0);
                        objectArray = new Object[]{this.mqlink.getMQLinkName(), n, n2};
                        break;
                    }
                    case 2: {
                        objectArray = new Object[]{this.mqlink.getMQLinkName(), this.senderChannelName};
                        string = "ERR_BAD_REMOTE_CHANNEL_TYPE_SICO3014";
                        break;
                    }
                    case 3: {
                        objectArray = new Object[]{this.mqlink.getMQLinkName()};
                        string = "ERR_REMOTE_QM_UNAVAILABLE_SICO3008";
                        break;
                    }
                    case 5: {
                        objectArray = new Object[]{this.mqlink.getMQLinkName()};
                        string = "INFO_REMOTE_QM_TERMINATING_SICO3009";
                        bl = true;
                        break;
                    }
                    case 1: {
                        objectArray = new Object[]{this.mqlink.getMQLinkName(), this.senderChannelName};
                        string = "ERR_REMOTE_CHANNEL_NOT_FOUND_SICO3006";
                        break;
                    }
                    case 7: {
                        objectArray = new Object[]{this.mqlink.getMQLinkName()};
                        string = "INFO_CHANNEL_CLOSED_SICO3012";
                        bl = true;
                        break;
                    }
                    case 23: {
                        objectArray = new Object[]{this.mqlink.getMQLinkName(), this.remoteQmgrName};
                        string = "ERR_TERMINATED_BY_REMOTE_EXIT_SICO3005";
                        break;
                    }
                    case 21: {
                        string = "ERR_MSGWRAP_DIFFERENT_SICO3010";
                        Integer n = new Integer(this.messageSeqWrapValue);
                        Integer n3 = errorData.getErrorDataLength() >= 12 ? new Integer(errorData.getUserData()) : new Integer(0);
                        objectArray = new Object[]{this.mqlink.getMQLinkName(), n, n3};
                        break;
                    }
                    case 8: {
                        objectArray = new Object[]{this.mqlink.getMQLinkName()};
                        string = "INFO_DISCINTERVAL_EXPIRED_SICO3013";
                        bl = true;
                        break;
                    }
                    case 4: {
                        string = "ERR_SND_SEQUENCE_ERROR_SICO3011";
                        int n = this.syncItem != null ? this.syncItem.getCommittedSequenceNumber() + 1 : 1;
                        Integer n4 = new Integer(n);
                        if (errorData.getErrorDataLength() >= 12) {
                            objectArray = new Object[]{this.mqlink.getMQLinkName(), n4, new Integer(errorData.getUserData())};
                            break;
                        }
                        objectArray = new Object[]{this.mqlink.getMQLinkName(), n4, new Integer(0)};
                        break;
                    }
                    case 22: {
                        objectArray = new Object[]{this.mqlink.getMQLinkName(), this.senderChannelName};
                        string = "ERR_REMOTE_CHANNEL_UNAVAILABLE_SICO3108";
                        break;
                    }
                    case 6: 
                    case 9: {
                        objectArray = new Object[]{this.mqlink.getMQLinkName(), this.remoteQmgrName};
                        string = "ERR_MSG_NOT_RECEIVED_SICO3080";
                        break;
                    }
                }
            }
        }
        if (string != null) {
            if (bl) {
                SibTr.info((TraceComponent)tc, (String)string, (Object)objectArray);
            } else {
                SibTr.error((TraceComponent)tc, (String)string, (Object)objectArray);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"logMQError");
        }
        return true;
    }

    protected void setState(int n) {
        this.senderStatus = n;
    }

    protected int getState() {
        return this.senderStatus;
    }

    public String getRemoteQMgrName() {
        return this.remoteQmgrName;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/link/MQLinkSender.java, SIB.comms, WAS602.SIB, o0610.11 1.71.1.2");
        }
    }

    private class SenderStateMachine {
        private volatile int state = 0;
        private volatile boolean waitingForResponse;
        private int Count;
        int numMessages;

        private SenderStateMachine() {
        }

        int getStatus() {
            return this.state;
        }

        private synchronized void gotoState(int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)("gotoState " + MQUtil.getState(n)));
            }
            if (this.state == n) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"gotoState");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                this.checkStateTransition(this.state, n);
            }
            this.state = n;
            switch (n) {
                case 11: {
                    this.doStarting();
                    break;
                }
                case 14: {
                    this.doPropose();
                    break;
                }
                case 16: {
                    this.doCheckSync();
                    break;
                }
                case 18: {
                    this.doCheckReset();
                    break;
                }
                case 21: {
                    this.doCloseChannel();
                    break;
                }
                case 12: {
                    this.doRetry();
                    break;
                }
                case 13: {
                    this.doConnecting();
                    break;
                }
                case 2: {
                    this.doStopped();
                    break;
                }
                case 22: {
                    this.doEndChannel();
                    break;
                }
                case 23: {
                    this.doWaitMessage();
                    break;
                }
                case 15: 
                case 17: 
                case 19: 
                case 20: {
                    break;
                }
                default: {
                    Object[] objectArray = new Object[]{MQLinkSender.this.mqlink.getMQLinkName(), new Integer(n)};
                    SibTr.error((TraceComponent)tc, (String)"ERR_MQSENDER_STATE_SICO3209", (Object)objectArray);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"gotoState");
            }
        }

        private synchronized void dataReceived(WsByteBuffer wsByteBuffer) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"dataReceived");
            }
            this.waitingForResponse = false;
            MQFap mQFap = null;
            try {
                mQFap = new MQFap(wsByteBuffer);
                TSH tSH = mQFap.getTsh();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("tsh contents: " + tSH));
                }
                if ((tSH.getControlFlags1() & 8) != 0) {
                    if ((tSH.getControlFlags1() & 2) != 0) {
                        MQLinkSender.this.logMQError(mQFap);
                    }
                    this.gotoState(22);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"dataReceived");
                    }
                    return;
                }
                switch (this.state) {
                    case 15: {
                        this.doProposed(mQFap);
                        break;
                    }
                    case 17: {
                        this.doWaitResync(mQFap);
                        break;
                    }
                    case 20: {
                        this.doBatchConfirm(mQFap);
                        break;
                    }
                    case 19: {
                        this.doMessageTransfer(mQFap);
                        break;
                    }
                    default: {
                        if (tSH.getSegmentType() != 9) {
                            this.doError(mQFap, 10, new Integer(tSH.getSegmentType()));
                        }
                        break;
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (tc.isEventEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an UnsupportedEncodingException", (Object)unsupportedEncodingException);
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unsupported CCSID : CCSID = " + mQFap.getCCSID() + " Encoding = " + Integer.toHexString(mQFap.getCCSID())));
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"MQLinkSender.$SenderStateMachine.dataReceived", (String)"10", (Object)this);
                Object[] objectArray = new Object[]{MQLinkSender.this.mqlink.getMQLinkName(), MQUtil.byteBufferToString(wsByteBuffer)};
                SibTr.error((TraceComponent)tc, (String)"ERR_MQLINKSENDER_DATA_SICO3212", (Object)objectArray);
                this.doError(null, 12, null);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"MQLinkSender.$SenderStateMachine.dataReceived", (String)"11", (Object)this);
            }
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
                FFDCFilter.processException((Throwable)sIConnectionDroppedException, (String)"MQLinkSender.$SenderStateMachine.dataReceived", (String)"12", (Object)this);
                this.doError(mQFap, 22, null);
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                FFDCFilter.processException((Throwable)sIConnectionLostException, (String)"MQLinkSender.$SenderStateMachine.dataReceived", (String)"13", (Object)this);
                this.doError(mQFap, 22, null);
            }
            if (mQFap != null) {
                mQFap.release();
            } else {
                wsByteBuffer.release();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"dataReceived");
            }
        }

        private void doError(MQFap mQFap, int n, Integer n2) {
            block10: {
                if (mQFap != null) {
                    Object[] objectArray = new Object[]{MQLinkSender.this.mqlink.getMQLinkName(), mQFap};
                    SibTr.error((TraceComponent)tc, (String)"ERR_MQLINKSENDER_DATA_SICO3212", (Object)objectArray);
                }
                try {
                    if (MQLinkSender.this.mqConnection != null) {
                        if (mQFap == null) {
                            mQFap = new MQFap();
                        }
                        mQFap.createStatus((byte)8, n, n2, MQLinkSender.this.senderEnc, MQLinkSender.this.senderCCSID);
                        long l = mQFap.send(MQLinkSender.this.mqConnection);
                        if (MQLinkSender.this.stats != null) {
                            MQLinkSender.this.stats.senderSent(l);
                        }
                    }
                }
                catch (SIConnectionLostException sIConnectionLostException) {
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIConnectionLostException));
                    }
                }
                catch (SIConnectionDroppedException sIConnectionDroppedException) {
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIConnectionDroppedException));
                    }
                }
                catch (IOException iOException) {
                    if (!tc.isEventEnabled()) break block10;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)iOException);
                }
            }
            this.gotoState(22);
        }

        private void doStarting() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doStarting");
            }
            MQLinkSender.this.senderStatus = 5;
            MQLinkSender.this.startTime = System.currentTimeMillis();
            try {
                Object object;
                if (MQLinkSender.this.jsConnection == null) {
                    object = (SICoreConnectionFactory)MQLinkSender.this.engine.getMessageProcessor();
                    AuthUtilsFactory authUtilsFactory = AuthUtilsFactory.getInstance();
                    AuthUtils authUtils = authUtilsFactory.createNewAuthUtils();
                    Subject subject = authUtils.getSIBServerSubject();
                    MQLinkSender.this.jsConnection = object.createConnection(subject, new HashMap());
                    MQLinkSender.this.mqSync = MQSync.open(MQLinkSender.this.messageStore, MQLinkSender.this.jsConnection, MQLinkSender.this.mqlink.getMQLinkUuid());
                }
                if (MQLinkSender.this.consumerSession == null) {
                    object = (MPCoreConnection)MQLinkSender.this.jsConnection;
                    MQLinkSender.this.consumerSession = object.createMQLinkConsumerSession(MQLinkSender.this.mqlink.getMQLinkUuid(), null, Reliability.RELIABLE_PERSISTENT);
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"MQLinkSender.MQLinkSender", (String)"14", (Object)this);
                this.gotoState(22);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"MQLinkSender.MQLinkSender", (String)"15", (Object)this);
                this.gotoState(22);
            }
            if (MQLinkSender.this.consumerSession != null) {
                this.gotoState(23);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doStarting");
            }
        }

        private void doConnecting() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doConnecting");
            }
            MQLinkSender.this.senderStatus = 1;
            MQLinkSender.this.senderHostName = MQLinkSender.this.mqlink.getSenderHostName();
            MQLinkSender.this.senderPort = MQLinkSender.this.mqlink.getSenderPort();
            MQLinkSender.this.heartbeatInterval = MQLinkSender.this.mqlink.getHeartbeatInterval();
            try {
                MQLinkSender.this.mqConnection = null;
                InetSocketAddress inetSocketAddress = new InetSocketAddress(MQLinkSender.this.senderHostName, (int)MQLinkSender.this.senderPort);
                ConnectionManager.initialise(null);
                MQReceiveListener mQReceiveListener = new MQReceiveListener();
                MQLinkSender.this.mqConnection = ConnectionManager.getRef().connect(inetSocketAddress, mQReceiveListener, MQLinkSender.this.mqlink.getProtocolName(), MQLinkSender.this.mqlink.getMQLinkName(), MQLinkSender.this.mqlink.getSenderChannelName());
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"MQLinkSender.doConnecting", (String)"16", (Object)this);
            }
            if (MQLinkSender.this.mqConnection == null) {
                MQLinkSender.this.stateMachine.gotoState(12);
            } else {
                MQLinkSender.this.partnerAddress = MQLinkSender.this.mqConnection.getRemoteNetworkAddress();
                MQLinkSender.this.timer.enable(1, MQLinkSender.this.heartbeatInterval * 1000);
                MQLinkSender.this.stateMachine.gotoState(14);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doConnecting");
            }
        }

        private void doPropose() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doPropose");
            }
            MQLinkSender.this.senderStatus = 2;
            MQLinkSender.this.senderChannelName = MQLinkSender.this.mqlink.getSenderChannelName();
            MQLinkSender.this.qmgrName = MQLinkSender.this.mqlink.getQMName();
            MQLinkSender.this.resetSequenceNumber = MQLinkSender.this.mqlink.getSenderResetSequenceNumber();
            MQLinkSender.this.batchSize = MQLinkSender.this.mqlink.getBatchSize();
            MQLinkSender.this.disconnectInterval = MQLinkSender.this.mqlink.getDisconnectInterval();
            MQLinkSender.this.maxMessageSize = MQLinkSender.this.mqlink.getMaxMessageSize();
            MQLinkSender.this.messageSeqWrapValue = MQLinkSender.this.mqlink.getMessageSeqWrapValue();
            MQLinkSender.this.maxTransmissionSize = MQLinkSender.this.mqlink.getTransmissionSize();
            MQLinkSender.this.npmSpeedFast = MQLinkSender.this.mqlink.isNpmSpeedFast();
            MQLinkSender.this.fapLevel = (byte)7;
            MQLinkSender.this.numberBatches = 0L;
            MQLinkSender.this.numberMessages = 0L;
            MQLinkSender.this.msgsInBatch = 0;
            this.Count = 1;
            MQLinkSender.this.startTime = System.currentTimeMillis();
            try {
                MQFap mQFap = new MQFap(1, 0, MQLinkSender.this.senderEnc, MQLinkSender.this.senderCCSID);
                this.createProposal(mQFap);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Init MQ session", (Object)mQFap);
                }
                this.waitingForResponse = true;
                long l = mQFap.send(MQLinkSender.this.mqConnection);
                if (MQLinkSender.this.stats != null) {
                    MQLinkSender.this.stats.senderSent(l);
                }
                this.gotoState(15);
            }
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
                this.gotoState(22);
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                this.gotoState(22);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doPropose");
            }
        }

        private void doProposed(MQFap mQFap) throws IOException, SIConnectionLostException, SIConnectionDroppedException {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doProposed");
            }
            TSH tSH = mQFap.getTsh();
            switch (tSH.getSegmentType()) {
                case 6: {
                    mQFap.getSecurityData().setUserData(null);
                    long l = mQFap.send(MQLinkSender.this.mqConnection);
                    if (MQLinkSender.this.stats == null) break;
                    MQLinkSender.this.stats.senderSent(l);
                    break;
                }
                case 1: {
                    InitData initData = mQFap.getInitData();
                    if (mQFap.isUnsupportedCCSID()) {
                        SibTr.error((TraceComponent)tc, (String)"ERR_UNSUPPORTED_CCSID_SICO3250", (Object)new Object[]{MQLinkSender.this.mqlink.getSenderChannelName(), MQLinkSender.this.mqlink.getMQLinkName(), "1208", "" + tSH.getCCSID()});
                        this.gotoState(21);
                        break;
                    }
                    MQLinkSender.this.remoteQmgrName = initData.getQueueManagerName().trim();
                    if ((tSH.getControlFlags1() & 2) != 0) {
                        if (this.Count >= 10) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sender channel " + MQLinkSender.this.mqlink.getSenderChannelName() + " for MQ link " + MQLinkSender.this.mqlink.getMQLinkName() + " has exceeded the maximum negotiation attempts"));
                            }
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Tsh = " + tSH + "InitData = " + initData));
                            }
                            SibTr.error((TraceComponent)tc, (String)"ERR_BIND_FAILED_SICO3062", (Object)new Object[]{MQLinkSender.this.mqlink.getSenderChannelName(), MQLinkSender.this.mqlink.getMQLinkName()});
                            this.gotoState(21);
                            break;
                        }
                        tSH.setControlFlags1((byte)1);
                        tSH.setSegmentType((byte)1);
                        tSH.setMQEncoding(546);
                        tSH.setEncoding(MQLinkSender.this.senderEnc);
                        tSH.setCCSID(MQLinkSender.this.senderCCSID);
                        if (!this.negotiateInitData(mQFap)) {
                            this.gotoState(21);
                            break;
                        }
                        this.waitingForResponse = true;
                        long l = mQFap.send(MQLinkSender.this.mqConnection);
                        if (MQLinkSender.this.stats == null) break;
                        MQLinkSender.this.stats.senderSent(l);
                        break;
                    }
                    this.gotoState(16);
                    break;
                }
                case 5: {
                    if ((tSH.getControlFlags1() & 2) != 0) {
                        if (!MQLinkSender.this.logMQError(mQFap)) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Tsh = " + tSH));
                            }
                            SibTr.error((TraceComponent)tc, (String)"ERR_BIND_FAILED_SICO3062", (Object)new Object[]{MQLinkSender.this.mqlink.getSenderChannelName(), MQLinkSender.this.mqlink.getMQLinkName()});
                        }
                        this.gotoState(21);
                        break;
                    }
                    this.gotoState(16);
                    break;
                }
                default: {
                    this.doError(mQFap, 10, new Integer(tSH.getSegmentType()));
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doProposed");
            }
        }

        private void doCheckSync() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doCheckSync");
            }
            MQLinkSender.this.senderStatus = 6;
            try {
                MQLinkSender.this.syncItem = MQLinkSender.this.mqSync.readSync(1, MQLinkSender.this.qmgrName, MQLinkSender.this.senderChannelName, MQLinkSender.this.mqlink.getMQLinkName());
                if (MQLinkSender.this.syncItem != null && MQLinkSender.this.syncItem.isInDoubt()) {
                    MQFap mQFap = new MQFap(2, 0, MQLinkSender.this.senderEnc, MQLinkSender.this.senderCCSID);
                    mQFap.getResync().setMessageSequenceNumber(MQLinkSender.this.syncItem.getInDoubtSequenceNumber());
                    mQFap.getResync().setLUWID(MQLinkSender.this.syncItem.getInDoubtLuwid());
                    this.waitingForResponse = true;
                    long l = mQFap.send(MQLinkSender.this.mqConnection);
                    if (MQLinkSender.this.stats != null) {
                        MQLinkSender.this.stats.senderSent(l);
                    }
                    this.gotoState(17);
                } else {
                    MQSyncItem mQSyncItem;
                    MQSyncItem mQSyncItem2 = MQLinkSender.this.syncItem;
                    if (mQSyncItem2 == null) {
                        mQSyncItem2 = new MQSyncItem(1, MQLinkSender.this.qmgrName, MQLinkSender.this.senderChannelName, MQLinkSender.this.mqlink.getMQLinkName());
                    }
                    if ((mQSyncItem = MQLinkSender.this.mqSync.anotherInDoubt(mQSyncItem2)) != null) {
                        Object[] objectArray = new Object[]{MQLinkSender.this.mqlink.getMQLinkName(), mQSyncItem.getChannelName(), mQSyncItem.getRemoteQmgrName()};
                        SibTr.error((TraceComponent)tc, (String)"ERR_CHANNEL_INDOUBT_SICO3065", (Object)objectArray);
                        this.gotoState(21);
                    } else {
                        this.gotoState(18);
                    }
                }
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                FFDCFilter.processException((Throwable)sIConnectionLostException, (String)"MQLinkSender.doCheckSync", (String)"17", (Object)this);
                this.gotoState(21);
            }
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
                FFDCFilter.processException((Throwable)sIConnectionDroppedException, (String)"MQLinkSender.doCheckSync", (String)"18", (Object)this);
                this.gotoState(21);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"MQLinkSender.doCheckSync", (String)"19", (Object)this);
                this.gotoState(21);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doCheckSync");
            }
        }

        private void doWaitResync(MQFap mQFap) throws IOException, MessageStoreException {
            block6: {
                TSH tSH;
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"doWaitResync");
                }
                if ((tSH = mQFap.getTsh()).getSegmentType() != 5) {
                    this.doError(mQFap, 10, new Integer(tSH.getSegmentType()));
                    return;
                }
                boolean bl = (tSH.getControlFlags1() & 2) == 0;
                MPCoreConnection mPCoreConnection = (MPCoreConnection)MQLinkSender.this.jsConnection;
                try {
                    MQLinkSender.this.mqlink.resolveSyncItem(bl, mPCoreConnection, MQLinkSender.this.mqSync, MQLinkSender.this.syncItem);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"MQLinkSender.doWaitResync", (String)"20", (Object)this);
                    this.gotoState(21);
                    break block6;
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"MQLinkSender.doWaitResync", (String)"21", (Object)this);
                    this.gotoState(21);
                    break block6;
                }
                this.gotoState(18);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doWaitResync");
            }
        }

        private void doCheckReset() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doCheckReset");
            }
            try {
                if (MQLinkSender.this.syncItem != null) {
                    MQLinkSender.this.nextSequenceNum = MQLinkSender.this.syncItem.getCommittedSequenceNumber() + 1;
                    MQLinkSender.this.currLuwid = MQLinkSender.this.syncItem.getCommittedLuwid() + 1L;
                } else {
                    MQLinkSender.this.nextSequenceNum = 1;
                    MQLinkSender.this.currLuwid = 1L;
                }
                if (MQLinkSender.this.resetSequenceNumber != 0) {
                    MQLinkSender.this.nextSequenceNum = MQLinkSender.this.resetSequenceNumber;
                    MQFap mQFap = new MQFap(3, 0, MQLinkSender.this.senderEnc, MQLinkSender.this.senderCCSID);
                    mQFap.getReset().setMessageSequenceNumber(MQLinkSender.this.nextSequenceNum);
                    long l = mQFap.send(MQLinkSender.this.mqConnection);
                    if (MQLinkSender.this.stats != null) {
                        MQLinkSender.this.stats.senderSent(l);
                    }
                }
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                FFDCFilter.processException((Throwable)sIConnectionLostException, (String)"MQLinkSender.doCheckReset", (String)"22", (Object)this);
                this.gotoState(21);
            }
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
                FFDCFilter.processException((Throwable)sIConnectionDroppedException, (String)"MQLinkSender.doCheckReset", (String)"23", (Object)this);
                this.gotoState(21);
            }
            long l = MQLinkSender.this.disconnectInterval == 0 ? Long.MAX_VALUE : (long)MQLinkSender.this.disconnectInterval * 1000L;
            MQLinkSender.this.timer.enable(0, l);
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Disconnect Interval = " + MQLinkSender.this.disconnectInterval + ", Timer enabled with interval " + l));
            }
            this.gotoState(19);
            MQLinkSender.this.mqlink.emitNotification(5, MQLinkSender.this.remoteQmgrName);
            MQLinkSender.this.startConsumerSession(true);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doCheckReset");
            }
        }

        private synchronized void doMessageTransfer(LockedMessageEnumeration lockedMessageEnumeration) {
            Object object;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doMessageTransfer(LockedMessageEnumeration)");
            }
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            int n2 = 0;
            ArrayList arrayList = new ArrayList();
            boolean bl3 = false;
            MQLinkSender.this.messageList = lockedMessageEnumeration;
            this.numMessages = 0;
            while (true) {
                try {
                    object = lockedMessageEnumeration.nextLocked();
                    if (object == null) break;
                    ++this.numMessages;
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"MQLinkSender$SenderStateMachine.doMessageTransfer", (String)"24", (Object)this);
                    bl3 = true;
                    break;
                }
                try {
                    bl2 = MQLinkSender.this.isRecoverable((SIBusMessage)object);
                    if (bl2) {
                        if (bl3) continue;
                        if (MQLinkSender.this.transaction == null) {
                            MQLinkSender.this.transaction = MQLinkSender.this.messageStore.getTransactionFactory().createLocalTransaction();
                            bl = true;
                        }
                    }
                    n = MQLinkSender.this.nextSequenceNumber();
                    boolean bl4 = MQLinkSender.this.sendMessagetoMQ((SIBusMessage)((JsMessage)object), MQLinkSender.this.currLuwid, n, arrayList, (Transaction)(bl2 ? MQLinkSender.this.transaction : null));
                    if (bl4) {
                        MQLinkSender.this.numberMessages++;
                        MQLinkSender.this.msgsInBatch++;
                        n2 = n;
                    } else {
                        MQLinkSender.this.rollbackSequenceNumber();
                    }
                    lockedMessageEnumeration.deleteCurrent(bl2 ? MQLinkSender.this.transaction : null);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"MQLinkSender$SenderStateMachine.doMessageTransfer", (String)"25", (Object)this);
                    if (!bl2 && !(sIException instanceof SIConnectionDroppedException) && !(sIException instanceof SIConnectionLostException)) continue;
                    bl3 = true;
                }
            }
            MQLinkSender.this.stopConsumerSession(false);
            MQLinkSender.this.timer.restart(0);
            if (bl3) {
                MQLinkSender.this.stateMachine.gotoState(21);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"doMessageTransfer(LockedMessageEnumeration)");
                }
                return;
            }
            if (bl) {
                if (MQLinkSender.this.syncItem == null) {
                    MQLinkSender.this.syncItem = new MQSyncItem(1, MQLinkSender.this.qmgrName, MQLinkSender.this.senderChannelName, MQLinkSender.this.mqlink.getMQLinkName());
                }
                MQLinkSender.this.syncItem.setInDoubt(true);
                MQLinkSender.this.syncItem.setInDoubtLuwid(MQLinkSender.this.currLuwid);
                MQLinkSender.this.syncItem.setInDoubtSequenceNumber(n2);
                MQLinkSender.this.syncItem.setInDoubtMsgIds(arrayList);
                try {
                    MQLinkSender.this.mqSync.writeSync(MQLinkSender.this.syncItem, null);
                }
                catch (MessageStoreException messageStoreException) {
                    bl3 = true;
                }
            }
            if (MQLinkSender.this.stats != null) {
                MQLinkSender.this.stats.onBatchSend();
                MQLinkSender.this.stats.busyIndicator(this.numMessages * 100 / MQLinkSender.this.batchSize);
            }
            MQLinkSender.this.timer.disable(0);
            this.gotoState(20);
            this.waitingForResponse = true;
            try {
                object = new MQFap(5, 1, MQLinkSender.this.senderEnc, MQLinkSender.this.senderCCSID);
                ((MQFap)object).getTsh().setLUWID(MQLinkSender.this.currLuwid);
                long l = ((MQFap)object).send(MQLinkSender.this.mqConnection);
                if (MQLinkSender.this.stats != null) {
                    MQLinkSender.this.stats.senderSent(l);
                }
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                this.waitingForResponse = false;
                this.gotoState(21);
            }
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
                this.waitingForResponse = false;
                this.gotoState(21);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doMessageTransfer(LockedMessageEnumeration)");
            }
        }

        private void doMessageTransfer(MQFap mQFap) throws IOException {
            TSH tSH;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doMessageTransfer(data, tsh)");
            }
            if (((tSH = mQFap.getTsh()).getControlFlags1() & 2) != 0) {
                MQLinkSender.this.logMQError(mQFap);
                this.gotoState(21);
            }
            if (tSH.getSegmentType() != 9 || (tSH.getControlFlags1() & 2) != 0) {
                this.doError(mQFap, 10, new Integer(tSH.getSegmentType()));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doMessageTransfer(data, tsh)");
            }
        }

        private void doBatchConfirm(MQFap mQFap) throws IOException {
            TSH tSH;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doBatchConfirm");
            }
            if ((tSH = mQFap.getTsh()).getSegmentType() != 5 && tSH.getSegmentType() != 9) {
                this.doError(mQFap, 10, new Integer(tSH.getSegmentType()));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"doBatchConfirm");
                }
                return;
            }
            if ((tSH.getControlFlags1() & 2) != 0) {
                MQLinkSender.this.logMQError(mQFap);
                this.gotoState(22);
                return;
            }
            if (tSH.getSegmentType() == 9) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"doBatchConfirm");
                }
                return;
            }
            try {
                if (MQLinkSender.this.syncItem != null && MQLinkSender.this.syncItem.isInDoubt()) {
                    MQLinkSender.this.syncItem.inDoubtToCommit();
                    MQLinkSender.this.mqSync.writeSync(MQLinkSender.this.syncItem, (Transaction)MQLinkSender.this.transaction);
                    if (MQLinkSender.this.resetSequenceNumber != 0) {
                        MQLinkSender.this.mqlink.cancelSenderResetSequenceNumber();
                        MQLinkSender.this.resetSequenceNumber = 0;
                    }
                }
                if (MQLinkSender.this.transaction != null) {
                    MQLinkSender.this.transaction.commit();
                    MQLinkSender.this.transaction = null;
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"MQLinkSender.$SenderStateMachine.doBatchConfirm", (String)"26", (Object)this);
                this.gotoState(21);
                return;
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"MQLinkSender.$SenderStateMachine.doBatchConfirm", (String)"27", (Object)this);
                this.gotoState(21);
                return;
            }
            MQLinkSender.this.longRetryCount = MQLinkSender.this.mqlink.getLongRetryCount();
            MQLinkSender.this.shortRetryCount = MQLinkSender.this.mqlink.getShortRetryCount();
            MQLinkSender.this.numberBatches++;
            MQLinkSender.this.msgsInBatch = 0;
            MQLinkSender.this.currLuwid++;
            MQLinkSender.this.timer.restart(0);
            this.gotoState(19);
            MQLinkSender.this.startConsumerSession(false);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doBatchConfirm");
            }
        }

        private void doCloseChannel() {
            block10: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"doCloseChannel");
                }
                try {
                    if (MQLinkSender.this.mqConnection != null) {
                        MQFap mQFap = new MQFap();
                        mQFap.createStatus((byte)8, 0, null, MQLinkSender.this.senderEnc, MQLinkSender.this.senderCCSID);
                        long l = mQFap.send(MQLinkSender.this.mqConnection);
                        if (MQLinkSender.this.stats != null) {
                            MQLinkSender.this.stats.senderSent(l);
                        }
                        MQLinkSender.this.buffersReceived = MQLinkSender.this.mqConnection.getBuffersReceived();
                        MQLinkSender.this.buffersSent = MQLinkSender.this.mqConnection.getBuffersSent();
                        MQLinkSender.this.bytesReceived = MQLinkSender.this.mqConnection.getBytesReceived();
                        MQLinkSender.this.bytesSent = MQLinkSender.this.mqConnection.getBytesSent();
                        MQLinkSender.this.mqConnection.close();
                        MQLinkSender.this.mqConnection = null;
                    }
                }
                catch (SIConnectionLostException sIConnectionLostException) {
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIConnectionLostException));
                    }
                }
                catch (SIConnectionDroppedException sIConnectionDroppedException) {
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIConnectionDroppedException));
                    }
                }
                catch (IOException iOException) {
                    if (!tc.isEventEnabled()) break block10;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)iOException);
                }
            }
            this.gotoState(22);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doCloseChannel");
            }
        }

        private void doEndChannel() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doEndChannel");
            }
            this.terminate(true, true);
            if (MQLinkSender.this.mqlink.isSenderStopped() || MQLinkSender.this.senderStatus == 0) {
                MQLinkSender.this.mqlink.unsetSender(MQLinkSender.this.thisSender);
            } else if (MQLinkSender.this.disconnectIntervalReached) {
                MQLinkSender.this.disconnectIntervalReached = false;
                this.gotoState(23);
            } else {
                this.gotoState(12);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doEndChannel");
            }
        }

        private void doStopped() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doStopped");
            }
            if (MQLinkSender.this.stopRequested) {
                MQLinkSender.this.senderStatus = 9;
            } else {
                MQLinkSender.this.senderStatus = 0;
            }
            this.terminate(false, true);
            this.gotoState(21);
            MQLinkSender.this.timer.stop();
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doStopped");
            }
        }

        private void doWaitMessage() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doWaitMessage");
            }
            try {
                this.terminate(true, true);
                MQLinkSender.this.timer.stop();
                ConsumerCallback consumerCallback = new ConsumerCallback();
                MPConsumerSession mPConsumerSession = (MPConsumerSession)MQLinkSender.this.consumerSession;
                mPConsumerSession.registerAsynchConsumerCallback(consumerCallback, 0, 0L, 1, Reliability.NONE, true, null);
                mPConsumerSession.start(false);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"MQLinkSender$SenderStateMachine.doWaitMessage", (String)"28", (Object)this);
                this.gotoState(12);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doWaitMessage");
            }
        }

        private void doRetry() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doRetry");
            }
            MQLinkSender.this.senderStatus = 4;
            this.terminate(true, true);
            if (MQLinkSender.this.shortRetryCount > 0) {
                if (MQLinkSender.this.stats != null) {
                    MQLinkSender.this.stats.incrementStats(13, 1L);
                }
                MQLinkSender.this.shortRetryCount--;
                MQLinkSender.this.timer.enable(2, MQLinkSender.this.shortRetryInterval * 1000);
            } else if (MQLinkSender.this.longRetryCount > 0) {
                if (MQLinkSender.this.stats != null) {
                    MQLinkSender.this.stats.incrementStats(14, 1L);
                }
                MQLinkSender.this.longRetryCount--;
                MQLinkSender.this.timer.enable(2, MQLinkSender.this.longRetryInterval * 1000);
            } else {
                MQLinkSender.this.mqlink.setSenderStopped();
                MQLinkSender.this.senderStatus = 9;
                MQLinkSender.this.stateMachine.gotoState(2);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doRetry");
            }
        }

        private void createProposal(MQFap mQFap) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"createProposal");
            }
            InitData initData = mQFap.getInitData();
            TSH tSH = mQFap.getTsh();
            initData.setChannelName(MQLinkSender.this.senderChannelName);
            initData.setQueueManagerName(MQLinkSender.this.qmgrName);
            initData.setCCSID(MQLinkSender.this.senderCCSID);
            initData.setHeartbeatInterval(MQLinkSender.this.heartbeatInterval);
            initData.setMaxMessagesPerBatch((short)MQLinkSender.this.batchSize);
            initData.setFapLevel(MQLinkSender.this.fapLevel);
            initData.setIDFlags((byte)7);
            initData.setMaxTransmissionSize(MQLinkSender.this.maxTransmissionSize);
            initData.setMaxMessageSize(MQLinkSender.this.maxMessageSize);
            initData.setMessageSequenceWrapValue(MQLinkSender.this.messageSeqWrapValue);
            byte by = 4;
            if (MQLinkSender.this.npmSpeedFast) {
                by = (byte)(by | 2);
            }
            initData.setIDFlags2(by);
            initData.setEFILength((short)0);
            tSH.setEncoding(MQLinkSender.this.senderEnc);
            tSH.setSegmentType((byte)1);
            tSH.setControlFlags1((byte)1);
            tSH.setMQEncoding(273);
            tSH.setCCSID(MQLinkSender.this.senderCCSID);
            tSH.setTransLength(initData.size() + tSH.size());
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createProposal");
            }
        }

        private boolean negotiateInitData(MQFap mQFap) throws IOException {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"negotiateInitData");
            }
            InitData initData = mQFap.getInitData();
            TSH tSH = mQFap.getTsh();
            if ((initData.getErrFlags() & 1) != 0 || (initData.getErrFlags() & 2) != 0) {
                if ((initData.getErrFlags() & 1) != 0) {
                    try {
                        if (Charset.isSupported(CCSID.getCodepage((int)initData.getCCSID()))) {
                            MQLinkSender.this.senderCCSID = initData.getCCSID();
                            initData.setCCSID(MQLinkSender.this.senderCCSID);
                            tSH.setCCSID(MQLinkSender.this.senderCCSID);
                            byte by = initData.getIDFlags2();
                            by = (byte)(by ^ 4);
                            initData.setIDFlags2(by);
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (tc.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)unsupportedEncodingException);
                        }
                        SibTr.error((TraceComponent)tc, (String)"ERR_UNSUPPORTED_CCSID_SICO3250", (Object)new Object[]{MQLinkSender.this.mqlink.getSenderChannelName(), MQLinkSender.this.mqlink.getMQLinkName(), "" + MQLinkSender.this.senderCCSID, "" + initData.getCCSID()});
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((Object)this, (TraceComponent)tc, (String)"negotiateInitData (unsupported CCSID)");
                        }
                        return false;
                    }
                }
                if ((initData.getErrFlags() & 2) != 0) {
                    MQLinkSender.this.senderEnc = tSH.getEncoding();
                    tSH.setEncoding(MQLinkSender.this.senderEnc);
                }
            } else {
                byte by;
                initData.setCCSID(MQLinkSender.this.senderCCSID);
                if ((initData.getErrFlags() & 0x10) != 0) {
                    if (MQLinkSender.this.maxMessageSize > initData.getMaxMessageSize()) {
                        MQLinkSender.this.maxMessageSize = initData.getMaxMessageSize();
                    } else {
                        initData.setMaxMessageSize(MQLinkSender.this.maxMessageSize);
                    }
                }
                if ((initData.getErrFlags() & 4) != 0) {
                    if (MQLinkSender.this.maxTransmissionSize > initData.getMaxTransmissionSize()) {
                        MQLinkSender.this.maxTransmissionSize = initData.getMaxTransmissionSize();
                    } else {
                        initData.setMaxTransmissionSize(MQLinkSender.this.maxTransmissionSize);
                    }
                }
                if ((initData.getErrFlags() & 0x20) != 0) {
                    if (MQLinkSender.this.batchSize > initData.getMaxMessagesPerBatch()) {
                        MQLinkSender.this.batchSize = initData.getMaxMessagesPerBatch();
                    } else {
                        initData.setMaxMessagesPerBatch((short)MQLinkSender.this.batchSize);
                    }
                }
                if ((initData.getErrFlags() & 8) != 0 && (by = initData.getFapLevel()) <= 7 && by >= 4) {
                    MQLinkSender.this.fapLevel = by;
                }
                if ((initData.getErrFlags() & 0xFFFFFF80) != 0) {
                    if (MQLinkSender.this.heartbeatInterval < initData.getHeartbeatInterval() || initData.getHeartbeatInterval() == 0) {
                        MQLinkSender.this.heartbeatInterval = initData.getHeartbeatInterval();
                        MQLinkSender.this.timer.enable(1, MQLinkSender.this.heartbeatInterval * 1000);
                    } else {
                        initData.setHeartbeatInterval(MQLinkSender.this.heartbeatInterval);
                    }
                }
                if ((initData.getErrFlags() & 0x40) != 0 && MQLinkSender.this.messageSeqWrapValue != initData.getMessageSequenceWrapValue()) {
                    SibTr.error((TraceComponent)tc, (String)"ERR_MSGWRAP_DIFFERENT_SICO3010", (Object)new Object[]{new Integer(MQLinkSender.this.messageSeqWrapValue), new Integer(initData.getMessageSequenceWrapValue())});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"negotiateInitData (different seq wrap)");
                    }
                    return false;
                }
                if ((initData.getIDEFlags2() & 2) != 0) {
                    MQLinkSender.this.npmSpeedFast = (initData.getIDFlags2() & 2) == 0;
                }
            }
            initData.setErrFlags((byte)0);
            initData.setQueueManagerName(MQLinkSender.this.qmgrName);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"negotiateInitData");
            }
            return true;
        }

        private synchronized void doHeartbeat() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doHeartbeat");
            }
            try {
                if (this.waitingForResponse) {
                    MQFap mQFap = new MQFap();
                    mQFap.createStatus((byte)8, 8, null, MQLinkSender.this.senderEnc, MQLinkSender.this.senderCCSID);
                    long l = mQFap.send(MQLinkSender.this.mqConnection);
                    if (MQLinkSender.this.stats != null) {
                        MQLinkSender.this.stats.senderSent(l);
                    }
                    this.gotoState(22);
                } else if (this.state == 19 || this.state == 20) {
                    this.waitingForResponse = true;
                    MQFap mQFap = new MQFap(9, 1, MQLinkSender.this.senderEnc, MQLinkSender.this.senderCCSID);
                    long l = mQFap.send(MQLinkSender.this.mqConnection);
                    if (MQLinkSender.this.stats != null) {
                        MQLinkSender.this.stats.senderSent(l);
                    }
                }
            }
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
                FFDCFilter.processException((Throwable)sIConnectionDroppedException, (String)"MQLinkSender.$StateMachine.doHeartbeat", (String)"29", (Object)this);
                this.gotoState(12);
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                FFDCFilter.processException((Throwable)sIConnectionLostException, (String)"MQLinkSender.$StateMachine.doHeartbeat", (String)"30", (Object)this);
                this.gotoState(12);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"MQLinkSender.$StateMachine.doHeartbeat", (String)"31", (Object)this);
                this.gotoState(12);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doHeartbeat");
            }
        }

        private synchronized void doDisconnect() {
            block11: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"doDisConnect");
                }
                if (MQLinkSender.this.mqlink.isAuditEnabled()) {
                    SibTr.audit((TraceComponent)tc, (String)"INFO_DISCINTERVAL_EXPIRED_SICO3013", (Object)MQLinkSender.this.senderChannelName);
                }
                this.terminate(false, true);
                try {
                    if (MQLinkSender.this.mqConnection != null) {
                        MQFap mQFap = new MQFap();
                        mQFap.createStatus((byte)8, 8, null, MQLinkSender.this.senderEnc, MQLinkSender.this.senderCCSID);
                        long l = mQFap.send(MQLinkSender.this.mqConnection);
                        if (MQLinkSender.this.stats != null) {
                            MQLinkSender.this.stats.senderSent(l);
                        }
                        MQLinkSender.this.mqConnection.close();
                        MQLinkSender.this.mqConnection = null;
                    }
                }
                catch (SIConnectionLostException sIConnectionLostException) {
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIConnectionLostException));
                    }
                }
                catch (SIConnectionDroppedException sIConnectionDroppedException) {
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIConnectionDroppedException));
                    }
                }
                catch (IOException iOException) {
                    if (!tc.isEventEnabled()) break block11;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)iOException);
                }
            }
            MQLinkSender.this.disconnectIntervalReached = true;
            this.gotoState(22);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"doDisConnect");
            }
        }

        private synchronized void start() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
            }
            if (((MQLinkSender)MQLinkSender.this).stateMachine.state == 0 || ((MQLinkSender)MQLinkSender.this).stateMachine.state == 2) {
                MQLinkSender.this.stateMachine.gotoState(11);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
            }
        }

        private synchronized void stop(int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
            }
            if (MQLinkSender.this.mqlink.isAuditEnabled()) {
                Object[] objectArray = new Object[]{MQLinkSender.this.mqlink.getMQLinkName()};
                SibTr.audit((TraceComponent)tc, (String)"INFO_MQLINKSENDER_STOP_SICO3202", (Object)objectArray);
            }
            if (n == 1) {
                MQLinkSender.this.stateMachine.gotoState(2);
            } else {
                MQLinkSender.this.stopRequested = true;
                MQLinkSender.this.stateMachine.gotoState(2);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
            }
        }

        private synchronized void retry() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"retry");
            }
            if (((MQLinkSender)MQLinkSender.this).stateMachine.state == 12) {
                MQLinkSender.this.timer.stop();
                MQLinkSender.this.stateMachine.gotoState(11);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"retry");
            }
        }

        private void terminate(boolean bl, boolean bl2) {
            block6: {
                try {
                    this.waitingForResponse = false;
                    if (MQLinkSender.this.timer != null) {
                        MQLinkSender.this.timer.disable(1);
                        MQLinkSender.this.timer.disable(0);
                    }
                    if (bl2) {
                        MQLinkSender.this.stopConsumerSession(true);
                    }
                    if (MQLinkSender.this.transaction != null) {
                        MQLinkSender.this.transaction.rollback();
                        MQLinkSender.this.transaction = null;
                    }
                    if (bl && MQLinkSender.this.mqConnection != null) {
                        MQLinkSender.this.mqConnection.close();
                        MQLinkSender.this.mqConnection = null;
                    }
                }
                catch (SIException sIException) {
                    if (!tc.isEventEnabled()) break block6;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIException));
                }
            }
        }

        private void checkStateTransition(int n, int n2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkStateTransition");
            }
            boolean bl = false;
            switch (n2) {
                case 11: {
                    if (n == 2 || n == 0 || n == 12) break;
                    bl = true;
                    break;
                }
                case 13: {
                    if (n == 12 || n == 23) break;
                    bl = true;
                    break;
                }
                case 14: {
                    if (n == 13) break;
                    bl = true;
                    break;
                }
                case 15: {
                    if (n == 14 || n == 15) break;
                    bl = true;
                    break;
                }
                case 16: {
                    if (n == 15) break;
                    bl = true;
                    break;
                }
                case 17: {
                    if (n == 16) break;
                    bl = true;
                    break;
                }
                case 18: {
                    if (n == 16 || n == 17) break;
                    bl = true;
                    break;
                }
                case 19: {
                    if (n == 18 || n == 20) break;
                    bl = true;
                    break;
                }
                case 20: {
                    if (n == 19) break;
                    bl = true;
                    break;
                }
                case 2: 
                case 12: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (bl) {
                SibTr.error((TraceComponent)tc, (String)"ERR_MQLINKSENDER_STATE_SICO3213", (Object)new Object[]{MQLinkSender.this.mqlink.getMQLinkName(), new Integer(n), new Integer(n2)});
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkStateTransition");
            }
        }
    }

    private class ConsumerCallback
    implements AsynchConsumerCallback {
        private ConsumerCallback() {
        }

        public void consumeMessages(LockedMessageEnumeration lockedMessageEnumeration) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"consumeMessages");
            }
            if (MQLinkSender.this.stateMachine.state == 23) {
                try {
                    lockedMessageEnumeration.nextLocked();
                    lockedMessageEnumeration.unlockCurrent();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"MQLinkSender$SenderStateMachine.consumeMessages", (String)"9", (Object)this);
                }
                MQLinkSender.this.stopConsumerSession(true);
                MQLinkSender.this.stateMachine.gotoState(13);
            } else {
                MQLinkSender.this.stateMachine.doMessageTransfer(lockedMessageEnumeration);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"consumeMessages");
            }
        }
    }

    private class MQReceiveListener
    implements ReceiveListener {
        private MQReceiveListener() {
        }

        public ReceiveListener dataReceived(Connection connection, WsByteBuffer wsByteBuffer) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"dataReceived");
            }
            if (tc.isDebugEnabled()) {
                SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])wsByteBuffer.array(), (int)wsByteBuffer.arrayOffset(), (int)wsByteBuffer.remaining(), (String)"Data received by MQLinkSender");
            }
            MQLinkSender.this.timer.restart(1);
            if (MQLinkSender.this.stats != null) {
                MQLinkSender.this.stats.senderReceived(wsByteBuffer.remaining());
            }
            MQLinkSender.this.stateMachine.dataReceived(wsByteBuffer);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"dataReceived");
            }
            return null;
        }

        public void errorOccurred(Connection connection, Throwable throwable) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"errorOccurred");
            }
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)throwable);
            }
            MQLinkSender.this.buffersReceived = MQLinkSender.this.mqConnection.getBuffersReceived();
            MQLinkSender.this.buffersSent = MQLinkSender.this.mqConnection.getBuffersSent();
            MQLinkSender.this.bytesReceived = MQLinkSender.this.mqConnection.getBytesReceived();
            MQLinkSender.this.bytesSent = MQLinkSender.this.mqConnection.getBytesSent();
            MQLinkSender.this.stateMachine.gotoState(22);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"errorOccurred");
            }
        }

        public WsByteBuffer buildErrorCloseFapFlow() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"buildErrorCloseFapFlow");
            }
            MQLinkSender.this.stateMachine.gotoState(21);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"buildErrorCloseFapFlow");
            }
            return null;
        }
    }
}

