/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.link;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.admin.SIBMQLinkReceiverSavedStatus;
import com.ibm.websphere.sib.admin.SIBMQLinkSenderCurrentStatus;
import com.ibm.websphere.sib.admin.SIBMQLinkSenderSavedStatus;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsConfigComponent;
import com.ibm.ws.sib.admin.JsEObject;
import com.ibm.ws.sib.admin.JsEngineComponentWithEventListener;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.admin.SIBMQConstants;
import com.ibm.ws.sib.admin.SIBMQLinkReceiverChannelRuntime;
import com.ibm.ws.sib.admin.SIBMQLinkRuntime;
import com.ibm.ws.sib.admin.SIBMQLinkSenderChannelRuntime;
import com.ibm.ws.sib.admin.SIBMQLinkState;
import com.ibm.ws.sib.comms.impl.ConversationState;
import com.ibm.ws.sib.comms.impl.ObjectStoreFullException;
import com.ibm.ws.sib.comms.mq.link.LinkConstants;
import com.ibm.ws.sib.comms.mq.link.MQLinkManagerImpl;
import com.ibm.ws.sib.comms.mq.link.MQLinkReceiver;
import com.ibm.ws.sib.comms.mq.link.MQLinkSender;
import com.ibm.ws.sib.comms.mq.link.MQLinkStats;
import com.ibm.ws.sib.comms.mq.link.MQSync;
import com.ibm.ws.sib.comms.mq.link.MQSyncItem;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.comms.mq.util.MQUtil;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.psb.PSBFactory;
import com.ibm.ws.sib.psb.PSBFactoryPoint;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.security.auth.AuthUtilsFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.SelectorDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;

public class MQLink
implements LinkConstants,
JsEngineComponentWithEventListener,
JsConfigComponent,
SIBMQLinkRuntime,
SIBMQLinkSenderChannelRuntime,
SIBMQLinkReceiverChannelRuntime,
SIBMQConstants,
MQConstants {
    private String mqLinkName;
    private String mqLinkUuid;
    private String mqLinkTargetUuid;
    private String description;
    private int receiverState = 9;
    private String senderChannel;
    private String receiverChannel;
    private String senderHostName = "localhost";
    private short senderPort = (short)1414;
    private String qmgrName;
    private int resetSenderSequenceNumber = 0;
    private int batchSize = 50;
    private int heartbeatInterval = 300;
    private int disconnectInterval = 900;
    private boolean npmSpeedFast = true;
    private int shortRetryCount = 10;
    private int shortRetryInterval = 60;
    private int longRetryCount = 999999999;
    private int longRetryInterval = 1200;
    private int maxMessageSize = Integer.MAX_VALUE;
    private int maxTransmissionSize = 32766;
    private int messageSeqWrapValue = 999999999;
    private boolean autoStart = true;
    private boolean autoStartSender = true;
    private boolean autoStartReceiver = true;
    private boolean adoptEnabled = true;
    private Reliability inboundNPReliability = Reliability.EXPRESS_NONPERSISTENT;
    private Reliability inboundPersReliability = Reliability.ASSURED_PERSISTENT;
    private boolean auditEnabled = false;
    private String protocolName = "OutboundBasicMQLink";
    private int appServerStartMode = 0;
    private JsMessagingEngine engine;
    private MQLinkSender sender;
    private ConversationState receiverList;
    private RuntimeEventListener runtimeEventListener;
    private MQLinkStats stats;
    private long createTime;
    private long altTime;
    private String meName;
    private static String CLASS_NAME = MQLink.class.getName();
    private static final TraceComponent tc = SibTr.register((Class)MQLink.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static DestroyCallback staticDestroyCallback;
    private static SetReceiverCallback staticSetReceiverCallback;
    private static StopCallback staticStopCallback;
    private static StatusCallback staticStatusCallback;
    private int senderState = 9;

    public void configure(JsEObject jsEObject) {
        Object object;
        String string;
        String string2;
        int n;
        this.altTime = System.currentTimeMillis();
        String[] stringArray = jsEObject.getAttributeNames();
        for (n = 0; n < stringArray.length; ++n) {
            string2 = stringArray[n];
            string = jsEObject.getAttribute(stringArray[n]);
            this.setAttribute(string2, string);
        }
        Map map = jsEObject.getChildren();
        Object v = map.get("senderChannel");
        if (v != null) {
            object = ((JsEObject)v).getAttributeNames();
            for (n = 0; n < ((String[])object).length; ++n) {
                string2 = object[n];
                string = ((JsEObject)v).getAttribute(object[n]);
                this.setAttribute(string2, string);
            }
        }
        if ((object = map.get("receiverChannel")) != null) {
            String[] stringArray2 = ((JsEObject)object).getAttributeNames();
            for (n = 0; n < stringArray2.length; ++n) {
                string2 = stringArray2[n];
                string = ((JsEObject)object).getAttribute(stringArray2[n]);
                this.setAttribute(string2, string);
            }
        }
    }

    public void setAttribute(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAttribute", (Object)new Object[]{string, string2});
        }
        if (string.equalsIgnoreCase("name")) {
            this.mqLinkName = string2;
        } else if (string.equalsIgnoreCase("uuid")) {
            this.mqLinkUuid = string2;
        } else if (string.equalsIgnoreCase("targetUuid")) {
            this.mqLinkTargetUuid = string2;
        } else if (string.equalsIgnoreCase("description")) {
            this.description = string2;
        } else if (string.equalsIgnoreCase("qmName")) {
            this.qmgrName = string2;
        } else if (string.equalsIgnoreCase("senderChannelName")) {
            this.senderChannel = string2;
        } else if (string.equalsIgnoreCase("receiverChannelName")) {
            this.receiverChannel = string2;
        } else if (string.equalsIgnoreCase("port")) {
            this.senderPort = (short)Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("hostName")) {
            this.senderHostName = string2;
        } else if (string.equalsIgnoreCase("batchSize")) {
            this.batchSize = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("heartBeat")) {
            this.heartbeatInterval = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("maxMsgSize")) {
            this.maxMessageSize = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("discInterval")) {
            this.disconnectInterval = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("sequenceWrap")) {
            this.messageSeqWrapValue = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("nonPersistentMessageSpeed")) {
            this.npmSpeedFast = string2.equalsIgnoreCase("FAST");
        } else if (string.equalsIgnoreCase("shortRetryInterval")) {
            this.shortRetryInterval = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("shortRetryCount")) {
            this.shortRetryCount = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("longRetryInterval")) {
            this.longRetryInterval = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("longRetryCount")) {
            this.longRetryCount = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("adoptable")) {
            this.adoptEnabled = string2.equalsIgnoreCase("TRUE");
        } else if (string.equalsIgnoreCase("inboundNonPersistentReliability")) {
            this.inboundNPReliability = string2.equalsIgnoreCase("EXPRESS") ? Reliability.EXPRESS_NONPERSISTENT : (string2.equalsIgnoreCase("RELIABLE") ? Reliability.RELIABLE_NONPERSISTENT : Reliability.BEST_EFFORT_NONPERSISTENT);
        } else if (string.equalsIgnoreCase("inboundPersistentReliability")) {
            this.inboundPersReliability = string2.equalsIgnoreCase("RELIABLE") ? Reliability.RELIABLE_PERSISTENT : Reliability.ASSURED_PERSISTENT;
        } else if (string.equalsIgnoreCase("initialState")) {
            this.autoStart = string2.equalsIgnoreCase("STARTED");
        } else if (string.equalsIgnoreCase("senderChannelInitialState")) {
            this.autoStartSender = string2.equalsIgnoreCase("STARTED");
        } else if (string.equalsIgnoreCase("receiverChannelInitialState")) {
            this.autoStartReceiver = string2.equalsIgnoreCase("STARTED");
        } else if (string.equalsIgnoreCase("protocolName")) {
            if (string2 != null && string2.trim().length() > 0) {
                this.protocolName = string2;
            }
        } else {
            String string3 = nls.getFormattedMessage("INFO_MQLINK_PARM_SICO3242", new Object[]{string, string2}, null);
            SIErrorException sIErrorException = new SIErrorException(string3);
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.comms.mq.link", (String)"2");
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unknown MQLink attributes " + string + "=" + string2));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAttribute");
        }
    }

    public void initialize(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialize");
        }
        this.engine = jsMessagingEngine;
        this.createTime = this.altTime = System.currentTimeMillis();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialize");
        }
    }

    public void start(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("AppServer is starting in mode " + n));
        }
        this.appServerStartMode = n;
        if ((n & 2) == 0) {
            if (this.stats == null) {
                this.stats = new MQLinkStats(this.mqLinkName == null ? "" : this.mqLinkName);
            }
            MQLinkManagerImpl mQLinkManagerImpl = (MQLinkManagerImpl)MQLinkManagerImpl.getInstance();
            mQLinkManagerImpl.addMQLink(this);
            if (this.autoStart) {
                if (this.autoStartReceiver) {
                    this.receiverState = 0;
                }
                if (this.autoStartSender) {
                    this.setSenderState(0);
                    this.startMQLink();
                }
            } else {
                this.setSenderState(9);
                this.receiverState = 9;
            }
            PSBFactory pSBFactory = PSBFactoryPoint.getInstance();
            try {
                pSBFactory.getBridge().cleanupBrokers(this.engine, this.mqLinkName, this.mqLinkUuid, this.qmgrName, this.mqLinkTargetUuid);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"start", (String)"2", (Object)this);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"start", (String)"3", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    public void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        if ((this.appServerStartMode & 2) == 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("ME is stopping in mode " + n));
            }
            this.stopMQLink(0, 1);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"destroy");
        }
        if ((this.appServerStartMode & 2) == 0) {
            if (this.sender != null) {
                this.sender.destroy();
            }
            if (this.receiverList != null) {
                this.receiverList.scanObjects(staticDestroyCallback, null, null);
            }
            ((MQLinkManagerImpl)MQLinkManagerImpl.getInstance()).removeMQLink(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"destroy");
        }
    }

    public void setCustomProperty(String string, String string2) {
    }

    public void startMQLink() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"startMQLink");
        }
        this.startSender();
        this.startReceiver();
        this.emitNotification(1);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"startMQLink");
        }
    }

    public void resetSender() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"resetSender");
        }
        if (this.auditEnabled) {
            SibTr.audit((TraceComponent)tc, (String)"INFO_MQLINK_RESET_SICO3240", (Object)this.mqLinkName);
        }
        this.resetSenderSequenceNumber = 1;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"resetSender");
        }
    }

    public void resolveSyncItem(boolean bl, MPCoreConnection mPCoreConnection, MQSync mQSync, MQSyncItem mQSyncItem) throws SIException, MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"resolveSyncItem");
        }
        if (mQSyncItem == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"resolveSyncItem - syncItem is null");
            }
            return;
        }
        if (!mQSyncItem.isInDoubt()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"resolveSyncItem - channel is not indoubt");
            }
            return;
        }
        MessageStore messageStore = (MessageStore)this.engine.getMessageStore();
        ExternalLocalTransaction externalLocalTransaction = messageStore.getTransactionFactory().createLocalTransaction();
        if (bl) {
            List list = mQSyncItem.getInDoubtMsgIds();
            if (list != null && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Number of indoubt message ids = " + list.size()));
            }
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                String string2 = "SI_SystemMessageID = '" + string + "'";
                SelectionCriteria selectionCriteria = null;
                selectionCriteria = SelectionCriteriaFactory.getInstance().createSelectionCriteria(null, string2, SelectorDomain.SIMESSAGE);
                ConsumerSession consumerSession = mPCoreConnection.createMQLinkConsumerSession(this.getMQLinkUuid(), selectionCriteria, Reliability.RELIABLE_PERSISTENT);
                consumerSession.start(false);
                consumerSession.receiveNoWait((SITransaction)externalLocalTransaction);
            }
            mQSyncItem.inDoubtToCommit();
        } else {
            mQSyncItem.clearIndoubt();
        }
        mQSync.writeSync(mQSyncItem, externalLocalTransaction);
        externalLocalTransaction.commit();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"resolveSyncItem");
        }
    }

    public void resolve(boolean bl) {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"resolve");
        }
        if (this.auditEnabled) {
            objectArray = new Object[]{this.mqLinkName};
            if (bl) {
                SibTr.audit((TraceComponent)tc, (String)"INFO_MQLINK_RESOLVE_COMMIT_SICO3233", (Object)objectArray);
            } else {
                SibTr.audit((TraceComponent)tc, (String)"INFO_MQLINK_RESOLVE_BACKOUT_SICO3234", (Object)objectArray);
            }
        }
        try {
            objectArray = (Object[])this.engine.getMessageProcessor();
            AuthUtilsFactory authUtilsFactory = AuthUtilsFactory.getInstance();
            AuthUtils authUtils = authUtilsFactory.createNewAuthUtils();
            Subject subject = authUtils.getSIBServerSubject();
            SICoreConnection sICoreConnection = objectArray.createConnection(subject, new HashMap());
            MPCoreConnection mPCoreConnection = (MPCoreConnection)sICoreConnection;
            MessageStore messageStore = (MessageStore)this.engine.getMessageStore();
            MQSync mQSync = MQSync.open(messageStore, sICoreConnection, this.getMQLinkUuid());
            if (mQSync != null) {
                NonLockingCursor nonLockingCursor = mQSync.newNonLockingItemCursor(null);
                MQSyncItem mQSyncItem = (MQSyncItem)nonLockingCursor.next();
                while (mQSyncItem != null) {
                    if (mQSyncItem.getType() == 1 && mQSyncItem.isInDoubt()) {
                        this.resolveSyncItem(bl, mPCoreConnection, mQSync, mQSyncItem);
                    }
                    mQSyncItem = (MQSyncItem)nonLockingCursor.next();
                }
                nonLockingCursor.finished();
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"MQLink.resolve", (String)"1", (Object)this);
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"MQLink.resolve", (String)"2", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"resolve");
        }
    }

    public Properties display(String string, String string2) {
        Properties properties = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"display");
        }
        if (string.equalsIgnoreCase("qmgr")) {
            properties = new Properties();
            properties.setProperty("DESCR", this.description == null ? "" : this.description);
            properties.setProperty("QMNAME", this.qmgrName);
            properties.setProperty("CRDATE", MQUtil.timeToMQDate(this.createTime));
            properties.setProperty("CRTIME", MQUtil.timeToMQTime(this.createTime));
            properties.setProperty("ALTDATE", MQUtil.timeToMQDate(this.altTime));
            properties.setProperty("ALTTIME", MQUtil.timeToMQTime(this.altTime));
            properties.setProperty("PLATFORM", System.getProperty("os.name"));
            properties.setProperty("CCSID", new Integer(1208).toString());
        } else if (string.equalsIgnoreCase("channel") || string.equalsIgnoreCase("chstatus")) {
            if (string2 != null && string2.equals(this.senderChannel)) {
                properties = this.sender.display(string);
            } else if (string2 == null || string2.equals(this.receiverChannel)) {
                // empty if block
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"display");
        }
        return properties;
    }

    synchronized boolean setSender(MQLinkSender mQLinkSender) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSender");
        }
        if (this.sender == null) {
            this.sender = mQLinkSender;
            this.sender.setState(this.senderState);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSender");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSender");
        }
        return false;
    }

    public synchronized void unsetSender(MQLinkSender mQLinkSender) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unsetSender");
        }
        if (this.sender == mQLinkSender) {
            this.senderState = this.sender.getState();
            this.sender = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unsetSender");
        }
    }

    public synchronized boolean setReceiver(MQLinkReceiver mQLinkReceiver) {
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReceiver");
        }
        if (this.isReceiverStopped()) {
            return false;
        }
        if (this.receiverList == null) {
            this.receiverList = new ConversationState();
        } else {
            MQLinkReceiver mQLinkReceiver2 = (MQLinkReceiver)this.receiverList.scanObjects(staticSetReceiverCallback, mQLinkReceiver, null);
            if (mQLinkReceiver2 != null) {
                if (!this.adoptEnabled) {
                    return false;
                }
                mQLinkReceiver2.adopted();
            }
        }
        try {
            l = this.receiverList.addVObject(mQLinkReceiver);
        }
        catch (ObjectStoreFullException objectStoreFullException) {
            FFDCFilter.processException((Throwable)objectStoreFullException, (String)"MQLink.setReceiver", (String)"1", (Object)this);
            return false;
        }
        mQLinkReceiver.setHandle(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReceiver");
        }
        return true;
    }

    public synchronized void unsetReceiver(MQLinkReceiver mQLinkReceiver) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unsetReceiver");
        }
        if (this.receiverList != null && mQLinkReceiver != null && mQLinkReceiver.getHandle() >= 10L) {
            this.receiverList.removeVObject(mQLinkReceiver.getHandle());
        }
        if (this.receiverList != null && this.receiverList.getObjectCount() == 0 && this.receiverState != 9) {
            this.receiverState = 0;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unsetReceiver");
        }
    }

    public JsMessagingEngine getEngine() {
        return this.engine;
    }

    public boolean isStopped() {
        return this.getLinkState() == 9;
    }

    public boolean isSenderStopped() {
        return this.getSenderState() == 9;
    }

    public boolean isReceiverStopped() {
        return this.receiverState == 9;
    }

    public void setSenderStopped() {
        this.setSenderState(9);
    }

    public void cancelSenderResetSequenceNumber() {
        this.resetSenderSequenceNumber = 0;
    }

    public String getMQLinkName() {
        return this.mqLinkName;
    }

    public String getMQLinkUuid() {
        return this.mqLinkUuid;
    }

    public String getMQLinkTargetUuid() {
        return this.mqLinkTargetUuid;
    }

    public String getSenderChannelName() {
        return this.senderChannel;
    }

    public String getReceiverChannelName() {
        return this.receiverChannel;
    }

    public String getSenderHostName() {
        return this.senderHostName;
    }

    public short getSenderPort() {
        return this.senderPort;
    }

    public String getQMName() {
        return this.qmgrName;
    }

    public int getSenderResetSequenceNumber() {
        return this.resetSenderSequenceNumber;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public int getDisconnectInterval() {
        return this.disconnectInterval;
    }

    public boolean isNpmSpeedFast() {
        return this.npmSpeedFast;
    }

    public int getShortRetryCount() {
        return this.shortRetryCount;
    }

    public int getShortRetryInterval() {
        return this.shortRetryInterval;
    }

    public int getLongRetryCount() {
        return this.longRetryCount;
    }

    public int getLongRetryInterval() {
        return this.longRetryInterval;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public int getMessageSeqWrapValue() {
        return this.messageSeqWrapValue;
    }

    public int getTransmissionSize() {
        return this.maxTransmissionSize;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public boolean isAuditEnabled() {
        return this.auditEnabled;
    }

    public boolean isAdoptEnabled() {
        return this.adoptEnabled;
    }

    public Reliability getInboundNPReliability() {
        return this.inboundNPReliability;
    }

    public Reliability getInboundPersReliability() {
        return this.inboundPersReliability;
    }

    public MQLinkStats getStats() {
        return this.stats;
    }

    public long getAltTime() {
        return this.altTime;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public SIBMQLinkState getMQLinkOverallStatus() {
        return new SIBMQLinkState(this.getLinkState());
    }

    public void stopMQLink(int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopMQLink");
        }
        this.stopSender(n, n2);
        this.stopReceiver(n, n2);
        this.emitNotification(2, 1);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopMQLink");
        }
    }

    public void stopSender(int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopSender");
        }
        if (this.sender != null) {
            this.sender.stop(n, n2);
        } else {
            this.senderState = n2 == 1 ? 0 : 9;
        }
        this.emitNotification(4, 1);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopSender");
        }
    }

    public void stopReceiver(int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopReceiver");
        }
        if (this.receiverList != null) {
            this.receiverList.scanObjects(staticStopCallback, new Integer(n), new Integer(n2));
        }
        if (n2 == 0) {
            this.receiverState = 9;
        }
        this.emitNotification(8, 1);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopReceiver");
        }
    }

    public void stopReceiverInstance(long l, int n) {
        MQLinkReceiver mQLinkReceiver;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopReceiverInstance");
        }
        if (this.receiverList != null && (mQLinkReceiver = (MQLinkReceiver)this.receiverList.getVObject(l)) != null) {
            mQLinkReceiver.stop(n, 1);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopReceiverInstance");
        }
    }

    public SIBMQLinkSenderCurrentStatus getSenderCurrentStatus() {
        SIBMQLinkSenderCurrentStatus sIBMQLinkSenderCurrentStatus;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSenderCurrentStatus");
        }
        if (this.sender != null) {
            sIBMQLinkSenderCurrentStatus = this.sender.getSenderCurrentStatus();
        } else if (this.isSenderStopped()) {
            sIBMQLinkSenderCurrentStatus = new SIBMQLinkSenderCurrentStatus();
            sIBMQLinkSenderCurrentStatus.setStatus(new SIBMQLinkState(9));
        } else {
            sIBMQLinkSenderCurrentStatus = new SIBMQLinkSenderCurrentStatus();
            sIBMQLinkSenderCurrentStatus.setStatus(new SIBMQLinkState(0));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSenderCurrentStatus", (Object)sIBMQLinkSenderCurrentStatus);
        }
        return sIBMQLinkSenderCurrentStatus;
    }

    public List getReceiverCurrentStatus() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReceiverCurrentStatus");
        }
        if (this.receiverList == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        this.receiverList.scanObjects(staticStatusCallback, arrayList, null);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReceiverCurrentStatus");
        }
        if (arrayList.size() != 0) {
            return arrayList;
        }
        return null;
    }

    public List getSenderSavedStatus() {
        ArrayList<SIBMQLinkSenderSavedStatus> arrayList = new ArrayList<SIBMQLinkSenderSavedStatus>();
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSenderSavedSatus");
        }
        try {
            SICoreConnectionFactory sICoreConnectionFactory = (SICoreConnectionFactory)this.engine.getMessageProcessor();
            AuthUtilsFactory authUtilsFactory = AuthUtilsFactory.getInstance();
            AuthUtils authUtils = authUtilsFactory.createNewAuthUtils();
            Subject subject = authUtils.getSIBServerSubject();
            SICoreConnection sICoreConnection = sICoreConnectionFactory.createConnection(subject, new HashMap());
            MessageStore messageStore = (MessageStore)this.engine.getMessageStore();
            MQSync mQSync = MQSync.open(messageStore, sICoreConnection, this.getMQLinkUuid());
            if (mQSync != null) {
                NonLockingCursor nonLockingCursor = mQSync.newNonLockingItemCursor(null);
                MQSyncItem mQSyncItem = (MQSyncItem)nonLockingCursor.next();
                while (mQSyncItem != null) {
                    if (mQSyncItem.getType() == 1) {
                        SIBMQLinkSenderSavedStatus sIBMQLinkSenderSavedStatus = new SIBMQLinkSenderSavedStatus();
                        sIBMQLinkSenderSavedStatus.setQueueManager(mQSyncItem.getRemoteQmgrName());
                        sIBMQLinkSenderSavedStatus.setChannelName(mQSyncItem.getChannelName());
                        sIBMQLinkSenderSavedStatus.setInDoubt(new Boolean(mQSyncItem.isInDoubt()));
                        sIBMQLinkSenderSavedStatus.setCurrentLUWID(Long.toHexString(mQSyncItem.getInDoubtLuwid()));
                        sIBMQLinkSenderSavedStatus.setCurrentSequenceNumber(new Long(mQSyncItem.getInDoubtSequenceNumber()));
                        sIBMQLinkSenderSavedStatus.setLastLUWID(Long.toHexString(mQSyncItem.getCommittedLuwid()));
                        sIBMQLinkSenderSavedStatus.setLastSequenceNumber(new Long(mQSyncItem.getCommittedSequenceNumber()));
                        arrayList.add(sIBMQLinkSenderSavedStatus);
                    }
                    mQSyncItem = (MQSyncItem)nonLockingCursor.next();
                }
                nonLockingCursor.finished();
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"MQLink.getSenderSavedStatus", (String)"1", (Object)this);
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"MQLink.getSenderSavedStatus", (String)"2", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSenderSavedStatus");
        }
        if (arrayList.size() != 0) {
            return arrayList;
        }
        return null;
    }

    public List getReceiverSavedStatus() {
        ArrayList<SIBMQLinkReceiverSavedStatus> arrayList = new ArrayList<SIBMQLinkReceiverSavedStatus>();
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReceiverSavedStatus");
        }
        try {
            SICoreConnectionFactory sICoreConnectionFactory = (SICoreConnectionFactory)this.engine.getMessageProcessor();
            AuthUtilsFactory authUtilsFactory = AuthUtilsFactory.getInstance();
            AuthUtils authUtils = authUtilsFactory.createNewAuthUtils();
            Subject subject = authUtils.getSIBServerSubject();
            SICoreConnection sICoreConnection = sICoreConnectionFactory.createConnection(subject, new HashMap());
            MessageStore messageStore = (MessageStore)this.engine.getMessageStore();
            MQSync mQSync = MQSync.open(messageStore, sICoreConnection, this.getMQLinkUuid());
            if (mQSync != null) {
                NonLockingCursor nonLockingCursor = mQSync.newNonLockingItemCursor(null);
                MQSyncItem mQSyncItem = (MQSyncItem)nonLockingCursor.next();
                while (mQSyncItem != null) {
                    if (mQSyncItem.getType() == 2) {
                        SIBMQLinkReceiverSavedStatus sIBMQLinkReceiverSavedStatus = new SIBMQLinkReceiverSavedStatus();
                        sIBMQLinkReceiverSavedStatus.setQueueManager(mQSyncItem.getRemoteQmgrName());
                        sIBMQLinkReceiverSavedStatus.setChannelName(mQSyncItem.getChannelName());
                        sIBMQLinkReceiverSavedStatus.setLastLUWID(Long.toHexString(mQSyncItem.getCommittedLuwid()));
                        sIBMQLinkReceiverSavedStatus.setLastSequenceNumber(new Long(mQSyncItem.getCommittedSequenceNumber()));
                        arrayList.add(sIBMQLinkReceiverSavedStatus);
                    }
                    mQSyncItem = (MQSyncItem)nonLockingCursor.next();
                }
                nonLockingCursor.finished();
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"MQLink.getSenderSavedStatus", (String)"1", (Object)this);
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"MQLink.getSenderSavedStatus", (String)"2", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReceiverSavedStatus");
        }
        if (arrayList.size() != 0) {
            return arrayList;
        }
        return null;
    }

    public void startSender() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"startSender");
        }
        if (this.senderChannel.length() != 0) {
            if (this.sender == null) {
                this.sender = new MQLinkSender(this);
            }
            this.emitNotification(3);
            this.sender.startSender();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"startSender");
        }
    }

    public void startReceiver() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"startReceiver");
        }
        this.receiverState = 0;
        this.emitNotification(7);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"startReceiver");
        }
    }

    public void commitSender() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitSender");
        }
        this.resolve(true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitSender");
        }
    }

    public void rollbackSender() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollbackSender");
        }
        this.resolve(false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollbackSender");
        }
    }

    public SIBMQLinkState getReceiverOverallStatus() {
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"getReceiverOverallStatus");
        }
        if (this.receiverList != null) {
            if (this.receiverList.getObjectCount() != 0) {
                return new SIBMQLinkState(10);
            }
            return new SIBMQLinkState(this.receiverState);
        }
        return new SIBMQLinkState(this.receiverState);
    }

    public void serverStarted() {
    }

    public void serverStopping() {
    }

    public boolean isBusSecure(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isBusSecure");
        }
        AuthUtils authUtils = AuthUtilsFactory.getInstance().createNewAuthUtils();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isBusSecure");
        }
        return authUtils.isBusSecure(string);
    }

    public void busReloaded(SIBus sIBus, boolean bl, boolean bl2, boolean bl3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"busReloaded");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"busReloaded");
        }
    }

    public void engineReloaded(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"engineReloaded");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"engineReloaded");
        }
    }

    public boolean isDeletable(ItemStream itemStream) {
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isMQLinkDeletable");
        }
        if (itemStream != null) {
            if (!((MQSync)itemStream).isIndoubt(this.mqLinkName)) {
                ((MQSync)itemStream).destroy(this.mqLinkName);
            } else {
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isMQLinkDeletable");
        }
        return bl;
    }

    private void setSenderState(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSenderState");
        }
        if (this.sender == null) {
            this.senderState = n;
        } else {
            this.sender.setState(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSenderState");
        }
    }

    private int getSenderState() {
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"getSenderState");
        }
        if (this.sender == null) {
            return this.senderState;
        }
        return this.sender.getState();
    }

    private int getLinkState() {
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"getLinkState");
        }
        if (this.getSenderState() == 9 && this.getReceiverOverallStatus().intValue() == 9) {
            return 9;
        }
        return 6;
    }

    public void setRuntimeEventListener(RuntimeEventListener runtimeEventListener) {
        this.runtimeEventListener = runtimeEventListener;
    }

    public RuntimeEventListener getRuntimeEventListener() {
        return this.runtimeEventListener;
    }

    public void emitNotification(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"emitNotification", (Object)(" Type = " + n));
        }
        this.emitNotification(n, 0);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"emitNotification");
        }
    }

    public void emitNotification(int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"emitNotification", (Object)(" Type = " + n + " Reason = " + n2));
        }
        this.emitNotification(n, n2, " ");
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"emitNotification");
        }
    }

    public void emitNotification(int n, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"emitNotification", (Object)(" Type = " + n + " RemoteQMgr = " + string));
        }
        this.emitNotification(n, 0, string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"emitNotification");
        }
    }

    public void emitNotification(int n, int n2, String string) {
        block27: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"emitNotification", (Object)(" Type = " + n + " Reason = " + n2 + " RemoteQMgr = " + string));
            }
            if (this.engine != null & this.engine.isEventNotificationEnabled()) {
                try {
                    String string2;
                    Properties properties = new Properties();
                    String string3 = null;
                    String string4 = null;
                    if (string == null) {
                        string = " ";
                    }
                    switch (n2) {
                        case 0: {
                            string2 = " ";
                            break;
                        }
                        case 1: {
                            string2 = "stop.reason.administrator.command";
                            break;
                        }
                        case 2: {
                            string2 = "communications.failure";
                            break;
                        }
                        case 3: {
                            string2 = "requested.by.remote.qm";
                            break;
                        }
                        default: {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"unknown notification reason");
                            }
                            throw new SIErrorException("Unknown notification reason");
                        }
                    }
                    properties.put("mqlink.name", this.mqLinkName);
                    switch (n) {
                        case 1: {
                            string3 = "SIB.mqlink.start";
                            string4 = nls.getFormattedMessage("MQLINK_STARTED_SICO3300", new Object[]{this.mqLinkName, this.engine.getBusName()}, null);
                            break;
                        }
                        case 2: {
                            string3 = "SIB.mqlink.stop";
                            string4 = nls.getFormattedMessage("MQLINK_STOPPED_SICO3301", new Object[]{this.mqLinkName, this.engine.getBusName()}, null);
                            properties.put("stop.reason", string2);
                            break;
                        }
                        case 3: {
                            string3 = "SIB.mqlink.sender.start";
                            string4 = nls.getFormattedMessage("MQLINK_SENDER_STARTED_SICO3302", new Object[]{this.senderChannel, this.mqLinkName, this.engine.getBusName()}, null);
                            properties.put("mqlink.sender.name", this.senderChannel);
                            break;
                        }
                        case 4: {
                            string3 = "SIB.mqlink.sender.stop";
                            string4 = nls.getFormattedMessage("MQLINK_SENDER_STOPPED_SICO3303", new Object[]{this.senderChannel, this.mqLinkName, this.engine.getBusName()}, null);
                            properties.put("mqlink.sender.name", this.senderChannel);
                            properties.put("stop.reason", string2);
                            break;
                        }
                        case 5: {
                            string3 = "SIB.mqlink.sender.session.start";
                            string4 = nls.getFormattedMessage("MQLINK_SENDER_SESSION_STARTED_SICO3304", new Object[]{this.senderChannel, this.mqLinkName, this.engine.getBusName(), string}, null);
                            properties.put("mqlink.sender.name", this.senderChannel);
                            properties.put("remote.queue.manager.name", string);
                            break;
                        }
                        case 6: {
                            string3 = "SIB.mqlink.sender.session.stop";
                            string4 = nls.getFormattedMessage("MQLINK_SENDER_SESSION_STOPPED_SICO3305", new Object[]{this.senderChannel, this.mqLinkName, this.engine.getBusName(), string}, null);
                            properties.put("mqlink.sender.name", this.senderChannel);
                            properties.put("remote.queue.manager.name", string);
                            properties.put("stop.reason", string2);
                            break;
                        }
                        case 7: {
                            string3 = "SIB.mqlink.receiver.start";
                            string4 = nls.getFormattedMessage("MQLINK_RECEIVER_STARTED_SICO3306", new Object[]{this.receiverChannel, this.mqLinkName, this.engine.getBusName()}, null);
                            properties.put("mqlink.receiver.channel.name", this.receiverChannel);
                            break;
                        }
                        case 8: {
                            string3 = "SIB.mqlink.receiver.stop";
                            string4 = nls.getFormattedMessage("MQLINK_RECEIVER_STOPPED_SICO3307", new Object[]{this.receiverChannel, this.mqLinkName, this.engine.getBusName()}, null);
                            properties.put("mqlink.receiver.channel.name", this.receiverChannel);
                            break;
                        }
                        case 9: {
                            string3 = "SIB.mqlink.receiver.session.start";
                            string4 = nls.getFormattedMessage("MQLINK_RECEIVER_SESSION_STARTED_SICO3308", new Object[]{this.receiverChannel, this.mqLinkName, this.engine.getBusName(), string}, null);
                            properties.put("mqlink.receiver.channel.name", this.receiverChannel);
                            properties.put("remote.queue.manager.name", string);
                            break;
                        }
                        case 10: {
                            string3 = "SIB.mqlink.sender.session.stop";
                            string4 = nls.getFormattedMessage("MQLINK_RECEIVER_SESSION_STOPPED_SICO3309", new Object[]{this.receiverChannel, this.mqLinkName, this.engine.getBusName(), string}, null);
                            properties.put("mqlink.receiver.channel.name", this.receiverChannel);
                            properties.put("remote.queue.manager.name", string);
                            properties.put("stop.reason", string2);
                            break;
                        }
                        default: {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"unknown notification type");
                            }
                            throw new SIErrorException("Unknown notification type");
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Issuing event notification on engine: " + this.engine + "\n" + "notification: " + string3 + "\nproperties: " + properties));
                    }
                    this.runtimeEventListener.runtimeEventOccurred(this.engine, string3, string4, properties);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".emitNotification"), (String)"1", (Object)this);
                    if (!tc.isEntryEnabled()) break block27;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"emitNotification");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/link/MQLink.java, SIB.comms, WAS60.SIB, o0444.07 1.55");
        }
        staticDestroyCallback = new DestroyCallback();
        staticSetReceiverCallback = new SetReceiverCallback();
        staticStopCallback = new StopCallback();
        staticStatusCallback = new StatusCallback();
    }

    private static class StatusCallback
    implements ConversationState.ScanCallback {
        private StatusCallback() {
        }

        public Object examineObject(Object object, Object object2, Object object3) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"examineObject");
            }
            List list = (List)object2;
            list.add(((MQLinkReceiver)object).getReceiverCurrentStatus());
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"examineObject");
            }
            return null;
        }
    }

    private static class StopCallback
    implements ConversationState.ScanCallback {
        private StopCallback() {
        }

        public Object examineObject(Object object, Object object2, Object object3) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"examineObject");
            }
            ((MQLinkReceiver)object).stop((Integer)object2, (Integer)object3);
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"examineObject");
            }
            return null;
        }
    }

    private static class SetReceiverCallback
    implements ConversationState.ScanCallback {
        private SetReceiverCallback() {
        }

        public Object examineObject(Object object, Object object2, Object object3) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"examineObject");
            }
            MQLinkReceiver mQLinkReceiver = (MQLinkReceiver)object;
            MQLinkReceiver mQLinkReceiver2 = (MQLinkReceiver)object2;
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"examineObject");
            }
            if (mQLinkReceiver.getRemoteQMName().equals(mQLinkReceiver2.getRemoteQMName())) {
                return mQLinkReceiver;
            }
            return null;
        }
    }

    private static class DestroyCallback
    implements ConversationState.ScanCallback {
        private DestroyCallback() {
        }

        public Object examineObject(Object object, Object object2, Object object3) {
            ((MQLinkReceiver)object).destroy();
            return null;
        }
    }
}

