/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.link;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.admin.SIBMQClientLinkConnectionStatus;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.sib.admin.JsConfigComponent;
import com.ibm.ws.sib.admin.JsEObject;
import com.ibm.ws.sib.admin.JsEngineComponentWithEventListener;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.admin.SIBMQClientLinkRuntime;
import com.ibm.ws.sib.admin.SIBMQClientLinkState;
import com.ibm.ws.sib.comms.DirectConnection;
import com.ibm.ws.sib.comms.impl.ConversationState;
import com.ibm.ws.sib.comms.impl.DirectConnectionImpl;
import com.ibm.ws.sib.comms.mq.client.MQClientServer;
import com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine;
import com.ibm.ws.sib.comms.mq.client.MQHObject;
import com.ibm.ws.sib.comms.mq.link.LinkConstants;
import com.ibm.ws.sib.comms.mq.link.MQClientLinkJMSServerMBean;
import com.ibm.ws.sib.comms.mq.link.MQLinkManagerImpl;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public class MQClientLink
implements LinkConstants,
JsEngineComponentWithEventListener,
MQConstants,
SIBMQClientLinkRuntime,
JsConfigComponent {
    private String name = "";
    private String description = "";
    private String channelName = "";
    private String qmName = "";
    private boolean defaultQM = false;
    private int maxMsgSize = Integer.MAX_VALUE;
    private int heartbeat = 300;
    private int initialState = 0;
    private Reliability inboundPersistentReliability = Reliability.ASSURED_PERSISTENT;
    private Reliability inboundNonPersistentReliability = Reliability.RELIABLE_NONPERSISTENT;
    private String brokerConQ = "SYSTEM.BROKER.CONTROL.QUEUE";
    private String brokerPubQ = "SYSTEM.BROKER.DEFAULT.STREAM";
    private String brokerSubQ = "SYSTEM.JMS.ND.SUBSCRIBER.QUEUE";
    private String brokerDurSubQ = "SYSTEM.JMS.D.SUBSCRIBER.QUEUE";
    private String brokerCCSubQ = "SYSTEM.JMS.ND.CC.SUBSCRIBER.QUEUE";
    private String brokerCCDurSubQ = "SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE";
    private String defaultTopicSpace = "Default.Topic.Space";
    private String mqClientLinkUUID;
    private String meName = "";
    private String busName = "";
    private DirectConnection directConnect = new DirectConnectionImpl();
    private int overallState;
    private ConversationState mqClientServerStore = null;
    long createTime;
    long altTime;
    private boolean migratedClientLink = false;
    private RuntimeEventListener runtimeEventListener;
    private JsMessagingEngine engine;
    private static String CLASS_NAME = MQClientLink.class.getName();
    private int appServerStartMode = 0;
    private static final TraceComponent tc = SibTr.register((Class)MQClientLink.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls;
    private HashMap tmpDestNameToInfoMap = new HashMap();

    public void startMQClientLink() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"startMQClientLink");
        }
        if (this.overallState == 1) {
            this.overallState = 0;
            if (this.mqClientServerStore != null) {
                List list = this.mqClientServerStore.getAllObjects();
                for (int i = 0; i < list.size(); ++i) {
                    MQClientServer mQClientServer;
                    block8: {
                        mQClientServer = (MQClientServer)list.get(i);
                        if (mQClientServer == null) continue;
                        MQClientServerStateMachine mQClientServerStateMachine = mQClientServer.getMQClientServerStateMachine();
                        if (mQClientServerStateMachine != null && mQClientServerStateMachine.getMQClientLinkInstanceStatus() == 1) {
                            mQClientServerStateMachine = null;
                            mQClientServer.setMQClientServerStateMachine(null);
                        }
                        long l = mQClientServer.getMQClientServerStoreHandle();
                        try {
                            this.mqClientServerStore.removeVObject(l);
                            mQClientServer.setMQClientServerStoreHandle(0L);
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            if (!tc.isDebugEnabled()) break block8;
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"The MQClientServer to be removed could not be found in the store", (Object)noSuchElementException);
                        }
                    }
                    mQClientServer = null;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"startMQClientLink");
        }
    }

    public void stopMQClientLink(int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopMQClientLink");
        }
        this.overallState = n2 == 0 ? 1 : 0;
        if (this.mqClientServerStore != null) {
            List list = this.mqClientServerStore.getAllObjects();
            for (int i = 0; i < list.size(); ++i) {
                MQClientServerStateMachine mQClientServerStateMachine;
                MQClientServer mQClientServer = (MQClientServer)list.get(i);
                if (mQClientServer == null || (mQClientServerStateMachine = mQClientServer.getMQClientServerStateMachine()) == null) continue;
                try {
                    Connection connection;
                    if (n == 0 && (connection = mQClientServerStateMachine.getConnection()) != null) {
                        connection.close();
                    }
                    mQClientServer.stop();
                    if (n2 == 0) {
                        if (mQClientServerStateMachine.getMQClientLinkInstanceStatus() == 1) continue;
                        if (n == 0) {
                            mQClientServerStateMachine.gotoMQClientLinkInstanceStatus(1);
                            continue;
                        }
                        mQClientServerStateMachine.gotoMQClientLinkInstanceStatus(5);
                        continue;
                    }
                    mQClientServerStateMachine = null;
                    mQClientServer.setMQClientServerStateMachine(null);
                    this.mqClientServerStore.removeVObject(mQClientServer.getMQClientServerStoreHandle());
                    mQClientServer.setMQClientServerStoreHandle(0L);
                    mQClientServer = null;
                    continue;
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"There was no status to remove for the MQClientLink instance", (Object)noSuchElementException);
                    continue;
                }
                catch (SIConnectionDroppedException sIConnectionDroppedException) {
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"The connection has dropped", (Object)((Object)sIConnectionDroppedException));
                    continue;
                }
                catch (SIConnectionLostException sIConnectionLostException) {
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"The connection is lost", (Object)((Object)sIConnectionLostException));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopMQClientLink");
        }
    }

    public boolean isMQClientLinkStarted() {
        return this.overallState == 0;
    }

    public boolean isMQClientLinkStopped() {
        return this.overallState == 1;
    }

    public String getMQClientLinkName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVirtualQmgrName() {
        return this.qmName;
    }

    public String getMQChannelName() {
        return this.channelName;
    }

    public int getInitialState() {
        return this.initialState;
    }

    public int getOverallState() {
        return this.overallState;
    }

    public int getHeartbeatInterval() {
        return this.heartbeat;
    }

    public int getMaxMessageSize() {
        return this.maxMsgSize;
    }

    public boolean getIsDefaultMQClientLink() {
        return this.defaultQM;
    }

    public String getMeName() {
        return this.meName;
    }

    public String getBusName() {
        return this.busName;
    }

    public Reliability getInboundPersistentReliability() {
        return this.inboundPersistentReliability;
    }

    public Reliability getInboundNonPersistentReliability() {
        return this.inboundNonPersistentReliability;
    }

    public String getBrokerConQ() {
        return this.brokerConQ;
    }

    public String getBrokerPubQ() {
        return this.brokerPubQ;
    }

    public String getBrokerSubQ() {
        return this.brokerSubQ;
    }

    public String getBrokerDurSubQ() {
        return this.brokerDurSubQ;
    }

    public String getBrokerCCSubQ() {
        return this.brokerCCSubQ;
    }

    public String getBrokerCCDurSubQ() {
        return this.brokerCCDurSubQ;
    }

    public String getDefaultTopicSpace() {
        return this.defaultTopicSpace;
    }

    public ConversationState getMQClientServerStore() {
        return this.mqClientServerStore;
    }

    public void setMQClientServerStore(ConversationState conversationState) {
        this.mqClientServerStore = conversationState;
    }

    public DirectConnection getConnectionProperties() {
        return this.directConnect;
    }

    public void error(String string) throws SIErrorException {
        System.err.println(string);
        SIErrorException sIErrorException = new SIErrorException(this.name + ":" + string);
        FFDCFilter.processException((Throwable)sIErrorException, (String)"MQClientLink.error", (String)"1", (Object)this);
        throw sIErrorException;
    }

    public void initialize(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialise");
        }
        this.engine = jsMessagingEngine;
        this.setAttribute("MeName", jsMessagingEngine.getName());
        this.setAttribute("BusName", jsMessagingEngine.getBusName());
        this.createTime = this.altTime = System.currentTimeMillis();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialise");
        }
    }

    public void start(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("AppServer is starting in mode " + n));
        }
        this.appServerStartMode = n;
        if ((n & 2) == 0) {
            MQLinkManagerImpl mQLinkManagerImpl = (MQLinkManagerImpl)MQLinkManagerImpl.getInstance();
            mQLinkManagerImpl.addMQClientLink(this);
            if (this.migratedClientLink) {
                this.registerMBean();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    public void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        if ((this.appServerStartMode & 2) == 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("ME is stopping in mode " + n));
            }
            int n2 = 1;
            this.stopMQClientLink(n, n2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"destroy");
        }
        if ((this.appServerStartMode & 2) == 0) {
            ((MQLinkManagerImpl)MQLinkManagerImpl.getInstance()).removeMQClientLink(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"destroy");
        }
    }

    public void setCustomProperty(String string, String string2) {
    }

    public void configure(JsEObject jsEObject) {
        String string;
        String string2;
        int n;
        this.altTime = System.currentTimeMillis();
        String[] stringArray = jsEObject.getAttributeNames();
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Configuration attributes names = " + stringArray));
        }
        for (n = 0; n < stringArray.length; ++n) {
            string2 = stringArray[n];
            string = jsEObject.getAttribute(stringArray[n]);
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Configuration attribute name " + string2 + " value " + string));
            }
            this.setAttribute(string2, string);
        }
        Map map = jsEObject.getChildren();
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Configuration child objects = " + map));
        }
        Object v = map.get("advancedProperties");
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("advancedProperties = " + v));
        }
        if (v != null) {
            String[] stringArray2 = ((JsEObject)v).getAttributeNames();
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Attribute names = " + stringArray2));
            }
            for (n = 0; n < stringArray2.length; ++n) {
                string2 = stringArray2[n];
                string = ((JsEObject)v).getAttribute(stringArray2[n]);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Attribute name = " + string2 + " Attribute value = " + string));
                }
                this.setAttribute(string2, string);
            }
        }
    }

    public void setAttribute(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAttribute");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Name, Value", (Object)new Object[]{string, string2});
        }
        if (string.equalsIgnoreCase("name")) {
            this.name = string2;
        } else if (string.equalsIgnoreCase("description")) {
            this.description = string2;
        } else if (string.equalsIgnoreCase("channelName")) {
            this.channelName = string2;
        } else if (string.equalsIgnoreCase("qmName")) {
            this.qmName = string2;
        } else if (string.equalsIgnoreCase("defaultQM")) {
            this.defaultQM = Boolean.valueOf(string2);
        } else if (string.equalsIgnoreCase("maxMsgSize")) {
            this.maxMsgSize = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("heartBeat")) {
            this.heartbeat = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("initialState")) {
            this.initialState = string2.equalsIgnoreCase("STARTED") ? 0 : 1;
            this.overallState = this.initialState;
        } else if (string.equalsIgnoreCase("inboundPersistentReliability")) {
            this.inboundPersistentReliability = string2.equalsIgnoreCase("RELIABLE") ? Reliability.RELIABLE_PERSISTENT : Reliability.ASSURED_PERSISTENT;
        } else if (string.equalsIgnoreCase("inboundNonPersistentReliabiity")) {
            this.inboundNonPersistentReliability = string2.equalsIgnoreCase("EXPRESS") ? Reliability.EXPRESS_NONPERSISTENT : (string2.equalsIgnoreCase("RELIABLE") ? Reliability.RELIABLE_NONPERSISTENT : Reliability.BEST_EFFORT_NONPERSISTENT);
        } else if (string.equalsIgnoreCase("brokerConQ")) {
            this.brokerConQ = string2;
        } else if (string.equalsIgnoreCase("brokerPubQ")) {
            this.brokerPubQ = string2;
        } else if (string.equalsIgnoreCase("brokerSubQ")) {
            this.brokerSubQ = string2;
        } else if (string.equalsIgnoreCase("brokerDurSubQ")) {
            this.brokerDurSubQ = string2;
        } else if (string.equalsIgnoreCase("brokerCCSubQ")) {
            this.brokerCCSubQ = string2;
        } else if (string.equalsIgnoreCase("brokerCCDurSubQ")) {
            this.brokerCCDurSubQ = string2;
        } else if (string.equalsIgnoreCase("defaultTopicSpace")) {
            this.defaultTopicSpace = string2;
        } else if (string.equalsIgnoreCase("MeName")) {
            this.meName = string2;
            this.directConnect.setName(this.meName);
        } else if (string.equalsIgnoreCase("BusName")) {
            this.busName = string2;
            this.directConnect.setBus(this.busName);
        } else if (string.equalsIgnoreCase("migratedDefinition")) {
            this.migratedClientLink = Boolean.getBoolean(string2);
        } else if (string.equalsIgnoreCase("UUID")) {
            this.mqClientLinkUUID = string2;
        } else {
            String string3 = nls.getFormattedMessage("INFO_MQCLIENTLINK_PARM_SICO3700", new Object[]{string, string2}, null);
            SIErrorException sIErrorException = new SIErrorException(string3);
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.comms.mq.link.MQClientLink", (String)"2", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unknown MQClientLink attributes " + string + "=" + string2));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAttribute");
        }
    }

    public String toString() {
        return "MQClientLink@" + this.hashCode() + ": Virtual QM Name: '" + this.getVirtualQmgrName() + "' Channel: '" + this.getMQChannelName() + "' ME Info: " + this.getMeName() + ":" + this.getBusName();
    }

    public SIBMQClientLinkState getMQClientLinkOverallStatus() {
        List list;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMQClientLinkOverallStatus");
        }
        int n = this.overallState;
        if (this.mqClientServerStore != null && (list = this.mqClientServerStore.getAllObjects()).size() > 0) {
            n = 6;
        }
        list = new SIBMQClientLinkState(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMQClientLinkOverallStatus");
        }
        return list;
    }

    public List getMQClientLinkConnectionStatus() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMQClientLinkConnectionStatus");
        }
        ArrayList<SIBMQClientLinkConnectionStatus> arrayList = new ArrayList<SIBMQClientLinkConnectionStatus>();
        if (this.mqClientServerStore != null) {
            List list = this.mqClientServerStore.getAllObjects();
            for (int i = 0; i < list.size(); ++i) {
                MQClientServerStateMachine mQClientServerStateMachine;
                MQClientServer mQClientServer = (MQClientServer)list.get(i);
                SIBMQClientLinkConnectionStatus sIBMQClientLinkConnectionStatus = null;
                if (mQClientServer != null && (mQClientServerStateMachine = mQClientServer.getMQClientServerStateMachine()) != null) {
                    sIBMQClientLinkConnectionStatus = mQClientServerStateMachine.getCurrentSIBMQClientLinkConnectionStatus();
                }
                arrayList.add(sIBMQClientLinkConnectionStatus);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMQClientLinkConnectionStatus");
        }
        return arrayList;
    }

    public void stopConnection(long l, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopConnection");
        }
        if (this.mqClientServerStore != null) {
            try {
                MQClientServerStateMachine mQClientServerStateMachine;
                MQClientServer mQClientServer = (MQClientServer)this.mqClientServerStore.getVObject(l);
                if (mQClientServer != null && (mQClientServerStateMachine = mQClientServer.getMQClientServerStateMachine()) != null) {
                    Connection connection;
                    if (n == 0 && (connection = mQClientServerStateMachine.getConnection()) != null) {
                        connection.close();
                    }
                    mQClientServer.stop();
                    if (mQClientServerStateMachine.getMQClientLinkInstanceStatus() != 1) {
                        if (n == 0) {
                            mQClientServerStateMachine.gotoMQClientLinkInstanceStatus(1);
                            mQClientServerStateMachine = null;
                            mQClientServer.setMQClientServerStateMachine(null);
                            this.mqClientServerStore.removeVObject(l);
                            mQClientServer.setMQClientServerStoreHandle(0L);
                            mQClientServer = null;
                        } else {
                            mQClientServerStateMachine.gotoMQClientLinkInstanceStatus(5);
                        }
                    } else {
                        mQClientServerStateMachine = null;
                        mQClientServer.setMQClientServerStateMachine(null);
                        this.mqClientServerStore.removeVObject(l);
                        mQClientServer.setMQClientServerStoreHandle(0L);
                        mQClientServer = null;
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"We tried to remove some state but failed to find any", (Object)noSuchElementException);
                }
            }
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"The connection has dropped", (Object)((Object)sIConnectionDroppedException));
                }
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"The connection is lost", (Object)((Object)sIConnectionLostException));
                }
                sIConnectionLostException.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopConnection");
        }
    }

    public void serverStarted() {
    }

    public void serverStopping() {
    }

    private void registerMBean() {
        block5: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerMBean");
            }
            try {
                String string = "JMSServer";
                MQClientLinkJMSServerMBean mQClientLinkJMSServerMBean = new MQClientLinkJMSServerMBean(this);
                String string2 = this.name;
                String string3 = AdminServiceFactory.getAdminService().getNodeName();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Registering MBean with name " + string + ", with MBeanId " + string2 + " and with unique Id " + string3 + string));
                }
                AdminServiceFactory.getMBeanFactory().activateMBean(string, (RuntimeCollaborator)new DefaultRuntimeCollaborator((Object)mQClientLinkJMSServerMBean, string3 + string), string2, null);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, (String)"com.ibm.ws.sib.comms.mq.link.MQClientLink", (String)"936", (Object)this);
                if (!tc.isDebugEnabled()) break block5;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Failed to register MBean", (Object)((Object)adminException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerMBean");
        }
    }

    public void busReloaded(SIBus sIBus, boolean bl, boolean bl2, boolean bl3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"busReloaded");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"busReloaded");
        }
    }

    public void engineReloaded(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"engineReloaded");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"engineReloaded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openNotification(MQHObject mQHObject) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"openNotification", (Object)("" + mQHObject + " (" + mQHObject.getName() + ")"));
        }
        boolean bl2 = bl = (mQHObject.getOpenOptions() & 1) == 1 || (mQHObject.getOpenOptions() & 4) == 4 || (mQHObject.getOpenOptions() & 2) == 2;
        if (mQHObject.isTemporaryDestination()) {
            HashMap hashMap = this.tmpDestNameToInfoMap;
            synchronized (hashMap) {
                if (this.tmpDestNameToInfoMap.containsKey(mQHObject.getName())) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Duplicate temporary queue name identified, [object:" + mQHObject + " name:" + mQHObject.getName() + "] ignoring."));
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("New temporary queue created (" + mQHObject.getName() + ") as a result of opening a model queue."));
                    }
                    this.tmpDestNameToInfoMap.put(mQHObject.getName(), new TemporaryDestinationInformation(mQHObject.getSessDestAddr(), bl ? 1 : 0));
                }
            }
        }
        if (bl) {
            HashMap hashMap = this.tmpDestNameToInfoMap;
            synchronized (hashMap) {
                if (this.tmpDestNameToInfoMap.containsKey(mQHObject.getName())) {
                    TemporaryDestinationInformation temporaryDestinationInformation = (TemporaryDestinationInformation)this.tmpDestNameToInfoMap.get(mQHObject.getName());
                    ++temporaryDestinationInformation.inputUsageCount;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Usage count of temporary queue (" + mQHObject.getName() + ") increased to " + temporaryDestinationInformation.inputUsageCount));
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"openNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIDestinationAddress closeNotification(MQHObject mQHObject) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"closeNotification", (Object)("" + mQHObject + " (" + mQHObject.getName() + ")"));
        }
        SIDestinationAddress sIDestinationAddress = null;
        boolean bl = (mQHObject.getOpenOptions() & 1) == 1 || (mQHObject.getOpenOptions() & 4) == 4 || (mQHObject.getOpenOptions() & 2) == 2;
        HashMap hashMap = this.tmpDestNameToInfoMap;
        synchronized (hashMap) {
            if (this.tmpDestNameToInfoMap.containsKey(mQHObject.getName())) {
                TemporaryDestinationInformation temporaryDestinationInformation = (TemporaryDestinationInformation)this.tmpDestNameToInfoMap.get(mQHObject.getName());
                if (mQHObject.isTemporaryDestination()) {
                    temporaryDestinationInformation.isQueueHandleClosed = true;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Handle used to open model queue, creating temporary queue (" + mQHObject.getName() + ") has been closed.  There are " + temporaryDestinationInformation.inputUsageCount + " users of this temporary queue."));
                    }
                }
                if (bl) {
                    --temporaryDestinationInformation.inputUsageCount;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Number of users using temporary queue (" + mQHObject.getName() + ") has decreased to" + temporaryDestinationInformation.inputUsageCount));
                    }
                }
                if (temporaryDestinationInformation.inputUsageCount == 0 && temporaryDestinationInformation.isQueueHandleClosed) {
                    this.tmpDestNameToInfoMap.remove(mQHObject.getName());
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("There are no open handles for temporary queue (" + mQHObject.getName() + ").  Removing it from table"));
                    }
                    sIDestinationAddress = temporaryDestinationInformation.address;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"closeNotification", (Object)("" + sIDestinationAddress));
        }
        return sIDestinationAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOpenForInputCount(MQHObject mQHObject) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOpenInputCount", (Object)("" + mQHObject + " (" + mQHObject.getName() + ")"));
        }
        int n = -1;
        HashMap hashMap = this.tmpDestNameToInfoMap;
        synchronized (hashMap) {
            if (this.tmpDestNameToInfoMap.containsKey(mQHObject.getName())) {
                TemporaryDestinationInformation temporaryDestinationInformation = (TemporaryDestinationInformation)this.tmpDestNameToInfoMap.get(mQHObject.getName());
                n = temporaryDestinationInformation.inputUsageCount;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOpenInputCount", (Object)("" + n));
        }
        return n;
    }

    public void setRuntimeEventListener(RuntimeEventListener runtimeEventListener) {
        this.runtimeEventListener = runtimeEventListener;
    }

    public RuntimeEventListener getRuntimeEventListener() {
        return this.runtimeEventListener;
    }

    public void emitNotification(int n, String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"emitNotification", (Object)(" Type = " + n + " Address = " + string2));
        }
        this.emitNotification(n, 0, string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"emitNotification");
        }
    }

    public void emitNotification(int n, int n2, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"emitNotification", (Object)(" Type = " + n + " Reason = " + n2 + " UserId = " + string));
        }
        this.emitNotification(n, n2, string, "");
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"emitNotification");
        }
    }

    public void emitNotification(int n, int n2, String string, String string2) {
        block18: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"emitNotification", (Object)(" Type = " + n + " Reason = " + n2 + " UserId = " + string + "Address " + string2));
            }
            if (this.engine != null & this.engine.isEventNotificationEnabled()) {
                try {
                    String string3;
                    Properties properties = new Properties();
                    String string4 = null;
                    String string5 = null;
                    switch (n2) {
                        case 0: {
                            string3 = "";
                            break;
                        }
                        case 1: {
                            string3 = "stop.reason.administrator.command";
                            break;
                        }
                        case 2: {
                            string3 = "communications.failure";
                            break;
                        }
                        case 4: {
                            string3 = "client.shutdown";
                            break;
                        }
                        default: {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"unknown notification reason");
                            }
                            throw new SIErrorException("Unknown notification reason");
                        }
                    }
                    properties.put("client.userid", string);
                    switch (n) {
                        case 11: {
                            string4 = "SIB.client.connection.start";
                            string5 = nls.getFormattedMessage("MQCLIENT_CONNECTED_SICO3310", new Object[]{string, string2}, null);
                            properties.put("fap.type", "MQFAP");
                            properties.put("communications.address", string2);
                            break;
                        }
                        case 12: {
                            string4 = "SIB.client.connection.stop";
                            string5 = nls.getFormattedMessage("MQCLIENT_DISCONNECTED_SICO3301", new Object[]{string}, null);
                            properties.put("stop.reason", string3);
                            break;
                        }
                        default: {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"unknown notification type");
                            }
                            throw new SIErrorException("Unknown notification type");
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Issuing event notification on engine: " + this.engine + "\n" + "notification: " + string4 + "\nproperties: " + properties));
                    }
                    this.runtimeEventListener.runtimeEventOccurred(this.engine, string4, string5, properties);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".emitNotification"), (String)"1", (Object)this);
                    if (!tc.isEntryEnabled()) break block18;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"emitNotification");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/link/MQClientLink.java, SIB.comms, WAS602.SIB, o0610.11 1.45");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    }

    private class TemporaryDestinationInformation {
        private int inputUsageCount = 0;
        private boolean isQueueHandleClosed = false;
        private SIDestinationAddress address = null;

        private TemporaryDestinationInformation(SIDestinationAddress sIDestinationAddress, int n) {
            this.address = sIDestinationAddress;
            this.inputUsageCount = n;
        }
    }
}

