/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.mq.MQLinkManager;
import com.ibm.ws.sib.comms.mq.client.DestinationDefinitionWrapper;
import com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine;
import com.ibm.ws.sib.comms.mq.client.MQException;
import com.ibm.ws.sib.comms.mq.client.MQHObject;
import com.ibm.ws.sib.comms.mq.client.MQHandleStore;
import com.ibm.ws.sib.comms.mq.client.Subscription;
import com.ibm.ws.sib.comms.mq.client.SubscriptionIdentity;
import com.ibm.ws.sib.comms.mq.client.SubscriptionTable;
import com.ibm.ws.sib.comms.mq.link.MQClientLink;
import com.ibm.ws.sib.comms.mq.link.MQLinkManagerImpl;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.comms.mq.util.MQFap;
import com.ibm.ws.sib.comms.mq.util.MQUtil;
import com.ibm.ws.sib.mfp.JsDestinationAddressFactory;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.mqinterop.MQHeaderFactory;
import com.ibm.ws.sib.mfp.mqinterop.api.MQMD;
import com.ibm.ws.sib.mfp.mqinterop.api.MQMD1;
import com.ibm.ws.sib.mfp.mqinterop.api.MQOD;
import com.ibm.ws.sib.mfp.mqinterop.api.MQPMO;
import com.ibm.ws.sib.mfp.mqinterop.api.MQRFH2;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQGet;
import com.ibm.ws.sib.mfp.mqinterop.util.HexString;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.ExceptionDestinationHandler;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.SIMPFactory;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.utils.TopicWildcardTranslation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;

public class PubSub
implements MQConstants {
    private static final TraceComponent tc = SibTr.register((Class)PubSub.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final int PUBSUB_CONTROL_Q = 1;
    private static final int PUBSUB_PUBLISH_Q = 2;
    private static final int PUBSUB_SUBSCRIBE_Q = 3;
    private static final int PUBSUB_CC_SUBSCRIBE_Q = 4;
    private static Hashtable optionFields;
    private static int validRegisterOptions;
    private static int validDeregisterOptions;
    private static int validPublishOptions;
    private static int persistenceOptions;
    private static int defaultRegisterOptions;
    private static int defaultPublishOptions;
    private static int defaultDeregisterOptions;
    private int qType;
    private MQHObject mqHObject;
    private Subscription subscription;
    private SubscriptionTable subscriptionTable;
    private SIDestinationAddress ccDestAddr;
    private boolean jmsQueueNeedsMapping = false;

    private PubSub(MQHObject mQHObject, int n) {
        this.mqHObject = mQHObject;
        this.qType = n;
    }

    protected boolean isControlQ() {
        return this.qType == 1;
    }

    protected boolean isPublishQ() {
        return this.qType == 2;
    }

    protected boolean isSubscriptionQ() {
        return this.qType == 3;
    }

    protected boolean isCCSubscriptionQ() {
        return this.qType == 4;
    }

    protected static boolean open(MQHObject mQHObject, MQOD mQOD, MQClientServerStateMachine mQClientServerStateMachine) throws MQException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"open");
        }
        PubSub pubSub = null;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            Object object;
            String string = mQHObject.getName();
            MQClientLink mQClientLink = mQClientServerStateMachine.getMQClientLink();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Analyzing destination name: " + string));
            }
            if (string == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"open");
                }
                return false;
            }
            if (string.equals(mQClientLink.getBrokerConQ())) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Opening the pubsub CONTROL queue");
                }
                pubSub = new PubSub(mQHObject, 1);
            } else if (string.equals(mQClientLink.getBrokerPubQ())) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Opening the pubsub PUBLISH queue");
                }
                pubSub = new PubSub(mQHObject, 2);
            } else {
                object = mQOD.getDynamicQName();
                if (object != null) {
                    object = ((String)object).trim();
                }
                if (object != null && ((String)object).endsWith("*") && (((String)object).equals(mQClientLink.getBrokerDurSubQ()) || ((String)object).equals(mQClientLink.getBrokerSubQ()) || ((String)object).equals(mQClientLink.getBrokerCCDurSubQ()) || ((String)object).equals(mQClientLink.getBrokerCCSubQ()))) {
                    byte[] byArray = mQClientServerStateMachine.getJSConnection().createUniqueId();
                    string = ((String)object).substring(0, ((String)object).length() - 1) + HexString.hexString((byte[])byArray);
                    mQHObject.setSessDestName(string);
                    mQOD.setObjectName(string);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Using dynamic destination name: " + string));
                    }
                    if (((String)object).equals(mQClientLink.getBrokerDurSubQ()) || ((String)object).equals(mQClientLink.getBrokerSubQ())) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Opening the pubsub SUBSCRIBE queue");
                        }
                        pubSub = new PubSub(mQHObject, 3);
                        bl2 = true;
                    } else {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Opening the pubsub connection consumer SUBSCRIBE queue");
                        }
                        bl3 = true;
                    }
                } else if (string.equals(mQClientLink.getBrokerDurSubQ()) || string.equals(mQClientLink.getBrokerSubQ())) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Opening the pubsub SUBSCRIBE queue");
                    }
                    pubSub = new PubSub(mQHObject, 3);
                    bl2 = true;
                } else if (string.equals(mQClientLink.getBrokerCCDurSubQ()) || string.equals(mQClientLink.getBrokerCCSubQ())) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Opening a pubsub connection consumer SUBSCRIBE queue");
                    }
                    bl3 = true;
                }
            }
            if (pubSub != null) {
                pubSub.subscriptionTable = object = SubscriptionTable.open((MessageStore)mQClientServerStateMachine.getEngine().getMessageStore());
                mQHObject.setPubSub(pubSub);
                if (bl2) {
                    ((SubscriptionTable)object).addSubscriptionQueue(mQHObject.getSessDestName());
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("isSubQ = " + bl2));
                    }
                } else if (bl3 && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("isCCSubQ = " + bl3));
                }
            }
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"open", (String)"1");
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Caught a MessageStoreException", (Object)((Object)messageStoreException));
            }
            throw new MQException(2195);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"open", (String)"2");
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Caught an SIException", (Object)((Object)sIException));
            }
            throw new MQException(2152);
        }
        boolean bl4 = bl = pubSub != null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"open", (Object)("" + bl));
        }
        return bl;
    }

    protected JsMessage put(MQClientServerStateMachine mQClientServerStateMachine, MQFap mQFap, SITransaction sITransaction) throws Exception {
        Object object;
        MQRFH2.Element element;
        HashMap hashMap;
        MQRFH2 mQRFH2;
        MQMD1 mQMD1;
        SICoreConnection sICoreConnection;
        int n;
        String string;
        block71: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"put");
            }
            string = "ok";
            n = 0;
            sICoreConnection = mQClientServerStateMachine.getJSConnection();
            MQHandleStore mQHandleStore = mQClientServerStateMachine.getMQHandleStore();
            MQRFH2 mQRFH22 = mQFap.getRFH2();
            mQMD1 = mQFap.getMQMD();
            MQPMO mQPMO = mQFap.getMQPut().getPutMsgOpts();
            if (mQMD1.getPersistence() == 2) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Setting persistence to MQPER_NOT_PERSISTENT");
                }
                mQMD1.setPersistence(0);
            }
            if (mQMD1.getPriority() == -1) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Setting priority to 0");
                }
                mQMD1.setPriority(0);
            }
            if ((mQPMO.getOptions() & 0x40) != 0 || new String(mQMD1.getMsgId()).equals("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000")) {
                mQMD1.setMsgId(mQClientServerStateMachine.getNextMessageId());
            }
            if ((mQPMO.getOptions() & 0x80) != 0) {
                mQMD1.setCorrelId(mQClientServerStateMachine.getNextCorrelationId());
            }
            mQRFH2 = MQHeaderFactory.instance().createMQRFH2();
            hashMap = new HashMap();
            try {
                if (mQRFH22 == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"RFH folder was null");
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"put");
                    }
                    return null;
                }
                if (mQRFH22.getFolderContent("psc") == null) {
                    n = 2339;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"psc folder not present in RFH2 folder");
                    }
                    break block71;
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("psc Folder: " + mQRFH22.getFolderContent("psc")));
                }
                mQRFH2.getFolder("pscr", true);
                if (this.qType == 1) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Putting message to control queue");
                    }
                    this.controlQPut(mQFap, sICoreConnection, mQHandleStore, mQClientServerStateMachine, hashMap, sITransaction);
                    break block71;
                }
                if (this.qType == 2) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Putting message to publish queue");
                    }
                    this.streamQPut(mQFap, sICoreConnection, mQClientServerStateMachine, sITransaction);
                    break block71;
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message put to wrong queue!");
                }
                throw new MQException(3079);
            }
            catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                FFDCFilter.processException((Throwable)sIConnectionUnavailableException, (String)"put", (String)"3", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SIConnectionUnavailableException", (Object)((Object)sIConnectionUnavailableException));
                }
                n = 3007;
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                FFDCFilter.processException((Throwable)sIConnectionLostException, (String)"put", (String)"4", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SIConnectionLostException", (Object)((Object)sIConnectionLostException));
                }
                n = 3007;
            }
            catch (SINotAuthorizedException sINotAuthorizedException) {
                FFDCFilter.processException((Throwable)sINotAuthorizedException, (String)"put", (String)"5", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SINotAuthorizedException", (Object)((Object)sINotAuthorizedException));
                }
                n = 3081;
            }
            catch (SIDestinationLockedException sIDestinationLockedException) {
                FFDCFilter.processException((Throwable)sIDestinationLockedException, (String)"put", (String)"6", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SIDestinationLockedExcepion", (Object)((Object)sIDestinationLockedException));
                }
                n = 3156;
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"put", (String)"7", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SIResourceException", (Object)((Object)sIResourceException));
                }
                n = 3007;
            }
            catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                FFDCFilter.processException((Throwable)sINotPossibleInCurrentConfigurationException, (String)"put", (String)"8", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SINotPossibleInCurrentConfigurationException", (Object)((Object)sINotPossibleInCurrentConfigurationException));
                }
                n = 3007;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"put", (String)"9", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an UnsupportedEncodingException", (Object)unsupportedEncodingException);
                }
                n = 3007;
            }
            catch (SIDiscriminatorSyntaxException sIDiscriminatorSyntaxException) {
                FFDCFilter.processException((Throwable)sIDiscriminatorSyntaxException, (String)"put", (String)"10", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SIDiscriminatorSyntaxException", (Object)((Object)sIDiscriminatorSyntaxException));
                }
                n = 3072;
            }
            catch (SISelectorSyntaxException sISelectorSyntaxException) {
                FFDCFilter.processException((Throwable)sISelectorSyntaxException, (String)"put", (String)"11", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SISelectorSyntaxException", (Object)((Object)sISelectorSyntaxException));
                }
                n = 2067;
            }
            catch (SIDurableSubscriptionAlreadyExistsException sIDurableSubscriptionAlreadyExistsException) {
                FFDCFilter.processException((Throwable)sIDurableSubscriptionAlreadyExistsException, (String)"put", (String)"12", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SIDurableSubscriptionAlreadyExistsException", (Object)((Object)sIDurableSubscriptionAlreadyExistsException));
                }
                n = 3155;
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"put", (String)"13", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SIException", (Object)((Object)sIException));
                }
                n = 3007;
            }
            catch (MessageCreateFailedException messageCreateFailedException) {
                FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"put", (String)"14", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an MessageCreateFailedException", (Object)((Object)messageCreateFailedException));
                }
                n = 3007;
            }
            catch (MQException mQException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an MQException", (Object)mQException);
                }
                n = mQException.getReason();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"put", (String)"15", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an Exception", (Object)exception);
                }
                n = 3007;
            }
        }
        if (n != 0) {
            if (n == 3157) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Already joined");
                }
                string = "warning";
            } else if (string.equals("ok")) {
                string = "error";
            }
        }
        if (mQMD1.getMsgType() == 8 && (n == 0 && (mQMD1.getReport() & 1) == 0 || string.equals("error") && (mQMD1.getReport() & 2) == 0 || string.equals("warning") && (mQMD1.getReport() & 2) == 0 && (mQMD1.getReport() & 1) == 0 || mQMD1.getReplyToQ().trim().length() == 0)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No response needed");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"put");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Setting return code to: " + string));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Setting reason to: " + n));
        }
        mQRFH2.setFieldValue("pscr", "Completion", (Object)string);
        if (n != 0) {
            element = mQRFH2.getFolder("pscr", true);
            object = element.addElement("Response");
            object.setValue("Reason", (Object)new Integer(n));
        }
        element = hashMap.entrySet().iterator();
        while (element.hasNext()) {
            object = (Map.Entry)element.next();
            mQRFH2.setFieldValue("pscr", (String)object.getKey(), (Object)((String)object.getValue()));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("RFH2 header: " + mQRFH2.toString()));
        }
        object = (MQMD1)mQFap.getMQMD().clone();
        object.setMsgType(2);
        object.setReplyToQ("");
        object.setReplyToQMgr("");
        int n2 = object.getReport();
        if ((n2 & 0x40) == 0) {
            object.setCorrelId(mQMD1.getMsgId());
        }
        if ((n2 & 0x80) == 0) {
            object.setMsgId("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes());
        }
        if (new String(object.getMsgId()).equals("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000")) {
            object.setMsgId(mQClientServerStateMachine.getNextMessageId());
        }
        String string2 = mQClientServerStateMachine.getMQClientLink().getVirtualQmgrName();
        MQPMO mQPMO = mQFap.getMQPut().getPutMsgOpts();
        int n3 = mQPMO.getOptions();
        mQPMO.setOptions(n3 |= 0x800);
        object.setApplOriginData(null);
        object.setPutApplName(string2.length() > 28 ? string2.substring(0, 28) : string2);
        object.setPutApplType(26);
        MQFap.setDateAndTime((MQMD1)object);
        object.setAccountingToken(null);
        object.setApplIdentityData(null);
        object.setUserIdentifier(null);
        MQFap mQFap2 = mQFap;
        mQFap = mQFap.createAPIReply();
        mQFap.setMQMD((MQMD1)object);
        if (mQFap.getMQPut() != null) {
            mQFap.getMQPut().setMsgDesc((MQMD)object);
        }
        mQFap.writeRFH(mQRFH2);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("pscr Folder: " + mQRFH2.getFolderContent("pscr")));
        }
        MQLinkManagerImpl mQLinkManagerImpl = (MQLinkManagerImpl)MQLinkManager.getInstance();
        String string3 = mQMD1.getReplyToQ().trim();
        boolean bl = mQLinkManagerImpl.isJmsPubSubSystemQueue(string3);
        this.mqHObject.setSystemObject(bl);
        JsMessage jsMessage = mQFap.decodeClientMessage(Reliability.RELIABLE_PERSISTENT, Reliability.RELIABLE_NONPERSISTENT, mQMD1.getReplyToQ().trim(), this.mqHObject, mQClientServerStateMachine, this.mqHObject.isSystemObject());
        if (bl) {
            string3 = mQLinkManagerImpl.mapSystemObjectName(string3);
        }
        SIDestinationAddressFactory sIDestinationAddressFactory = JsDestinationAddressFactory.getInstance();
        SIDestinationAddress sIDestinationAddress = sIDestinationAddressFactory.createSIDestinationAddress(string3, false);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Putting response message to " + sIDestinationAddress));
        }
        if (bl) {
            ((MPCoreConnection)sICoreConnection).systemSend((SIBusMessage)jsMessage, sITransaction, sIDestinationAddress, DestinationType.QUEUE, null, false);
        } else {
            sICoreConnection.send((SIBusMessage)jsMessage, sITransaction, sIDestinationAddress, DestinationType.QUEUE, null, null);
        }
        if (mQFap2.getMQPut() != null) {
            mQFap2.getMQPut().setMsgDesc((MQMD)mQMD1);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"put");
        }
        return null;
    }

    private void controlQPut(MQFap mQFap, SICoreConnection sICoreConnection, MQHandleStore mQHandleStore, MQClientServerStateMachine mQClientServerStateMachine, HashMap hashMap, SITransaction sITransaction) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"controlQPut");
        }
        MQRFH2 mQRFH2 = mQFap.getRFH2();
        MQMD1 mQMD1 = mQFap.getMQMD();
        String string = this.getStringFieldValue(mQRFH2, "psc", "Command");
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Processing command: " + string));
        }
        int n = 0;
        if (string.equals("RegSub")) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Handling a register subscriber");
            }
            if (!this.mqHObject.getName().equals("SYSTEM.BROKER.CONTROL.QUEUE")) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"**** Wrong queue! ****");
                }
                n = 3079;
            }
            this.registerSubscriber(mQRFH2, mQMD1, sICoreConnection, mQHandleStore, mQClientServerStateMachine, hashMap, sITransaction);
        } else if (string.equals("Publish")) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"**** Wrong queue! ****");
            }
            n = 3079;
        } else if (string.equals("DeregSub")) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Handling a deregister subscriber");
            }
            if (!this.mqHObject.getName().equals("SYSTEM.BROKER.CONTROL.QUEUE")) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"**** Wrong queue! ****");
                }
                n = 3079;
            }
            this.deregisterSubscriber(mQRFH2, mQMD1, sICoreConnection, mQHandleStore, mQClientServerStateMachine, hashMap, sITransaction);
        } else {
            n = 2337;
        }
        if (n != 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Throwing an MQException due to RC=" + n));
            }
            throw new MQException(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"controlQPut");
        }
    }

    protected ConsumerSession getConsumerSession(MQFap mQFap, MQClientServerStateMachine mQClientServerStateMachine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerSession");
        }
        MQGet mQGet = mQFap.getMQGet();
        MQMD mQMD = mQGet.getMsgDesc();
        ConsumerSession consumerSession = null;
        if (this.subscriptionTable != null) {
            SubscriptionIdentity subscriptionIdentity = new SubscriptionIdentity(mQMD.getCorrelId(), mQClientServerStateMachine.getMQClientLink().getVirtualQmgrName(), this.mqHObject.getName());
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Getting by ID from the subscription table", (Object)subscriptionIdentity);
            }
            this.subscription = this.subscriptionTable.getById(subscriptionIdentity);
            if (this.subscription != null) {
                consumerSession = this.subscription.getConsumerSession();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerSession");
        }
        return consumerSession;
    }

    protected void encode(MQFap mQFap) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encode");
        }
        if (this.subscription != null) {
            int n = this.subscription.getOptions();
            int n2 = n & persistenceOptions;
            MQMD1 mQMD1 = mQFap.getMQMD();
            if (n2 == 2048) {
                mQMD1.setPersistence(1);
            } else if (n2 == 1024) {
                mQMD1.setPersistence(0);
            } else if ((n & 0x2000) != 0) {
                mQMD1.setPersistence(1);
            } else if ((n & 0x1000) != 0) {
                // empty if block
            }
            if ((n & 1) != 0) {
                mQMD1.setCorrelId(this.subscription.getCorrelId());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encode");
        }
    }

    protected void encode(MQClientServerStateMachine mQClientServerStateMachine, JsMessage jsMessage) throws MQException {
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encode");
        }
        if ((n2 = (n = this.subscription.getOptions()) & persistenceOptions) == 2048) {
            jsMessage.setReliability(Reliability.ASSURED_PERSISTENT);
        } else if (n2 == 1024) {
            jsMessage.setReliability(Reliability.RELIABLE_NONPERSISTENT);
        } else if ((n & 0x2000) != 0) {
            if (this.jmsQueueNeedsMapping) {
                jsMessage.setReliability(Reliability.ASSURED_PERSISTENT);
            } else {
                String string = this.subscription.getQName();
                DestinationDefinitionWrapper destinationDefinitionWrapper = new DestinationDefinitionWrapper(mQClientServerStateMachine, string);
                jsMessage.setReliability(destinationDefinitionWrapper.getDefaultReliability());
            }
        } else if ((n & 0x1000) != 0) {
            // empty if block
        }
        if ((n & 1) != 0) {
            jsMessage.setCorrelationIdAsBytes(this.subscription.getCorrelId());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encode");
        }
    }

    private void streamQPut(MQFap mQFap, SICoreConnection sICoreConnection, MQClientServerStateMachine mQClientServerStateMachine, SITransaction sITransaction) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"streamQPut");
        }
        MQRFH2 mQRFH2 = mQFap.getRFH2();
        String string = this.getStringFieldValue(mQRFH2, "psc", "Command");
        int n = 0;
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Processing command: " + string));
        }
        if (string.equals("RegSub")) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"**** Wrong queue! ****");
            }
            n = 3079;
        } else if (string.equals("Publish")) {
            this.publish(mQFap, sICoreConnection, mQClientServerStateMachine, sITransaction);
        } else if (string.equals("DeregSub")) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"**** Wrong queue! ****");
            }
            n = 3079;
        } else {
            n = 2337;
        }
        if (n != 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Throwing an MQException due to RC=" + n));
            }
            throw new MQException(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"streamQPut");
        }
    }

    private void registerSubscriber(MQRFH2 mQRFH2, MQMD1 mQMD1, SICoreConnection sICoreConnection, MQHandleStore mQHandleStore, MQClientServerStateMachine mQClientServerStateMachine, HashMap hashMap, SITransaction sITransaction) throws Exception {
        Object object;
        ArrayList arrayList;
        SubscriptionIdentity subscriptionIdentity;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerSubscriber");
        }
        String string = this.getStringFieldValue(mQRFH2, "psc", "Topic");
        String string2 = this.getStringFieldValue(mQRFH2, "psc", "SubPoint");
        String string3 = this.getStringFieldValue(mQRFH2, "psc", "SubName");
        String string4 = this.getStringFieldValue(mQRFH2, "psc", "SubIdentity");
        String string5 = this.getStringFieldValue(mQRFH2, "psc", "SubUserData");
        String string6 = this.getQmgrName(mQRFH2, mQMD1);
        String string7 = this.getQName(mQRFH2, mQMD1);
        byte[] byArray = mQMD1.getCorrelId();
        String string8 = mQClientServerStateMachine.getUserId().trim();
        int n = this.getOptions(mQRFH2, "psc", "RegOpt", defaultRegisterOptions);
        String string9 = null;
        int n2 = 0;
        int n3 = 0;
        Subscription subscription = null;
        ConsumerSession consumerSession = null;
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Register subscriber parameters:", (Object)new Object[]{"Topic: " + string, "Subscription point: " + string2, "Subscription name: " + string3, "Subscription identity: " + string4, "Subscription user data: " + string5, "Queue manager name: " + string6, "Queue name: " + string7, "Options: " + n + " (0x" + Integer.toHexString(n) + ")", "         " + MQUtil.getOptions(n, "MQREGO_")});
        }
        if (string6 == null) {
            string6 = mQClientServerStateMachine.getMQClientLink().getVirtualQmgrName();
        }
        this.validateRegisterSubscriber(mQRFH2, n, string6, string7, string3, string4, mQClientServerStateMachine);
        if (string5 != null) {
            string9 = this.getFilter(string5);
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Filter: " + string9));
            }
        }
        if ((n & 0x10000) != 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Full response required");
            }
            hashMap.put("Command", "RegSub");
            if (string != null) {
                hashMap.put("Topic", string);
            }
            if (string6 != null) {
                hashMap.put("QMgrName", string6);
            }
            if (string5 != null) {
                hashMap.put("SubUserData", string5);
            }
            if (string2 != null) {
                hashMap.put("SubPoint", string2);
            }
            if (string7 != null) {
                hashMap.put("QName", string7);
            }
            if (string3 != null) {
                hashMap.put("SubName", string3);
            }
            if (string4 != null) {
                hashMap.put("SubIdentity", string4);
            }
            if (byArray != null) {
                hashMap.put("CorrelId", HexString.hexString((byte[])byArray));
            }
        }
        if ((subscriptionIdentity = this.subscriptionTable.locateUser(byArray, string6, string7, string8, (n & 0x100000) == 0, true, (Transaction)sITransaction)) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Duplicate subscription");
            }
            throw new MQException(3152);
        }
        Subscription subscription2 = null;
        Subscription subscription3 = null;
        if (string3 == null && string != null && byArray != null) {
            subscription3 = this.subscriptionTable.getById(subscriptionIdentity);
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Got old subscription by id", (Object)subscription3);
            }
        }
        if (string3 != null) {
            subscription2 = this.subscriptionTable.getByName(string3);
            if (subscription3 != null) {
                if (subscription3.getSubName() == null) {
                    if ((n & 0x4000) == 0) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Duplicate subscription but no MQREGO_ADD_NAME specified");
                        }
                        n2 = 3152;
                    }
                } else if (!subscription3.getSubName().equals(string3)) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Duplicate identity but different name on subscription");
                    }
                    n2 = 3152;
                }
            }
        }
        subscription = subscription2 != null ? subscription2 : subscription3;
        if (n2 != 0) {
            throw new MQException(n2);
        }
        if (string4 != null && subscription != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Subidentity (" + string4 + ") wants to join existing subscription " + subscription));
            }
            arrayList = subscription.getSubIdentities();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!((String)arrayList.get(i)).equals(string4)) continue;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Already joined");
                }
                bl = true;
                break;
            }
            if ((n & 0x60000) == 0) {
                if (subscription == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"New subscription with subIdentity, but no join options specified");
                    }
                    n2 = 3154;
                } else if (!bl) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"No join options on existing subscription");
                    }
                    n2 = 3154;
                }
            }
        }
        if (n2 != 0) {
            throw new MQException(n2);
        }
        string2 = mQClientServerStateMachine.getMQClientLink().getDefaultTopicSpace();
        if (subscription == null) {
            if (string7 == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"No queue name present");
                }
                n2 = 2339;
            }
            if (string == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"No topic name present");
                }
                n2 = 2339;
            }
        } else {
            arrayList = subscription.getSubIdentities();
            if (string4 != null) {
                if ((n & 0x40000) != 0) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Requesting to join exclusive");
                    }
                    if ((subscription.getOptions() & 0x40000) != 0) {
                        if (bl) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No changes to options, but we are already joined");
                            }
                            n3 = 3157;
                        } else if (arrayList.size() > 1 || !bl && arrayList.size() > 0) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Subscription is in use");
                            }
                            n2 = 3155;
                        }
                    }
                } else if ((n & 0x20000) != 0) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Requesting to join shared");
                    }
                    if ((subscription.getOptions() & 0x40000) != 0) {
                        if (!bl) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Subscription is locked");
                            }
                            n2 = 3156;
                        }
                    } else if (bl) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Already joined");
                        }
                        n3 = 3157;
                    } else {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Cloned subscription request? - Not supported");
                        }
                        n2 = 3007;
                    }
                }
            }
            if (n2 == 0 && (arrayList.size() > 1 || arrayList.size() > 0 && !bl) && (n & 0x8000) == 0) {
                if (subscriptionIdentity != null && !subscriptionIdentity.equals(subscription.getId()) || string3 != null && !string3.equals(subscription.getSubName()) || (n & persistenceOptions) != (subscription.getOptions() & persistenceOptions) || string != null && !string.equals(subscription.getTopic())) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Parameters do not match - Subscripion is in use");
                    }
                    n2 = 3155;
                }
                if (string9 != null && !string9.equals(subscription.getFilter())) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Filter does not match - Subscription is in use");
                    }
                    n2 = 3155;
                }
            }
            if (n2 != 0) {
                throw new MQException(n2);
            }
            if (n3 != 0) {
                throw new MQException(n3);
            }
            consumerSession = subscription.getConsumerSession();
            if ((n & 0x8000) == 0 && (string != null && !string.equals(subscription.getTopic()) || string9 != null && !string9.equals(subscription.getFilter()) || (n & persistenceOptions) != (subscription.getOptions() & persistenceOptions))) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Recreating the consumer / durable subscription");
                }
                consumerSession.close();
                consumerSession.deregisterAsynchConsumerCallback();
                subscription.setCCAsynchConsumerCallback(null);
                consumerSession = null;
                subscription.setConsumerSession(null);
                if (subscription.isDurable()) {
                    sICoreConnection.deleteDurableSubscription(string3, sICoreConnection.getMeName());
                }
            }
            if (string6 == null) {
                string6 = subscription.getQmgrName();
            }
            if (string9 == null) {
                string9 = subscription.getFilter();
            }
            if (string7 == null) {
                string7 = subscription.getQName();
            }
            if (string == null) {
                string = subscription.getTopic();
            }
            if (byArray == null) {
                byArray = subscription.getCorrelId();
            }
            if (mQClientServerStateMachine.getUserId() == null) {
                string8 = subscription.getUserId();
            }
        }
        string2 = mQClientServerStateMachine.getMQClientLink().getDefaultTopicSpace();
        arrayList = JsDestinationAddressFactory.getInstance();
        SIDestinationAddress sIDestinationAddress = arrayList.createSIDestinationAddress(string2, false);
        this.subscription = subscription == null ? new Subscription() : subscription;
        if (consumerSession == null) {
            TopicWildcardTranslation topicWildcardTranslation;
            object = "";
            try {
                topicWildcardTranslation = TopicWildcardTranslation.getInstance();
                object = topicWildcardTranslation.convertEventBrokerToSIB(string);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Remapped topic name is: " + (String)object));
                }
            }
            catch (ParseException parseException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught a ParseException:", (Object)parseException);
                }
                n2 = 3072;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an Exception:", (Object)exception);
                }
                n2 = 3072;
            }
            if (n2 != 0) {
                throw new MQException(n2);
            }
            topicWildcardTranslation = SelectionCriteriaFactory.getInstance().createSelectionCriteria((String)object, string9, SelectorDomain.JMS);
            if (string7.startsWith("SYSTEM.JMS.ND.")) {
                Reliability reliability;
                int n4 = n & persistenceOptions;
                Object object2 = n4 == 2048 ? Reliability.ASSURED_PERSISTENT : (reliability = n4 == 1024 ? Reliability.RELIABLE_NONPERSISTENT : null);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Creating a normal consumer");
                }
                consumerSession = sICoreConnection.createConsumerSession(sIDestinationAddress, null, (SelectionCriteria)topicWildcardTranslation, reliability, false, false, Reliability.RELIABLE_NONPERSISTENT, true, null);
                this.subscription.setDurable(false);
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Creating a durable subscription");
                }
                try {
                    sICoreConnection.createDurableSubscription(string3, sICoreConnection.getMeName(), sIDestinationAddress, (SelectionCriteria)topicWildcardTranslation, false, false, null);
                }
                catch (SIDurableSubscriptionAlreadyExistsException sIDurableSubscriptionAlreadyExistsException) {
                    // empty catch block
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Creating consumer session for a durable subscription");
                }
                consumerSession = sICoreConnection.createConsumerSessionForDurableSubscription(string3, sICoreConnection.getMeName(), sIDestinationAddress, (SelectionCriteria)topicWildcardTranslation, false, false, Reliability.ASSURED_PERSISTENT, false, null, true, null);
                this.subscription.setDurable(true);
            }
        }
        this.subscription.setConsumerSession(consumerSession);
        object = this.subscription.getId();
        long l = System.currentTimeMillis();
        this.subscription.setRegTime(l);
        if (subscription == null || (n & 0x8000) == 0) {
            this.subscription.setId(subscriptionIdentity);
            this.subscription.setQName(string7);
            this.subscription.setQmgrName(string6);
            this.subscription.setFilter(string9);
            this.subscription.setCorrelId(byArray);
            this.subscription.setTopic(string);
            this.subscription.setSubPoint(string2);
            this.subscription.setSubName(string3);
            this.subscription.setUserId(mQClientServerStateMachine.getUserId());
            if (n != 0) {
                this.subscription.setOptions(n);
            } else if (subscription == null) {
                this.subscription.setOptions(defaultRegisterOptions);
            }
            this.subscription.setExpiryTime((long)mQMD1.getExpiry() + l);
        }
        this.subscription.addSubIdentity(string4);
        this.subscriptionTable.add((SubscriptionIdentity)object, this.subscription, (Transaction)sITransaction);
        if ((n & 0x10000) != 0 && this.subscription != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Generating a full response");
            }
            hashMap.put("Topic", this.subscription.getTopic());
            hashMap.put("QMgrName", string6);
            if (this.subscription.getFilter() != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("SubUserData = " + this.subscription.getFilter()));
                }
                if (this.subscription.getFilter().length() == 0) {
                    hashMap.put("SubUserData", this.subscription.getFilter());
                } else {
                    hashMap.put("SubUserData", "sel=" + this.subscription.getFilter());
                }
            }
            if (this.subscription.getSubPoint() != null) {
                hashMap.put("SubPoint", this.subscription.getSubPoint());
            }
            if (this.subscription.getQName() != null) {
                hashMap.put("QName", this.subscription.getQName());
            }
            if (this.subscription.getSubName() != null) {
                hashMap.put("SubName", this.subscription.getSubName());
            }
            if (string4 != null) {
                hashMap.put("SubIdentity", string4);
            }
            hashMap.put("CorrelId", HexString.hexString((byte[])this.subscription.getCorrelId()));
        }
        if (this.isCCSubQ(mQClientServerStateMachine, this.subscription.getQName())) {
            if (this.subscription.getCCAsynchConsumerCallback() == null) {
                this.subscription.getConsumerSession().stop();
                this.registerCCAsynchConsumerCallback(mQClientServerStateMachine, this.subscription);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Registered connection consumer asynch. consumer callback");
                }
                this.subscription.getConsumerSession().start(false);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Started consumer session");
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection consumer asynch. consumer callback already registered");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerSubscriber");
        }
    }

    private void publish(MQFap mQFap, SICoreConnection sICoreConnection, MQClientServerStateMachine mQClientServerStateMachine, SITransaction sITransaction) throws Exception {
        block34: {
            int n;
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"publish");
            }
            MQRFH2 mQRFH2 = mQFap.getRFH2();
            MQMD1 mQMD1 = mQFap.getMQMD();
            String string = this.getStringFieldValue(mQRFH2, "psc", "Topic");
            String string2 = this.getStringFieldValue(mQRFH2, "psc", "SubPoint");
            String string3 = this.getStringFieldValue(mQRFH2, "psc", "PubTime");
            String string4 = this.getStringFieldValue(mQRFH2, "psc", "SeqNum");
            String string5 = this.getQmgrName(mQRFH2, mQMD1);
            String string6 = this.getQName(mQRFH2, mQMD1);
            int n2 = this.getOptions(mQRFH2, "psc", "PubOpt", defaultPublishOptions);
            long l = 0L;
            boolean bl = false;
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Publish parameters:", (Object)new Object[]{"Topic: " + string, "Subscription point: " + string2, "Publish time: " + string3, "Sequence Number: " + string4, "Queue manager name: " + string5, "Queue name: " + string6, "Options: " + n2 + " (0x" + Integer.toHexString(n2) + ")", "         " + MQUtil.getOptions(n2, "MQPUBO_")});
            }
            this.validatePublish(mQRFH2, string5, string6);
            if (string3 != null) {
                int n3 = Integer.parseInt(string3.substring(0, 3));
                int n4 = Integer.parseInt(string3.substring(4, 5));
                n = Integer.parseInt(string3.substring(6, 7));
                int n5 = Integer.parseInt(string3.substring(8, 9));
                int n6 = Integer.parseInt(string3.substring(10, 11));
                int n7 = Integer.parseInt(string3.substring(12, 13));
                GregorianCalendar gregorianCalendar = new GregorianCalendar(n3, n4, n, n5, n6, n7);
                l = gregorianCalendar.getTimeInMillis();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Generated publish time: " + l));
                }
            }
            string2 = mQClientServerStateMachine.getMQClientLink().getDefaultTopicSpace();
            SIDestinationAddressFactory sIDestinationAddressFactory = JsDestinationAddressFactory.getInstance();
            SIDestinationAddress sIDestinationAddress = sIDestinationAddressFactory.createSIDestinationAddress(string2, false);
            n = 1;
            JsMessage jsMessage = mQFap.decodeClientMessage(mQClientServerStateMachine.getMQClientLink().getInboundPersistentReliability(), mQClientServerStateMachine.getMQClientLink().getInboundNonPersistentReliability(), string2, this.mqHObject, mQClientServerStateMachine, n != 0);
            jsMessage.setDiscriminator(string);
            if (l != 0L) {
                jsMessage.setTimestamp(l);
            }
            bl = mQMD1.getPersistence() == 1;
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Putting message to topic space");
                }
                sICoreConnection.send((SIBusMessage)jsMessage, sITransaction, sIDestinationAddress, DestinationType.TOPICSPACE, null, null);
            }
            catch (SIIncorrectCallException sIIncorrectCallException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SIIncorrectCallException:", (Object)((Object)sIIncorrectCallException));
                }
                if (bl) {
                    this.dlqMessage(string2, mQClientServerStateMachine, jsMessage, sIIncorrectCallException.getExceptionReason(), sIIncorrectCallException.getExceptionInserts(), sITransaction);
                }
            }
            catch (SINotAuthorizedException sINotAuthorizedException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SINotAuthorizedException:", (Object)((Object)sINotAuthorizedException));
                }
                if (bl) {
                    this.dlqMessage(string2, mQClientServerStateMachine, jsMessage, sINotAuthorizedException.getExceptionReason(), sINotAuthorizedException.getExceptionInserts(), sITransaction);
                }
            }
            catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SINotPossibleInCurrentConfigurationException:", (Object)((Object)sINotPossibleInCurrentConfigurationException));
                }
                if (bl) {
                    this.dlqMessage(string2, mQClientServerStateMachine, jsMessage, sINotPossibleInCurrentConfigurationException.getExceptionReason(), sINotPossibleInCurrentConfigurationException.getExceptionInserts(), sITransaction);
                }
            }
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SIConnectionDroppedException:", (Object)((Object)sIConnectionDroppedException));
                }
                if (bl) {
                    this.dlqMessage(string2, mQClientServerStateMachine, jsMessage, sIConnectionDroppedException.getExceptionReason(), sIConnectionDroppedException.getExceptionInserts(), sITransaction);
                }
            }
            catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SIConnectionUnavailableException:", (Object)((Object)sIConnectionUnavailableException));
                }
                if (bl) {
                    this.dlqMessage(string2, mQClientServerStateMachine, jsMessage, sIConnectionUnavailableException.getExceptionReason(), sIConnectionUnavailableException.getExceptionInserts(), sITransaction);
                }
            }
            catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SITemporaryDestinationNotFoundException:", (Object)((Object)sITemporaryDestinationNotFoundException));
                }
                if (bl) {
                    this.dlqMessage(string2, mQClientServerStateMachine, jsMessage, sITemporaryDestinationNotFoundException.getExceptionReason(), sITemporaryDestinationNotFoundException.getExceptionInserts(), sITransaction);
                }
            }
            catch (SILimitExceededException sILimitExceededException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SILimitExceededException:", (Object)((Object)sILimitExceededException));
                }
                if (bl) {
                    this.dlqMessage(string2, mQClientServerStateMachine, jsMessage, sILimitExceededException.getExceptionReason(), sILimitExceededException.getExceptionInserts(), sITransaction);
                }
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SIConnectionLostException:", (Object)((Object)sIConnectionLostException));
                }
                if (bl) {
                    this.dlqMessage(string2, mQClientServerStateMachine, jsMessage, sIConnectionLostException.getExceptionReason(), sIConnectionLostException.getExceptionInserts(), sITransaction);
                }
            }
            catch (SIException sIException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an SIException:", (Object)((Object)sIException));
                }
                if (!bl) break block34;
                this.dlqMessage(string2, mQClientServerStateMachine, jsMessage, sIException.getExceptionReason(), sIException.getExceptionInserts(), sITransaction);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"publish");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void deregisterSubscriber(MQRFH2 mQRFH2, MQMD1 mQMD1, SICoreConnection sICoreConnection, MQHandleStore mQHandleStore, MQClientServerStateMachine mQClientServerStateMachine, HashMap hashMap, SITransaction sITransaction) throws Exception {
        ArrayList arrayList;
        Object object;
        int n;
        int n2;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        block50: {
            ArrayList<String> arrayList2;
            byte[] byArray;
            String string7;
            String string8;
            block49: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"deregisterSubscriber");
                }
                string8 = this.getStringFieldValue(mQRFH2, "psc", "QName");
                string6 = this.getStringFieldValue(mQRFH2, "psc", "SubPoint");
                string5 = this.getStringFieldValue(mQRFH2, "psc", "SubIdentity");
                string4 = this.getStringFieldValue(mQRFH2, "psc", "QMgrName");
                string3 = this.getStringFieldValue(mQRFH2, "psc", "SubName");
                string2 = this.getStringFieldValue(mQRFH2, "psc", "SubUserData");
                string = mQMD1.getUserIdentifier().trim();
                string7 = null;
                n2 = this.getOptions(mQRFH2, "psc", "RegOpt", defaultDeregisterOptions);
                byArray = null;
                arrayList2 = new ArrayList<String>();
                n = 0;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"De-register subscriber parameters:", (Object)new Object[]{"Subscription point: " + string6, "Subscription identity: " + string5, "Subscription name: " + string3, "Subscription user data: " + string2, "User Id: " + string, "Queue manager name: " + string4, "Queue name: " + string8, "Options: " + n2 + " (0x" + Integer.toHexString(n2) + ")", "         " + MQUtil.getOptions(n2, "MQREGO_")});
                }
                int n3 = 0;
                while (true) {
                    if ((object = this.getFieldValue(mQRFH2, "psc", "Topic", n3)) == null) {
                        if (tc.isDebugEnabled()) {
                            break;
                        }
                        break block49;
                    }
                    arrayList2.add((String)object);
                    ++n3;
                }
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Topic names:", arrayList2);
            }
            this.validateDeregisterSubscriber(mQRFH2, mQMD1, n2, string8, arrayList2, string5, string3);
            string6 = mQClientServerStateMachine.getMQClientLink().getDefaultTopicSpace();
            if ((n2 & 1) != 0) {
                byArray = mQMD1.getCorrelId();
            }
            if (string2 != null) {
                string7 = this.getFilter(string2);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Filter: " + string7));
                }
            }
            if ((n2 & 0x10000) != 0) {
                hashMap.put("Command", "DeregSub");
                if (string6 != null) {
                    hashMap.put("SubPoint", string6);
                }
                if (string4 != null) {
                    hashMap.put("QMgrName", string4);
                }
                if (string8 != null) {
                    hashMap.put("QName", string8);
                }
                if (string3 != null) {
                    hashMap.put("SubName", string3);
                }
                if (string5 != null) {
                    hashMap.put("SubIdentity", string5);
                }
                if (string2 != null) {
                    hashMap.put("SubUserData", string2);
                }
                if (byArray != null) {
                    hashMap.put("CorrelId", HexString.hexString((byte[])byArray));
                }
                if (arrayList2.size() > 0) {
                    hashMap.put("Topic", arrayList2.get(0));
                }
            }
            if (string3 != null) {
                arrayList = new ArrayList();
                object = this.subscriptionTable.getByName(string3);
                if (object != null) {
                    arrayList.add(object);
                    break block50;
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Subscription name does not exist:" + string3));
                    }
                    throw new MQException(3153);
                }
            }
            arrayList = this.subscriptionTable.getMatching(arrayList2, string6, string7, byArray, string4, string8);
        }
        if (arrayList.size() == 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No registered subscriptions");
            }
            throw new MQException(3073);
        }
        object = null;
        int n4 = 0;
        while (true) {
            block52: {
                int n5;
                ArrayList arrayList3;
                block53: {
                    block51: {
                        if (n4 >= arrayList.size()) break block51;
                        object = (Subscription)arrayList.get(n4);
                        if (!this.subscriptionTable.addUser(((Subscription)object).getId(), string, (((Subscription)object).getOptions() & 0x100000) == 0, false)) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Duplicate identity");
                            }
                            throw new MQException(3078);
                        }
                        if (string5 == null) break block52;
                        arrayList3 = ((Subscription)object).getSubIdentities();
                        break block53;
                    }
                    if (n != 0) {
                        throw new MQException(n);
                    }
                    if ((n2 & 0x10000) != 0 && object != null) {
                        hashMap.put("Topic", ((Subscription)object).getTopic());
                        if (string6 != null) {
                            hashMap.put("SubPoint", string6);
                        }
                        if (string4 != null) {
                            hashMap.put("QMgrName", string4);
                        } else {
                            hashMap.put("QMgrName", mQClientServerStateMachine.getMQClientLink().getVirtualQmgrName());
                        }
                        hashMap.put("QName", ((Subscription)object).getQName());
                        if (string3 != null) {
                            hashMap.put("SubName", string3);
                        }
                        if (string5 != null) {
                            hashMap.put("SubIdentity", string5);
                        }
                        if (string2 != null) {
                            hashMap.put("SubUserData", string2);
                        }
                        hashMap.put("CorrelId", HexString.hexString((byte[])mQMD1.getCorrelId()));
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"deregisterSubscriber");
                    }
                    return;
                }
                for (n5 = 0; n5 < arrayList3.size() && !arrayList3.get(n5).equals(string5); ++n5) {
                }
                if (n5 == arrayList3.size()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Sub identity error");
                    }
                    n = 3154;
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Removing sub identity: " + string5));
                    }
                    ((Subscription)object).removeSubIdentity(string5);
                }
            }
            if ((n2 & 0x80000) == 0 && n == 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Leave only is not specified");
                }
                if (((Subscription)object).getSubIdentities().size() == 0) {
                    this.subscriptionTable.remove((Subscription)object, (Transaction)sITransaction);
                    if (((Subscription)object).getConsumerSession() != null) {
                        ((Subscription)object).getConsumerSession().stop();
                        if (((Subscription)object).getCCAsynchConsumerCallback() != null) {
                            ((Subscription)object).getConsumerSession().deregisterAsynchConsumerCallback();
                            ((Subscription)object).setCCAsynchConsumerCallback(null);
                        }
                        ((Subscription)object).getConsumerSession().close();
                        ((Subscription)object).setConsumerSession(null);
                    }
                    if (((Subscription)object).isDurable()) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Deregistering durable subscription");
                        }
                        sICoreConnection.deleteDurableSubscription(string3, sICoreConnection.getMeName());
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Already joined");
                    }
                    n = 3155;
                }
            }
            ++n4;
        }
    }

    private int getOptions(MQRFH2 mQRFH2, String string, String string2, int n) throws UnsupportedEncodingException, IOException {
        String string3;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOptions");
        }
        int n2 = 0;
        int n3 = 0;
        while ((string3 = this.getFieldValue(mQRFH2, string, string2, n3)) != null) {
            Integer n4 = (Integer)optionFields.get(string3);
            n2 = n4 != null ? (n2 |= n4.intValue()) : (n2 |= Integer.parseInt(string3));
            ++n3;
        }
        if (n3 == 1 && n2 == 0) {
            n2 = n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOptions", (Object)("" + n2));
        }
        return n2;
    }

    private void dlqMessage(String string, MQClientServerStateMachine mQClientServerStateMachine, JsMessage jsMessage, int n, String[] stringArray, SITransaction sITransaction) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dlqMessage");
        }
        SIMPFactory sIMPFactory = (SIMPFactory)mQClientServerStateMachine.getEngine().getMessageProcessor();
        ExceptionDestinationHandler exceptionDestinationHandler = null;
        exceptionDestinationHandler = sIMPFactory.createExceptionDestinationHandler(string);
        UndeliverableReturnCode undeliverableReturnCode = exceptionDestinationHandler.handleUndeliverableMessage((SIBusMessage)jsMessage, null, (Transaction)sITransaction, n, stringArray);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Undeliverable rc =" + undeliverableReturnCode));
        }
        if (undeliverableReturnCode != UndeliverableReturnCode.ERROR) {
            // empty if block
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dlqMessage");
        }
    }

    private String getFilter(String string) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getFilter", (Object)string);
        }
        String string2 = null;
        if (string != null) {
            if (string.length() == 0) {
                string2 = string;
            } else if (string.startsWith("sel=") && (string2 = string.substring(4)) != null && (string2 = string2.trim()).length() >= 2 && string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getFilter", (Object)string2);
        }
        return string2;
    }

    private void validateRegisterSubscriber(MQRFH2 mQRFH2, int n, String string, String string2, String string3, String string4, MQClientServerStateMachine mQClientServerStateMachine) throws UnsupportedEncodingException, IOException, MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"validateRegisterSubscriber");
        }
        int n2 = 0;
        if (this.getFieldValue(mQRFH2, "psc", "Topic", 1) != null) {
            n2 = 2338;
        } else if ((n & ~validRegisterOptions) != 0) {
            n2 = 3083;
        } else if (n != 0) {
            if ((n & 1) != 0) {
                // empty if block
            }
            if ((n & 4) != 0) {
                n2 = 3083;
            }
            if ((n & 0x10) != 0) {
                n2 = 3083;
            }
            if ((n & 0x20) != 0) {
                // empty if block
            }
            if ((n & 0x100) != 0) {
                n2 = 3083;
            }
            if ((n & 0x400) != 0 && (n & 0x3800) != 0) {
                n2 = 3083;
            }
            if ((n & 0x800) != 0 && (n & 0x3400) != 0) {
                n2 = 3083;
            }
            if ((n & 0x1000) != 0 && (n & 0x2C00) != 0) {
                n2 = 3083;
            }
            if ((n & 0x2000) != 0 && (n & 0x1C00) != 0) {
                n2 = 3083;
            }
            if ((n & 0x4000) != 0 && string3 == null) {
                n2 = 3083;
            }
            if ((n & 0x8000) != 0) {
                // empty if block
            }
            if ((n & 0x10000) != 0) {
                // empty if block
            }
            if ((n & 0x60000) != 0) {
                if (string4 == null) {
                    n2 = 3083;
                }
                if ((n & 0x20000) != 0 && (n & 0x40000) != 0) {
                    n2 = 3083;
                }
            }
            if ((n & 0x100000) != 0) {
                // empty if block
            }
        }
        if (n2 != 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exception due to rc=" + n2));
            }
            throw new MQException(n2);
        }
        if (!string.equals(mQClientServerStateMachine.getMQClientLink().getVirtualQmgrName())) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("QMgrName = " + string + " VirtualQMgrName = " + mQClientServerStateMachine.getMQClientLink().getVirtualQmgrName()));
            }
            n2 = 2058;
        } else if (string4 != null && string4.length() > 128) {
            n2 = 3154;
        }
        if (n2 != 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exception due to rc=" + n2));
            }
            throw new MQException(n2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"validateRegisterSubscriber");
        }
    }

    private void validatePublish(MQRFH2 mQRFH2, String string, String string2) throws UnsupportedEncodingException, IOException, MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"validatePublish");
        }
        int n = this.getOptions(mQRFH2, "psc", "PubOpt", defaultPublishOptions);
        int n2 = 0;
        if (this.getFieldValue(mQRFH2, "psc", "Topic", 1) != null) {
            n2 = 2338;
        } else if ((n & ~validRegisterOptions) != 0) {
            n2 = 3084;
        } else if (n != 0) {
            if ((n & 1) != 0) {
                // empty if block
            }
            if ((n & 2) != 0) {
                n2 = 3084;
            }
            if ((n & 4) != 0) {
                if (string == null) {
                    n2 = 3076;
                } else if (string2 == null) {
                    n2 = 3076;
                }
            }
            if ((n & 8) != 0) {
                n2 = 3084;
            }
            if ((n & 0x10) != 0) {
                n2 = 3084;
            }
        }
        if (n2 != 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exception due to rc=" + n2));
            }
            throw new MQException(n2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"validatePublish");
        }
    }

    private void validateDeregisterSubscriber(MQRFH2 mQRFH2, MQMD1 mQMD1, int n, String string, ArrayList arrayList, String string2, String string3) throws UnsupportedEncodingException, IOException, MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"validateDeregisterSubscriber");
        }
        int n2 = 0;
        if (this.getFieldValue(mQRFH2, "psc", "SubPoint", 1) != null) {
            n2 = 2338;
        } else if ((n & ~validDeregisterOptions) != 0) {
            n2 = 3083;
        } else {
            if ((n & 1) != 0 && mQMD1.getCorrelId() == null) {
                n2 = 3083;
            }
            if ((n & 0x40) != 0 && arrayList.size() > 0) {
                n2 = 3083;
            }
            if ((n & 0x10000) != 0 && ((n & 0x40) != 0 || arrayList.size() > 1)) {
                n2 = 3083;
            }
            if ((n & 0x80000) != 0 && string2 == null) {
                n2 = 3083;
            }
            if ((n & 0x100000) != 0) {
                // empty if block
            }
        }
        if (arrayList.size() == 0 && (n & 0x40) == 0) {
            n2 = 2339;
        }
        if (string3 != null && (n & 0x40) != 0) {
            n2 = 3083;
        }
        if (n2 != 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exception due to rc=" + n2));
            }
            throw new MQException(n2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"validateDeregisterSubscriber");
        }
    }

    private String getQmgrName(MQRFH2 mQRFH2, MQMD1 mQMD1) throws UnsupportedEncodingException, IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getQmgrName");
        }
        String string = this.getStringFieldValue(mQRFH2, "psc", "QMgrName");
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Qmgr Name in RFH2 header = " + string + " MQMD.ReplyToQMgr =" + mQMD1.getReplyToQMgr()));
        }
        if (string == null) {
            string = mQMD1.getReplyToQMgr();
        }
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getQmgrName", (Object)string);
        }
        return string;
    }

    private String getQName(MQRFH2 mQRFH2, MQMD1 mQMD1) throws UnsupportedEncodingException, IOException {
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getQName");
        }
        if ((string = this.getStringFieldValue(mQRFH2, "psc", "QName")) == null) {
            string = mQMD1.getReplyToQ();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getQName", (Object)string);
        }
        return string;
    }

    private String getFieldValue(MQRFH2 mQRFH2, String string, String string2, int n) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getFieldValue");
        }
        MQRFH2.Element element = mQRFH2.getFolder(string, false);
        String string3 = null;
        if (element != null) {
            MQRFH2.Element[] elementArray = element.getChildren();
            if (elementArray.length <= n) {
                return null;
            }
            for (int i = 0; i < elementArray.length && string3 == null; ++i) {
                if (!string2.equals(elementArray[i].getName()) || n-- != 0) continue;
                string3 = elementArray[i].getStringValue();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getFieldValue", string3);
        }
        return string3;
    }

    private String getStringFieldValue(MQRFH2 mQRFH2, String string, String string2) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)("getStringFieldValue " + string2));
        }
        String string3 = null;
        try {
            string3 = mQRFH2.getStringFieldValue(string, string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getStringFieldValue ", (Object)string3);
        }
        return string3;
    }

    private boolean isCCSubQ(MQClientServerStateMachine mQClientServerStateMachine, String string) {
        MQClientLink mQClientLink;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isCCSubQ");
        }
        if (string.equals((mQClientLink = mQClientServerStateMachine.getMQClientLink()).getBrokerCCSubQ()) || string.equals(mQClientLink.getBrokerCCDurSubQ())) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)("isCCSubQ " + bl));
        }
        return bl;
    }

    private void createDestAddr(MQClientServerStateMachine mQClientServerStateMachine, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDestAddr ", (Object)string);
        }
        SIDestinationAddressFactory sIDestinationAddressFactory = JsDestinationAddressFactory.getInstance();
        MQLinkManagerImpl mQLinkManagerImpl = (MQLinkManagerImpl)MQLinkManager.getInstance();
        this.jmsQueueNeedsMapping = mQLinkManagerImpl.isJmsPubSubSystemQueue(string);
        if (this.jmsQueueNeedsMapping) {
            string = mQLinkManagerImpl.mapSystemObjectName(string);
            this.ccDestAddr = sIDestinationAddressFactory.createSIDestinationAddress(string, false);
        } else {
            this.ccDestAddr = sIDestinationAddressFactory.createSIDestinationAddress(string, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDestAddr ", (Object)(string + this.ccDestAddr));
        }
    }

    private void registerCCAsynchConsumerCallback(MQClientServerStateMachine mQClientServerStateMachine, Subscription subscription) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerCCAsynchConsumerCallback");
        }
        this.createDestAddr(mQClientServerStateMachine, subscription.getQName());
        CCAsynchConsumerCallback cCAsynchConsumerCallback = (CCAsynchConsumerCallback)subscription.getCCAsynchConsumerCallback();
        if (cCAsynchConsumerCallback == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No async consumer created - creating a new one");
            }
            cCAsynchConsumerCallback = new CCAsynchConsumerCallback(this, mQClientServerStateMachine);
            subscription.getConsumerSession().registerAsynchConsumerCallback((AsynchConsumerCallback)cCAsynchConsumerCallback, 0, 0L, 10, null);
        } else {
            cCAsynchConsumerCallback.pubSub = this;
        }
        subscription.setCCAsynchConsumerCallback(cCAsynchConsumerCallback);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)("registerCCAsynchConsumerCallback " + cCAsynchConsumerCallback));
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/client/PubSub.java, SIB.comms, WASX.SIB, m0434.23 1.37");
        }
        optionFields = new Hashtable();
        defaultRegisterOptions = 4096;
        defaultPublishOptions = 0;
        defaultDeregisterOptions = 0;
        optionFields.put("None", new Integer(0));
        optionFields.put("CorrelAsId", new Integer(1));
        optionFields.put("Anon", new Integer(2));
        optionFields.put("Local", new Integer(4));
        optionFields.put("DirectReq", new Integer(8));
        optionFields.put("NewPubsOnly", new Integer(16));
        optionFields.put("PubOnReqOnly", new Integer(32));
        optionFields.put("DeregAll", new Integer(64));
        optionFields.put("InclStreamName", new Integer(128));
        optionFields.put("InformIfRet", new Integer(256));
        optionFields.put("DupsOK", new Integer(512));
        optionFields.put("NonPers", new Integer(1024));
        optionFields.put("Pers", new Integer(2048));
        optionFields.put("PersAsPub", new Integer(4096));
        optionFields.put("PersAsQueue", new Integer(8192));
        optionFields.put("AddName", new Integer(16384));
        optionFields.put("NoAlter", new Integer(32768));
        optionFields.put("FullResp", new Integer(65536));
        optionFields.put("JoinShared", new Integer(131072));
        optionFields.put("JoinExcl", new Integer(262144));
        optionFields.put("LeaveOnly", new Integer(524288));
        optionFields.put("VariableUserId", new Integer(0x100000));
        optionFields.put("Locked", new Integer(0x200000));
        optionFields.put("CorrelAsId", new Integer(1));
        optionFields.put("RetainPub", new Integer(2));
        optionFields.put("OtherSubsOnly", new Integer(4));
        optionFields.put("NoReg", new Integer(8));
        optionFields.put("IsRetainedPub", new Integer(16));
        validRegisterOptions = 1572661;
        validPublishOptions = 31;
        validDeregisterOptions = 1638465;
        persistenceOptions = 15360;
    }

    private static class CCAsynchConsumerCallback
    implements AsynchConsumerCallback {
        PubSub pubSub;
        MQClientServerStateMachine mqClientServerStateMachine;

        CCAsynchConsumerCallback(PubSub pubSub, MQClientServerStateMachine mQClientServerStateMachine) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
            }
            this.pubSub = pubSub;
            this.mqClientServerStateMachine = mQClientServerStateMachine;
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
            }
        }

        public void consumeMessages(LockedMessageEnumeration lockedMessageEnumeration) {
            block27: {
                Object[] objectArray;
                block28: {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((Object)this, (TraceComponent)tc, (String)"consumeMessages");
                    }
                    objectArray = new Object[]{this.mqClientServerStateMachine.getMQClientLink().getMQClientLinkName()};
                    if (lockedMessageEnumeration == null) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Async consumer callback called with NULL LME");
                        }
                        SibTr.error((TraceComponent)tc, (String)"MQCLIENTLINK_INTERNAL_ERROR_SICO3709", (Object)objectArray);
                    }
                    SIUncoordinatedTransaction sIUncoordinatedTransaction = null;
                    if (this.pubSub.ccDestAddr == null) break block28;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"About to get message from LME");
                    }
                    try {
                        if (sIUncoordinatedTransaction == null) {
                            sIUncoordinatedTransaction = this.mqClientServerStateMachine.getJSConnection().createUncoordinatedTransaction();
                        }
                        while (lockedMessageEnumeration.hasNext()) {
                            SIBusMessage sIBusMessage = lockedMessageEnumeration.nextLocked();
                            if (this.pubSub.subscription != null) {
                                this.pubSub.encode(this.mqClientServerStateMachine, (JsMessage)sIBusMessage);
                            }
                            if (this.pubSub.jmsQueueNeedsMapping) {
                                ((MPCoreConnection)this.mqClientServerStateMachine.getJSConnection()).systemSend(sIBusMessage, (SITransaction)sIUncoordinatedTransaction, this.pubSub.ccDestAddr, DestinationType.QUEUE, null, false);
                            } else {
                                this.mqClientServerStateMachine.getJSConnection().send(sIBusMessage, (SITransaction)sIUncoordinatedTransaction, this.pubSub.ccDestAddr, DestinationType.QUEUE, null, null);
                            }
                            lockedMessageEnumeration.deleteCurrent((SITransaction)sIUncoordinatedTransaction);
                        }
                        sIUncoordinatedTransaction.commit();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"PubSub.consumeMessages", (String)"17", (Object)this);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an exception while creating a transaction or processing a locked message", (Object)exception);
                        }
                        SibTr.error((TraceComponent)tc, (String)"MQCLIENTLINK_INTERNAL_ERROR_SICO3709", (Object)objectArray);
                        try {
                            lockedMessageEnumeration.getConsumerSession().stop();
                        }
                        catch (SIException sIException) {
                            FFDCFilter.processException((Throwable)sIException, (String)"PubSub.consumeMessages", (String)"18", (Object)this);
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an exception while stopping consumer session", (Object)((Object)sIException));
                            }
                            SibTr.error((TraceComponent)tc, (String)"MQCLIENTLINK_INTERNAL_ERROR_SICO3709", (Object)objectArray);
                        }
                        if (sIUncoordinatedTransaction == null) break block27;
                        try {
                            sIUncoordinatedTransaction.rollback();
                        }
                        catch (SIException sIException) {
                            FFDCFilter.processException((Throwable)sIException, (String)"PubSub.consumeMessages", (String)"19", (Object)this);
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an exception while trying to rollback a transaction", (Object)((Object)sIException));
                            }
                            SibTr.error((TraceComponent)tc, (String)"MQCLIENTLINK_INTERNAL_ERROR_SICO3709", (Object)objectArray);
                        }
                        if (lockedMessageEnumeration == null) break block27;
                        try {
                            lockedMessageEnumeration.unlockCurrent();
                            break block27;
                        }
                        catch (SIMessageNotLockedException sIMessageNotLockedException) {
                            break block27;
                        }
                        catch (SIException sIException) {
                            FFDCFilter.processException((Throwable)sIException, (String)"PubSub.consumeMessages", (String)"20", (Object)this);
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an exception while trying to unlock the current message", (Object)((Object)sIException));
                            }
                            SibTr.error((TraceComponent)tc, (String)"MQCLIENTLINK_INTERNAL_ERROR_SICO3709", (Object)objectArray);
                        }
                    }
                    break block27;
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Destination address is null");
                }
                SibTr.error((TraceComponent)tc, (String)"MQCLIENTLINK_INTERNAL_ERROR_SICO3709", (Object)objectArray);
                try {
                    lockedMessageEnumeration.getConsumerSession().stop();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"PubSub.consumeMessages", (String)"21", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an exception while stopping consumer session", (Object)((Object)sIException));
                    }
                    SibTr.error((TraceComponent)tc, (String)"MQCLIENTLINK_INTERNAL_ERROR_SICO3709", (Object)objectArray);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"consumeMessages");
            }
        }
    }
}

