/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.admin.SIBMQClientLinkConnectionStatus;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.SIBMQClientLinkState;
import com.ibm.ws.sib.comms.impl.ConversationState;
import com.ibm.ws.sib.comms.impl.ObjectStoreFullException;
import com.ibm.ws.sib.comms.mq.client.MQAPICallStatus;
import com.ibm.ws.sib.comms.mq.client.MQBACK;
import com.ibm.ws.sib.comms.mq.client.MQCLOSE;
import com.ibm.ws.sib.comms.mq.client.MQCMIT;
import com.ibm.ws.sib.comms.mq.client.MQCONN;
import com.ibm.ws.sib.comms.mq.client.MQClientServer;
import com.ibm.ws.sib.comms.mq.client.MQDISC;
import com.ibm.ws.sib.comms.mq.client.MQException;
import com.ibm.ws.sib.comms.mq.client.MQGET;
import com.ibm.ws.sib.comms.mq.client.MQHObject;
import com.ibm.ws.sib.comms.mq.client.MQHandleStore;
import com.ibm.ws.sib.comms.mq.client.MQINQ;
import com.ibm.ws.sib.comms.mq.client.MQOPEN;
import com.ibm.ws.sib.comms.mq.client.MQPUT;
import com.ibm.ws.sib.comms.mq.client.MQPUT1;
import com.ibm.ws.sib.comms.mq.client.MQSET;
import com.ibm.ws.sib.comms.mq.client.MQSPI;
import com.ibm.ws.sib.comms.mq.client.MQVerb;
import com.ibm.ws.sib.comms.mq.client.MessageId;
import com.ibm.ws.sib.comms.mq.client.XACLOSE;
import com.ibm.ws.sib.comms.mq.client.XACOMMIT;
import com.ibm.ws.sib.comms.mq.client.XACOMPLETE;
import com.ibm.ws.sib.comms.mq.client.XAEND;
import com.ibm.ws.sib.comms.mq.client.XAFORGET;
import com.ibm.ws.sib.comms.mq.client.XAOPEN;
import com.ibm.ws.sib.comms.mq.client.XAPREPARE;
import com.ibm.ws.sib.comms.mq.client.XARECOVER;
import com.ibm.ws.sib.comms.mq.client.XAROLLBACK;
import com.ibm.ws.sib.comms.mq.client.XASTART;
import com.ibm.ws.sib.comms.mq.link.LinkConstants;
import com.ibm.ws.sib.comms.mq.link.MQClientLink;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.comms.mq.util.MQFap;
import com.ibm.ws.sib.comms.mq.util.MQUtil;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.mfp.mqinterop.fap.InitData;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQFAP;
import com.ibm.ws.sib.mfp.mqinterop.fap.SecurityData;
import com.ibm.ws.sib.mfp.mqinterop.fap.TSH;
import com.ibm.ws.sib.mfp.mqinterop.fap.UseridData;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;

public class MQClientServerStateMachine
implements MQConstants,
LinkConstants,
MQFAP,
SICoreConnectionListener {
    private static final TraceComponent tc = SibTr.register((Class)MQClientServerStateMachine.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    public static final int TX_UNKNOWN = 0;
    public static final int TX_LOCAL = 1;
    public static final int TX_XA = 2;
    private MQClientLink mqClientLink;
    private MQClientServer mqClientServer;
    private int state;
    private int mqClientLinkInstanceStatus;
    private MQFap errorFap;
    private Connection connection;
    private String channelName;
    private int maxTransmissionSize;
    private int maxMessageSize;
    private int heartbeatInterval;
    private int fapLevel;
    private String userid;
    private String password;
    private JsMessagingEngine me;
    private SICoreConnection jsConnection;
    private String applName;
    private int applType;
    private byte[] acctToken = new byte[32];
    private MQHandleStore mqHandleStore;
    private SITransaction transaction;
    private SIXAResource xaResource;
    private int transactionalState;
    private MQFap messageFap;
    private boolean waitingForHeartbeat;
    private SIBMQClientLinkConnectionStatus sibMQClientLinkConnectionStatus = null;
    private SIBMQClientLinkState sibMQClientLinkState;
    private MQAPICallStatus[] arrayMQAPICallStatus = new MQAPICallStatus[12];
    private MessageId messageId = new MessageId(this);
    private MessageId correlationId = new MessageId(this);
    private boolean meQuiescing = false;
    private byte wireEnc;
    private short wireCCSID;
    private boolean closed = false;

    public MQClientServerStateMachine() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.gotoMQClientLinkInstanceStatus(2);
        this.gotoState(3);
        this.transactionalState = 0;
        this.xaResource = null;
        this.transaction = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    void gotoState(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)("gotoState " + MQUtil.getState(n)));
        }
        this.state = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"gotoState");
        }
    }

    public void gotoMQClientLinkInstanceStatus(int n) {
        this.mqClientLinkInstanceStatus = n;
    }

    void dataReceived(Connection connection, WsByteBuffer wsByteBuffer) {
        block15: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"dataReceived", (Object)("Connection = " + connection));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Received WsByteBuffer length " + wsByteBuffer.limit()));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Received WsByteBuffer " + wsByteBuffer));
            }
            this.connection = connection;
            try {
                MQFap mQFap = new MQFap(wsByteBuffer, this.fapLevel);
                if (mQFap.getSegmentType() == 5 && (mQFap.getTsh().getControlFlags1() & 8) != 0) {
                    this.gotoState(2);
                    this.closeChannel();
                    return;
                }
                switch (this.state) {
                    case 3: {
                        this.doAccept(mQFap);
                        break;
                    }
                    case 4: {
                        this.doReceiveSecurity(mQFap);
                        break;
                    }
                    case 24: {
                        this.doReceiveMQAPIData(mQFap);
                        break;
                    }
                    case 9: {
                        MQVerb mQVerb = this.doReceiveMessage(mQFap);
                        if (mQVerb != null && this.state == 24) {
                            mQVerb.action();
                        }
                        break;
                    }
                    case 2: {
                        this.doStopped(mQFap);
                        break;
                    }
                    default: {
                        this.doError(mQFap);
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block15;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an IOException - 1", (Object)iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dataReceived of MQClientServerStateMachine");
        }
    }

    private void doError(MQFap mQFap) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"doError");
        }
        if (mQFap != null) {
            this.mqClientLink.error("MQClientServer received unexpected message.\n" + mQFap + "\nConnection=" + this.connection);
        } else {
            this.mqClientLink.error("MQClientServer in unexpected state");
        }
        try {
            if (this.errorFap != null) {
                this.errorFap.send(this.connection);
            }
        }
        catch (SIConnectionDroppedException sIConnectionDroppedException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection has dropped - 1", (Object)((Object)sIConnectionDroppedException));
            }
            this.closeChannel();
        }
        catch (SIConnectionLostException sIConnectionLostException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection is lost - 1", (Object)((Object)sIConnectionLostException));
            }
            this.closeChannel();
        }
        this.errorFap = null;
        this.stop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"doError");
        }
    }

    private void doAccept(MQFap mQFap) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"doAccept");
        }
        TSH tSH = mQFap.getTsh();
        this.wireEnc = tSH.getEncoding();
        this.wireCCSID = tSH.getCCSID();
        int n = 0;
        if (mQFap.getSegmentType() == 1 & tSH.getControlFlags1() != 8) {
            InitData initData = mQFap.getInitData();
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Initdata = ", (Object)initData.toString());
            }
            if ((initData.getIDFlags() & 0x20) == 0) {
                this.closeChannel();
            } else if (this.mqClientLink.isMQClientLinkStopped()) {
                this.doCloseChannel(mQFap, this.wireEnc, this.wireCCSID, 22);
            } else {
                try {
                    this.initialiseState();
                    int n2 = initData.getIDFlags();
                    initData.setIDFlags((byte)(n2 |= 4));
                    if (initData.getMaxTransmissionSize() > 32766) {
                        n |= 4;
                        initData.setMaxTransmissionSize(32766);
                    }
                    this.fapLevel = initData.getFapLevel() & 0xFF;
                    if (this.fapLevel > 7) {
                        mQFap.getInitData().setFapLevel((byte)7);
                        n |= 8;
                    } else if (this.fapLevel < 4) {
                        mQFap.getInitData().setFapLevel((byte)4);
                        n |= 8;
                    }
                    if (initData.getMaxMessageSize() > this.mqClientLink.getMaxMessageSize()) {
                        initData.setMaxMessageSize(this.mqClientLink.getMaxMessageSize());
                        n |= 0x10;
                    }
                    if (this.fapLevel >= 4) {
                        this.heartbeatInterval = this.mqClientLink.getHeartbeatInterval();
                        if (initData.getHeartbeatInterval() >= this.heartbeatInterval && this.heartbeatInterval != 0 || initData.getHeartbeatInterval() == 0) {
                            this.heartbeatInterval = initData.getHeartbeatInterval();
                        } else {
                            initData.setHeartbeatInterval(this.heartbeatInterval);
                            n |= 0xFFFFFF80;
                        }
                        initData.setQueueManagerName(this.mqClientLink.getVirtualQmgrName());
                    }
                    byte by = tSH.getControlFlags1();
                    if (n != 0) {
                        initData.setErrFlags((byte)n);
                        tSH.setControlFlags1((byte)2);
                        this.cleanupState();
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"doAccept - SendReply to client");
                    }
                    this.sendReply(this.connection, mQFap);
                    if (n == 0) {
                        this.channelName = initData.getChannelName();
                        this.maxTransmissionSize = initData.getMaxTransmissionSize();
                        this.maxMessageSize = initData.getMaxMessageSize();
                        if (this.sibMQClientLinkConnectionStatus != null) {
                            this.sibMQClientLinkConnectionStatus.setHeartbeatInterval(new Integer(this.heartbeatInterval));
                            this.sibMQClientLinkConnectionStatus.setMaxMessageLength(new Integer(this.maxMessageSize));
                        }
                        this.gotoState(4);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Now in State_RECEIVE_SECURITY");
                        }
                    }
                }
                catch (ObjectStoreFullException objectStoreFullException) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"The Object store is full", (Object)objectStoreFullException);
                    }
                    this.doCloseChannel(mQFap, this.wireEnc, this.wireCCSID, 6);
                }
            }
        } else {
            this.closeChannel();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"doAccept");
        }
    }

    private void initialiseState() throws ObjectStoreFullException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialiseState");
        }
        this.gotoMQClientLinkInstanceStatus(3);
        ConversationState conversationState = this.createMQClientServerStore();
        long l = conversationState.addVObject(this.mqClientServer);
        this.mqClientServer.setMQClientServerStoreHandle(l);
        this.sibMQClientLinkConnectionStatus = new SIBMQClientLinkConnectionStatus(l);
        if (this.connection != null) {
            this.sibMQClientLinkConnectionStatus.setIpAddress(this.connection.getRemoteNetworkAddress());
            Long l2 = new Long(0L);
            this.sibMQClientLinkConnectionStatus.setMessagesReceived(l2);
            this.sibMQClientLinkConnectionStatus.setLastMessageReceiveTimeMillis(null);
            this.sibMQClientLinkConnectionStatus.setMessagesSent(l2);
            this.sibMQClientLinkConnectionStatus.setLastMessageSendTimeMillis(null);
            this.sibMQClientLinkConnectionStatus.setApiCallsServiced(l2);
            this.sibMQClientLinkConnectionStatus.setBuffersSent(l2);
            this.sibMQClientLinkConnectionStatus.setBuffersReceived(l2);
            this.sibMQClientLinkConnectionStatus.setBytesSent(l2);
            this.sibMQClientLinkConnectionStatus.setBytesReceived(l2);
            this.sibMQClientLinkConnectionStatus.setChannelStartTimeMillis(new Long(System.currentTimeMillis()));
            this.sibMQClientLinkConnectionStatus.setHeartbeatInterval(new Integer(this.mqClientLink.getHeartbeatInterval()));
            this.sibMQClientLinkConnectionStatus.setMaxMessageLength(new Integer(this.mqClientLink.getMaxMessageSize()));
            this.sibMQClientLinkConnectionStatus.setStopRequested(new Boolean(false));
            this.sibMQClientLinkConnectionStatus.setLocalAddress(this.connection.getLocalNetworkAddress());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialiseState");
        }
    }

    private synchronized ConversationState createMQClientServerStore() {
        ConversationState conversationState;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createMQClientServerStore");
        }
        if ((conversationState = this.mqClientLink.getMQClientServerStore()) == null) {
            conversationState = new ConversationState();
            this.mqClientLink.setMQClientServerStore(conversationState);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createMQClientServerStore");
        }
        return conversationState;
    }

    void cleanupState() throws IndexOutOfBoundsException, NoSuchElementException {
        long l;
        ConversationState conversationState;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cleanupState");
        }
        if ((conversationState = this.mqClientLink.getMQClientServerStore()) != null && (l = this.mqClientServer.getMQClientServerStoreHandle()) != 0L) {
            conversationState.removeVObject(l);
            this.sibMQClientLinkState = null;
            this.sibMQClientLinkConnectionStatus = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cleanupState");
        }
    }

    private void doReceiveSecurity(MQFap mQFap) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"doReceiveSecurity");
        }
        switch (mQFap.getSegmentType()) {
            case 6: {
                SecurityData securityData = mQFap.getSecurityData();
                securityData.setUserData(null);
                try {
                    mQFap.send(this.connection);
                }
                catch (SIConnectionDroppedException sIConnectionDroppedException) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection has dropped - 2", (Object)((Object)sIConnectionDroppedException));
                    }
                    this.closeChannel();
                }
                catch (SIConnectionLostException sIConnectionLostException) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection is Lost - 2", (Object)((Object)sIConnectionLostException));
                    }
                    this.closeChannel();
                }
                break;
            }
            case 8: {
                UseridData useridData = mQFap.getUseridData();
                this.userid = useridData.getUserIdentifier().trim();
                this.password = useridData.getPassword().trim();
                this.gotoState(24);
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Now in STATE_RECEIVE_MQAPI_DATA");
                break;
            }
            case -127: 
            case -126: 
            case -125: 
            case -124: 
            case -123: 
            case -122: 
            case -121: 
            case -120: 
            case -119: 
            case -118: 
            case -117: 
            case -116: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -89: 
            case -88: 
            case -87: 
            case -86: {
                this.gotoState(24);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Now in STATE_RECEIVE_MQAPI_DATA");
                }
                this.doReceiveMQAPIData(mQFap);
                break;
            }
            case 9: {
                this.doHeartbeat(mQFap);
                break;
            }
            case 5: {
                if ((mQFap.getTsh().getControlFlags1() & 8) == 0) break;
                break;
            }
            default: {
                this.doError(mQFap);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"doReceiveSecurity");
        }
    }

    private void doStopped(MQFap mQFap) {
        block8: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doStopped");
            }
            try {
                mQFap.createStatus((byte)2, 22, null, mQFap.getEncoding(), mQFap.getCCSID());
                mQFap.send(this.connection);
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an IOException - 2", (Object)iOException);
                }
            }
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection has dropped - 3", (Object)((Object)sIConnectionDroppedException));
                }
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                if (!tc.isDebugEnabled()) break block8;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection is lost - 3", (Object)((Object)sIConnectionLostException));
            }
        }
        this.closeChannel();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"doStopped");
        }
    }

    private void doReceiveMQAPIData(MQFap mQFap) {
        MQVerb mQVerb;
        block34: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doReceiveMQAPIData");
            }
            this.gotoMQClientLinkInstanceStatus(4);
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("MQAPI call" + mQFap.getMQAPI()));
            }
            mQVerb = null;
            try {
                this.wireEnc = mQFap.getTsh().getEncoding();
                this.wireCCSID = mQFap.getTsh().getCCSID();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("==== Received ====> " + MQUtil.getSegmentTypeConstant(mQFap.getSegmentType()) + " for MQFAP chl connection " + this.connection));
                }
                switch (mQFap.getSegmentType()) {
                    case -127: {
                        mQVerb = new MQCONN(this.connection, mQFap, this);
                        break;
                    }
                    case -126: {
                        mQVerb = new MQDISC(this.connection, mQFap, this);
                        break;
                    }
                    case -125: {
                        mQVerb = new MQOPEN(this.connection, mQFap, this);
                        break;
                    }
                    case -124: {
                        mQVerb = new MQCLOSE(this.connection, mQFap, this);
                        break;
                    }
                    case -123: {
                        mQVerb = new MQGET(this.connection, mQFap, this);
                        break;
                    }
                    case -122: {
                        this.messageFap = mQFap;
                        mQVerb = this.doReceiveMessage(mQFap);
                        break;
                    }
                    case -121: {
                        this.messageFap = mQFap;
                        mQVerb = this.doReceiveMessage(mQFap);
                        break;
                    }
                    case -120: {
                        mQVerb = new MQSET(this.connection, mQFap, this);
                        break;
                    }
                    case -119: {
                        mQVerb = new MQINQ(this.connection, mQFap, this);
                        break;
                    }
                    case -118: {
                        mQVerb = new MQCMIT(this.connection, mQFap, this);
                        break;
                    }
                    case -117: {
                        mQVerb = new MQBACK(this.connection, mQFap, this);
                        break;
                    }
                    case -116: {
                        mQVerb = new MQSPI(this.connection, mQFap, this);
                        break;
                    }
                    case -95: {
                        mQVerb = new XASTART(this.connection, mQFap, this);
                        break;
                    }
                    case -94: {
                        mQVerb = new XAEND(this.connection, mQFap, this);
                        break;
                    }
                    case -93: {
                        mQVerb = new XAOPEN(this.connection, mQFap, this);
                        break;
                    }
                    case -92: {
                        mQVerb = new XACLOSE(this.connection, mQFap, this);
                        break;
                    }
                    case -91: {
                        mQVerb = new XAPREPARE(this.connection, mQFap, this);
                        break;
                    }
                    case -90: {
                        mQVerb = new XACOMMIT(this.connection, mQFap, this);
                        break;
                    }
                    case -89: {
                        mQVerb = new XAROLLBACK(this.connection, mQFap, this);
                        break;
                    }
                    case -88: {
                        mQVerb = new XAFORGET(this.connection, mQFap, this);
                        break;
                    }
                    case -87: {
                        mQVerb = new XARECOVER(this.connection, mQFap, this);
                        break;
                    }
                    case -86: {
                        mQVerb = new XACOMPLETE(this.connection, mQFap, this);
                        break;
                    }
                    case 9: {
                        this.doHeartbeat(mQFap);
                        break;
                    }
                    default: {
                        this.doError(mQFap);
                    }
                }
                if (mQVerb != null && this.state == 24) {
                    mQVerb.action();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"MQClientServerStateMachine.doReceiveMQAPIData", (String)"1", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an unexpected exception actioning an MQVerb", (Object)throwable);
                }
                if (mQVerb == null) break block34;
                mQVerb.reply(2, 2195);
            }
        }
        if (mQVerb != null && mQFap.getSegmentType() != 9) {
            CommsPMI.getMQClientLinkStats().onApiCall();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"doReceiveMQAPIData");
        }
    }

    private MQVerb doReceiveMessage(MQFap mQFap) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"doReceiveMessage");
        }
        MQVerb mQVerb = null;
        try {
            this.messageFap.addSegment(mQFap);
            if ((mQFap.getTsh().getControlFlags1() & 0x20) != 0) {
                if (this.messageFap.getSegmentType() == -122) {
                    mQVerb = new MQPUT(this.connection, this.messageFap, this);
                } else if (this.messageFap.getSegmentType() == -121) {
                    mQVerb = new MQPUT1(this.connection, this.messageFap, this);
                }
                this.gotoState(24);
            } else {
                this.gotoState(9);
            }
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an IOException - 3", (Object)iOException);
            }
            this.doCloseChannel(mQFap, mQFap.getEncoding(), mQFap.getCCSID(), 16);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"doReceiveMessage", mQVerb);
        }
        return mQVerb;
    }

    public void doCloseChannel(MQFap mQFap, byte by, short s, int n) {
        block9: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"doCloseChannel", (Object)("errorCode = " + n));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Encoding = " + by + " CodePage = " + s));
            }
            try {
                mQFap.createStatus((byte)8, n, null, by, s);
                mQFap.send(this.connection);
                this.connection.close();
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an IOException - 4", (Object)iOException);
                }
            }
            catch (SIConnectionDroppedException sIConnectionDroppedException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection has dropped - 4", (Object)((Object)sIConnectionDroppedException));
                }
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                if (!tc.isDebugEnabled()) break block9;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection is lost - 4", (Object)((Object)sIConnectionLostException));
            }
        }
        this.closeChannel();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"doCloseChannel");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop - MQClient server");
        }
        this.gotoState(2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"Stop - MQClient server");
        }
    }

    public boolean isClosed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isClosed");
            SibTr.exit((TraceComponent)tc, (String)"isClosed", (Object)("" + this.closed));
        }
        return this.closed;
    }

    public void closeChannel() {
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"closeChannel");
            }
            try {
                if (this.mqHandleStore != null) {
                    List list = this.mqHandleStore.getAllObjects();
                    for (int i = 0; i < list.size(); ++i) {
                        MQHObject mQHObject = (MQHObject)list.get(i);
                        if (mQHObject == null) continue;
                        mQHObject.closeSessions();
                        mQHObject = null;
                    }
                    this.mqHandleStore = null;
                }
            }
            catch (MQException mQException) {
                if (!tc.isDebugEnabled()) break block6;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"An MQException was encountered while closing resources", (Object)mQException);
            }
        }
        this.closed = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"closeChannel");
        }
    }

    boolean doHeartbeat(MQFap mQFap) {
        try {
            if (mQFap != null) {
                TSH tSH = mQFap.getTsh();
                this.waitingForHeartbeat = false;
                if ((tSH.getControlFlags1() & 1) != 0) {
                    this.sendReply(this.connection, mQFap);
                }
                return true;
            }
            if (this.waitingForHeartbeat) {
                this.closeChannel();
                this.waitingForHeartbeat = false;
                return false;
            }
            this.waitingForHeartbeat = true;
            MQFap mQFap2 = new MQFap(9, 1, this.wireEnc, this.wireCCSID);
            mQFap2.send(this.connection);
            return true;
        }
        catch (SIConnectionDroppedException sIConnectionDroppedException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection has dropped - 5", (Object)((Object)sIConnectionDroppedException));
            }
            this.closeChannel();
            return false;
        }
        catch (SIConnectionLostException sIConnectionLostException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection is Lost - 5", (Object)((Object)sIConnectionLostException));
            }
            this.closeChannel();
            return false;
        }
    }

    private void sendReply(Connection connection, MQFap mQFap) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendReply");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending reply\n" + mQFap));
        }
        try {
            mQFap.send(connection);
        }
        catch (SIConnectionDroppedException sIConnectionDroppedException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection has dropped - 6", (Object)((Object)sIConnectionDroppedException));
            }
            this.closeChannel();
        }
        catch (SIConnectionLostException sIConnectionLostException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection is Lost - 6", (Object)((Object)sIConnectionLostException));
            }
            this.closeChannel();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendReply");
        }
    }

    public byte[] getNextMessageId() {
        return this.messageId.getNext();
    }

    public byte[] getNextCorrelationId() {
        return this.correlationId.getNext();
    }

    public void setMQClientLink(MQClientLink mQClientLink) {
        this.mqClientLink = mQClientLink;
    }

    public MQClientLink getMQClientLink() {
        return this.mqClientLink;
    }

    public void setMQClientServer(MQClientServer mQClientServer) {
        this.mqClientServer = mQClientServer;
    }

    public MQClientServer getMQClientServer() {
        return this.mqClientServer;
    }

    public int getMQClientLinkInstanceStatus() {
        return this.mqClientLinkInstanceStatus;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setMQHandleStore(MQHandleStore mQHandleStore) {
        this.mqHandleStore = mQHandleStore;
    }

    public MQHandleStore getMQHandleStore() {
        return this.mqHandleStore;
    }

    public void setChannelName(String string) {
        this.channelName = string;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setMaxMessageSize(int n) {
        this.maxMessageSize = n;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxTransmissionSize(int n) {
        this.maxTransmissionSize = n;
    }

    public int getMaxTransmissionSize() {
        return this.maxTransmissionSize;
    }

    public void setJSConnection(SICoreConnection sICoreConnection) throws SIConnectionLostException {
        block9: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJSConnection");
            }
            this.jsConnection = sICoreConnection;
            if (sICoreConnection != null) {
                Object[] objectArray;
                String string = sICoreConnection.getMeName();
                JsAdminService jsAdminService = JsAdminService.getInstance();
                Enumeration enumeration = jsAdminService.listMessagingEngines(this.mqClientLink.getBusName());
                while (enumeration.hasMoreElements()) {
                    objectArray = (Object[])enumeration.nextElement();
                    if (objectArray.getName().equals(string)) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Located and saved ME " + string));
                        }
                        this.me = objectArray;
                        break;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Skipping ME " + objectArray.getName()));
                }
                if (this.me == null) {
                    objectArray = new Object[]{string};
                    String string2 = nls.getFormattedMessage("MQCLIENTSERVERSTATEMACHINE_ME_NOT_FOUND_SICO3706", objectArray, null);
                    throw new SIConnectionLostException(string2);
                }
                try {
                    sICoreConnection.addConnectionListener((SICoreConnectionListener)this);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine", (String)"2", (Object)this);
                    if (!tc.isDebugEnabled()) break block9;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to register connection listener", (Object)((Object)sIException));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJSConnection");
        }
    }

    public SICoreConnection getJSConnection() {
        return this.jsConnection;
    }

    public void setApplName(String string) {
        this.applName = string;
    }

    public String getApplName() {
        return this.applName;
    }

    public void setApplType(int n) {
        this.applType = n;
    }

    public int getApplType() {
        return this.applType;
    }

    public void setAcctToken(byte[] byArray) {
        this.acctToken = byArray;
    }

    public byte[] getAcctToken() {
        return this.acctToken;
    }

    public JsMessagingEngine getEngine() {
        return this.me;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public String getUserId() {
        return this.userid;
    }

    public String getPassword() {
        return this.password;
    }

    public MQAPICallStatus[] getMQAPICallStatus() {
        return this.arrayMQAPICallStatus;
    }

    public void setMQAPICallStatus(MQAPICallStatus[] mQAPICallStatusArray) {
        this.arrayMQAPICallStatus = mQAPICallStatusArray;
    }

    public SIXAResource getXAResource() {
        return this.xaResource;
    }

    public void setXAResource(SIXAResource sIXAResource) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setXAResource");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Params: xaResource", (Object)sIXAResource);
        }
        this.xaResource = sIXAResource;
        if (sIXAResource == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Setting state to Unknown");
            }
            this.setTransactionalMode(0);
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Setting state to XA");
            }
            this.setTransactionalMode(2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setXAResource");
        }
    }

    public void setTransaction(SITransaction sITransaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTransaction");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Params: transaction", (Object)sITransaction);
        }
        this.transaction = sITransaction;
        if (sITransaction == null && this.transactionalState == 1) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Setting state to Unknown");
            }
            this.transactionalState = 0;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTransaction");
        }
    }

    public SITransaction getTransaction() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransaction");
        }
        if (this.getTransactionalMode() == 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Transactional state is unknown - creating a new local tran");
            }
            try {
                SIUncoordinatedTransaction sIUncoordinatedTransaction = this.getJSConnection().createUncoordinatedTransaction();
                this.setTransactionalMode(1);
                this.setTransaction((SITransaction)sIUncoordinatedTransaction);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine", (String)"3", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to create local transaction", (Object)((Object)sIException));
                }
            }
        } else if (this.getTransactionalMode() == 1) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Transactional state is local");
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Transactional state is XA");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"rc=", (Object)this.transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransaction");
        }
        return this.transaction;
    }

    public int getTransactionalMode() {
        return this.transactionalState;
    }

    private void setTransactionalMode(int n) {
        this.transactionalState = n;
    }

    public SIBMQClientLinkConnectionStatus getSIBMQClientLinkConnectionStatus() {
        return this.sibMQClientLinkConnectionStatus;
    }

    public void setSIBMQClientLinkConnectionStatus(SIBMQClientLinkConnectionStatus sIBMQClientLinkConnectionStatus) {
        this.sibMQClientLinkConnectionStatus = sIBMQClientLinkConnectionStatus;
    }

    public SIBMQClientLinkConnectionStatus getCurrentSIBMQClientLinkConnectionStatus() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCurrentSIBMQClientLinkConnectionStatus");
        }
        if (this.connection != null & this.sibMQClientLinkConnectionStatus != null) {
            long l = 0L;
            long l2 = 0L;
            MQAPICallStatus mQAPICallStatus = this.arrayMQAPICallStatus[5];
            if (mQAPICallStatus != null) {
                l += mQAPICallStatus.getAPICallCount();
                l2 = mQAPICallStatus.getAPICallDateAndTime();
            }
            if ((mQAPICallStatus = this.arrayMQAPICallStatus[6]) != null) {
                l += mQAPICallStatus.getAPICallCount();
                if (l2 < mQAPICallStatus.getAPICallDateAndTime()) {
                    l2 = mQAPICallStatus.getAPICallDateAndTime();
                }
            }
            this.sibMQClientLinkConnectionStatus.setMessagesReceived(new Long(l));
            if (l2 != 0L) {
                this.sibMQClientLinkConnectionStatus.setLastMessageReceiveTimeMillis(new Long(l2));
            } else {
                this.sibMQClientLinkConnectionStatus.setLastMessageReceiveTimeMillis(null);
            }
            long l3 = 0L;
            long l4 = 0L;
            mQAPICallStatus = this.arrayMQAPICallStatus[4];
            if (mQAPICallStatus != null) {
                l3 += mQAPICallStatus.getAPICallCount();
                l4 = mQAPICallStatus.getAPICallDateAndTime();
            }
            this.sibMQClientLinkConnectionStatus.setMessagesSent(new Long(l3));
            if (l4 != 0L) {
                this.sibMQClientLinkConnectionStatus.setLastMessageSendTimeMillis(new Long(l4));
            } else {
                this.sibMQClientLinkConnectionStatus.setLastMessageSendTimeMillis(null);
            }
            this.sibMQClientLinkConnectionStatus.setApiCallsServiced(new Long(this.totalAPICalls()));
            this.sibMQClientLinkConnectionStatus.setBuffersSent(new Long(this.connection.getBuffersSent()));
            this.sibMQClientLinkConnectionStatus.setBuffersReceived(new Long(this.connection.getBuffersReceived()));
            this.sibMQClientLinkConnectionStatus.setBytesSent(new Long(this.connection.getBytesSent()));
            this.sibMQClientLinkConnectionStatus.setBytesReceived(new Long(this.connection.getBytesReceived()));
            this.sibMQClientLinkState = new SIBMQClientLinkState(this.mqClientLinkInstanceStatus);
            this.sibMQClientLinkConnectionStatus.setStatus(this.sibMQClientLinkState);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCurrentSIBMQClientLinkConnectionStatus");
        }
        return this.sibMQClientLinkConnectionStatus;
    }

    private long totalAPICalls() {
        long l = 0L;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"totalAPICalls");
        }
        for (int i = 0; i < 12; ++i) {
            MQAPICallStatus mQAPICallStatus = this.arrayMQAPICallStatus[i];
            if (mQAPICallStatus == null) continue;
            l += mQAPICallStatus.getAPICallCount();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"totalAPICalls", (Object)("totalAPICalls = " + l));
        }
        return l;
    }

    public SIBMQClientLinkState getSIBMQClientLinkState() {
        return this.sibMQClientLinkState;
    }

    public void setSIBMQClientLinkState(SIBMQClientLinkState sIBMQClientLinkState) {
        this.sibMQClientLinkState = sIBMQClientLinkState;
    }

    public boolean isMeQuiescing() {
        return this.meQuiescing;
    }

    public void asynchronousException(ConsumerSession consumerSession, SIException sIException) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"asynchronousException");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Async exception (consumer, exception)", (Object)new Object[]{consumerSession, sIException});
        }
        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine", (String)"4", (Object)this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"asynchronousException");
        }
    }

    public void meQuiescing(SICoreConnection sICoreConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"meQuiescing");
        }
        this.meQuiescing = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"meQuiescing");
        }
    }

    public void commsFailure(SICoreConnection sICoreConnection, SIException sIException) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commsFailure");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Comms failure (consumer, exception)", (Object)new Object[]{sICoreConnection, sIException});
        }
        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine", (String)"5", (Object)this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commsFailure");
        }
    }

    public void meTerminated(SICoreConnection sICoreConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"meTerminated");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"meTerminated");
        }
    }

    public void asynchronousException(ConsumerSession consumerSession, Throwable throwable) {
    }

    public void commsFailure(SICoreConnection sICoreConnection, SIConnectionLostException sIConnectionLostException) {
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/client/MQClientServerStateMachine.java, SIB.comms, WAS602.SIB, o0610.11 1.41");
        }
    }
}

