/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine;
import com.ibm.ws.sib.comms.mq.link.LinkConstants;
import com.ibm.ws.sib.comms.mq.link.MQClientLink;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.mfp.mqinterop.fap.MQFAP;
import com.ibm.ws.sib.mqfapchannel.Connection;
import com.ibm.ws.sib.mqfapchannel.ReceiveListener;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.io.IOException;

public class MQClientServer
implements ReceiveListener,
MQConstants,
LinkConstants,
MQFAP {
    private String virtualQmgrName;
    private SICoreConnection jsConnection;
    private MQClientServerStateMachine mqClientServerStateMachine;
    private long mqClientServerStoreHandle = 0L;
    private static final TraceComponent tc = SibTr.register((Class)MQClientServer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private boolean tracedata = true;

    public MQClientServer(Connection connection, MQClientLink mQClientLink) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"MQClientServer", (Object)(" Connection = " + connection));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"MQCS > Create a new Client Server State Machine");
        }
        this.mqClientServerStateMachine = new MQClientServerStateMachine();
        connection.setAttachment(this.mqClientServerStateMachine);
        this.mqClientServerStateMachine.setMQClientServer(this);
        this.mqClientServerStateMachine.setMQClientLink(mQClientLink);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"MQClientServer", (Object)(" MQClientServerStateMachine  = " + this.mqClientServerStateMachine));
        }
    }

    public ReceiveListener dataReceived(Connection connection, WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dataReceived", (Object)(" Connection = " + connection));
        }
        if (tc.isDebugEnabled()) {
            SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])wsByteBuffer.array());
        }
        this.mqClientServerStateMachine.dataReceived(connection, wsByteBuffer);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dataReceived");
        }
        return null;
    }

    public void errorOccurred(Connection connection, Throwable throwable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"errorOccurred", (Object)new Object[]{this, connection, throwable});
        }
        if (this.mqClientServerStateMachine.isClosed() && throwable instanceof IOException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Channel closed - Ignoring exception");
            }
        } else {
            FFDCFilter.processException((Throwable)throwable, (String)"MQClientServer.errorOccurred", (String)"1", (Object)this);
            this.mqClientServerStateMachine.closeChannel();
        }
        this.stop();
        if (this.mqClientServerStoreHandle != 0L && this.mqClientServerStateMachine.getMQClientLink() != null && this.mqClientServerStateMachine.getMQClientLink().getMQClientServerStore() != null) {
            if (tc.isDebugEnabled()) {
                int n = (int)(this.mqClientServerStoreHandle >> 32);
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Removing MQClientServer instance for handle " + n));
            }
            this.mqClientServerStateMachine.getMQClientLink().getMQClientServerStore().removeVObject(this.mqClientServerStoreHandle);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"errorOccurred");
        }
    }

    public WsByteBuffer buildErrorCloseFapFlow() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"buildErrorCloseFapFlow");
        }
        this.mqClientServerStateMachine.closeChannel();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"buildErrorCloseFapFlow");
        }
        return null;
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop - MQClient server");
        }
        this.mqClientServerStateMachine.stop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"Stop - MQClient server");
        }
    }

    public MQClientServerStateMachine getMQClientServerStateMachine() {
        return this.mqClientServerStateMachine;
    }

    public void setMQClientServerStateMachine(MQClientServerStateMachine mQClientServerStateMachine) {
        this.mqClientServerStateMachine = mQClientServerStateMachine;
    }

    public long getMQClientServerStoreHandle() {
        return this.mqClientServerStoreHandle;
    }

    public void setMQClientServerStoreHandle(long l) {
        this.mqClientServerStoreHandle = l;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/client/MQClientServer.java, SIB.comms, WAS602.SIB, o0610.11 1.19");
        }
    }
}

