/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.mq.client;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationAliasDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.comms.mq.client.MQClientServerStateMachine;
import com.ibm.ws.sib.comms.mq.client.MQException;
import com.ibm.ws.sib.comms.mq.util.MQConstants;
import com.ibm.ws.sib.processor.SIMPAdmin;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.runtime.SIMPMessageProcessorControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueueControllable;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import java.util.ArrayList;

public class DestinationDefinitionWrapper
implements MQConstants {
    private static final TraceComponent tc = SibTr.register((Class)DestinationDefinitionWrapper.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private SIMPQueueControllable queueControllable = null;
    private BaseDestinationDefinition baseDestDef = null;
    private ArrayList aliasChainDefs = null;
    private MQClientServerStateMachine state = null;

    public DestinationDefinitionWrapper(MQClientServerStateMachine mQClientServerStateMachine, String string) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{mQClientServerStateMachine, string});
        }
        this.state = mQClientServerStateMachine;
        this.baseDestDef = this.getBaseDestinationDefinition(string);
        if (this.baseDestDef != null) {
            if (this.baseDestDef.isAlias()) {
                this.expandAliasDefinitions();
            } else if (this.baseDestDef.isLocal()) {
                this.queueControllable = this.getQueueControllable(string);
            }
        } else {
            this.queueControllable = this.getQueueControllable(string);
        }
        if (this.baseDestDef == null && this.queueControllable == null) {
            throw new MQException(2085);
        }
    }

    public boolean isLocal() {
        return this.baseDestDef != null ? this.baseDestDef.isLocal() : this.queueControllable.isLocal();
    }

    public boolean isAlias() {
        return this.baseDestDef != null ? this.baseDestDef.isAlias() : this.queueControllable.isAlias();
    }

    public boolean isForeign() {
        return this.baseDestDef != null ? this.baseDestDef.isForeign() : this.queueControllable.isForeign();
    }

    public boolean isTargetForeign() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isTargetForeign");
        }
        boolean bl = false;
        if (this.baseDestDef != null) {
            bl = this.getAliasTarget().isForeign();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isTargetForeign");
        }
        return bl;
    }

    public boolean isTargetLocal() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isTargetLocal");
        }
        boolean bl = false;
        if (this.baseDestDef != null) {
            bl = this.getAliasTarget().isLocal();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isTargetLocal");
        }
        return bl;
    }

    public boolean isReceiveExclusive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isReceiveExclusive");
        }
        boolean bl = false;
        if (this.baseDestDef != null) {
            if (this.baseDestDef.isLocal()) {
                bl = ((DestinationDefinition)this.baseDestDef).isReceiveExclusive();
            } else if (this.baseDestDef.isAlias() && this.isTargetLocal()) {
                bl = ((DestinationDefinition)this.getAliasTarget()).isReceiveExclusive();
            }
        } else {
            bl = this.queueControllable.isReceiveExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isReceiveExclusive");
        }
        return bl;
    }

    public boolean isReceiveAllowed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isReceiveAllowed");
        }
        boolean bl = false;
        if (this.baseDestDef != null) {
            if (this.baseDestDef.isLocal()) {
                bl = ((DestinationDefinition)this.baseDestDef).isReceiveAllowed();
            } else if (this.baseDestDef.isAlias() && this.isTargetLocal()) {
                bl = ((DestinationDefinition)this.getAliasTarget()).isReceiveAllowed();
            }
        } else {
            bl = this.queueControllable.isReceiveAllowed();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isReceiveAllowed");
        }
        return bl;
    }

    public boolean isSendAllowed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isSendAllowed");
        }
        boolean bl = false;
        if (this.baseDestDef != null) {
            if (this.baseDestDef.isLocal()) {
                bl = ((DestinationDefinition)this.baseDestDef).isSendAllowed();
            } else if (this.baseDestDef.isAlias() && this.isTargetLocal()) {
                bl = ((DestinationDefinition)this.getAliasTarget()).isSendAllowed();
            }
        } else {
            bl = this.queueControllable.isSendAllowed();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isSendAllowed");
        }
        return bl;
    }

    public Reliability getDefaultReliability() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDefaultReliability");
        }
        Reliability reliability = Reliability.NONE;
        if (this.baseDestDef != null) {
            if (this.baseDestDef.isLocal()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using local base definition");
                }
                reliability = ((DestinationDefinition)this.baseDestDef).getDefaultReliability();
            } else if (this.baseDestDef.isAlias()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias base definition");
                }
                for (int i = 0; i < this.aliasChainDefs.size(); ++i) {
                    BaseDestinationDefinition baseDestinationDefinition = (BaseDestinationDefinition)this.aliasChainDefs.get(i);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Checking destination: " + baseDestinationDefinition.getName()));
                    }
                    if (baseDestinationDefinition.isAlias()) {
                        Reliability reliability2 = ((DestinationAliasDefinition)baseDestinationDefinition).getDefaultReliability();
                        if (reliability2 == Reliability.NONE) continue;
                        reliability = reliability2;
                        break;
                    }
                    if (!baseDestinationDefinition.isLocal()) continue;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using resolved alias target defs");
                    }
                    reliability = ((DestinationDefinition)baseDestinationDefinition).getDefaultReliability();
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using queue controllable");
            }
            reliability = this.queueControllable.getDefaultReliability();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDefaultReliability", (Object)reliability);
        }
        return reliability;
    }

    public int getDefaultPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDefaultPriority");
        }
        int n = 0;
        if (this.baseDestDef != null) {
            if (this.baseDestDef.isLocal()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using local base definition");
                }
                n = ((DestinationDefinition)this.baseDestDef).getDefaultPriority();
            } else if (this.baseDestDef.isAlias()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias base definition");
                }
                for (int i = 0; i < this.aliasChainDefs.size(); ++i) {
                    BaseDestinationDefinition baseDestinationDefinition = (BaseDestinationDefinition)this.aliasChainDefs.get(i);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Checking destination: " + baseDestinationDefinition.getName()));
                    }
                    if (baseDestinationDefinition.isAlias()) {
                        int n2 = ((DestinationAliasDefinition)baseDestinationDefinition).getDefaultPriority();
                        if (n2 == -1) continue;
                        n = n2;
                        break;
                    }
                    if (!baseDestinationDefinition.isLocal()) continue;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using resolved alias target defs");
                    }
                    n = ((DestinationDefinition)baseDestinationDefinition).getDefaultPriority();
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using queue controllable");
            }
            n = this.queueControllable.getDefaultPriority();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDefaultPriority", (Object)("" + n));
        }
        return n;
    }

    public long getAlterationTime() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAlterationTime");
        }
        long l = -1L;
        if (this.baseDestDef != null) {
            if (this.baseDestDef.isLocal()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using local base definition");
                }
                l = ((DestinationDefinition)this.baseDestDef).getAlterationTime();
            } else if ((this.baseDestDef.isAlias() || this.baseDestDef.isForeign()) && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias or foreign base definition");
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using queue controllable");
            }
            l = this.queueControllable.getAlterationTime();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAlterationTime", (Object)("" + l));
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getBaseQName() throws MQException {
        String string;
        block12: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBaseQName");
            }
            string = "";
            if (this.baseDestDef != null) {
                if (this.baseDestDef.isAlias()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias base definition");
                    }
                    BaseDestinationDefinition baseDestinationDefinition = this.getAliasTarget();
                    string = baseDestinationDefinition.getName();
                    break block12;
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias or foreign base definition");
                    }
                    throw new MQException(2068);
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using queue controllable");
            }
            if (this.queueControllable.isAlias()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias queue controllable");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using local or foreign queue controllable");
                }
                throw new MQException(2068);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBaseQName", (Object)("" + string));
        }
        return string;
    }

    public String getDescription() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDescription");
        }
        String string = "";
        if (this.baseDestDef != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using base definition");
            }
            string = this.baseDestDef.getDescription();
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using queue controllable");
            }
            string = this.queueControllable.getDescription();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDescription", (Object)("" + string));
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getExceptionDestination() throws MQException {
        String string;
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"getExceptionDestination");
            }
            string = "";
            if (this.baseDestDef != null) {
                if (this.baseDestDef.isLocal()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using local base definition");
                    }
                    string = ((DestinationDefinition)this.baseDestDef).getExceptionDestination();
                    break block11;
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias or foreign base definition");
                    }
                    throw new MQException(2068);
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using queue controllable");
            }
            if (this.queueControllable.isLocal()) {
                string = this.queueControllable.getExceptionDestination();
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias or foreign base definition");
                }
                throw new MQException(2068);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getExceptionDestination", (Object)("" + string));
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getMaxFailedDeliveries() throws MQException {
        int n;
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMaxFailedDeliveries");
            }
            n = 0;
            if (this.baseDestDef != null) {
                if (this.baseDestDef.isLocal()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using local base definition");
                    }
                    n = ((DestinationDefinition)this.baseDestDef).getMaxFailedDeliveries();
                    break block11;
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias or foreign base definition");
                    }
                    throw new MQException(2068);
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using queue controllable");
            }
            if (this.queueControllable.isLocal()) {
                n = this.queueControllable.getMaxFailedDeliveries();
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias or foreign base definition");
                }
                throw new MQException(2068);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMaxFailedDeliveries", (Object)("" + n));
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getNumberOfQueuedMessages() throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNumberOfQueuedMessages");
        }
        long l = 0L;
        if (this.queueControllable != null) {
            if (this.queueControllable.isLocal()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using queue controllable");
                }
                try {
                    l = this.queueControllable.getLocalQueuePointControl().getNumberOfQueuedMessages();
                }
                catch (SIMPException sIMPException) {
                    FFDCFilter.processException((Throwable)sIMPException, (String)"DestinationDefinitionWrapper.getNumberOfQueuedMessages", (String)"1", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Local queue point control may be corrupt", (Object)sIMPException);
                    }
                    throw new MQException(2101);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias or foreign base definition");
                }
                throw new MQException(2068);
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using base destination definition");
        }
        if (!this.baseDestDef.isLocal()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias or foreign base destination definition");
            }
            throw new MQException(2068);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNumberOfQueuedMessages", (Object)("" + l));
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public DestinationType getDestinationType() throws MQException {
        DestinationType destinationType;
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestinationType");
            }
            if (this.baseDestDef != null) {
                if (this.baseDestDef.isLocal()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using local base destination definition");
                    }
                    destinationType = ((DestinationDefinition)this.baseDestDef).getDestinationType();
                    break block11;
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias or foreign base definition");
                    }
                    throw new MQException(2068);
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using queue controllable");
            }
            if (this.queueControllable.isLocal()) {
                destinationType = this.queueControllable.getDestinationType();
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias or foreign destination definition");
                }
                throw new MQException(2068);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDestinationType", (Object)("" + destinationType));
        }
        return destinationType;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isTemporary() throws MQException {
        boolean bl;
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"isTemporary");
            }
            bl = false;
            DestinationType destinationType = this.getDestinationType();
            if (destinationType == DestinationType.QUEUE) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"DestinationType is QUEUE");
                }
                if (this.queueControllable != null) {
                    if (this.queueControllable.isLocal()) {
                        bl = this.queueControllable.isTemporary();
                        break block11;
                    } else {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias or foreign definition");
                        }
                        throw new MQException(2068);
                    }
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Assume that the destination is not a temporary");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"DestinationType is not QUEUE");
                }
                throw new MQException(2068);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isTemporary", (Object)("" + bl));
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDestinationHighMsgs() throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestinationHighMsgs");
        }
        long l = 0L;
        if (this.queueControllable != null) {
            if (this.queueControllable.isLocal()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using queue controllable");
                }
                try {
                    l = this.queueControllable.getLocalQueuePointControl().getDestinationHighMsgs();
                }
                catch (SIMPException sIMPException) {
                    FFDCFilter.processException((Throwable)sIMPException, (String)"DestinationDefinitionWrapper.getDestinationHighMsgs", (String)"2", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Local queue point control may be corrupt", (Object)sIMPException);
                    }
                    throw new MQException(2101);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias or foreign base definition");
                }
                throw new MQException(2068);
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using base destination definition");
        }
        if (!this.baseDestDef.isLocal()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using alias or foreign base destination definition");
            }
            throw new MQException(2068);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDestinationHighMsgs", (Object)("" + l));
        }
        return l;
    }

    private SIMPQueueControllable getQueueControllable(String string) throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getQueueControllable", (Object)string);
        }
        JsMessagingEngine jsMessagingEngine = this.state.getEngine();
        String string2 = jsMessagingEngine.getBusName();
        SIMPQueueControllable sIMPQueueControllable = null;
        SIMPMessageProcessorControllable sIMPMessageProcessorControllable = ((SIMPAdmin)jsMessagingEngine.getMessageProcessor()).getAdministrator().getMPRuntimeControl();
        try {
            sIMPQueueControllable = sIMPMessageProcessorControllable.getQueueControlByName(string, string2);
        }
        catch (SIMPControllableNotFoundException sIMPControllableNotFoundException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Queue controllable for " + string + " not found: " + sIMPControllableNotFoundException));
            }
        }
        catch (SIMPException sIMPException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Resource exception", (Object)sIMPException);
            }
            throw new MQException(2195);
        }
        if (tc.isDebugEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getQueueControllable", (Object)sIMPQueueControllable);
        }
        return sIMPQueueControllable;
    }

    private BaseDestinationDefinition getBaseDestinationDefinition(String string) throws MQException {
        if (tc.isDebugEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBaseDestinationDefinition", (Object)string);
        }
        JsMessagingEngine jsMessagingEngine = this.state.getEngine();
        String string2 = jsMessagingEngine.getBusName();
        BaseDestinationDefinition baseDestinationDefinition = null;
        try {
            baseDestinationDefinition = jsMessagingEngine.getSIBDestination(string2, string);
        }
        catch (SIBExceptionDestinationNotFound sIBExceptionDestinationNotFound) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("WCCM definition for " + string + " not found"));
            }
        }
        catch (SIBExceptionBase sIBExceptionBase) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to query the destination", (Object)((Object)sIBExceptionBase));
            }
            throw new MQException(2195);
        }
        if (tc.isDebugEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBaseDestinationDefinition", (Object)baseDestinationDefinition);
        }
        return baseDestinationDefinition;
    }

    private BaseDestinationDefinition getAliasTarget() {
        return (BaseDestinationDefinition)this.aliasChainDefs.get(this.aliasChainDefs.size() - 1);
    }

    private void expandAliasDefinitions() throws MQException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"expandAliasDefinitions");
        }
        this.aliasChainDefs = new ArrayList();
        ArrayList<SIBUuid12> arrayList = new ArrayList<SIBUuid12>();
        this.aliasChainDefs.add(this.baseDestDef);
        arrayList.add(this.baseDestDef.getUUID());
        BaseDestinationDefinition baseDestinationDefinition = this.baseDestDef;
        while (true) {
            if ((baseDestinationDefinition = this.getBaseDestinationDefinition(((DestinationAliasDefinition)baseDestinationDefinition).getTargetName())) == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"The next item in the chain cannot be found");
                }
                throw new MQException(2082);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Examining: " + baseDestinationDefinition.getName() + "->" + baseDestinationDefinition.getUUID()));
            }
            if (!baseDestinationDefinition.isAlias()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Reached the end of the alias chain");
                }
                break;
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Destination is itself an alias");
            }
            if (arrayList.contains(baseDestinationDefinition.getUUID())) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Already seen this alias before!");
                }
                throw new MQException(2001);
            }
            this.aliasChainDefs.add(baseDestinationDefinition);
            arrayList.add(baseDestinationDefinition.getUUID());
        }
        this.aliasChainDefs.add(baseDestinationDefinition);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"expandAliasDefinitions");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/mq/client/DestinationDefinitionWrapper.java, SIB.comms, WAS602.SIB, o0610.11 1.4");
        }
    }
}

