/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.comms.impl.ObjectStoreFullException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class ConversationState {
    private static TraceComponent tc = SibTr.register((Class)ConversationState.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    public static final int OBJECT_TABLE_ORIGIN = 10;
    static final int INITIAL_SIZE_OF_OBJECT_TABLE = 42;
    static final int MINUS_ONE = -1;
    static final int OBJECT_TABLE_EXTEND_FACTOR = 2;
    private int maxIndex = 41;
    private int highWatermark = 10;
    private int freeSlot = 10;
    private int maxTableSize = 0;
    private Object[] objectTable;
    private int[] objectVersion;
    private boolean foundFreeSlot;
    private short connectionObjectId;
    private int requestNumber = 0;
    String nlsMsgText;
    Object[] args = null;

    public ConversationState() {
        this(Integer.MAX_VALUE);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public ConversationState(int n) {
        this(42, n);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("" + n));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public ConversationState(int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{"" + n, "" + n2});
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"ConversationState", (Object)"CS> Create a new Conversation State (Object Store)");
        }
        if (n <= 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Initial size of object store is negative " + n));
            }
            this.args = new Object[]{new Integer(n)};
            this.nlsMsgText = nls.getFormattedMessage("CONVERSATIONSTATE_INTERNAL_SICO3500", this.args, null);
            throw new SIErrorException(this.nlsMsgText);
        }
        if (n2 <= 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Maximum size of object store is negative " + n2));
            }
            this.args = new Object[]{new Integer(n2)};
            this.nlsMsgText = nls.getFormattedMessage("CONVERSATIONSTATE_INTERNAL_SICO3501", this.args, null);
            throw new SIErrorException(this.nlsMsgText);
        }
        if (n < 10) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Initial size of object store is less than its origin " + n + "   " + 10));
            }
            this.args = new Object[]{new Integer(n), new Integer(10)};
            this.nlsMsgText = nls.getFormattedMessage("CONVERSATIONSTATE_INTERNAL_SIC03502", this.args, null);
            throw new SIErrorException(this.nlsMsgText);
        }
        if (n > n2) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Initial size of object store is greater than the maximum size " + n + "   " + n2));
            }
            this.args = new Object[]{new Integer(n), new Integer(n2)};
            this.nlsMsgText = nls.getFormattedMessage("CONVERSATIONSTATE_INTERNAL_SICO3503", this.args, null);
            throw new SIErrorException(this.nlsMsgText);
        }
        this.maxTableSize = n2;
        this.objectTable = new Object[n];
        this.objectVersion = new int[n];
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public void setConnectionObjectId(short s) {
        this.connectionObjectId = s;
    }

    public short getConnectionObjectId() {
        return this.connectionObjectId;
    }

    public long addVObject(Object object) throws ObjectStoreFullException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addVObject");
        }
        int n = this.addObject(object);
        long l = n;
        l <<= 32;
        l |= (long)this.objectVersion[n];
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addVObject");
        }
        return l;
    }

    public synchronized Object getVObject(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getVObject");
        }
        int n = (int)(l >> 32);
        Object object = this.getObject(n);
        int n2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        if (n2 != this.objectVersion[n]) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Object versions do not match " + n2 + "   " + this.objectVersion[n]));
            }
            this.args = new Object[]{new Integer(n2), new Integer(this.objectVersion[n])};
            this.nlsMsgText = nls.getFormattedMessage("CONVERSATIONSTATE_INTERNAL_SIC03504", this.args, null);
            throw new NoSuchElementException(this.nlsMsgText);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"CS> Object = ", (Object)object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getVObject");
        }
        return object;
    }

    public synchronized void removeVObject(long l) {
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)("removeVObject " + l));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Remove an object from the Store");
        }
        if ((n2 = (int)(l & 0xFFFFFFFFFFFFFFFFL)) != this.objectVersion[n = (int)(l >> 32)]) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Object versions do not match " + n2 + "   " + this.objectVersion[n]));
            }
            this.args = new Object[]{new Integer(n2), new Integer(this.objectVersion[n])};
            this.nlsMsgText = nls.getFormattedMessage("CONVERSATIONSTATE_INTERNAL_SIC03505", this.args, null);
            throw new NoSuchElementException(this.nlsMsgText);
        }
        this.removeObject(n);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Successfully removed the object");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeVObject");
        }
    }

    public Object scanObjects(ScanCallback scanCallback, Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"scanObjects");
        }
        Object object3 = null;
        for (int i = 10; i < this.maxIndex && (this.objectTable[i] == null || (object3 = scanCallback.examineObject(this.objectTable[i], object, object2)) == null); ++i) {
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"scanObjects");
        }
        return object3;
    }

    public int getObjectCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getObjectCount");
        }
        int n = 0;
        for (int i = 10; i < this.maxIndex; ++i) {
            if (this.objectTable[i] == null) continue;
            ++n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getObjectCount");
        }
        return n;
    }

    public synchronized int addObject(Object object) throws ObjectStoreFullException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addObject");
        }
        int n2 = 0;
        if (this.freeSlot == -1) {
            this.extendObjectTable();
        }
        n2 = this.freeSlot;
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"CS> Object Index = ", (Object)new Integer(n2));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"CS> Put an object to the ObjectStore");
        }
        this.objectTable[n2] = object;
        this.highWatermark = Math.max(this.highWatermark, this.freeSlot);
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"CS> High Water Mark = ", (Object)new Integer(this.highWatermark));
        }
        this.foundFreeSlot = false;
        for (n = this.highWatermark + 1; n <= this.maxIndex; ++n) {
            if (this.objectTable[n] != null) continue;
            this.freeSlot = n;
            this.foundFreeSlot = true;
            break;
        }
        if (!this.foundFreeSlot) {
            for (n = 10; n <= this.highWatermark - 1; ++n) {
                if (this.objectTable[n] != null) continue;
                this.freeSlot = n;
                this.foundFreeSlot = true;
                break;
            }
        }
        if (!this.foundFreeSlot) {
            this.freeSlot = -1;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"CS> Next free slot = ", (Object)new Integer(this.freeSlot));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"CS> Max Index = ", (Object)new Integer(this.maxIndex));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addObject");
        }
        return n2;
    }

    private synchronized void extendObjectTable() throws ObjectStoreFullException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"extendObjectTable");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"CS> Extend Object Table");
        }
        if ((n = (this.maxIndex + 1) * 2 - 10) > this.maxTableSize) {
            if (this.maxIndex + 1 < this.maxTableSize) {
                n = this.maxTableSize;
            } else {
                throw new ObjectStoreFullException();
            }
        }
        Object[] objectArray = new Object[n];
        int[] nArray = new int[n];
        System.arraycopy(this.objectTable, 0, objectArray, 0, this.maxIndex + 1);
        System.arraycopy(this.objectVersion, 0, nArray, 0, this.maxIndex + 1);
        this.freeSlot = this.maxIndex + 1;
        this.maxIndex = n - 1;
        this.objectTable = objectArray;
        this.objectVersion = nArray;
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Next free slot = ", (Object)new Integer(this.freeSlot));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Max Index = ", (Object)new Integer(this.maxIndex));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"High Water Mark = ", (Object)new Integer(this.highWatermark));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"extendObjectTable");
        }
    }

    public synchronized Object getObject(int n) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getObject");
        }
        if (n < 10 || n > this.maxIndex) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Index out of bounds " + n + "   " + 10 + "   " + this.maxIndex));
            }
            this.args = new Object[]{new Integer(n), new Integer(10)};
            this.nlsMsgText = nls.getFormattedMessage("CONVERSATIONSTATE_INTERNAL_SIC03506", this.args, null);
            throw new SIErrorException(this.nlsMsgText);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"CS> Get an object from the Store");
        }
        if ((object = this.objectTable[n]) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("No object found for supplied index    " + n));
            }
            this.args = new Object[]{new Integer(n)};
            this.nlsMsgText = nls.getFormattedMessage("CONVERSATIONSTATE_INTERNAL_SIC03507", this.args, null);
            throw new NoSuchElementException(this.nlsMsgText);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"CS> Object = ", (Object)object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getObject");
        }
        return object;
    }

    public synchronized void removeObject(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)("removeObject " + n));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Remove an object from the Store");
        }
        if (n < 10 || n > this.maxIndex) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Index out of bounds on remove " + n + "   " + 10 + "   " + this.maxIndex));
            }
            this.args = new Object[]{new Integer(n), new Integer(10)};
            this.nlsMsgText = nls.getFormattedMessage("CONVERSATIONSTATE_INTERNAL_SIC03508", this.args, null);
            throw new SIErrorException(this.nlsMsgText);
        }
        if (this.objectTable[n] == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("No object found for supplied index on remove " + n));
            }
            this.args = new Object[]{new Integer(n)};
            this.nlsMsgText = nls.getFormattedMessage("CONVERSATIONSTATE_INTERNAL_SIC03509", this.args, null);
            throw new NoSuchElementException(this.nlsMsgText);
        }
        this.objectTable[n] = null;
        int n2 = n;
        this.objectVersion[n2] = this.objectVersion[n2] + 1;
        this.freeSlot = this.freeSlot == -1 ? n : Math.min(this.freeSlot, n);
        if (this.highWatermark == n) {
            while (this.objectTable[this.highWatermark] == null && this.highWatermark != 10) {
                --this.highWatermark;
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Successfully removed the object, next free slot = " + this.freeSlot + ", high water mark = " + this.highWatermark));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeObject");
        }
    }

    public synchronized List getAllObjects() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAllObjects");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 10; i < this.maxIndex; ++i) {
            if (this.objectTable[i] == null) continue;
            arrayList.add(this.objectTable[i]);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAllObjects");
        }
        return arrayList;
    }

    public void dumpObjectTable(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dumpObjectTable");
        }
        if (n < 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Number of entries to be dumped is negative " + n));
            }
            this.args = new Object[]{new Integer(n)};
            this.nlsMsgText = nls.getFormattedMessage("CONVERSATIONSTATE_INTERNAL_SIC03510", this.args, null);
            throw new SIErrorException(this.nlsMsgText);
        }
        for (int i = 10; i < 10 + n; ++i) {
            System.out.println(this.objectTable[i]);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dumpObjectTable");
        }
    }

    public void setInitialRequestNumber(int n) {
        this.requestNumber = n;
    }

    public synchronized int getUniqueRequestNumber() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUniqueRequestNumber");
        }
        this.requestNumber += 2;
        if (this.requestNumber > Short.MAX_VALUE) {
            this.requestNumber %= 2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUniqueRequestNumber", (Object)("" + this.requestNumber));
        }
        return this.requestNumber;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.mq.impl/src/com/ibm/ws/sib/comms/impl/ConversationState.java, SIB.comms, WAS60.SIB, o0444.07 1.6");
        }
    }

    public static interface ScanCallback {
        public Object examineObject(Object var1, Object var2, Object var3);
    }
}

